/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.rpc.RpcProxy;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.RouterActivityDef;
import com.kingdee.bos.workflow.define.ScriptActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.define.extended.MessageActivityDef;
import com.kingdee.bos.workflow.monitor.IWfUtil;
import com.kingdee.bos.workflow.monitor.WfUtil;
import com.kingdee.bos.workflow.monitor.client.AbstractJumpTargetActivityUI;
import com.kingdee.bos.workflow.monitor.client.Res;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.service.ormrpc.struct.WfProcessImageUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;

public class JumpTargetActivityUI
extends AbstractJumpTargetActivityUI {
    private static final Logger logger = CoreUIObject.getLogger(JumpTargetActivityUI.class);
    private final String resourceClass = "com.kingdee.bos.workflow.monitor.client.JumpUIResource";
    private String procInstId;
    JTextArea textArea = new JTextArea();
    int num = 0;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        Map names;
        super.onLoad();
        this.windowTitle = this.getResourceString("selectTargetActivity");
        this.tableActivitys.setEditable(false);
        this.tableActivitys.checkParsed();
        this.tableActivitys.removeRows();
        this.kDContainer1.setSize(320, 200);
        this.tableActivitys.setSize(300, 160);
        KDContainer opinionContainer = new KDContainer();
        ResourceBundle res = Res.getResource();
        opinionContainer.setTitle(res.getString("reason"));
        opinionContainer.setBounds(new Rectangle(10, 220, 320, 100));
        this.add((Component)opinionContainer, null);
        this.textArea.setLineWrap(true);
        this.textArea.setText("");
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        scrollPane.setBounds(10, 25, 300, 70);
        opinionContainer.add((Component)scrollPane);
        this.procInstId = (String)this.getUIContext().get("procInstId");
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        List list = service.getJumpTargetActivitys(this.procInstId);
        IRow row = this.tableActivitys.addHeadRow(0);
        ICell cell = row.getCell(0);
        cell.setValue((Object)this.getResourceString("activityType"));
        cell = row.getCell(1);
        cell.setValue((Object)this.getResourceString("activityName"));
        if (list.size() > 0) {
            ProcessDef def = (ProcessDef)((ActivityDef)list.get(0)).getContainer();
            names = WfProcessImageUtil.rename((ProcessDef)def, (Locale)this.getCurrentLocale());
        } else {
            names = Collections.emptyMap();
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ActivityDef actDef = (ActivityDef)list.get(i);
            row = this.tableActivitys.addRow(i);
            ICell cellActivityType = row.getCell(0);
            cellActivityType.setValue((Object)this.getActivityType(actDef));
            ICell cellActName = row.getCell(1);
            cellActName.setValue(names.get(actDef.getID()));
            row.setUserObject((Object)actDef);
        }
        this.tableActivitys.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                JumpTargetActivityUI.this.talbeClicked(e);
            }
        });
        this.actname.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                block3: {
                    block2: {
                        if (e.getKeyCode() == 40) break block2;
                        if (e.getKeyCode() == 10) break block2;
                        if (e.getKeyCode() != 32) break block3;
                    }
                    JumpTargetActivityUI.this.jumpTargetSearch();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JumpTargetActivityUI.this.jumpTargetSearch();
            }
        });
    }

    void test() {
        boolean searchcheck = false;
        Timer timer = new Timer();
        timer.schedule((TimerTask)new MyTask(), 0L);
        String name = this.actname.getText().trim();
        int j = 0;
        for (int i = 0; i < this.tableActivitys.getRowCount(); ++i) {
            IRow row = this.tableActivitys.getRow(i);
            ICell cell = row.getCell("colActivityName");
            String str = cell.getValue().toString().trim();
            int t = str.indexOf(name);
            if (t < 0) continue;
            if (j == this.num) {
                KDTSelectBlock sb = new KDTSelectBlock();
                sb.setTop(row.getRowIndex());
                sb.setLeft(0);
                sb.setBottom(row.getRowIndex());
                sb.setRight(0);
                sb.setMode(2);
                this.tableActivitys.getSelectManager().remove();
                this.tableActivitys.getSelectManager().add(sb);
                searchcheck = true;
                this.tableActivitys.getLayoutManager().scrollRowToShow(i);
            }
            ++j;
        }
    }

    private void jumpTargetSearch() {
        boolean searchcheck = false;
        boolean check = false;
        String name = this.actname.getText().trim();
        int rowNum = this.tableActivitys.getSelectManager().getActiveRowIndex();
        IRow row2 = this.tableActivitys.getRow(rowNum);
        if (row2 != null && !check) {
            this.tableActivitys.getSelectManager().remove();
            check = true;
        }
        int j = 0;
        for (int i = 0; i < this.tableActivitys.getRowCount(); ++i) {
            IRow row = this.tableActivitys.getRow(i);
            ICell cell = row.getCell("colActivityName");
            String str = cell.getValue().toString().trim();
            int t = str.indexOf(name);
            if (t < 0 || str == null) continue;
            if (j == this.num) {
                KDTSelectBlock sb = new KDTSelectBlock();
                sb.setTop(row.getRowIndex());
                sb.setLeft(0);
                sb.setBottom(row.getRowIndex());
                sb.setRight(0);
                sb.setMode(2);
                this.tableActivitys.getSelectManager().remove();
                this.tableActivitys.getSelectManager().add(sb);
                searchcheck = true;
                this.tableActivitys.getLayoutManager().scrollRowToShow(i);
            }
            ++j;
        }
        if (this.num >= j && !searchcheck) {
            this.num = -1;
            this.test();
        }
        ++this.num;
    }

    protected void talbeClicked(KDTMouseEvent e) {
        try {
            if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
                ActionEvent event = new ActionEvent(this.btnOk, 1001, this.btnOk.getActionCommand());
                this.btnOk_actionPerformed(event);
            }
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    private String getActivityType(ActivityDef actDef) {
        if (actDef instanceof ScriptActivityDef) {
            return this.getResourceString("scriptActivity");
        }
        if (actDef instanceof MessageActivityDef) {
            return this.getResourceString("messageActivity");
        }
        if (actDef instanceof ToolActivityDef) {
            return this.getResourceString("toolActivity");
        }
        if (actDef instanceof ManpowerActivityDef) {
            return this.getResourceString("manpowerActivity");
        }
        if (actDef instanceof RouterActivityDef) {
            return this.getResourceString("routerActivity");
        }
        if (actDef instanceof SubflowActivityDef) {
            return this.getResourceString("subflowActivity");
        }
        return "";
    }

    public String getResourceString(String key) {
        return EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.JumpUIResource", (String)key);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.tableActivitys.getRow(this.tableActivitys.getSelectManager().getActiveRowIndex());
        if (row == null) {
            MsgBox.showInfo((String)this.getResourceString("PLEASE_SELECT_DESTACTIVITY"));
            return;
        }
        String opinion = this.textArea.getText().trim() + "jumpto";
        ActivityDef actDef = (ActivityDef)row.getUserObject();
        try {
            IWfUtil util = (IWfUtil)RpcProxy.wrapRequired(IWfUtil.class, (String)WfUtil.class.getName());
            util.jumpTo(this.procInstId, actDef.getID(), opinion);
            this.actionExitCurrent_actionPerformed(e);
        }
        catch (WfException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            MsgBox.showError((String)this.getResourceString("jumpFailed"));
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            MsgBox.showError((String)this.getResourceString("jumpFailed"));
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    class MyTask
    extends TimerTask {
        MyTask() {
        }

        @Override
        public void run() {
            JumpTargetActivityUI.this.actname.requestFocus();
        }
    }
}

