/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.client;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.monitor.Pair;
import com.kingdee.bos.workflow.monitor.client.Res;
import com.kingdee.bos.workflow.monitor.client.WfUtils;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class PersonAndOpinionBox
extends JDialog {
    private static final long serialVersionUID = -3996969362481395308L;
    private String text;
    private PersonInfo info;
    private int type = 0;
    JTextField person = new JTextField(31);
    private final String res2 = "com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource";

    private PersonAndOpinionBox() {
    }

    public void setType(int type) {
        this.type = type;
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setModal(true);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int screenRes = toolkit.getScreenResolution();
        if (screenRes < 100) {
            this.setSize(500, 210);
        } else if (screenRes < 140 && screenRes >= 100) {
            this.setSize(570, 240);
        } else if (screenRes > 140) {
            this.setSize(610, 270);
        }
        Dimension size = toolkit.getScreenSize();
        this.setLocation((int)(size.getWidth() - 500.0) / 2, (int)(size.getHeight() - 210.0) / 2);
        this.setLayout(new FlowLayout(2));
        ResourceBundle res = Res.getResource();
        JLabel label = new JLabel(res.getString("performer"));
        this.add(label);
        this.person.setEditable(false);
        this.person.setEnabled(false);
        this.add(this.person);
        KDButton btnSelect = new KDButton(res.getString("select"));
        this.add((Component)btnSelect);
        btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PersonAndOpinionBox.this.selectPerson();
            }
        });
        final JTextArea textArea = new JTextArea(6, 42);
        textArea.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane(textArea);
        KDButton btnOK = new KDButton(res.getString("ok"));
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PersonAndOpinionBox.this.info == null) {
                    PersonAndOpinionBox.this.selectPerson();
                    return;
                }
                String s = textArea.getText().trim();
                PersonAndOpinionBox.this.text = s;
                PersonAndOpinionBox.this.dispose();
            }
        });
        btnOK.setLocation(300, 200);
        KDButton btnCancel = new KDButton(res.getString("cancel"));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PersonAndOpinionBox.this.dispose();
            }
        });
        this.add(scrollPane);
        this.add((Component)btnOK);
        this.add((Component)btnCancel);
    }

    private void selectPerson() {
        try {
            MetaDataPK pk = new MetaDataPK("com.kingdee.eas.basedata.person.app", "AllPersonQuery");
            QueryInfo queryInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)pk);
            HashMap<String, Object> promptContext = new HashMap<String, Object>();
            if (this.type == 0) {
                promptContext.put("DEFAULT_SHOW_ALL", Boolean.TRUE);
            }
            promptContext.put("0", "1");
            promptContext.put("All_Admins", Boolean.TRUE);
            PersonPromptBox dialog = new PersonPromptBox(null, promptContext);
            dialog.setQueryInfo(queryInfo);
            dialog.setModal(true);
            dialog.setEnabledMultiSelection(false);
            dialog.setIsSingleSelect(true);
            this.setPersonF7Filter(dialog);
            dialog.show();
            Object data = dialog.getData();
            if (dialog.isCanceled()) {
                return;
            }
            if (!(data instanceof Object[])) {
                MsgBox.showWarning((Component)this, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"chosenUserIsNull"));
                return;
            }
            Object[] datas = (Object[])data;
            if (datas.length == 0) {
                MsgBox.showWarning((Component)this, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"chosenUserIsNull"));
                return;
            }
            PersonInfo personInfo = (PersonInfo)datas[0];
            String personId = personInfo.getId().toString();
            if (!WfUtils.checkPersonHasUser(personId)) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"msgPersonHasNoUser"));
                return;
            }
            this.info = personInfo;
            this.person.setText(personInfo.getName());
        }
        catch (Exception ex) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"msgPersonHasNoUser"));
            return;
        }
    }

    private void setPersonF7Filter(PersonPromptBox dialog) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("EMPLOYEETYPE.inService", (Object)new Integer(0), CompareType.NOTEQUALS));
        view.setFilter(filter);
        dialog.setEntityViewInfo(view);
    }

    public static Pair<String, PersonInfo> read(String title) {
        PersonAndOpinionBox box = new PersonAndOpinionBox();
        box.setTitle(title);
        box.setType(10);
        box.init();
        box.setVisible(true);
        if (box.text == null) {
            return null;
        }
        return new Pair<String, PersonInfo>(box.text, box.info);
    }

    public static Pair<String, PersonInfo> readType(String title, int type) {
        PersonAndOpinionBox box = new PersonAndOpinionBox();
        box.setTitle(title);
        box.setType(type);
        box.init();
        box.setVisible(true);
        if (box.text == null) {
            return null;
        }
        return new Pair<String, PersonInfo>(box.text, box.info);
    }
}

