/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.workflow.metas.IWFRProcessInstLog;
import com.kingdee.bos.workflow.metas.WFRProcessInstLogCollection;
import com.kingdee.bos.workflow.metas.WFRProcessInstLogFactory;
import com.kingdee.bos.workflow.monitor.client.AbstractProcessLogListUI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;

public class ProcessLogListUI
extends AbstractProcessLogListUI {
    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.enableExportExcel(this.tblLogList);
        this.initTable();
        String processInstId = (String)this.getUIContext().get("processInstId");
        IWFRProcessInstLog IWFLog = WFRProcessInstLogFactory.getRemoteInstance();
        String oql = "select id, processDefID, processVersion, processInstID, logType, event, description,longDescription, extendedDescription, server, time where processInstID ='" + processInstId + "' ordre by time desc";
        WFRProcessInstLogCollection wfLogs = IWFLog.getCollection(oql);
        this.fillTable(wfLogs);
        this.toolBar.setVisible(false);
    }

    public void fillTable(WFRProcessInstLogCollection logs) {
        int count = logs.size();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblLogList.addRow(i);
            ICell cell = row.getCell(0);
            cell.setValue((Object)logs.get(i).getProcessDefID());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell(1);
            cell.setValue((Object)Integer.toString(logs.get(i).getProcessVersion()));
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell(2);
            cell.setValue((Object)logs.get(i).getProcessInstID());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell(3);
            cell.setValue((Object)logs.get(i).getLogType());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell(4);
            cell.setValue((Object)logs.get(i).getEvent());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell(5);
            cell.setValue((Object)logs.get(i).getDescription());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell(6);
            cell.setValue((Object)logs.get(i).getLongDescription());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell(7);
            cell.setValue((Object)logs.get(i).getExtendedDescription());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell(8);
            cell.setValue((Object)logs.get(i).getServer());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell(9);
            cell.setValue((Object)logs.get(i).getTime());
            cell.getStyleAttributes().setLocked(true);
        }
    }

    public void initTable() {
        this.tblLogList.removeRows();
        this.tblLogList.removeHeadRows();
        int colCount = 10;
        int j = 0;
        for (int i = 0; i < colCount; ++i) {
            this.tblLogList.addColumn(j);
        }
        IRow row = this.tblLogList.addHeadRow(0);
        ICell cell = row.getCell(0);
        cell.setValue((Object)"\u8fdb\u7a0b\u5b9a\u4e49ID");
        cell = row.getCell(1);
        cell.setValue((Object)"\u7248\u672c");
        cell = row.getCell(2);
        cell.setValue((Object)"\u8fdb\u7a0b\u5b9e\u4f8bID");
        cell = row.getCell(3);
        cell.setValue((Object)"\u65e5\u5fd7\u7c7b\u578b");
        cell = row.getCell(4);
        cell.setValue((Object)"\u4e8b\u4ef6");
        cell = row.getCell(5);
        cell.setValue((Object)"\u63cf\u8ff0");
        cell = row.getCell(6);
        cell.setValue((Object)"\u8be6\u7ec6\u63cf\u8ff0");
        cell = row.getCell(7);
        cell.setValue((Object)"\u6269\u5c55\u63cf\u8ff0");
        cell = row.getCell(8);
        cell.setValue((Object)"\u670d\u52a1\u5668");
        cell = row.getCell(9);
        cell.setValue((Object)"\u65f6\u95f4");
        this.tblLogList.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                Object msg;
                int colIndex = e.getRowIndex();
                int rowIndex = e.getColIndex();
                if (e.getClickCount() == 2 && e.getType() == 1 && (msg = ProcessLogListUI.this.tblLogList.getCell(colIndex, rowIndex).getValue()) != null && msg.toString().length() > 0) {
                    MsgBox.showInfo((String)msg.toString());
                }
            }
        });
    }

    @Override
    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        IWFRProcessInstLog IWFLog = WFRProcessInstLogFactory.getRemoteInstance();
        IWFLog.delete("where time <> '1980-09-30'");
        this.onLoad();
    }
}

