/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.client;

import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.monitor.client.AbstractProcessPropertyEditUI;
import com.kingdee.bos.workflow.monitor.client.MonitorResourceUtil;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.store.util.RelevantData;
import com.kingdee.bos.workflow.store.util.RelevantDataType;
import com.kingdee.bos.workflow.store.util.RelevantDataValueConvertor;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ProcessPropertyEditUI
extends AbstractProcessPropertyEditUI {
    String processInstId;
    String approveResultStr = "";
    private static final Logger logger = CoreUIObject.getLogger(ProcessPropertyEditUI.class);

    public void onLoad() throws Exception {
        this.txtName.setEditable(false);
        this.txtName.setText((String)this.getUIContext().get("Name"));
        this.txtType.setText((String)this.getUIContext().get("Type"));
        this.txtOriginalValue.setText((String)this.getUIContext().get("OriginalValue"));
        this.processInstId = (String)this.getUIContext().get("ProcessInstId");
        this.approveResultStr = (String)this.getUIContext().get("approveResultStr");
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    private void changeApproveResultProperty() {
        if (!StringUtils.isEmpty((String)this.approveResultStr) && this.txtType.getText().equals("APPROVERESULT_CHILD")) {
            String approveName = this.approveResultStr.substring(0, this.approveResultStr.indexOf("@@"));
            String oldApproveResult = this.approveResultStr.substring(this.approveResultStr.indexOf("@@") + 2);
            String approve = oldApproveResult.substring(oldApproveResult.indexOf("{") + 1, oldApproveResult.indexOf("}"));
            String[] arg = this.getMultiApproveValueArray(approve);
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < arg.length; ++i) {
                if (arg[i] == null) continue;
                map.put(arg[i].substring(0, arg[i].indexOf("=")).trim(), arg[i].substring(arg[i].indexOf("=") + 1).trim());
            }
            String newValue = this.txtNewValue.getText().trim();
            String propertyName = this.txtName.getText().trim();
            if (propertyName.equals("handleropinion") && !ProcessPropertyEditUI.isNumeric(newValue)) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u8f93\u5165\u7684\u65b0\u503c\u5fc5\u987b\u4e3a\u6570\u5b57\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!");
                this.abort();
            }
            if (propertyName.equals("ispass") && !newValue.equals("true") && !newValue.equals("false")) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u8f93\u5165\u7684\u65b0\u503c\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u53ea\u80fd\u4e3atrue\u6216false\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!");
                this.abort();
            }
            if (propertyName.equals("id")) {
                try {
                    BOSUuid.read((String)newValue);
                }
                catch (Exception e) {
                    MsgBox.showInfo((Component)((Object)this), (String)"\u8f93\u5165\u7684ID\u4e0d\u662f\u6807\u51c6\u7684BOSUuid\u7c7b\u578b\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!");
                    this.abort();
                }
            }
            if (map.containsKey(propertyName)) {
                map.remove(propertyName);
            }
            map.put(propertyName, newValue);
            String newApproveResult = "[id: " + map.get("id").toString() + "]" + map.toString();
            this.txtName.setText(approveName);
            this.txtType.setText("APPROVERESULT");
            this.txtOriginalValue.setText(oldApproveResult);
            this.txtNewValue.setText(newApproveResult);
        }
    }

    public static boolean isNumeric(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void actionEnter_actionPerformed(ActionEvent e) throws Exception {
        BOSUuid tempUuid;
        String url = UIConfig.getUrl();
        ORMRPCServiceLocator.setCurrentServiceURL((String)url);
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        this.changeApproveResultProperty();
        RelevantDataType type = new RelevantDataType();
        String typeName = this.stringToType(this.txtType.getText());
        if (type.isArray() || typeName.equalsIgnoreCase("PK") || typeName.equalsIgnoreCase("OBJECTVALUE") || typeName.equalsIgnoreCase("OBJECT") || typeName.equalsIgnoreCase("ENUM") || typeName.equalsIgnoreCase("PERFORMER") || typeName.equalsIgnoreCase("DATETIME")) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u5f53\u524d\u6570\u636e\u7c7b\u578b\u4e0d\u652f\u6301\u7f16\u8f91\uff01");
            this.abort();
        } else if (!typeName.equalsIgnoreCase("STRING")) {
            String msg;
            String newValue;
            if (this.txtNewValue.getText().equals("")) {
                String msg2 = MonitorResourceUtil.getWorkFlowMonitorResource("VALUE_DONT_MATCH_DATATYPE");
                MsgBox.showInfo((Component)((Object)this), (String)msg2);
                this.abort();
            } else if (typeName.equalsIgnoreCase("INTEGER")) {
                newValue = this.txtNewValue.getText();
                if (!StringUtils.isEmpty((String)newValue)) {
                    try {
                        Integer.valueOf(newValue);
                    }
                    catch (NumberFormatException ex) {
                        msg = MonitorResourceUtil.getWorkFlowMonitorResource("VALUE_DONT_MATCH_DATATYPE");
                        MsgBox.showInfo((Component)((Object)this), (String)msg);
                        this.abort();
                    }
                }
            } else if (typeName.equalsIgnoreCase("FLOAT")) {
                newValue = this.txtNewValue.getText();
                if (!StringUtils.isEmpty((String)newValue)) {
                    try {
                        Float.valueOf(newValue);
                    }
                    catch (NumberFormatException ex) {
                        msg = MonitorResourceUtil.getWorkFlowMonitorResource("VALUE_DONT_MATCH_DATATYPE");
                        MsgBox.showInfo((Component)((Object)this), (String)msg);
                        this.abort();
                    }
                }
            } else if (typeName.equalsIgnoreCase("BOOLEAN")) {
                newValue = this.txtNewValue.getText();
                if (!StringUtils.isEmpty((String)newValue)) {
                    try {
                        Boolean.valueOf(newValue);
                    }
                    catch (NumberFormatException ex) {
                        msg = MonitorResourceUtil.getWorkFlowMonitorResource("VALUE_DONT_MATCH_DATATYPE");
                        MsgBox.showInfo((Component)((Object)this), (String)msg);
                        this.abort();
                    }
                }
            } else if (typeName.equalsIgnoreCase("BOID") && !StringUtils.isEmpty((String)(newValue = this.txtNewValue.getText()))) {
                try {
                    BOSUuid.read((String)newValue);
                }
                catch (UuidException ex) {
                    msg = MonitorResourceUtil.getWorkFlowMonitorResource("VALUE_DONT_MATCH_DATATYPE");
                    MsgBox.showInfo((Component)((Object)this), (String)msg);
                    this.abort();
                }
                catch (IllegalArgumentException ex) {
                    msg = MonitorResourceUtil.getWorkFlowMonitorResource("VALUE_DONT_MATCH_DATATYPE");
                    MsgBox.showInfo((Component)((Object)this), (String)msg);
                    this.abort();
                }
            }
        }
        type.setArray(false);
        RelevantData data = this.getNewRelevantDataValue(type);
        if (data.getValue() instanceof BOSUuid && (tempUuid = (BOSUuid)data.getValue()).toString().equals(this.txtOriginalValue.getText())) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u65b0\u503c");
            return;
        }
        RelevantDataValueConvertor convertor = new RelevantDataValueConvertor(data);
        Object value = convertor.stringToValue();
        service.setProcessContext(this.processInstId, this.txtName.getText(), value);
        this.destroyWindow();
    }

    private RelevantData getNewRelevantDataValue(RelevantDataType type) throws WfException {
        String typeName = this.stringToType(this.txtType.getText());
        type.setMajorType(typeName);
        RelevantData data = new RelevantData();
        data.setDataType(type);
        Object objectValue = this.getObjectValue(typeName, this.txtNewValue.getText());
        data.setValue(objectValue);
        return data;
    }

    private Object getObjectValue(String type, String stringValue) {
        Object result = null;
        if (type.equalsIgnoreCase("BOID")) {
            result = BOSUuid.read((String)stringValue);
        } else if (type.equalsIgnoreCase("STRING")) {
            result = stringValue;
        } else if (type.equalsIgnoreCase("INTEGER")) {
            result = Integer.valueOf(stringValue);
        } else if (type.equalsIgnoreCase("FLOAT")) {
            result = Float.valueOf(stringValue);
        } else if (type.equalsIgnoreCase("BOOLEAN")) {
            result = Boolean.valueOf(stringValue);
        } else {
            if (type.equalsIgnoreCase("PK")) {
                throw new UnsupportedOperationException();
            }
            if (type.equalsIgnoreCase("APPROVERESULT")) {
                HashMap map = this.getMultiApproveValueFromString(stringValue);
                result = this.mapToMultiapproveInfo(map);
            } else {
                if (type.equalsIgnoreCase("OBJECTVALUE")) {
                    throw new UnsupportedOperationException();
                }
                if (type.equalsIgnoreCase("OBJECT")) {
                    throw new UnsupportedOperationException();
                }
                if (type.equalsIgnoreCase("ENUM")) {
                    throw new UnsupportedOperationException();
                }
                if (type.equalsIgnoreCase("PERFORMER")) {
                    throw new UnsupportedOperationException();
                }
                if (type.equalsIgnoreCase("DATETIME")) {
                    throw new UnsupportedOperationException();
                }
                throw new UnsupportedOperationException();
            }
        }
        return result;
    }

    private MultiApproveInfo mapToMultiapproveInfo(HashMap map) {
        MultiApproveInfo info = new MultiApproveInfo();
        info.setId(BOSUuid.read((String)((String)map.get("id"))));
        info.setMultiHandleOpinion((String)map.get("multihandleopinion"));
        info.setIsPass(map.get("ispass").equals("true") ? ApproveResult.PASS : ApproveResult.NOT_PASS);
        info.setOpinion((String)map.get("opinion_l1"), new Locale("l1"));
        info.setOpinion((String)map.get("opinion_l2"), new Locale("l2"));
        info.setOpinion((String)map.get("opinion_l3"), new Locale("l3"));
        info.setOpinion((String)map.get("opinion"));
        info.setHandlerOpinion(Integer.valueOf((String)map.get("handleropinion")).intValue());
        return info;
    }

    private String[] getMultiApproveValueArray(String approveStr) {
        String[] strs = approveStr.split(", ");
        for (int i = 0; i < strs.length; ++i) {
            boolean flag = false;
            if (strs[i].startsWith("multihandleopinion=")) {
                flag = true;
            } else if (strs[i].startsWith("opinion=")) {
                flag = true;
            } else if (strs[i].startsWith("ispass=")) {
                flag = true;
            } else if (strs[i].startsWith("opinion_l1=")) {
                flag = true;
            } else if (strs[i].startsWith("opinion_l2=")) {
                flag = true;
            } else if (strs[i].startsWith("opinion_l3=")) {
                flag = true;
            } else if (strs[i].startsWith("id=")) {
                flag = true;
            } else if (strs[i].startsWith("handleropinion=")) {
                flag = true;
            } else if (strs[i].startsWith("creator=")) {
                flag = true;
            } else if (strs[i].startsWith("createtime=")) {
                flag = true;
            }
            if (flag || i <= 0) continue;
            int n = i - 1;
            strs[n] = strs[n] + ", " + strs[i];
            strs[i] = null;
        }
        return strs;
    }

    private HashMap getMultiApproveValueFromString(String str) {
        String approveStr = str.substring(str.indexOf("{") + 1, str.indexOf("}"));
        String[] strs = this.getMultiApproveValueArray(approveStr);
        HashMap<String, String> map = new HashMap<String, String>();
        String temp = "";
        for (int i = 0; i < strs.length; ++i) {
            if (strs[i] == null) continue;
            temp = strs[i];
            String name = temp.substring(0, temp.indexOf("="));
            String value = temp.substring(temp.indexOf("=") + 1, temp.length());
            map.put(name.trim(), value.trim());
        }
        return map;
    }

    private String stringToType(String type) {
        String result = null;
        result = type.equalsIgnoreCase("\u5185\u7801\uff08BOID\uff09") ? "BOID" : (type.equalsIgnoreCase("\u5b57\u7b26\u4e32") ? "STRING" : (type.equalsIgnoreCase("\u6574\u578b") ? "INTEGER" : (type.equalsIgnoreCase("\u6d6e\u70b9\u578b") ? "FLOAT" : (type.equalsIgnoreCase("\u5e03\u5c14") ? "BOOLEAN" : (type.equalsIgnoreCase("\u4e3b\u952e(PK)") ? "PK" : (type.equalsIgnoreCase("\u503c\u5bf9\u8c61(ObjectValue)") ? "OBJECTVALUE" : (type.equalsIgnoreCase("\u5916\u90e8\u6570\u636e\u7c7b\u578b") ? "OBJECT" : (type.equalsIgnoreCase("\u679a\u4e3e") ? "ENUM" : (type.equalsIgnoreCase("\u53c2\u4e0e\u4eba(Performer)") ? "PERFORMER" : (type.equalsIgnoreCase("\u65e5\u671f") ? "DATETIME" : type))))))))));
        return result;
    }
}

