/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.streamwork.pivot.PivotUtils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.rpc.RpcProxy;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AbstractTaskServiceActivityDef;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.EndActivityDef;
import com.kingdee.bos.workflow.define.EventActivityDef;
import com.kingdee.bos.workflow.define.FunctionActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ReceiveSignalEndEventActivityDef;
import com.kingdee.bos.workflow.define.ReceiveSignalIntermediateEventActivityDef;
import com.kingdee.bos.workflow.define.RouterActivityDef;
import com.kingdee.bos.workflow.define.ScriptActivityDef;
import com.kingdee.bos.workflow.define.SignalStartEventActivityDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.TimerIntermediateEventActivityDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.define.extended.BotpActivityDef;
import com.kingdee.bos.workflow.define.extended.ManualDecisionActivityDef;
import com.kingdee.bos.workflow.define.extended.MessageActivityDef;
import com.kingdee.bos.workflow.define.extended.OtherSysActivityDef;
import com.kingdee.bos.workflow.ext.Config;
import com.kingdee.bos.workflow.ext.ConfigLoader;
import com.kingdee.bos.workflow.ext.IWfMonitorExt;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.monitor.IWfMonitorImageUIFacade;
import com.kingdee.bos.workflow.monitor.IWorkFlowMonitorPanelFacade;
import com.kingdee.bos.workflow.monitor.WfProcDiagramEncoder;
import com.kingdee.bos.workflow.monitor.WfProcessImage;
import com.kingdee.bos.workflow.monitor.client.ActivityTableUI;
import com.kingdee.bos.workflow.monitor.client.AppendDiagramDialog;
import com.kingdee.bos.workflow.monitor.client.BasicWorkFlowMonitorPanel;
import com.kingdee.bos.workflow.monitor.client.JumpTargetActivityUI;
import com.kingdee.bos.workflow.monitor.client.PermissionUtil;
import com.kingdee.bos.workflow.monitor.client.ProcessProperty;
import com.kingdee.bos.workflow.monitor.client.ShowPropertyPanel;
import com.kingdee.bos.workflow.monitor.client.WfMonitorUtils;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.service.ormrpc.IWfFacade;
import com.kingdee.bos.workflow.service.ormrpc.WfFacadeFactory;
import com.kingdee.bos.workflow.service.ormrpc.struct.IProcessImage;
import com.kingdee.eas.base.multiapprove.MetadataUtils;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class WorkFlowMonitorPanel
extends CoreUI {
    private static final Logger logger = CoreUIObject.getLogger(ShowPropertyPanel.class);
    private final String workflowResourceClass = "com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource";
    private static String imageUIFacade = null;
    private HashMap activityLabels;
    private static final long serialVersionUID = -3758980904202151345L;
    FontMetrics metrics = null;
    KDLabel label = null;
    KDLabel labeltext = null;
    KDLabel labeltext2 = null;
    ImageIcon icon = null;
    protected KDWorkButton flowpropertyButton;
    protected KDWorkButton nodepropertyButton;
    protected KDWorkButton showParentFlowButton;
    protected KDWorkButton btnTrace;
    protected KDWorkButton showInfoButton;
    protected KDWorkButton showTableButton;
    static KDLabel selectedLabel;
    public boolean isExit = false;
    protected String instID;
    private CoreUI basicUI;
    private IEnactmentService service;
    private boolean isPvmMode;
    private JEditorPane actTipsArea;
    private JScrollPane actTipsPos;
    private HashMap actTips = new HashMap();
    private final String processInstLogListUIClass = "com.kingdee.bos.workflow.report.client.ProcessInstLogListUI";
    PermissionUtil permissionUtil = new PermissionUtil();
    private final String resourceClass = "com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource";
    private final String res2 = "com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource";
    private String[] actInstInfoIdsForToolTip = null;
    IProcessImage image;
    WfProcessImage images;
    private static final Color BG_COLOR;
    IWfMonitorExt wfMonitorExt = null;
    private static Map ICON_MAP;
    private KDWorkButton refreshButton;
    private KDWorkButton jumpButton;
    private KDWorkButton showBillButton;
    private Image imagePlus = null;

    KDLabel getActLabel(String actDefId) {
        return (KDLabel)this.activityLabels.get(actDefId);
    }

    public WorkFlowMonitorPanel() throws Exception {
        this.wfMonitorExt = ConfigLoader.getConfig4Client().getWfMonitorExt(null);
    }

    public WorkFlowMonitorPanel(KDFrame frame) throws Exception {
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = (RequestContext)clientHanlder.getRequestContext();
            request.setClassName("com.kingdee.bos.workflow.monitor.app.WorkFlowMonitorPanelUIHandler");
            if (this.actInstInfoIdsForToolTip != null && this.actInstInfoIdsForToolTip.length > 0) {
                request.put("actInstIdsForToolTip", (Object)this.actInstInfoIdsForToolTip);
            }
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public boolean isPrepareInit() {
        return false;
    }

    public void addAllLabel() throws Exception {
        boolean perm = this.checkViewDiagramPermission();
        if (!perm) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"noPermision"));
            this.abort();
            return;
        }
        if (this.getComponents().length > 0) {
            this.removeAll();
        }
        this.activityLabels = new HashMap();
        this.actTipsArea = new JEditorPane();
        this.actTipsPos = new JScrollPane(this.actTipsArea);
        this.actTipsPos.setBounds(0, 0, 300, 200);
        this.actTipsArea.setEditable(false);
        this.actTipsArea.setContentType("text/html");
        this.actTipsPos.setVisible(false);
        this.actTipsArea.setBackground(new Color(255, 255, 231));
        this.actTipsPos.setBorder(LineBorder.createBlackLineBorder());
        this.add(this.actTipsPos);
        this.actTips.clear();
        this.isExit = false;
        int maxX = 0;
        int maxY = 0;
        IProcessImage.Activity[] activities = this.image.getActivities();
        HashMap activities1 = this.images.getActivities();
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        for (int i = 0; i < activities.length; ++i) {
            IProcessImage.Activity activity = activities[i];
            IProcessImage.Activity info = (IProcessImage.Activity)activities1.get(activity.actDefId);
            String name = activity.name;
            int count = activity.actInstIds != null ? activity.actInstIds.size() : 0;
            int x = activity.bound.x + this.image.getOffsetX();
            int y = activity.bound.y + this.image.getOffsetY();
            int height = activity.bound.height;
            int width = activity.bound.width;
            int tmp = metrics.stringWidth(name) + 4;
            if (count > 1) {
                name = name + "[" + count + "]";
            }
            String type = ".png";
            if (activity.iconResource.endsWith("running")) {
                type = ".gif";
            }
            this.icon = WorkFlowMonitorPanel.getIconByActivityTypeAndState(info.state, info.actDef, type, info.inited);
            int widths = metrics.stringWidth(name) + 5;
            if (tmp > width) {
                String[] names = this.getname(name, width, metrics);
                int a = metrics.stringWidth(names[1]) + 4;
                String[] names2 = null;
                if (a > width) {
                    names2 = this.getname(names[1], width, metrics);
                }
                this.label = new KDLabel(names[0], (Icon)this.icon, 0);
                this.label.setName(activity.actDefId);
                this.activityLabels.put(activity.actDefId, this.label);
                this.label.setBounds(x + 1, y + 1, width - 1, height + 5);
                if (names2 == null) {
                    this.labeltext = new KDLabel(names[1]);
                    this.labeltext.setBounds(x + 4, y + height - 4, metrics.stringWidth(names[1]), 30);
                    this.add((Component)this.labeltext);
                } else {
                    this.labeltext = new KDLabel(names2[0] + "\u2026");
                    this.labeltext.setBounds(x + 4, y + height - 4, metrics.stringWidth(names2[0]), 30);
                    this.add((Component)this.labeltext);
                }
            } else {
                this.label = new KDLabel(name, (Icon)this.icon, 0);
                this.label.setName(activity.actDefId);
                this.activityLabels.put(activity.actDefId, this.label);
                if (width > widths) {
                    widths = width;
                }
                this.label.setBounds(x + 1, y + 1, widths - 1, height - 1);
            }
            this.label.setFocusable(true);
            this.label.setVerticalTextPosition(3);
            this.label.setHorizontalTextPosition(0);
            if (x + width > maxX) {
                maxX = x + width;
            }
            if (y + height > maxY) {
                maxY = y + height;
            }
            this.label.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    Object obj = ((KDLabel)evt.getSource()).getUserObject();
                    if (!(obj instanceof IProcessImage.Activity)) {
                        return;
                    }
                    IProcessImage.Activity act = (IProcessImage.Activity)obj;
                    if (WorkFlowMonitorPanel.this.wfMonitorExt != null) {
                        WorkFlowMonitorPanel.this.wfMonitorExt.notifySelectedAct(act);
                    }
                    if (evt.getClickCount() == 1) {
                        if (selectedLabel != null) {
                            selectedLabel.setBorder(BorderFactory.createEmptyBorder());
                        }
                        if (BasicWorkFlowMonitorPanel.selectedLabel != null) {
                            BasicWorkFlowMonitorPanel.selectedLabel.setBorder(BorderFactory.createEmptyBorder());
                        }
                        if ((selectedLabel = (KDLabel)evt.getSource()) != null) {
                            if (WorkFlowMonitorPanel.this.nodepropertyButton != null) {
                                if (act.actInstIds != null) {
                                    WorkFlowMonitorPanel.this.nodepropertyButton.setEnabled(true);
                                } else {
                                    WorkFlowMonitorPanel.this.nodepropertyButton.setEnabled(false);
                                }
                            }
                            selectedLabel.setBorder(BorderFactory.createLineBorder(Color.black));
                        }
                    } else if (evt.getClickCount() == 2) {
                        try {
                            if (act.actInstIds != null) {
                                boolean perm = WorkFlowMonitorPanel.this.permissionUtil.checkOperate("wf_report_Monitor_ViewActivityProperty");
                                if (perm) {
                                    WorkFlowMonitorPanel.this.showPropertyDialog(act.actInstIds, act.actDefId);
                                } else {
                                    WorkFlowMonitorPanel.this.handleException("noPerm");
                                }
                            } else if (act.subflowDefId != null) {
                                WfMonitorUtils.showWfDiagramDefine((Component)((Object)WorkFlowMonitorPanel.this), act.subflowDefId);
                            }
                        }
                        catch (Exception e) {
                            WorkFlowMonitorPanel.this.handUIException(e);
                        }
                    }
                }
            });
            if (activity.isManpower || info.actDef instanceof MessageActivityDef) {
                this.label.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        WorkFlowMonitorPanel.this.showManActivityTooltips(e);
                    }
                });
            }
            if (info.actDef instanceof TimerIntermediateEventActivityDef) {
                this.label.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        WorkFlowMonitorPanel.this.showEventWaiterActTips(e);
                    }
                });
            }
            this.label.setUserObject((Object)activity);
            this.add((Component)this.label);
            if (!activity.hasAppended) continue;
            Image image = this.getImagePlus();
            KDLabel plusLabel = new KDLabel((Icon)new ImageIcon(image));
            Rectangle bound = this.label.getBounds();
            plusLabel.setBounds(bound.x + 40, bound.y - 20, 20, 20);
            this.add((Component)plusLabel);
            final IProcessImage.Activity act = activity;
            plusLabel.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1) {
                        WorkFlowMonitorPanel.this.showAppendDialog(act);
                    }
                }
            });
        }
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent arg0) {
            }

            @Override
            public void mouseMoved(MouseEvent arg0) {
                WorkFlowMonitorPanel.this.hideManActivityTooltips();
            }
        });
        this.setPreferredSize(new Dimension(maxX += 40, maxY += 40));
        this.setMaximumSize(new Dimension(maxX, maxY));
        this.setMinimumSize(new Dimension(maxX, maxY));
        this.repaint();
    }

    private String[] getname(String name, int width, FontMetrics metrics) {
        int tmp;
        String name1 = "";
        String name2 = "";
        for (int i = 0; i < name.length() && (tmp = metrics.stringWidth(name.substring(0, i + 1)) + 4) <= width; ++i) {
            name1 = name.substring(0, i + 1);
            name2 = name.substring(i + 1, name.length());
        }
        return new String[]{name1, name2};
    }

    private static ImageIcon getIconByActivityTypeAndState(String stateStr, ActivityDef actDef, String type, boolean inited) {
        WfState state;
        String name = null;
        WfState wfState = state = stateStr == null ? null : WfState.getEnum((String)stateStr);
        if (actDef instanceof StartActivityDef) {
            name = WfState.COMPLETED.equals((Object)state) ? "wf_start_complete" : "wf_start";
        } else if (actDef instanceof EndActivityDef) {
            name = WfState.COMPLETED.equals((Object)state) ? "wf_end_complete" : "wf_end";
        } else if (actDef instanceof RouterActivityDef) {
            name = ((RouterActivityDef)actDef).isSync() ? (WfState.COMPLETED.equals((Object)state) ? "wf_wait_complete" : "wf_wait") : (WfState.COMPLETED.equals((Object)state) ? "wf_empty_complete" : "wf_empty");
        } else if (actDef instanceof ManpowerActivityDef) {
            name = actDef instanceof ApproveActivityDef ? (state == null ? "wf_audit" : (WfState.NOT_STARTED.equals((Object)state) ? "wf_audit_running" : (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state) ? "wf_audit_suspend" : (WfState.ABORTED.equals((Object)state) ? "wf_audit_abort" : (WfState.TERMINATED.equals((Object)state) ? "wf_audit_terminate" : (WfState.RUNNING.equals((Object)state) ? "wf_audit" : (WfState.COMPLETED.equals((Object)state) && !inited ? "wf_audit_hasNoPersonAndSkip" : "wf_audit_complete"))))))) : (actDef instanceof ManualDecisionActivityDef ? (state == null ? "wf_decision" : (WfState.NOT_STARTED.equals((Object)state) ? "wf_decision_running" : (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state) ? "wf_decision_suspend" : (WfState.ABORTED.equals((Object)state) ? "wf_decision_abort" : (WfState.TERMINATED.equals((Object)state) ? "wf_decision_terminate" : (WfState.RUNNING.equals((Object)state) ? "wf_decision" : "wf_decision_complete")))))) : (state == null ? "wf_manual" : (WfState.NOT_STARTED.equals((Object)state) ? "wf_manual_running" : (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state) ? "wf_manual_suspend" : (WfState.ABORTED.equals((Object)state) ? "wf_manual_abort" : (WfState.TERMINATED.equals((Object)state) ? "wf_manual_terminate" : (WfState.RUNNING.equals((Object)state) ? "wf_manual" : "wf_manual_complete")))))));
        } else if (actDef instanceof ToolActivityDef) {
            name = actDef instanceof MessageActivityDef ? (state == null ? "wf_message" : (WfState.NOT_STARTED.equals((Object)state) ? "wf_message_running" : (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state) ? "wf_message_suspend" : (WfState.ABORTED.equals((Object)state) ? "wf_message_abort" : (WfState.TERMINATED.equals((Object)state) ? "wf_message_terminate" : "wf_message_complete"))))) : (actDef instanceof ScriptActivityDef ? (state == null ? "wf_script" : (WfState.NOT_STARTED.equals((Object)state) ? "wf_script_running" : (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state) ? "wf_script_suspend" : (WfState.ABORTED.equals((Object)state) ? "wf_script_abort" : (WfState.TERMINATED.equals((Object)state) ? "wf_script_terminate" : "wf_script_complete"))))) : (actDef instanceof FunctionActivityDef ? (state == null ? "wf_function" : (WfState.NOT_STARTED.equals((Object)state) ? "wf_function_running" : (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state) ? "wf_function_suspend" : (WfState.ABORTED.equals((Object)state) ? "wf_function_abort" : (WfState.TERMINATED.equals((Object)state) ? "wf_function_terminate" : "wf_function_complete"))))) : (actDef instanceof BotpActivityDef ? (state == null ? "wf_botp" : (WfState.NOT_STARTED.equals((Object)state) ? "wf_botp_running" : (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state) ? "wf_botp_suspend" : (WfState.ABORTED.equals((Object)state) ? "wf_botp_abort" : (WfState.TERMINATED.equals((Object)state) ? "wf_botp_terminate" : "wf_botp_complete"))))) : (actDef instanceof OtherSysActivityDef ? (state == null ? "imgWf_otherSys" : (WfState.NOT_STARTED.equals((Object)state) ? "imgWf_otherSys_running" : (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state) ? "imgWf_otherSys_suspend" : (WfState.ABORTED.equals((Object)state) ? "imgWf_otherSys_abort" : (WfState.TERMINATED.equals((Object)state) ? "imgWf_otherSys_terminate" : "imgWf_otherSys_complete"))))) : (state == null ? "wf_auto" : (WfState.NOT_STARTED.equals((Object)state) ? "wf_auto_running" : (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state) ? "wf_auto_suspend" : (WfState.ABORTED.equals((Object)state) ? "wf_auto_abort" : (WfState.TERMINATED.equals((Object)state) ? "wf_auto_terminate" : "wf_auto_complete")))))))));
        } else if (actDef instanceof SubflowActivityDef) {
            name = state == null ? "wf_subflow" : (WfState.NOT_STARTED.equals((Object)state) ? "wf_subflow_running" : (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state) ? "wf_subflow_suspend" : (WfState.ABORTED.equals((Object)state) ? "wf_subflow_abort" : (WfState.TERMINATED.equals((Object)state) ? "wf_subflow_terminate" : (WfState.RUNNING.equals((Object)state) ? "wf_subflow_running" : "wf_subflow_complete")))));
        } else if (actDef instanceof EventActivityDef) {
            if (actDef instanceof ReceiveSignalIntermediateEventActivityDef || actDef instanceof ReceiveSignalEndEventActivityDef || actDef instanceof SignalStartEventActivityDef) {
                name = "wf_waitevent_receiver";
                if (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state)) {
                    name = name + "_suspend";
                } else if (WfState.ABORTED.equals((Object)state)) {
                    name = name + "_abort";
                } else if (WfState.TERMINATED.equals((Object)state)) {
                    name = name + "_terminate";
                } else if (WfState.COMPLETED.equals((Object)state)) {
                    name = name + "_complete";
                }
            } else if (actDef instanceof TimerIntermediateEventActivityDef) {
                name = "wf_waitevent_timer";
                if (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state)) {
                    name = name + "_suspend";
                } else if (WfState.ABORTED.equals((Object)state)) {
                    name = name + "_abort";
                } else if (WfState.TERMINATED.equals((Object)state)) {
                    name = name + "_terminate";
                } else if (WfState.COMPLETED.equals((Object)state)) {
                    name = name + "_complete";
                } else if (WfState.RUNNING.equals((Object)state) || WfState.NOT_STARTED.equals((Object)state)) {
                    name = name + "_running";
                } else {
                    type = ".png";
                }
            } else {
                name = "wf_event_sender";
                if (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state)) {
                    name = name + "_suspend";
                } else if (WfState.ABORTED.equals((Object)state)) {
                    name = name + "_abort";
                } else if (WfState.TERMINATED.equals((Object)state)) {
                    name = name + "_terminate";
                } else if (WfState.COMPLETED.equals((Object)state)) {
                    name = name + "_complete";
                }
            }
        } else if (actDef instanceof AbstractTaskServiceActivityDef) {
            name = "wf_auto";
            if (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state)) {
                name = name + "_suspend";
            } else if (WfState.ABORTED.equals((Object)state)) {
                name = name + "_abort";
            } else if (WfState.TERMINATED.equals((Object)state)) {
                name = name + "_terminate";
            } else if (WfState.COMPLETED.equals((Object)state)) {
                name = name + "_complete";
            }
        }
        if (name == null) {
            BufferedImage img = new BufferedImage(54, 32, 1);
            Graphics2D g = (Graphics2D)img.getGraphics();
            String text = actDef.getType().toString();
            int len = g.getFontMetrics().stringWidth(text);
            g.drawString(text, (54 - len) / 2, 12);
            ImageIcon icon = new ImageIcon();
            icon.setImage(img);
            return icon;
        }
        ImageIcon image = WorkFlowMonitorPanel.getIcon(name, type);
        return image;
    }

    private static ImageIcon getIcon(String name, String type) {
        ImageIcon image;
        if (name.endsWith("running")) {
            type = ".gif";
        }
        if ((image = (ImageIcon)ICON_MAP.get(name)) == null) {
            URL url = WfProcDiagramEncoder.class.getResource("icons/" + name + type);
            image = new ImageIcon(url);
            ICON_MAP.put(name, image);
        }
        return image;
    }

    private void hideManActivityTooltips() {
        this.actTipsPos.setVisible(false);
    }

    public void showAppendDialog(IProcessImage.Activity activity) {
        try {
            IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
            String json = service.getDiagramJson(this.image.getProcInstId(), activity.actDefId);
            json = json.replace("(", "");
            json = json.replace(")", "");
            JSONObject jsonObject = new JSONObject(json);
            Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            AppendDiagramDialog panel = new AppendDiagramDialog(jsonObject);
            KDScrollPane scrollpanel = new KDScrollPane((Component)((Object)panel));
            if (w instanceof JDialog) {
                KDDialog dialog = new KDDialog((Dialog)((JDialog)w));
                dialog.setLayout((LayoutManager)new BorderLayout());
                dialog.add((Component)scrollpanel, (Object)"Center");
                dialog.setTitle("\u52a0\u7b7e\u8fc7\u7a0b\u56fe");
                Dimension d = panel.getPreferredSize();
                dialog.setPreferredSize(new Dimension(d.width, d.height + 20));
                dialog.setSize(new Dimension(d.width, d.height + 20));
                dialog.layout();
                dialog.setVisible(true);
                PivotUtils.makeCenter((Window)dialog);
            } else if (w instanceof JFrame) {
                KDFrame dialog = new KDFrame();
                dialog.setLayout((LayoutManager)new BorderLayout());
                dialog.add((Component)scrollpanel, (Object)"Center");
                dialog.setTitle("\u52a0\u7b7e\u8fc7\u7a0b\u56fe");
                Dimension d = panel.getPreferredSize();
                dialog.setPreferredSize(new Dimension(d.width + 30, d.height + 50));
                dialog.setSize(new Dimension(d.width + 30, d.height + 50));
                dialog.layout();
                dialog.setVisible(true);
                PivotUtils.makeCenter((Window)dialog);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showEventWaiterActTips(MouseEvent e) {
        KDLabel label = (KDLabel)e.getSource();
        Object obj = label.getUserObject();
        if (obj instanceof IProcessImage.Activity) {
            IProcessImage.Activity act = (IProcessImage.Activity)obj;
            if (!"open.not_running.not_started".equals(act.state)) {
                return;
            }
            String pronInstId = this.image.getProcInstId();
            String actDefId = act.actDefId;
            String key = "EventTimerInvoke:" + actDefId;
            String tips = null;
            try {
                Object raw = EnactmentServiceFactory.createRemoteEnactService().getProcessContext(pronInstId, key);
                if (raw == null) {
                    tips = "\u5df2\u7ecf\u6267\u884c0\u6b21";
                } else {
                    String[] val = (String[])raw;
                    tips = "\u5df2\u7ecf\u6267\u884c" + val[0] + "\u6b21,\u4e0a\u6b21\u6267\u884c\u8017\u65f6" + val[1] + "ms";
                }
                this.makeupActTips(act, tips);
            }
            catch (WfException e1) {
                e1.printStackTrace();
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void showManActivityTooltips(MouseEvent e) {
        try {
            KDLabel label = (KDLabel)e.getSource();
            Object obj = label.getUserObject();
            if (obj instanceof IProcessImage.Activity) {
                String tips;
                IProcessImage.Activity act = (IProcessImage.Activity)obj;
                this.actInstInfoIdsForToolTip = null;
                if (act.actInstIds != null) {
                    this.actInstInfoIdsForToolTip = act.actInstIds.toArray(new String[0]);
                }
                if ((tips = (String)this.actTips.get(act.actDefId)) == null) {
                    IWfMonitorImageUIFacade facade = imageUIFacade == null ? (IWfMonitorImageUIFacade)RpcProxy.wrapNoSupport(IWfMonitorImageUIFacade.class) : (IWfMonitorImageUIFacade)RpcProxy.wrapNoSupport(IWfMonitorImageUIFacade.class, (String)imageUIFacade);
                    tips = facade.getActTips(this.instID, act.actDefId, this.actInstInfoIdsForToolTip);
                    this.actTips.put(act.actDefId, tips);
                }
                this.makeupActTips(act, tips);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void makeupActTips(IProcessImage.Activity act, String tips) {
        int y;
        int height = 240;
        int width = 320;
        if (!tips.startsWith("<")) {
            int[] tmp = this.calcStringHeight(tips);
            height = tmp[0];
            width = tmp[1];
            tips = tips.replaceAll("\\r\\n", "<br>");
        }
        tips = "<div style='font-size:12pt'>" + tips + "</div>";
        this.actTipsArea.setText(tips);
        JViewport port = ((JScrollPane)this.getParent().getParent()).getViewport();
        int x = act.bound.x + this.image.getOffsetX();
        if (x - port.getViewPosition().x + width > port.getSize().width) {
            x -= width - 50;
        }
        if ((y = act.bound.y + 50 + this.image.getOffsetY()) - port.getViewPosition().y + height > port.getSize().height) {
            y -= height + 40;
        }
        this.actTipsPos.setBounds(x, y, width, height);
        this.actTipsPos.setVisible(true);
    }

    private int[] calcStringHeight(String s) {
        String[] lines = s.split("\\r");
        int count = 0;
        BufferedImage image = new BufferedImage(1, 1, 1);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setFont(this.getFont().deriveFont(9.0f));
        this.metrics = g.getFontMetrics();
        FontMetrics f = this.getGraphics().getFontMetrics();
        int maxWidth = 0;
        for (int i = 0; i < lines.length; ++i) {
            int width = f.stringWidth(lines[i]);
            if (width > maxWidth) {
                maxWidth = width;
            }
            int t = width / 280;
            if (width % 280 != 0) {
                ++t;
            }
            count += t;
        }
        if (maxWidth > 280) {
            maxWidth = 280;
        }
        return new int[]{count * 18 + 12, maxWidth + 40};
    }

    private IUIActionPostman prepareShowNodeProperty(RequestContext request, String permissionKey) {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        handler.setAvailabe(this.isprepareShowNodeProperty());
        if (!handler.isAvailabe()) {
            return handler;
        }
        if (request == null) {
            request = new RequestContext();
        }
        request.setMethodName("handleShowNodeProperty");
        request.setClassName("com.kingdee.bos.workflow.monitor.app.WorkFlowMonitorPanelUIHandler");
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        request.put("userId", (Object)userId);
        if (!StringUtils.isEmpty((String)permissionKey)) {
            request.put("permissionKey", (Object)permissionKey);
        }
        if (!StringUtils.isEmpty((String)this.instID)) {
            request.put("procInstId", (Object)this.instID);
        }
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    private boolean isprepareShowNodeProperty() {
        return true;
    }

    private void showPropertyDialog(List actInstIds, String actDefId) {
        this.showPropertyDialog(actInstIds, actDefId, null);
    }

    public String getCurrentActivityInstance(List actInstIds, String actDefId) {
        String str = null;
        for (int i = actInstIds.size() - 1; i >= 0; --i) {
            String id = (String)actInstIds.get(i);
            if (!this.checkCurrentActivity(actDefId, id)) continue;
            return id;
        }
        return str;
    }

    public boolean checkCurrentActivity(String actDefId, String instanceId) {
        boolean flag = false;
        ActivityInstInfo[] infos = this.image.getActivityInstInfos();
        for (int i = 0; i < infos.length; ++i) {
            ActivityInstInfo info = infos[i];
            if (!info.getActInstId().equals(instanceId) || !info.getActDefId().equals(actDefId)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    void showPropertyDialog(List actInstIds, String actDefId, String currentActInstId) {
        if (actInstIds == null || actInstIds.size() < 1) {
            return;
        }
        if (currentActInstId == null) {
            currentActInstId = this.getCurrentActivityInstance(actInstIds, actDefId);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"actInstIds", (Object)actInstIds);
        uiContext.put((Object)"monitorPanel", (Object)this);
        uiContext.put((Object)"actDefId", (Object)actDefId);
        uiContext.put((Object)"basicui", (Object)this.basicUI);
        uiContext.put((Object)"force_refresh", (Object)Boolean.FALSE);
        if (currentActInstId != null) {
            uiContext.put((Object)"currentActInstId", (Object)currentActInstId);
        }
        String className = ShowPropertyPanel.class.getName();
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext);
            uiWindow.show();
            if (((Boolean)uiContext.get((Object)"force_refresh")).booleanValue()) {
                this.refreshButton_actionPerformed(null);
            }
        }
        catch (UIException e) {
            this.handUIException(e);
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.setBackground(new Color(236, 237, 237));
        this.loadFromProcessDef(g);
    }

    private Image getImagePlus() {
        if (this.imagePlus == null) {
            try {
                URL url = WfProcessImage.class.getResource("icons/plus.png");
                this.imagePlus = Toolkit.getDefaultToolkit().createImage(url);
                if (this.imagePlus != null) {
                    this.imagePlus = this.imagePlus.getScaledInstance(20, 20, 4);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.imagePlus;
    }

    public void loadFromProcessDef(Graphics g) {
        Color c = new Color(236, 237, 237);
        Graphics2D g2d = (Graphics2D)g;
        this.image.paintWires(g2d, c);
        this.image.paintComments(g2d, c);
        IProcessImage.Activity[] activities = this.image.getActivities();
        for (int i = 0; i < activities.length; ++i) {
            IProcessImage.Activity activity = activities[i];
            if (activity.isAppended) {
                int x = activity.bound.x + this.image.getOffsetX() + (activity.bound.width - 32) / 2;
                int y = activity.bound.y + this.image.getOffsetY() + 4;
                g2d.setColor(Color.BLACK);
                g.drawString("+", x + 32, y + 32);
                continue;
            }
            if (!activity.hasAppended) continue;
        }
        if (this.wfMonitorExt != null) {
            this.wfMonitorExt.paintDecoration(g2d, activities, this.image.getOffsetX(), this.image.getOffsetY());
        }
    }

    public void onLoad(String instID, Map buttuonsMap, BasicWorkFlowMonitorPanel basicUI) throws Exception {
        this.setQueryPreference(false);
        this.flowpropertyButton = (KDWorkButton)buttuonsMap.get("btnFlowProperty");
        this.nodepropertyButton = (KDWorkButton)buttuonsMap.get("btnNodeProperty");
        this.btnTrace = (KDWorkButton)buttuonsMap.get("btnTrace");
        this.btnTrace.setToolTipText(EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"enableTraceButton"));
        this.showParentFlowButton = (KDWorkButton)buttuonsMap.get("btnShowParentWF");
        this.showInfoButton = (KDWorkButton)buttuonsMap.get("btnShowInfo");
        this.refreshButton = (KDWorkButton)buttuonsMap.get("btnRefresh");
        this.showTableButton = (KDWorkButton)buttuonsMap.get("btnShowTable");
        this.jumpButton = (KDWorkButton)buttuonsMap.get("btnJump");
        this.showBillButton = (KDWorkButton)buttuonsMap.get("btnShowBill");
        this.showTableButton.setVisible(true);
        this.showTableButton.setEnabled(true);
        this.basicUI = basicUI;
        this.jbInit();
        this.setLayout(null);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("procinstID", instID);
        IWorkFlowMonitorPanelFacade facade = (IWorkFlowMonitorPanelFacade)RpcProxy.wrapNoSupport(IWorkFlowMonitorPanelFacade.class);
        Map<String, Object> data = facade.getData(params);
        ActivityInstInfo[] actInstInfos = (ActivityInstInfo[])data.get("actInstInfos");
        ProcessInstInfo procInstInfo = (ProcessInstInfo)data.get("procInstInfo");
        ProcessDef processDef = (ProcessDef)data.get("processDef");
        this.image = (IProcessImage)data.get("image");
        basicUI.processInstInfo = this.image.getProcInstInfo();
        this.instID = this.image.getProcInstId();
        if (!StringUtils.isEmpty((String)instID)) {
            this.service = EnactmentServiceFactory.createRemoteEnactService();
            if (this.instID.endsWith("WFPCINST")) {
                this.images = new WfProcessImage(SysContext.getSysContext().getLocale(), BG_COLOR, processDef, actInstInfos, procInstInfo);
            } else if (this.instID.endsWith("WFPRCDEF")) {
                String procDefId = this.instID;
                this.images = new WfProcessImage(SysContext.getSysContext().getLocale(), processDef, BG_COLOR);
            }
            this.isPvmMode = true;
        }
        this.btnTrace.setVisible(false);
        this.refreshJumpBtn();
        this.nodepropertyButton.setEnabled(false);
        this.addAllLabel();
        String parentInstId = this.image.getParentProcInstId();
        if (parentInstId == null || parentInstId.trim().equals("")) {
            this.showParentFlowButton.setEnabled(false);
        }
    }

    private void refreshJumpBtn() {
        boolean isEnable = false;
        if (this.image != null) {
            boolean bl = isEnable = this.image.getProcInstState().equals("open.running") || this.image.getProcInstState().equals("open.not_running.suspended");
        }
        if (this.jumpButton != null) {
            this.jumpButton.setEnabled(isEnable);
        }
    }

    protected boolean checkViewDiagramPermission() throws EASBizException, BOSException {
        return this.permissionUtil.checkOperate(this.image.getResponsibles(), this.image.getInitiator(), "wf_report_Monitor_ViewDiagram", true);
    }

    protected boolean checkJumpPermission() throws EASBizException, BOSException {
        return this.permissionUtil.checkOperate(this.image.getResponsibles(), "wf_report_Monitor_OperateJump");
    }

    public void jbInit() {
        this.flowpropertyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkFlowMonitorPanel.this.beforeActionPerformed(e);
                try {
                    WorkFlowMonitorPanel.this.flowpropertyButton_actionPerformed(e);
                }
                catch (Exception exc) {
                    WorkFlowMonitorPanel.this.handUIException(exc);
                }
                finally {
                    WorkFlowMonitorPanel.this.afterActionPerformed(e);
                }
            }
        });
        this.nodepropertyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkFlowMonitorPanel.this.beforeActionPerformed(e);
                try {
                    WorkFlowMonitorPanel.this.prepareShowNodeProperty(null, "wf_report_Monitor_ViewActivityProperty").callHandler();
                    boolean perm = WorkFlowMonitorPanel.this.permissionUtil.checkOperate("wf_report_Monitor_ViewActivityProperty");
                    if (perm) {
                        WorkFlowMonitorPanel.this.nodepropertyButton_actionPerformed(e);
                    } else {
                        WorkFlowMonitorPanel.this.handleException("noPerm");
                    }
                }
                catch (Exception exc) {
                    WorkFlowMonitorPanel.this.handUIException(exc);
                }
                finally {
                    WorkFlowMonitorPanel.this.afterActionPerformed(e);
                }
            }
        });
        this.btnTrace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkFlowMonitorPanel.this.beforeActionPerformed(e);
                try {
                    WorkFlowMonitorPanel.this.setTraceMode_actionPerfomed(e);
                }
                catch (Exception exc) {
                    WorkFlowMonitorPanel.this.handUIException(exc);
                }
                finally {
                    WorkFlowMonitorPanel.this.afterActionPerformed(e);
                }
            }
        });
        this.showParentFlowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkFlowMonitorPanel.this.beforeActionPerformed(e);
                try {
                    WorkFlowMonitorPanel.this.showParentFlowButton_actionPerformed(e);
                }
                catch (Exception exc) {
                    WorkFlowMonitorPanel.this.handUIException(exc);
                }
                finally {
                    WorkFlowMonitorPanel.this.afterActionPerformed(e);
                }
            }
        });
        this.showInfoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkFlowMonitorPanel.this.beforeActionPerformed(e);
                try {
                    WorkFlowMonitorPanel.this.showInfoButton_actionPerformed(e);
                }
                catch (Exception exc) {
                    WorkFlowMonitorPanel.this.handUIException(exc);
                }
                finally {
                    WorkFlowMonitorPanel.this.afterActionPerformed(e);
                }
            }
        });
        this.showTableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkFlowMonitorPanel.this.beforeActionPerformed(e);
                try {
                    WorkFlowMonitorPanel.this.showTableButton_actionPerformed(e);
                }
                catch (Exception exc) {
                    WorkFlowMonitorPanel.this.handUIException(exc);
                }
                finally {
                    WorkFlowMonitorPanel.this.afterActionPerformed(e);
                }
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkFlowMonitorPanel.this.beforeActionPerformed(e);
                try {
                    WorkFlowMonitorPanel.this.refreshButton_actionPerformed(e);
                }
                catch (Exception exc) {
                    WorkFlowMonitorPanel.this.handUIException(exc);
                }
                finally {
                    WorkFlowMonitorPanel.this.afterActionPerformed(e);
                }
            }
        });
        this.jumpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkFlowMonitorPanel.this.beforeActionPerformed(e);
                try {
                    WorkFlowMonitorPanel.this.showJumpTargetUI(e);
                }
                catch (Exception exc) {
                    WorkFlowMonitorPanel.this.handUIException(exc);
                }
                finally {
                    WorkFlowMonitorPanel.this.afterActionPerformed(e);
                }
            }
        });
        this.showBillButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkFlowMonitorPanel.this.beforeActionPerformed(e);
                try {
                    WorkFlowMonitorPanel.this.showBillUI(e);
                }
                catch (Exception exc) {
                    WorkFlowMonitorPanel.this.handUIException(exc);
                }
                finally {
                    WorkFlowMonitorPanel.this.afterActionPerformed(e);
                }
            }
        });
    }

    public void showBillUI(ActionEvent e) throws Exception {
        IEnactmentService ems = EnactmentServiceFactory.createRemoteEnactService();
        String bizObjId = ems.getBizObjIdByProcessInstanceId(this.instID);
        boolean isOpenByMessage = false;
        if (!StringUtils.isEmpty((String)bizObjId)) {
            try {
                String className = "com.kingdee.eas.base.message.client.MessageServiceProvider";
                String methodName = "showWFBIllByBillId";
                Class[] parameterTypes = new Class[]{Component.class, String.class, String.class};
                Object[] args = new Object[]{this, bizObjId, null};
                Class<?> c = Class.forName(className);
                Method m = c.getMethod(methodName, parameterTypes);
                m.invoke(c, args);
                isOpenByMessage = true;
            }
            catch (Throwable t) {
                isOpenByMessage = false;
            }
        }
        if (!isOpenByMessage) {
            String editUIName = "";
            if (!StringUtils.isEmpty((String)bizObjId)) {
                editUIName = MetadataUtils.getEditUIClassByBillId((String)bizObjId);
            }
            if (StringUtils.isEmpty((String)bizObjId) || StringUtils.isEmpty((String)editUIName)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"noBill"));
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)bizObjId);
            uiContext.put((Object)"isFromWorkflow", (Object)new Boolean(true));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(editUIName, (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    protected void showJumpTargetUI(ActionEvent e) throws EASBizException, BOSException, Exception {
        boolean perm = this.checkJumpPermission();
        if (!perm) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"noPermision"));
            return;
        }
        IEnactmentService ems = EnactmentServiceFactory.createRemoteEnactService();
        boolean isIgnoreShareCenter = ems.isIgnoreShareCenter(this.instID);
        if (!isIgnoreShareCenter) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"ISSHARESKIP"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this.basicUI);
        uiContext.put((Object)"procInstId", (Object)this.instID);
        String className = JumpTargetActivityUI.class.getName();
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext);
            uiWindow.show();
        }
        catch (UIException e1) {
            this.handUIException(e1);
        }
    }

    protected void refreshButton_actionPerformed(ActionEvent e) {
        try {
            IWfFacade facade = WfFacadeFactory.getRemoteInstance();
            this.image = facade.getProcessImage(SysContext.getSysContext().getLocale(), this.instID);
            this.instID = this.image.getProcInstId();
            if (this.instID.endsWith("WFPCINST")) {
                this.images = new WfProcessImage(SysContext.getSysContext().getLocale(), this.service, this.instID, BG_COLOR);
            } else if (this.instID.endsWith("WFPRCDEF")) {
                String procDefId = this.instID;
                String hash = this.service.getProcessDefInfo(procDefId).getMd5HashValue();
                ProcessDef processDef = this.service.getProcessDefByDefineHashValue(hash);
                this.images = new WfProcessImage(SysContext.getSysContext().getLocale(), processDef, BG_COLOR);
            }
            this.addAllLabel();
            if (this.basicUI instanceof BasicWorkFlowMonitorPanel) {
                ((BasicWorkFlowMonitorPanel)this.basicUI).refreshMoniterTable();
            }
            this.refreshJumpBtn();
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    public void flowpropertyButton_actionPerformed(ActionEvent e) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"monitorPanel", (Object)this);
        String className = ProcessProperty.class.getName();
        uiContext.put((Object)"force_refresh", (Object)Boolean.FALSE);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext);
            ((UIModelDialog)uiWindow).setResizable(true);
            uiWindow.show();
            if (((Boolean)uiContext.get((Object)"force_refresh")).booleanValue()) {
                this.refreshButton_actionPerformed(null);
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            if (e1.getCause() instanceof AbortException) {
                return;
            }
            MsgBox.showError((String)"\u6d41\u7a0b\u5c5e\u6027\u52a0\u8f7d\u8fc7\u7a0b\u4e2d\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
    }

    public void nodepropertyButton_actionPerformed(ActionEvent e) {
        Object o = selectedLabel.getUserObject();
        if (o instanceof IProcessImage.Activity) {
            IProcessImage.Activity act = (IProcessImage.Activity)o;
            this.showPropertyDialog(act.actInstIds, act.actDefId);
        }
    }

    public void showParentFlowButton_actionPerformed(ActionEvent e) {
        String parentProcInstId = this.image.getParentProcInstId();
        if (parentProcInstId != null && !parentProcInstId.trim().equals("")) {
            UIContext uiContext = new UIContext((Object)this.basicUI);
            uiContext.put((Object)"id", (Object)parentProcInstId);
            String className = BasicWorkFlowMonitorPanel.class.getName();
            try {
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext);
                uiWindow.show();
            }
            catch (UIException e1) {
                this.handUIException(e1);
            }
        }
    }

    public void setTraceMode_actionPerfomed(ActionEvent e) throws Exception {
        if (this.isPvmMode) {
            try {
                this.service.enableTrace(this.instID);
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"hasEnableTraceNotice"));
            }
            catch (Exception ex) {
                logger.warn((Object)"set trace mode error!", (Throwable)ex);
            }
        }
    }

    public void showInfoButton_actionPerformed(ActionEvent e) {
        String processInstId = this.image.getProcInstId();
        if (processInstId != null && !processInstId.trim().equals("")) {
            try {
                UIContext uiContext = new UIContext((Object)this.basicUI);
                uiContext.put((Object)"processInstId", (Object)processInstId);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.bos.workflow.report.client.ProcessInstLogListUI", (Map)uiContext);
                uiWindow.show();
            }
            catch (UIException e1) {
                this.handUIException(e1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void showTableButton_actionPerformed(ActionEvent e) {
        String processInstId = this.image.getProcInstId();
        if (processInstId != null && !processInstId.trim().equals("")) {
            try {
                UIContext uiContext = new UIContext((Object)this.basicUI);
                uiContext.put((Object)"processInstId", (Object)processInstId);
                String className = ActivityTableUI.class.getName();
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext);
                uiWindow.show();
            }
            catch (UIException e1) {
                this.handUIException(e1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static EASWfServiceClient getServiceClient() throws BOSException {
        return new EASWfServiceClient();
    }

    private void handleException(String errMsgKey) {
        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)errMsgKey));
    }

    static {
        try {
            Config extConfig = ConfigLoader.getConfig4Client();
            imageUIFacade = extConfig.getWfMonitorImageUIFacadeClass();
        }
        catch (Throwable e) {
            imageUIFacade = null;
        }
        BG_COLOR = new Color(255, 255, 255);
        ICON_MAP = new Hashtable();
    }
}

