/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.report.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.monitor.client.BasicWorkFlowMonitorPanel;
import com.kingdee.bos.workflow.report.client.AbstractProcessTaskListUI;
import com.kingdee.bos.workflow.report.client.util.CompositeUtil;
import com.kingdee.bos.workflow.report.client.util.ReportResourceUtil;
import com.kingdee.bos.workflow.report.client.util.ReportUtil;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;

public class ProcessTaskListUI
extends AbstractProcessTaskListUI {
    private static final long serialVersionUID = -8431475093431756121L;
    private String[] hidedColums = new String[]{"FASSIGNID"};
    IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();

    private void queryHistoryData(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("queryHistory".equalsIgnoreCase(actionCommand)) {
            ReportUtil.setQueryCurrentState(this.queryHistoryKDWorkButton, this.queryHistoryMnItm);
            this.mainQueryPK = new MetaDataPK("com.kingdee.bos.workflow.metas", "AssignHst");
            this.refresh();
        } else if ("queryCurrent".equalsIgnoreCase(actionCommand)) {
            ReportUtil.setQueryHistoryState(this.queryHistoryKDWorkButton, this.queryHistoryMnItm);
            this.mainQueryPK = new MetaDataPK("com.kingdee.bos.workflow.metas", "Assign");
            this.refresh();
        }
    }

    private void refresh() {
        try {
            this.refreshList();
        }
        catch (Exception exp) {
            this.handleException(exp);
        }
    }

    private void initializeUI() {
        this.windowTitle = ReportResourceUtil.getReportName("ProcessTask_Normal");
        ReportUtil.setQueryHistoryState(this.queryHistoryKDWorkButton, this.queryHistoryMnItm);
        this.showProcessDiagramKDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_flowstakeout"));
        CompositeUtil.setRowSelect(this.tblMain);
        CompositeUtil.setTableReadOnly(this.tblMain);
        CompositeUtil.hideColumns(this.tblMain, this.hidedColums);
        this.tblMain.getColumn("FSUBJECT").setWidth(280);
        this.tblMain.getColumn("FBODY").setWidth(190);
        this.tblMain.getColumn("FSTATE").setWidth(60);
        this.tblMain.getColumn("FPERSONEMPNAME").setWidth(60);
        this.tblMain.getColumn("FACTDEFNAME").setWidth(95);
        this.tblMain.getColumn("FPROCDEFNAME").setWidth(250);
        this.tblMain.getColumn("FLASTSTATETIME").setWidth(130);
        this.tblMain.getColumn("FCREATEDTIME").setWidth(130);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh();
    }

    @Override
    public void actionQueryHistoryData_actionPerformed(ActionEvent e) throws Exception {
        this.queryHistoryData(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initializeUI();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dlg = super.initCommonQueryDialog();
        dlg.setShowSorter(false);
        dlg.setProcessor((IProcessor)new ProcessStateFilterProcess());
        return dlg;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return false;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    protected String[] getNotOrderColumns() {
        return new String[]{"FSUBJECT", "FBODY"};
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected String getKeyFieldName() {
        return "FASSIGNID";
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionShowProcessDiagram_actionPerformed(ActionEvent e) throws Exception {
        this.showProcessDiagram();
    }

    private void showProcessDiagram() throws WfException {
        try {
            String id;
            int index = CompositeUtil.getCurrentRowIndex(this.tblMain);
            if (index >= 0 && (id = this.getProcessInstanceID(index)) != null && id.length() > 0) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"id", (Object)id);
                BasicWorkFlowMonitorPanel.Show((Map)uiContext);
            }
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)((Object)this), (String)"UIException", (Throwable)e);
        }
    }

    private String getProcessInstanceID(int rowIndex) throws WfException {
        Object destValue;
        ICell destCell;
        IRow currentRow = this.tblMain.getRow(rowIndex);
        if (currentRow != null && (destCell = currentRow.getCell("FASSIGNID")) != null && (destValue = destCell.getValue()) != null && destValue instanceof String) {
            return this.service.getAssignmentById(destValue.toString()).getProcInstId();
        }
        return "";
    }

    private static class ProcessStateFilterProcess
    extends CommonQueryProcessor {
        private ProcessStateFilterProcess() {
        }

        public void process() throws Exception {
            Object editor;
            String field = (String)this.get("CURRENT_FIELD_PROP");
            if ("FSTATE".equals(field) && (editor = this.get("CURRENT_EDITOR")) instanceof KDComboBox) {
                KDComboBox box = (KDComboBox)editor;
                DefaultComboBoxModel model = (DefaultComboBoxModel)box.getModel();
                for (int i = 0; i < model.getSize(); ++i) {
                    if (model.getElementAt(i) == null || !model.getElementAt(i).equals(WfAssignmentState.PROCESSING)) continue;
                    model.removeElementAt(i);
                }
            }
        }
    }
}

