/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCRegister;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.MultiOrgSwitchUtils;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;

public class ContextUtils {
    public static final String CURRENT_USER = "UserInfo";
    public static final String CURRENT_COMPANY = "CurCompanyId";
    public static final String CURRENT_COMPANYINFO = "CompanyInfo";
    public static final String CURRENT_ADMIN = "CURRENT_ADMIN";
    public static final String CURRENT_PURCHASE = "CURRENT_PURCHASE";
    public static final String CURRENT_PROFIT = "CURRENT_PROFIT";
    public static final String CURRENT_STORAGE = "CURRENT_STORAGE";
    public static final String CURRENT_COST = "CURRENT_COST";
    public static final String CURRENT_SALE = "CURRENT_SALE";
    public static final String CURRENT_OTHER = "CURRENT_OTHER";
    public static final String CURRENT_CU = "CURRENT_CU";
    public static final String DEF_COMPANY = "SYS_KDORG_MYORG_COMPANY";
    public static final String DEF_PURCHASE = "SYS_KDORG_MYORG_PURCHASE";
    public static final String DEF_PROFIT = "SYS_KDORG_MYORG_PROFITCENTER";
    public static final String DEF_STORAGE = "SYS_KDORG_MYORG_STORAGE";
    public static final String DEF_COST = "SYS_KDORG_MYORG_COSTCENTER";
    public static final String DEF_SALE = "SYS_KDORG_MYORG_SALE";
    public static final String DEF_ADMIN = "SYS_KDORG_MYORG_ADMIN";
    public static final String DEF_OTHER = "SYS_KDORG_MYORG_OTHER";
    private static final String DB_TYPE = "dbType";
    private static final int DB_SQLSERVER = 0;
    private static final int DB_DB2 = 1;
    private static final int DB_ORACLE = 2;
    private static final int POSTGRESQL = 3;

    public static void setCurrentUser(Context ctx, UserInfo userInfo) {
        if (userInfo != null) {
            ctx.put((Object)CURRENT_USER, (Object)userInfo);
        }
    }

    public static String getCurrentCompanyOrg(Context ctx) {
        return ctx.get((Object)CURRENT_COMPANY) == null ? null : ctx.get((Object)CURRENT_COMPANY).toString();
    }

    public static void setCurrentCompanyOrg(Context ctx, String id) {
        if (id != null && id.length() > 0) {
            ctx.put((Object)CURRENT_COMPANY, (Object)id);
        }
    }

    public static String getCurrentAdminOrg(Context ctx) {
        return ctx.get((Object)CURRENT_ADMIN) == null ? null : ctx.get((Object)CURRENT_ADMIN).toString();
    }

    public static void setCurrentAdminOrg(Context ctx, String id) {
        if (id != null && id.length() > 0) {
            ctx.put((Object)CURRENT_ADMIN, (Object)id);
        }
    }

    public static String getCurrentPurchaseOrg(Context ctx) {
        return ctx.get((Object)CURRENT_PURCHASE) == null ? null : ctx.get((Object)CURRENT_PURCHASE).toString();
    }

    public static void setCurrentPurchaseOrg(Context ctx, String id) {
        if (id != null && id.length() > 0) {
            ctx.put((Object)CURRENT_PURCHASE, (Object)id);
        }
    }

    public static String getCurrentProfitOrg(Context ctx) {
        return ctx.get((Object)CURRENT_PROFIT) == null ? null : ctx.get((Object)CURRENT_PROFIT).toString();
    }

    public static void setCurrentProfitOrg(Context ctx, String id) {
        if (id != null && id.length() > 0) {
            ctx.put((Object)CURRENT_PROFIT, (Object)id);
        }
    }

    public static String getCurrentStorageOrg(Context ctx) {
        return ctx.get((Object)CURRENT_STORAGE) == null ? null : ctx.get((Object)CURRENT_STORAGE).toString();
    }

    public static void setCurrentStorageOrg(Context ctx, String id) {
        if (id != null && id.length() > 0) {
            ctx.put((Object)CURRENT_STORAGE, (Object)id);
        }
    }

    public static String getCurrentSaleOrg(Context ctx) {
        return ctx.get((Object)CURRENT_SALE) == null ? null : ctx.get((Object)CURRENT_SALE).toString();
    }

    public static void setCurrentSaleOrg(Context ctx, String id) {
        if (id != null && id.length() > 0) {
            ctx.put((Object)CURRENT_SALE, (Object)id);
        }
    }

    public static String getCurrentCostOrg(Context ctx) {
        return ctx.get((Object)CURRENT_COST) == null ? null : ctx.get((Object)CURRENT_COST).toString();
    }

    public static void setCurrentCostOrg(Context ctx, String id) {
        if (id != null && id.length() > 0) {
            ctx.put((Object)CURRENT_COST, (Object)id);
        }
    }

    public static String getCurrentOtherOrg(Context ctx) {
        return ctx.get((Object)CURRENT_OTHER) == null ? null : ctx.get((Object)CURRENT_OTHER).toString();
    }

    public static void setCurrentOtherOrg(Context ctx, String id) {
        if (id != null && id.length() > 0) {
            ctx.put((Object)CURRENT_OTHER, (Object)id);
        }
    }

    public static UserInfo getUser(Context ctx) {
        return ctx.get((Object)CURRENT_USER) == null ? null : (UserInfo)ctx.get((Object)CURRENT_USER);
    }

    public static String getDefaultCompany(Context ctx) {
        return ctx.get((Object)DEF_COMPANY) == null ? null : ctx.get((Object)DEF_COMPANY).toString();
    }

    public static void setDefaultCompany(Context ctx, String id) {
        if (id != null) {
            ctx.put((Object)DEF_COMPANY, (Object)id);
        }
    }

    public static String getCurrentCompany(Context ctx) {
        return ctx.get((Object)CURRENT_COMPANY) == null ? null : ctx.get((Object)CURRENT_COMPANY).toString();
    }

    public static void setCurrentCompanyInfo(Context ctx, Object companyInfo) {
        if (companyInfo != null) {
            ctx.put((Object)CURRENT_COMPANYINFO, companyInfo);
        }
    }

    public static Object getCurrentCompanyInfo(Context ctx) {
        return ctx.get((Object)CURRENT_COMPANYINFO);
    }

    public static void setCurrentCompany(Context ctx, String id) {
        if (id != null) {
            ctx.put((Object)CURRENT_COMPANY, (Object)id);
        }
    }

    public static String getDefaultCost(Context ctx) {
        return ctx.get((Object)DEF_COST) == null ? null : ctx.get((Object)DEF_COST).toString();
    }

    public static void setDefaultCost(Context ctx, String id) {
        if (id != null) {
            ctx.put((Object)DEF_COST, (Object)id);
        }
    }

    public static String getDefaultPurchase(Context ctx) {
        return ctx.get((Object)DEF_PURCHASE) == null ? null : ctx.get((Object)DEF_PURCHASE).toString();
    }

    public static void setDefaultPurchase(Context ctx, String id) {
        if (id != null && id.length() > 0) {
            ctx.put((Object)DEF_PURCHASE, (Object)id);
        }
    }

    public static String getDefaultProfit(Context ctx) {
        return ctx.get((Object)DEF_PROFIT) == null ? null : ctx.get((Object)DEF_PROFIT).toString();
    }

    public static void setDefualtProfit(Context ctx, String id) {
        if (id != null) {
            ctx.put((Object)DEF_PROFIT, (Object)id);
        }
    }

    public static String getDefaultStorage(Context ctx) {
        return ctx.get((Object)DEF_STORAGE) == null ? null : ctx.get((Object)DEF_STORAGE).toString();
    }

    public static void setDefaultStorage(Context ctx, String id) {
        if (id != null) {
            ctx.put((Object)DEF_STORAGE, (Object)id);
        }
    }

    public static String getDefaultSale(Context ctx) {
        return ctx.get((Object)DEF_SALE) == null ? null : ctx.get((Object)DEF_SALE).toString();
    }

    public static void setDefaultSale(Context ctx, String id) {
        if (id != null) {
            ctx.put((Object)DEF_SALE, (Object)id);
        }
    }

    public static String getDefaultAdmin(Context ctx) {
        return ctx.get((Object)DEF_ADMIN) == null ? null : ctx.get((Object)DEF_ADMIN).toString();
    }

    public static void setDefaultAdmin(Context ctx, String id) {
        if (id != null) {
            ctx.put((Object)DEF_ADMIN, (Object)id);
        }
    }

    public static void setDBType(Context ctx, int dbType) {
        if (dbType != -1) {
            ctx.put((Object)DB_TYPE, (Object)ContextUtils.getDbType(dbType));
        }
    }

    public static String getOtherOrg(Context ctx) {
        return ctx.get((Object)DEF_OTHER) == null ? null : ctx.get((Object)DEF_OTHER).toString();
    }

    public static void setOtherOrg(Context ctx, String id) {
        if (id != null) {
            ctx.put((Object)DEF_OTHER, (Object)id);
        }
    }

    private static String getDbType(int dbType) {
        return DbType.getName((int)dbType);
    }

    public static void loadUserContext(Context ctx) throws BOSException {
        IObjectPK userPK = ctx.getCaller();
        if (userPK == null) {
            return;
        }
        try {
            StringBuffer oql = new StringBuffer("SELECT *, security.* WHERE id = '").append(userPK.toString()).append("'");
            IUser iUser = UserFactory.getLocalInstance(ctx);
            UserInfo userInfo = iUser.getUserInfo(oql.toString());
            if (userInfo != null) {
                ContextUtil.setCurrentUserInfo((Context)ctx, (UserInfo)userInfo);
                ContextUtil.setCurrentOrgUnit((Context)ctx, (OrgUnitInfo)userInfo.getDefOrgUnit());
                if (userInfo.getDefOrgUnit() != null && userInfo.getDefOrgUnit().getId() != null) {
                    MultiOrgSwitchUtils.switchOrg((Context)ctx, (String)userInfo.getDefOrgUnit().getId().toString());
                }
                ContextUtil.setDbType((Context)ctx, (String)ContextUtils.getDBType(ctx));
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static String getDBType(Context ctx) throws Exception {
        DCRegister dcRegister = new DCRegister();
        int dbType = -1;
        ArrayList dcList = dcRegister.getDCList();
        int len = dcList.size();
        for (int i = 0; i < len; ++i) {
            DCInfo info = (DCInfo)dcList.get(i);
            if (!info.getSolutionName().equalsIgnoreCase(ctx.getSolution()) || !info.getNumber().equalsIgnoreCase(ctx.getAIS())) continue;
            dbType = info.getDBType();
            break;
        }
        return DbType.getName((int)dbType);
    }
}

