/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.util.LocaleUtils;
import java.util.Locale;

public class MultiLangHelper {
    private static final Locale[] SUPPORTED_LOCALES = new Locale[]{LocaleUtils.locale_l2, LocaleUtils.locale_l3};
    private static final Locale[] SUPPORTED_ORIGIN_LOCALES = new Locale[]{LocaleUtils.locale_zh_CN, LocaleUtils.locale_zh_TW};
    private static Locale[] allLocales = null;
    private static LanguageInfo[] languages = null;

    private MultiLangHelper() {
    }

    public static Locale[] getSupportedLocales() {
        return (Locale[])SUPPORTED_LOCALES.clone();
    }

    public static Locale[] getSupportedOriginLocales() {
        return (Locale[])SUPPORTED_ORIGIN_LOCALES.clone();
    }

    public static synchronized Locale[] getDefinedOriginLocales(Context ctx) {
        if (allLocales == null) {
            LanguageInfo[] tempLan = MultiLangHelper.getDefinedLanguages(ctx);
            int size = tempLan.length;
            allLocales = new Locale[size];
            for (int i = 0; i < size; ++i) {
                MultiLangHelper.allLocales[i] = tempLan[i].getOriginalLocale();
            }
        }
        return (Locale[])allLocales.clone();
    }

    public static synchronized Locale[] getDefinedLocales(Context ctx) {
        LanguageInfo[] tempLan = MultiLangHelper.getDefinedLanguages(ctx);
        int size = tempLan.length;
        Locale[] locales = new Locale[size];
        for (int i = 0; i < size; ++i) {
            locales[i] = tempLan[i].getLocale();
        }
        return (Locale[])locales.clone();
    }

    public static synchronized LanguageInfo[] getDefinedLanguages(Context ctx) {
        if (languages == null) {
            IMetaDataLoader loader = null;
            loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            SolutionInfo solutionInfo = loader.getSolution();
            LanguageCollection languageCol = solutionInfo.getLanguages();
            int size = languageCol.size();
            languages = new LanguageInfo[size];
            for (int i = 0; i < size; ++i) {
                MultiLangHelper.languages[i] = languageCol.get(i);
            }
        }
        return languages;
    }

    public static String getFieldName(String fieldPrefix, Locale locale) {
        return fieldPrefix + "_" + locale.toString().toUpperCase();
    }

    public static void copyMultiLangProperty(IObjectValue sourceObject, IObjectValue tgtObject, String prop, Locale[] locales) {
        for (int i = locales.length - 1; i >= 0; --i) {
            tgtObject.put(prop, sourceObject.get(prop, locales[i]), locales[i]);
        }
    }
}

