/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission;

import com.kingdee.eas.EASObject;
import com.kingdee.eas.base.permission.IServerConfigFileCache;
import com.kingdee.eas.base.permission.UsbKeyException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class ServerConfigFileCache
extends EASObject
implements IServerConfigFileCache {
    private static Logger logger = Logger.getLogger(ServerConfigFileCache.class);
    private static String configFileContent = null;
    private static String USBKEY_CONFIG_FILENAME = "usbkeypwd.conf";

    @Override
    public String getConfigFileContent() {
        if (configFileContent == null) {
            ServerConfigFileCache.initConfigContent();
        }
        if (configFileContent != null) {
            configFileContent = configFileContent.trim();
        }
        return configFileContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initConfigContent() {
        InputStream inputStream = null;
        try {
            String filePath = System.getProperty("user.home");
            String fileName = filePath + File.separator + USBKEY_CONFIG_FILENAME;
            File configFile = new File(fileName);
            if (!configFile.exists()) {
                logger.error((Object)("file not found ,file name is:" + fileName));
                return;
            }
            inputStream = new FileInputStream(configFile);
            byte[] content = new byte[new Integer("" + configFile.length()).intValue()];
            inputStream.read(content);
            if (content != null && content.length != 0) {
                configFileContent = new String(content);
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"fileNotFount!", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"IOException!", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean buildServerFile(String contentStr) throws UsbKeyException {
        boolean restartServer = false;
        try {
            String filePath = System.getProperty("user.home");
            String fileName = filePath + File.separator + USBKEY_CONFIG_FILENAME;
            File configFile = new File(fileName);
            if (!configFile.exists()) {
                configFile.createNewFile();
            } else {
                configFile.delete();
                configFile.createNewFile();
                restartServer = true;
            }
            try (FileOutputStream fileWriter = null;){
                fileWriter = new FileOutputStream(configFile);
                ((OutputStream)fileWriter).write((" " + contentStr.trim()).getBytes());
                ((OutputStream)fileWriter).close();
            }
        }
        catch (IOException ie) {
            logger.error((Object)"io exception :", (Throwable)ie);
            throw new UsbKeyException(UsbKeyException.CREATE_SERVERFILE_ERROR);
        }
        return restartServer;
    }
}

