/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.AbstractAgentUserManagerFacadeControllerBean;
import com.kingdee.eas.base.permission.app.agentuser.PersonHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.List;
import org.apache.log4j.Logger;

public class AgentUserManagerFacadeControllerBean
extends AbstractAgentUserManagerFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.AgentUserManagerFacadeControllerBean");

    @Override
    protected void _createUserByPerson(Context ctx, IObjectPK personId) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getLocalInstance(ctx);
        iUser.createUserByPerson(personId);
    }

    @Override
    protected UserCollection _findAllAgentUserCollection(Context ctx) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getLocalInstance(ctx);
        return iUser.getUserCollection("select * where isDelete = 0 and agentUser = 1");
    }

    @Override
    protected void _switchNormalUser(Context ctx, List userNumberList) throws BOSException, EASBizException {
        if (userNumberList == null || userNumberList.isEmpty()) {
            logger.info((Object)"userNumberList is null or empty !");
        }
        String userNumberStr = ToolUtils.aryToStr(userNumberList, true);
        String sql = "update t_pm_user set fagentUser = 0 where fnumber in (" + userNumberStr + ")";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _deleteAgentUser(Context ctx, String numberStr) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)numberStr)) {
            return;
        }
        IUser iUser = UserFactory.getLocalInstance(ctx);
        UserCollection userInfoCol = iUser.getUserCollection("select * where number ='" + numberStr + "'");
        if (userInfoCol == null || userInfoCol.isEmpty()) {
            return;
        }
        int size = userInfoCol.size();
        for (int i = 0; i < size; ++i) {
            UserInfo userInfo = userInfoCol.get(i);
            if (!userInfo.isAgentUser()) continue;
            userInfo.setPerson(null);
            userInfo.setIsDelete(true);
            userInfo.setNumber(userInfo.getNumber() + Uuid.create().toString());
            iUser.update((IObjectPK)new ObjectStringPK(userInfo.getId().toString()), (CoreBaseInfo)userInfo);
        }
    }

    @Override
    protected void _updateUserInfoByPerson(Context ctx, IObjectPK personId, String oldPersonNumber) throws BOSException, EASBizException {
        this.updateAgentUserNumberByperson(ctx, personId, oldPersonNumber);
    }

    private void updateAgentUserNumberByperson(Context ctx, IObjectPK personId, String oldPersonNumber) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)StringUtils.cnulls((Object)personId)) || StringUtils.isEmpty((String)oldPersonNumber)) {
            throw new IllegalArgumentException(" personId or useInfoNumber is null");
        }
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PersonInfo personInfo = iPerson.getPersonInfo(personId);
        if (personInfo == null) {
            return;
        }
        if (personInfo.getNumber().equals(oldPersonNumber)) {
            return;
        }
        IUser iUser = UserFactory.getLocalInstance(ctx);
        UserInfo userInfo = iUser.getUser(oldPersonNumber);
        if (userInfo == null) {
            return;
        }
        userInfo.setNumber(personInfo.getNumber());
        iUser.update((IObjectPK)new ObjectStringPK(userInfo.getId().toString()), (IObjectValue)userInfo, false);
    }

    @Override
    protected void _updateUserInfoByPerson(Context ctx, IObjectPK personId, String oldPersonNumber, boolean isDealPos) throws BOSException, EASBizException {
        this.updateAgentUserNumberByperson(ctx, personId, oldPersonNumber);
        if (isDealPos) {
            IUser iUser = UserFactory.getLocalInstance(ctx);
            UserInfo userInfo = iUser.getUser(oldPersonNumber);
            if (userInfo == null) {
                return;
            }
            IOrgRange iOrgRange = OrgRangeFactory.getLocalInstance(ctx);
            iOrgRange.deleteByUserId(userInfo.getId().toString(), null);
            PersonHelper personhelper = new PersonHelper();
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            personhelper.addUserOrgRange(ctx, personId, iPerson.getPersonInfo(personId));
        }
    }
}

