/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.IBMCMessage;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.permission.AuthenMessageTypeEnum;
import com.kingdee.eas.base.permission.AuthenRecordCollection;
import com.kingdee.eas.base.permission.AuthenRecordFactory;
import com.kingdee.eas.base.permission.AuthenRecordInfo;
import com.kingdee.eas.base.permission.PermChangeRecordFactory;
import com.kingdee.eas.base.permission.PermChangeRecordInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.AbstractAuthenRecordControllerBean;
import com.kingdee.eas.base.permission.app.CreateNewUserAuthenRecordAuthen;
import com.kingdee.eas.base.permission.app.IAuthenRecordAuthen;
import com.kingdee.eas.base.permission.app.RoleAssignPermAuthenRecordAuthen;
import com.kingdee.eas.base.permission.app.UserAssignGrantRoleAuthenRecordAuthen;
import com.kingdee.eas.base.permission.app.UserAssignPermAuthenRecordAuthen;
import com.kingdee.eas.base.permission.app.UserAssignRoleAuthenRecordAuthen;
import com.kingdee.eas.base.permission.app.plunin.PermissionChangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class AuthenRecordControllerBean
extends AbstractAuthenRecordControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.AuthenRecordControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    @Override
    protected boolean _passAuthen(Context ctx, List fidList) throws BOSException {
        String fidsStr = ToolUtils.aryToStr(fidList);
        for (int i = 0; i < fidList.size(); ++i) {
            String authenRecordFid = (String)fidList.get(i);
            try {
                AuthenRecordInfo authenRecordInfo = AuthenRecordFactory.getLocalInstance(ctx).getAuthenRecordInfo((IObjectPK)new ObjectUuidPK(authenRecordFid), this.getSelector());
                if (!"10".equals(authenRecordInfo.getAuthenStatus().getValue()) && !"50".equals(authenRecordInfo.getPermChange().getOperType().getValue())) continue;
                PermChangeRecordInfo permchangeRecordInfo = authenRecordInfo.getPermChange();
                if ("10".equals(permchangeRecordInfo.getOperType().getValue())) {
                    this.authenAssignPermToUser(ctx, authenRecordFid);
                    continue;
                }
                if ("20".equals(permchangeRecordInfo.getOperType().getValue()) || "30".equals(permchangeRecordInfo.getOperType().getValue())) {
                    this.authenAssignRoleToUser(ctx, authenRecordFid);
                    continue;
                }
                if ("40".equals(permchangeRecordInfo.getOperType().getValue())) {
                    this.authenAssignPermToRole(ctx, authenRecordFid);
                    continue;
                }
                if ("50".equals(permchangeRecordInfo.getOperType().getValue())) {
                    this.authenCreateNewUser(ctx, authenRecordFid);
                    continue;
                }
                if (!"60".equals(permchangeRecordInfo.getOperType().getValue())) continue;
                this.authenUserLoginAuthenWayChange(ctx, authenRecordFid);
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_PM_AuthenRecord SET FAUTHENSTATUS =?,FAuthenTime=NOW() WHERE fid in (" + fidsStr + ") ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{"20"});
        sql = new StringBuffer();
        sql.append("select FID,FPermChangeID from T_PM_AuthenRecord WHERE fid in (" + fidsStr + ") ");
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowset.next()) {
                String authenRecordFids = rowset.getString("FID");
                String permChangeID = rowset.getString("FPermChangeID");
                this.sendPassAuthenMessage(ctx, permChangeID, authenRecordFids);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    private void authenCreateNewUser(Context ctx, String authenRecordId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_PM_USER SET FIsRegister =1 WHERE FNUMBER= ").append("(SELECT fassignedobjectnumber FROM t_pm_permchangerecord inner join t_pm_authenrecord").append(" on t_pm_permchangerecord.fid = t_pm_authenrecord.FPERMCHANGEID  ").append(" where t_pm_authenrecord.fid = ? )");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authenRecordId});
    }

    private void authenUserLoginAuthenWayChange(Context ctx, String authenRecordId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_PM_USER SET FIsRegister =1 WHERE FNUMBER= ").append("(SELECT fassignedobjectnumber FROM t_pm_permchangerecord inner join t_pm_authenrecord").append(" on t_pm_permchangerecord.fid = t_pm_authenrecord.FPERMCHANGEID  ").append(" where t_pm_authenrecord.fid = ? )");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authenRecordId});
    }

    private void authenAssignPermToRole(Context ctx, String authenRecordId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO T_PM_ROLEPERM(FID,FRoleID,FPermItemID,FPermType,FRuleStructure,FRuleExpr) ");
        sql.append("SELECT FRolePerm,FRoleID,FPermItemID,FPermType,FRuleStructure,FRuleExpr ");
        sql.append("from T_PM_RolePermChange where FPermChangeID in (select pcr.fid from T_PM_PermChangeRecord pcr ");
        sql.append(" inner join t_pm_authenrecord ar on pcr.fid = ar.FPermChangeID where ar.fid = ? and ");
        sql.append(" ar.FAuthenStatus = ?) and FAssignType =?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authenRecordId, "10", "10"});
        sql = new StringBuffer();
        sql.append("UPDATE T_PM_ROLEPERM SET (FRuleStructure,FRuleExpr) = (SELECT T_PM_ROLEPermChange.FRuleStructure,");
        sql.append("T_PM_ROLEPermChange.FRuleExpr FROM  T_PM_ROLEPermChange  where FPermChangeID in (select pcr.fid from  ");
        sql.append(" T_PM_PermChangeRecord pcr inner join t_pm_authenrecord ar on pcr.fid = ar.FPermChangeID where ar.fid = ? and ");
        sql.append(" ar.FAuthenStatus = ?) and FAssignType =? and T_PM_ROLEPERM.fid = T_PM_ROLEPermChange.FRolePerm)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authenRecordId, "10", "30"});
        sql = new StringBuffer();
        sql.append("DELETE from T_PM_ROLEPERM where exists(select 1 from t_pm_rolepermchange rpc inner join ");
        sql.append(" t_pm_authenrecord ar on rpc.FPermChangeID = ar.FPermChangeID where ar.fid = ?");
        sql.append(" and T_PM_ROLEPERM.fid = rpc.FRolePerm and ar.FAuthenStatus = ? and rpc.FAssignType = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authenRecordId, "10", "20"});
        sql = new StringBuffer();
        sql.append("update t_pm_rolepermchange set FAuthenStatus = ? where FPermChangeID in (");
        sql.append(" select pcr.fid from T_PM_PermChangeRecord pcr inner join t_pm_authenrecord ar on ");
        sql.append(" pcr.fid = ar.FPermChangeID where ar.fid = ? )");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{"20", authenRecordId});
    }

    @Override
    protected boolean _notPassAuthen(Context ctx, List fidList, String oprtType, String reasonText) throws BOSException {
        String fidsStr = ToolUtils.aryToStr(fidList);
        for (int i = 0; i < fidList.size(); ++i) {
            String authenRecordFid = (String)fidList.get(i);
            AuthenRecordInfo authenRecordInfo = this.getAuthenRecordInfoByFid(ctx, authenRecordFid);
            PermChangeRecordInfo permchangeRecordInfo = authenRecordInfo.getPermChange();
            if ("10".equals(permchangeRecordInfo.getOperType().getValue())) {
                this.notAuthenAssignPermToUser(ctx, authenRecordFid);
                continue;
            }
            if ("20".equals(permchangeRecordInfo.getOperType().getValue()) || "30".equals(permchangeRecordInfo.getOperType().getValue())) {
                this.notAuthenAssignRoleToUser(ctx, authenRecordFid);
                continue;
            }
            if ("40".equals(permchangeRecordInfo.getOperType().getValue())) {
                this.notAuthenAssignPermToRole(ctx, authenRecordFid);
                continue;
            }
            if (!"50".equals(permchangeRecordInfo.getOperType().getValue())) continue;
            this.cancelAuthenCreateNewUser(ctx, permchangeRecordInfo.getId().toString());
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_PM_AuthenRecord SET FAUTHENSTATUS =?,FAuthenTime=NOW(),FAuthenOpinion = ? WHERE fid in (" + fidsStr + ") ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{"30", reasonText});
        sql = new StringBuffer();
        sql.append("select FID,FPermChangeID from T_PM_AuthenRecord WHERE fid in (" + fidsStr + ") ");
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowset.next()) {
                String authenRecordFids = rowset.getString("FID");
                String permChangeID = rowset.getString("FPermChangeID");
                this.sendNotPassAuthenMessage(ctx, permChangeID, authenRecordFids, reasonText);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private void sendPassAuthenMessage(Context ctx, String permChangeID, String authenRecordId) throws BOSException, EASBizException {
        PermChangeRecordInfo permChangeRecordInfo = PermChangeRecordFactory.getLocalInstance(ctx).getPermChangeRecordInfo((IObjectPK)new ObjectUuidPK(permChangeID), this.getPermChangeRecordSelector());
        AuthenRecordInfo authenRecordInfo = AuthenRecordFactory.getLocalInstance(ctx).getAuthenRecordInfo((IObjectPK)new ObjectUuidPK(authenRecordId));
        List messageTypeList = this.getAuthenMessage(ctx, (IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000113B7DE7F"));
        String body = this.buildPassMessageBody(ctx, permChangeRecordInfo, authenRecordInfo);
        for (int i = 0; i < messageTypeList.size(); ++i) {
            PersonInfo assignPerson;
            AuthenMessageTypeEnum authenMessageTypeEnum = (AuthenMessageTypeEnum)((Object)messageTypeList.get(i));
            if (authenMessageTypeEnum.getValue().equals("10")) {
                IBMCMessage ibmcMessage = BMCMessageFactory.getLocalInstance((Context)ctx);
                BMCMessageInfo messageInfo = new BMCMessageInfo();
                messageInfo.setBizType(MsgBizType.URGENT);
                messageInfo.setStatus(MsgStatus.UNREADED);
                messageInfo.setType(MsgType.NOTICE);
                messageInfo.setPriority(MsgPriority.HIGH);
                messageInfo.setSender("authenadmin");
                messageInfo.setTitle(ResourceBase.getString((String)RESOURCE, (String)"APPLICATION_RESULT_PASS", (Locale)ctx.getLocale()));
                messageInfo.setBody(body);
                messageInfo.setReceiver(permChangeRecordInfo.getAssigner().getId().toString());
                ibmcMessage.addnew((CoreBaseInfo)messageInfo);
                continue;
            }
            if (authenMessageTypeEnum.getValue().equals("20")) {
                String mobileNumber = null;
                assignPerson = permChangeRecordInfo.getAssigner().getPerson();
                mobileNumber = assignPerson != null && StringUtils.isEmpty((String)assignPerson.getCell()) ? assignPerson.getCell() : permChangeRecordInfo.getAssigner().getCell();
                if (StringUtils.isEmpty((String)mobileNumber)) continue;
                MsgUtil.mobileMsgSend((Context)ctx, (String)body, (int)1, (boolean)false, null, (String)mobileNumber, null);
                continue;
            }
            if (!authenMessageTypeEnum.getValue().equals("30")) continue;
            String emailAddress = null;
            assignPerson = permChangeRecordInfo.getAssigner().getPerson();
            emailAddress = assignPerson != null && StringUtils.isEmpty((String)assignPerson.getEmail()) ? assignPerson.getEmail() : permChangeRecordInfo.getAssigner().getEmail();
            if (StringUtils.isEmpty((String)emailAddress)) continue;
            this.sendMail(ctx, emailAddress, ResourceBase.getString((String)RESOURCE, (String)"APPLICATION_RESULT_PASS", (Locale)ctx.getLocale()), body);
        }
    }

    private String buildPassMessageBody(Context ctx, PermChangeRecordInfo permChangeRecordInfo, AuthenRecordInfo authenRecordInfo) throws BOSException, EASBizException {
        StringBuffer messageBody = new StringBuffer();
        messageBody.append(permChangeRecordInfo.getAssigner().getNumber() + ResourceBase.getString((String)RESOURCE, (String)"HELLO", (Locale)ctx.getLocale()) + "\n" + ResourceBase.getString((String)RESOURCE, (String)"YOU_ON", (Locale)ctx.getLocale())).append(permChangeRecordInfo.getChangeTime() + ResourceBase.getString((String)RESOURCE, (String)"SUBMIT", (Locale)ctx.getLocale()) + permChangeRecordInfo.getOperType().getAlias()).append(ResourceBase.getString((String)RESOURCE, (String)"APPLICATION_PASS", (Locale)ctx.getLocale())).append(ResourceBase.getString((String)RESOURCE, (String)"OPERATE_OBJECT", (Locale)ctx.getLocale()) + permChangeRecordInfo.getAssignedObjectNumber() + " " + permChangeRecordInfo.getAssignedObjectName()).append(ResourceBase.getString((String)RESOURCE, (String)"AUTHENTICATOR", (Locale)ctx.getLocale()) + authenRecordInfo.getAuthenTime());
        return messageBody.toString();
    }

    private void sendNotPassAuthenMessage(Context ctx, String permChangeID, String authenRecordId, String reasonText) throws BOSException, EASBizException {
        PermChangeRecordInfo permChangeRecordInfo = PermChangeRecordFactory.getLocalInstance(ctx).getPermChangeRecordInfo((IObjectPK)new ObjectUuidPK(permChangeID), this.getPermChangeRecordSelector());
        AuthenRecordInfo authenRecordInfo = AuthenRecordFactory.getLocalInstance(ctx).getAuthenRecordInfo((IObjectPK)new ObjectUuidPK(authenRecordId));
        String body = this.buildNotPassMessageBody(ctx, permChangeRecordInfo, authenRecordInfo, reasonText);
        List messageTypeList = this.getAuthenMessage(ctx, (IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000113B7DE7F"));
        for (int i = 0; i < messageTypeList.size(); ++i) {
            PersonInfo assignPerson;
            AuthenMessageTypeEnum authenMessageTypeEnum = (AuthenMessageTypeEnum)((Object)messageTypeList.get(i));
            if (authenMessageTypeEnum.getValue().equals("10")) {
                IBMCMessage ibmcMessage = BMCMessageFactory.getLocalInstance((Context)ctx);
                BMCMessageInfo messageInfo = new BMCMessageInfo();
                messageInfo.setBizType(MsgBizType.URGENT);
                messageInfo.setStatus(MsgStatus.UNREADED);
                messageInfo.setType(MsgType.NOTICE);
                messageInfo.setPriority(MsgPriority.HIGH);
                messageInfo.setSender("authenadmin");
                messageInfo.setTitle(ResourceBase.getString((String)RESOURCE, (String)"APPLICATION_RESULT_NO_PASS", (Locale)ctx.getLocale()));
                messageInfo.setBody(body);
                messageInfo.setReceiver(permChangeRecordInfo.getAssigner().getId().toString());
                ibmcMessage.addnew((CoreBaseInfo)messageInfo);
                continue;
            }
            if (authenMessageTypeEnum.getValue().equals("20")) {
                String mobileNumber = null;
                assignPerson = permChangeRecordInfo.getAssigner().getPerson();
                mobileNumber = assignPerson != null && StringUtils.isEmpty((String)assignPerson.getCell()) ? assignPerson.getCell() : permChangeRecordInfo.getAssigner().getCell();
                if (StringUtils.isEmpty((String)mobileNumber)) continue;
                MsgUtil.mobileMsgSend((Context)ctx, (String)body, (int)1, (boolean)false, null, (String)mobileNumber, null);
                continue;
            }
            if (!authenMessageTypeEnum.getValue().equals("30")) continue;
            String emailAddress = null;
            assignPerson = permChangeRecordInfo.getAssigner().getPerson();
            emailAddress = assignPerson != null && StringUtils.isEmpty((String)assignPerson.getEmail()) ? assignPerson.getEmail() : permChangeRecordInfo.getAssigner().getEmail();
            if (StringUtils.isEmpty((String)emailAddress)) continue;
            this.sendMail(ctx, emailAddress, ResourceBase.getString((String)RESOURCE, (String)"APPLICATION_RESULT_NO_PASS", (Locale)ctx.getLocale()), body);
        }
    }

    private String buildNotPassMessageBody(Context ctx, PermChangeRecordInfo permChangeRecordInfo, AuthenRecordInfo authenRecordInfo, String reasonText) throws BOSException, EASBizException {
        StringBuffer messageBody = new StringBuffer();
        messageBody.append(permChangeRecordInfo.getAssigner().getNumber() + ResourceBase.getString((String)RESOURCE, (String)"HELLO", (Locale)ctx.getLocale()) + "\n" + ResourceBase.getString((String)RESOURCE, (String)"YOU_ON", (Locale)ctx.getLocale())).append(permChangeRecordInfo.getChangeTime() + ResourceBase.getString((String)RESOURCE, (String)"SUBMIT", (Locale)ctx.getLocale()) + permChangeRecordInfo.getOperType().getAlias()).append(ResourceBase.getString((String)RESOURCE, (String)"APPLICATION_NO_PASS", (Locale)ctx.getLocale())).append(ResourceBase.getString((String)RESOURCE, (String)"OPERATE_OBJECT", (Locale)ctx.getLocale()) + permChangeRecordInfo.getAssignedObjectNumber() + " " + permChangeRecordInfo.getAssignedObjectName()).append(ResourceBase.getString((String)RESOURCE, (String)"CERTIFICATION_OPTIONS", (Locale)ctx.getLocale()) + reasonText + ResourceBase.getString((String)RESOURCE, (String)"AUTHENTICATOR", (Locale)ctx.getLocale()) + authenRecordInfo.getAuthenTime());
        return messageBody.toString();
    }

    private void notAuthenAssignPermToRole(Context ctx, String authenRecordFid) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_PM_RolePermChange set FAuthenStatus = ? where exists (select 1 from ");
        sql.append(" T_PM_AuthenRecord re where re.FPermChangeID = T_PM_RolePermChange.FPermChangeID ");
        sql.append(" and re.fid = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{"30", authenRecordFid});
    }

    private AuthenRecordInfo getAuthenRecordInfoByFid(Context ctx, String authenRecordFid) throws BOSException {
        AuthenRecordInfo authenRecordInfo;
        try {
            authenRecordInfo = AuthenRecordFactory.getLocalInstance(ctx).getAuthenRecordInfo((IObjectPK)new ObjectUuidPK(authenRecordFid), this.getSelector());
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return authenRecordInfo;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("permChange.operType"));
        selector.add(new SelectorItemInfo("authenStatus"));
        return selector;
    }

    private void authenAssignRoleToUser(Context ctx, String authenRecordFid) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO T_PM_UserRoleOrg (fuserid,froleid,forgid) ");
        sql.append("SELECT fuserid,froleid,forgid from T_PM_UserRoleOrgChange ch inner join T_PM_AuthenRecord re ");
        sql.append(" on ch.FPermChangeID = re.FPermChangeID where re.fid =? ");
        sql.append(" and not exists(select 1 from T_PM_UserRoleOrg uro where uro.fuserid =ch.fuserid ");
        sql.append(" and uro.froleid = ch.froleid and uro.forgid = ch.forgid) and ch.FAssignType= ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authenRecordFid, "10"});
        sql = new StringBuffer();
        sql.append("INSERT INTO T_PM_GrantUserRoleOrg (fuserid,froleid,forgid) ");
        sql.append("SELECT fuserid,froleid,forgid from T_PM_GrantUserRoleOrgChange ch inner join T_PM_AuthenRecord re ");
        sql.append(" on ch.FPermChangeID = re.FPermChangeID where re.fid =? ");
        sql.append(" and not exists(select 1 from T_PM_GrantUserRoleOrg uro where uro.fuserid =ch.fuserid ");
        sql.append(" and uro.froleid = ch.froleid and uro.forgid = ch.forgid) and ch.FAssignType= ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authenRecordFid, "10"});
        sql = new StringBuffer();
        sql.append("DELETE FROM T_PM_UserRoleOrg ").append(" WHERE EXISTS (SELECT 1 FROM T_PM_UserRoleOrgChange ch inner join T_PM_AuthenRecord re ").append(" on ch.FPermChangeID = re.FPermChangeID where re.fid =? and ").append(" T_PM_UserRoleOrg.FRoleID = ch.FRoleID and T_PM_UserRoleOrg.fuserid = ch.fuserid").append(" and T_PM_UserRoleOrg.forgid = ch.forgid and ch.FAssignType= ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authenRecordFid, "20"});
        sql = new StringBuffer();
        sql.append("DELETE FROM T_PM_GrantUserRoleOrg ").append(" WHERE EXISTS (SELECT 1 FROM T_PM_GrantUserRoleOrgChange ch inner join T_PM_AuthenRecord re ").append(" on ch.FPermChangeID = re.FPermChangeID where re.fid =? and ").append(" T_PM_GrantUserRoleOrg.FRoleID = ch.FRoleID and T_PM_GrantUserRoleOrg.fuserid = ch.fuserid").append(" and T_PM_GrantUserRoleOrg.forgid = ch.forgid and ch.FAssignType= ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authenRecordFid, "20"});
        sql = new StringBuffer();
        sql.append("update T_PM_UserRoleOrgChange set FAuthenStatus = ? where exists (select 1 from ");
        sql.append(" T_PM_AuthenRecord re where re.FPermChangeID = T_PM_UserRoleOrgChange.FPermChangeID ");
        sql.append(" and re.fid = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{"20", authenRecordFid});
        sql = new StringBuffer();
        sql.append("select fuserid from T_PM_UserRoleOrgChange where exists (select 1 from ");
        sql.append(" T_PM_AuthenRecord re where re.FPermChangeID = T_PM_UserRoleOrgChange.FPermChangeID ");
        sql.append(" and re.fid = ?)");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authenRecordFid});
        try {
            while (rowSet.next()) {
                String userPk = rowSet.getString("fuserid");
                this.handleCallBack(ctx, (IObjectPK)new ObjectUuidPK(userPk));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void authenAssignPermToUser(Context ctx, String authenRecordFid) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO T_PM_UserOrgPerm (FID, FOwner, FOrgID, FPermItemID,FPermType, FRuleStructure,FRuleExpr,FCtrlUnitID) ");
        sql.append("SELECT FuserOrgPerm,fownerid,FOrgID,FPermItemID,FPermType,FRuleStructure,FRuleExpr,FCtrlUnitID from ");
        sql.append(" t_pm_UserOrgPermChange WHERE EXISTS (SELECT 1 FROM T_PM_AuthenRecord re inner join t_pm_permAuthentor pmau ");
        sql.append(" on re.FAuthentorID = pmau.FAuthentorID where re.fid = ? ");
        sql.append(" and re.FPermChangeID = t_pm_UserOrgPermChange.FPermChangeID ");
        sql.append(" and t_pm_UserOrgPermChange.FPermItemID = pmau.FPermitemID and re.FAuthenStatus = ?) and fassigntype = ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authenRecordFid, "10", "10"});
        sql = new StringBuffer();
        sql.append("UPDATE T_PM_UserOrgPerm set FRuleStructure = (SELECT FRuleStructure from t_pm_UserOrgPermChange ");
        sql.append(" WHERE EXISTS (SELECT 1 FROM T_PM_AuthenRecord re inner join t_pm_permAuthentor pmau ");
        sql.append(" on re.FAuthentorID = pmau.FAuthentorID where re.fid = ? and re.FAuthenStatus = ? ");
        sql.append(" and re.FPermChangeID = t_pm_UserOrgPermChange.FPermChangeID ");
        sql.append(" and t_pm_UserOrgPermChange.FPermItemID = pmau.FPermitemID) and fassigntype = ? ");
        sql.append(" and T_PM_UserOrgPerm.fid=t_pm_UserOrgPermChange.FuserOrgPerm)");
        sql.append(" WHERE fid in (SELECT FuserOrgPerm from t_pm_UserOrgPermChange ");
        sql.append(" WHERE EXISTS(SELECT 1 FROM T_PM_AuthenRecord re inner join t_pm_permAuthentor pmau ");
        sql.append(" on re.FAuthentorID = pmau.FAuthentorID where re.fid = ? and re.FAuthenStatus = ? ");
        sql.append(" and re.FPermChangeID = t_pm_UserOrgPermChange.FPermChangeID ");
        sql.append(" and t_pm_UserOrgPermChange.FPermItemID = pmau.FPermitemID) and fassigntype = ?) ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authenRecordFid, "10", "30", authenRecordFid, "10", "30"});
        sql = new StringBuffer();
        sql.append("UPDATE T_PM_UserOrgPerm set FRuleExpr = (SELECT FRuleExpr from t_pm_UserOrgPermChange ");
        sql.append(" WHERE EXISTS (SELECT 1 FROM T_PM_AuthenRecord re inner join t_pm_permAuthentor pmau ");
        sql.append(" on re.FAuthentorID = pmau.FAuthentorID where re.fid = ? and re.FAuthenStatus = ? ");
        sql.append(" and re.FPermChangeID = t_pm_UserOrgPermChange.FPermChangeID ");
        sql.append(" and t_pm_UserOrgPermChange.FPermItemID = pmau.FPermitemID) and fassigntype = ? ");
        sql.append(" and T_PM_UserOrgPerm.fid=t_pm_UserOrgPermChange.FuserOrgPerm)");
        sql.append(" WHERE fid in(SELECT fuserOrgPerm from t_pm_UserOrgPermChange ");
        sql.append(" WHERE EXISTS(SELECT 1 FROM T_PM_AuthenRecord re inner join t_pm_permAuthentor pmau ");
        sql.append(" on re.FAuthentorID = pmau.FAuthentorID where re.fid = ? and re.FAuthenStatus = ? ");
        sql.append(" and re.FPermChangeID = t_pm_UserOrgPermChange.FPermChangeID ");
        sql.append(" and t_pm_UserOrgPermChange.FPermItemID = pmau.FPermitemID) and fassigntype = ? )");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authenRecordFid, "10", "30", authenRecordFid, "10", "30"});
        sql = new StringBuffer();
        sql.append("DELETE FROM T_PM_UserOrgPerm where fid in ");
        sql.append("(SELECT FUserOrgPerm from t_pm_UserOrgPermChange ");
        sql.append(" WHERE EXISTS (SELECT 1 FROM T_PM_AuthenRecord re inner join t_pm_permAuthentor pmau ");
        sql.append(" on re.FAuthentorID = pmau.FAuthentorID where re.fid = ? and re.FAuthenStatus = ?  ");
        sql.append(" and re.FPermChangeID = t_pm_UserOrgPermChange.FPermChangeID ");
        sql.append(" and t_pm_UserOrgPermChange.FPermItemID = pmau.FPermitemID) ");
        sql.append(" and fassigntype = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authenRecordFid, "10", "20"});
        sql = new StringBuffer();
        sql.append(" UPDATE T_PM_UserOrgPermChange SET FAuthenStatus =? WHERE exists (select 1 from ");
        sql.append(" T_PM_AuthenRecord aure inner join  t_pm_permAuthentor pmau on aure.FAuthentorID = pmau.FAuthentorID");
        sql.append(" where aure.fid = ? and aure.FPermChangeID = t_pm_UserOrgPermChange.FPermChangeID ");
        sql.append(" and pmau.FPermitemID = t_pm_UserOrgPermChange.FPermItemID)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{"20", authenRecordFid});
        sql = new StringBuffer();
        sql.append("select top 1 FOwnerID from t_pm_UserOrgPermChange inner join T_PM_AuthenRecord ").append("on t_pm_UserOrgPermChange.FPermChangeID = T_PM_AuthenRecord.FPermChangeID ").append("where T_PM_AuthenRecord.fid = ?");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authenRecordFid});
        try {
            while (rowSet.next()) {
                String userPk = rowSet.getString("FOwnerID");
                if (StringUtils.isEmpty((String)userPk)) continue;
                this.handleCallBack(ctx, (IObjectPK)new ObjectUuidPK(userPk));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void notAuthenAssignRoleToUser(Context ctx, String authenRecordFid) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_PM_UserRoleOrgChange set FAuthenStatus = ? where exists (select 1 from ");
        sql.append(" T_PM_AuthenRecord re where re.FPermChangeID = T_PM_UserRoleOrgChange.FPermChangeID ");
        sql.append(" and re.fid = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{"30", authenRecordFid});
    }

    private void notAuthenAssignPermToUser(Context ctx, String authenRecordFid) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_PM_UserOrgPermChange SET FAuthenStatus =? WHERE exists (select 1 from ");
        sql.append(" T_PM_AuthenRecord aure inner join  t_pm_permAuthentor pmau on aure.FAuthentorID = pmau.FAuthentorID");
        sql.append(" where aure.fid = ? and aure.FPermChangeID = t_pm_UserOrgPermChange.FPermChangeID ");
        sql.append(" and pmau.FPermitemID = t_pm_UserOrgPermChange.FPermItemID)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{"30", authenRecordFid});
    }

    @Override
    protected boolean _isHasUnauthenRecord(Context ctx, List idList) throws BOSException {
        String idStr = ToolUtils.aryToStr(idList);
        AuthenRecordCollection authenRecordColl = AuthenRecordFactory.getLocalInstance(ctx).getAuthenRecordCollection("where id in(" + idStr + ")");
        for (int i = 0; i < authenRecordColl.size(); ++i) {
            AuthenRecordInfo authenRecordInfo = authenRecordColl.get(i);
            if (!"10".equals(authenRecordInfo.getAuthenStatus().getValue())) continue;
            return true;
        }
        return false;
    }

    private void handleCallBack(Context ctx, IObjectPK userPK) throws EASBizException, BOSException {
        if (userPK == null) {
            return;
        }
        try {
            PermissionChangeHelper helper = new PermissionChangeHelper();
            helper.setUserPK(userPK);
            helper.exceChange(ctx);
        }
        catch (Exception e) {
            logger.error((Object)"handleCallBack when saving user orgnization permissions:", (Throwable)e);
        }
    }

    @Override
    protected void _dealAuthenMessageType(Context ctx, IObjectPK authentorId, AuthenMessageTypeEnum authenMessageType, boolean isEnable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        if (isEnable) {
            sql.append("INSERT INTO T_PM_AuthenMessageType VALUES(?,?)");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authentorId.toString(), authenMessageType.getValue()});
        } else {
            sql.append("DELETE FROM T_PM_AuthenMessageType WHERE FAuthentorID=? AND FAuthenMessageType =?");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authentorId.toString(), authenMessageType.getValue()});
        }
    }

    @Override
    protected List _getAuthenMessage(Context ctx, IObjectPK authentorId) throws BOSException {
        ArrayList<AuthenMessageTypeEnum> messageList = new ArrayList<AuthenMessageTypeEnum>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT distinct FAuthenMessageType FROM T_PM_AuthenMessageType WHERE FAuthentorID =?");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authentorId.toString()});
        try {
            while (rowSet.next()) {
                String messageType = rowSet.getString("FAuthenMessageType");
                messageList.add(AuthenMessageTypeEnum.getEnum(messageType));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return messageList;
    }

    @Override
    protected void _sendAuthenMessage(Context ctx, IObjectPK permChangeId) throws BOSException, EASBizException {
        PermChangeRecordInfo permChangeRecordInfo = PermChangeRecordFactory.getLocalInstance(ctx).getPermChangeRecordInfo(permChangeId, this.getPermChangeRecordSelector());
        List messageTypeList = this.getAuthenMessage(ctx, (IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000113B7DE7F"));
        String body = this.buildMessageBody(ctx, permChangeRecordInfo);
        for (int i = 0; i < messageTypeList.size(); ++i) {
            String receiveEmailAddress;
            UserInfo authenadmin;
            AuthenMessageTypeEnum authenMessageTypeEnum = (AuthenMessageTypeEnum)((Object)messageTypeList.get(i));
            if (authenMessageTypeEnum.getValue().equals("10")) {
                IBMCMessage ibmcMessage = BMCMessageFactory.getLocalInstance((Context)ctx);
                BMCMessageInfo messageInfo = new BMCMessageInfo();
                messageInfo.setBizType(MsgBizType.URGENT);
                messageInfo.setStatus(MsgStatus.UNREADED);
                messageInfo.setType(MsgType.NOTICE);
                messageInfo.setPriority(MsgPriority.HIGH);
                messageInfo.setSender(permChangeRecordInfo.getAssigner().getName());
                messageInfo.setTitle(ResourceBase.getString((String)RESOURCE, (String)"PENDING_CERTIFICATION_APPLICATION", (Locale)ctx.getLocale()));
                messageInfo.setBody(body);
                messageInfo.setReceiver("00000000-0000-0000-0000-00000000000113B7DE7F");
                ibmcMessage.addnew((CoreBaseInfo)messageInfo);
                continue;
            }
            if (authenMessageTypeEnum.getValue().equals("20")) {
                authenadmin = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000113B7DE7F"));
                String mobileNumber = authenadmin.getCell();
                if (StringUtils.isEmpty((String)mobileNumber)) continue;
                MsgUtil.mobileMsgSend((Context)ctx, (String)body, (int)1, (boolean)false, null, (String)mobileNumber, null);
                continue;
            }
            if (!authenMessageTypeEnum.getValue().equals("30") || StringUtils.isEmpty((String)(receiveEmailAddress = (authenadmin = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000113B7DE7F"))).getEmail()))) continue;
            this.sendMail(ctx, receiveEmailAddress, ResourceBase.getString((String)RESOURCE, (String)"PENDING_CERTIFICATION_APPLICATION", (Locale)ctx.getLocale()), body);
        }
    }

    private void sendMail(Context ctx, String receiver, String title, String body) throws EASBizException, BOSException {
        try {
            Class<?> mailMsgInfoClass = Class.forName("com.kingdee.eas.base.forewarn.app.MailMsgInfo");
            Object mailInfo = mailMsgInfoClass.newInstance();
            Method method = mailMsgInfoClass.getMethod("setReceiver", String.class);
            method.invoke(mailInfo, receiver);
            method = mailMsgInfoClass.getMethod("setContent", String.class);
            method.invoke(mailInfo, body);
            method = mailMsgInfoClass.getMethod("setMsgTitle", String.class);
            method.invoke(mailInfo, title);
            method = mailMsgInfoClass.getMethod("sendMail", Context.class);
            method.invoke(mailInfo, ctx);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private String buildMessageBody(Context ctx, PermChangeRecordInfo permChangeRecordInfo) throws BOSException, EASBizException {
        StringBuffer messageBody = new StringBuffer();
        messageBody.append(ResourceBase.getString((String)RESOURCE, (String)"AUTHENADMIN_HELLO", (Locale)ctx.getLocale())).append(ResourceBase.getString((String)RESOURCE, (String)"OPERATE_TYPE", (Locale)ctx.getLocale()) + permChangeRecordInfo.getOperType().getAlias() + "\uff0c").append(ResourceBase.getString((String)RESOURCE, (String)"OPERATE_OBJECT", (Locale)ctx.getLocale()) + permChangeRecordInfo.getAssignedObjectNumber() + " ").append("" + permChangeRecordInfo.getAssignedObjectName() + "\uff0c").append(ResourceBase.getString((String)RESOURCE, (String)"OPERATOR", (Locale)ctx.getLocale()) + permChangeRecordInfo.getAssigner().getNumber() + "\uff0c").append("" + permChangeRecordInfo.getChangeTime()).append(ResourceBase.getString((String)RESOURCE, (String)"PLEASE_LOGIN_HANDLE", (Locale)ctx.getLocale()));
        return messageBody.toString();
    }

    private SelectorItemCollection getPermChangeRecordSelector() {
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("*"));
        coll.add(new SelectorItemInfo("assigner.id"));
        coll.add(new SelectorItemInfo("assigner.name"));
        coll.add(new SelectorItemInfo("assigner.number"));
        coll.add(new SelectorItemInfo("assigner.cell"));
        coll.add(new SelectorItemInfo("assigner.email"));
        coll.add(new SelectorItemInfo("assigner.person.cell"));
        coll.add(new SelectorItemInfo("assigner.person.email"));
        return coll;
    }

    @Override
    protected void _cancelAssign(Context ctx, List fidList) throws BOSException {
        if (fidList == null || fidList.size() == 0) {
            return;
        }
        for (int i = 0; i < fidList.size(); ++i) {
            String permChangeID = (String)fidList.get(i);
            String operType = null;
            PermChangeRecordInfo permchangeRecordInfo = null;
            try {
                permchangeRecordInfo = PermChangeRecordFactory.getLocalInstance(ctx).getPermChangeRecordInfo((IObjectPK)new ObjectUuidPK(permChangeID));
                operType = permchangeRecordInfo.getOperType().getValue();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            if ("10".equals(operType)) {
                this.cancelAuthenAssignPermToUser(ctx, permChangeID);
                continue;
            }
            if ("20".equals(operType) || "30".equals(operType)) {
                this.cancelAuthenAssignRoleToUser(ctx, permChangeID);
                continue;
            }
            if ("40".equals(operType)) {
                this.cancelAuthenAssignPermToRole(ctx, permChangeID);
                continue;
            }
            if (!"50".equals(operType)) continue;
            this.cancelAuthenCreateNewUser(ctx, permChangeID);
        }
        this.deleteAuthenRecord(ctx, fidList);
        this.deletePermchangeRecord(ctx, fidList);
    }

    private void deletePermchangeRecord(Context ctx, List fidList) throws BOSException {
        String fidsStr = ToolUtils.aryToStr(fidList);
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM T_PM_PermChangeRecord where fid in (" + fidsStr + ")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void deleteAuthenRecord(Context ctx, List fidList) throws BOSException {
        String fidsStr = ToolUtils.aryToStr(fidList);
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM T_PM_Authenrecord where fpermchangeid in (" + fidsStr + ")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void cancelAuthenCreateNewUser(Context ctx, String permChangeID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM T_PM_USER where fnumber = (select fassignedObjectNumber from t_pm_permchangerecord where fid='" + permChangeID + "')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void cancelAuthenAssignPermToRole(Context ctx, String permChangeID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM T_PM_UserOrgPermChange where fpermchangeid = '" + permChangeID + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void cancelAuthenAssignRoleToUser(Context ctx, String permChangeID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM T_PM_UserRoleOrgChange where fpermchangeid = '" + permChangeID + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("DELETE FROM T_PM_GrantUserRoleOrgChange where fpermchangeid = '" + permChangeID + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void cancelAuthenAssignPermToUser(Context ctx, String permChangeID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM T_PM_UserOrgPermChange where fpermchangeid = '" + permChangeID + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected boolean _passAuthenNew(Context ctx, List permChangeIdList) throws BOSException, EASBizException {
        if (permChangeIdList == null || permChangeIdList.isEmpty()) {
            return true;
        }
        ArrayList<String> needAuthenList = new ArrayList<String>();
        for (int i = 0; i < permChangeIdList.size(); ++i) {
            String authenRecordFid = (String)permChangeIdList.get(i);
            AuthenRecordInfo authenRecordInfo = AuthenRecordFactory.getLocalInstance(ctx).getAuthenRecordInfo((IObjectPK)new ObjectUuidPK(authenRecordFid), this.getSelector());
            if (!"10".equals(authenRecordInfo.getAuthenStatus().getValue())) continue;
            needAuthenList.add(authenRecordFid);
            PermChangeRecordInfo permchangeRecordInfo = authenRecordInfo.getPermChange();
            IAuthenRecordAuthen iAuthenRecordAuthen = this.getAuthenRecordAuthenImpl(permchangeRecordInfo.getOperType().getValue(), ctx);
            iAuthenRecordAuthen.passAuthen(ctx, authenRecordInfo);
            this.sendAuthenReslutMessage(ctx, authenRecordFid, true, null);
        }
        return true;
    }

    private void sendAuthenReslutMessage(Context ctx, String authenRecordId, boolean isPass, String reasonText) throws BOSException, EASBizException {
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        AuthenRecordInfo authenRecordInfo = AuthenRecordFactory.getLocalInstance(ctx).getAuthenRecordInfo((IObjectPK)new ObjectUuidPK(authenRecordId));
        String permChangeID = authenRecordInfo.getPermChange().getId().toString();
        PermChangeRecordInfo permChangeRecordInfo = PermChangeRecordFactory.getLocalInstance(ctx).getPermChangeRecordInfo((IObjectPK)new ObjectUuidPK(permChangeID), this.getPermChangeRecordSelector());
        String body = this.buildAuthenResultMessageBody(ctx, permChangeRecordInfo, authenRecordInfo, isPass, reasonText);
        List messageTypeList = this.getAuthenMessageType(ctx);
        for (String messageType : messageTypeList) {
            PersonInfo assignPerson;
            if (messageType.equals("10")) {
                IBMCMessage ibmcMessage = BMCMessageFactory.getLocalInstance((Context)ctx);
                BMCMessageInfo messageInfo = new BMCMessageInfo();
                messageInfo.setBizType(MsgBizType.URGENT);
                messageInfo.setStatus(MsgStatus.UNREADED);
                messageInfo.setType(MsgType.NOTICE);
                messageInfo.setPriority(MsgPriority.HIGH);
                messageInfo.setSender(currentUserInfo.getName());
                if (isPass) {
                    messageInfo.setTitle(ResourceBase.getString((String)RESOURCE, (String)"authen_pass_message_title", (Locale)ctx.getLocale()));
                } else {
                    messageInfo.setTitle(ResourceBase.getString((String)RESOURCE, (String)"authen_no_pass_message_title", (Locale)ctx.getLocale()));
                }
                messageInfo.setBody(body);
                messageInfo.setReceiver(permChangeRecordInfo.getAssigner().getId().toString());
                ibmcMessage.addnew((CoreBaseInfo)messageInfo);
                continue;
            }
            if (messageType.equals("20")) {
                String mobileNumber = null;
                assignPerson = permChangeRecordInfo.getAssigner().getPerson();
                mobileNumber = assignPerson != null && StringUtils.isEmpty((String)assignPerson.getCell()) ? assignPerson.getCell() : permChangeRecordInfo.getAssigner().getCell();
                if (StringUtils.isEmpty((String)mobileNumber)) continue;
                SendMessageThread sendMessageThread = new SendMessageThread(ctx, messageType, messageType);
                sendMessageThread.start();
                continue;
            }
            if (!messageType.equals("30")) continue;
            String emailAddress = null;
            assignPerson = permChangeRecordInfo.getAssigner().getPerson();
            emailAddress = assignPerson != null && StringUtils.isEmpty((String)assignPerson.getEmail()) ? assignPerson.getEmail() : permChangeRecordInfo.getAssigner().getEmail();
            if (StringUtils.isEmpty((String)emailAddress)) continue;
            SendMailThread sendMailThread = new SendMailThread(ctx, emailAddress, body);
            sendMailThread.start();
        }
    }

    private String buildAuthenResultMessageBody(Context ctx, PermChangeRecordInfo permChangeRecordInfo, AuthenRecordInfo authenRecordInfo, boolean isPass, String reasonText) throws BOSException, EASBizException {
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String messageBody = "";
        messageBody = isPass ? MessageFormat.format(ResourceBase.getString((String)RESOURCE, (String)"authen_pass_message_body", (Locale)ctx.getLocale()), permChangeRecordInfo.getAssigner().getNumber(), permChangeRecordInfo.getChangeTime(), permChangeRecordInfo.getOperType().getAlias(), permChangeRecordInfo.getAssignedObjectNumber(), permChangeRecordInfo.getAssignedObjectName(), currentUserInfo.getName(), dataFormat.format(new Date())) : MessageFormat.format(ResourceBase.getString((String)RESOURCE, (String)"authen_no_pass_message_body", (Locale)ctx.getLocale()), permChangeRecordInfo.getAssigner().getNumber(), permChangeRecordInfo.getChangeTime(), permChangeRecordInfo.getOperType().getAlias(), permChangeRecordInfo.getAssignedObjectNumber(), permChangeRecordInfo.getAssignedObjectName(), reasonText, currentUserInfo.getName(), dataFormat.format(new Date()));
        return messageBody;
    }

    private IAuthenRecordAuthen getAuthenRecordAuthenImpl(String operType, Context ctx) {
        if ("10".equals(operType) || "80".equals(operType)) {
            return new UserAssignPermAuthenRecordAuthen(ctx);
        }
        if ("20".equals(operType) || "30".equals(operType)) {
            return new UserAssignRoleAuthenRecordAuthen(ctx);
        }
        if ("40".equals(operType)) {
            return new RoleAssignPermAuthenRecordAuthen();
        }
        if ("50".equals(operType)) {
            return new CreateNewUserAuthenRecordAuthen();
        }
        if ("70".equals(operType)) {
            return new UserAssignGrantRoleAuthenRecordAuthen(ctx);
        }
        return null;
    }

    @Override
    protected boolean _notPassAuthenNew(Context ctx, List permChangeIdList, String oprtType, String reasonText) throws BOSException, EASBizException {
        if (permChangeIdList == null || permChangeIdList.isEmpty()) {
            return true;
        }
        ArrayList<String> needAuthenList = new ArrayList<String>();
        for (int i = 0; i < permChangeIdList.size(); ++i) {
            String authenRecordFid = (String)permChangeIdList.get(i);
            AuthenRecordInfo authenRecordInfo = this.getAuthenRecordInfoByFid(ctx, authenRecordFid);
            if (!"10".equals(authenRecordInfo.getAuthenStatus().getValue())) continue;
            needAuthenList.add(authenRecordFid);
            PermChangeRecordInfo permchangeRecordInfo = authenRecordInfo.getPermChange();
            IAuthenRecordAuthen iAuthenRecordAuthen = this.getAuthenRecordAuthenImpl(permchangeRecordInfo.getOperType().getValue(), ctx);
            iAuthenRecordAuthen.noPassAuthen(ctx, authenRecordInfo, reasonText);
            this.sendAuthenReslutMessage(ctx, authenRecordFid, false, reasonText);
        }
        return true;
    }

    @Override
    protected void _sendAuthenMessage(Context ctx, String permChangeId, Set authentorIdSet) throws BOSException, EASBizException {
        for (Object authentorIdObj : authentorIdSet) {
            this._sendAuthenMessage(ctx, permChangeId, (String)authentorIdObj);
        }
    }

    @Override
    protected void _sendAuthenMessage(Context ctx, String permChangeID, String authentorid) throws BOSException, EASBizException {
        PermChangeRecordInfo permChangeRecordInfo = PermChangeRecordFactory.getLocalInstance(ctx).getPermChangeRecordInfo((IObjectPK)new ObjectUuidPK(permChangeID), this.getPermChangeRecordSelector());
        String body = this.buildMessageBody(ctx, permChangeRecordInfo, authentorid);
        List messageTypeList = this.getAuthenMessageType(ctx);
        for (String messageType : messageTypeList) {
            String receiveEmailAddress;
            UserInfo authenadmin;
            if (messageType.equals("10")) {
                IBMCMessage ibmcMessage = BMCMessageFactory.getLocalInstance((Context)ctx);
                BMCMessageInfo messageInfo = new BMCMessageInfo();
                messageInfo.setBizType(MsgBizType.URGENT);
                messageInfo.setStatus(MsgStatus.UNREADED);
                messageInfo.setType(MsgType.NOTICE);
                messageInfo.setPriority(MsgPriority.HIGH);
                messageInfo.setSender(permChangeRecordInfo.getAssigner().getName());
                messageInfo.setTitle(ResourceBase.getString((String)RESOURCE, (String)"authen_message_title", (Locale)ctx.getLocale()));
                messageInfo.setBody(body);
                messageInfo.setReceiver(authentorid);
                ibmcMessage.addnew((CoreBaseInfo)messageInfo);
                continue;
            }
            if (messageType.equals("20")) {
                authenadmin = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(authentorid));
                String mobileNumber = authenadmin.getCell();
                if (StringUtils.isEmpty((String)mobileNumber)) continue;
                SendMessageThread sendMessageThread = new SendMessageThread(ctx, messageType, messageType);
                sendMessageThread.start();
                continue;
            }
            if (!messageType.equals("30") || StringUtils.isEmpty((String)(receiveEmailAddress = (authenadmin = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(authentorid))).getEmail()))) continue;
            SendMailThread sendMailThread = new SendMailThread(ctx, receiveEmailAddress, body);
            sendMailThread.start();
        }
    }

    private String buildMessageBody(Context ctx, PermChangeRecordInfo permChangeRecordInfo, String authentorid) throws BOSException, EASBizException {
        UserInfo authentor = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(authentorid));
        return MessageFormat.format(ResourceBase.getString((String)RESOURCE, (String)"authen_message_body", (Locale)ctx.getLocale()), authentor.getName(), permChangeRecordInfo.getOperType().getAlias(), permChangeRecordInfo.getAssignedObjectNumber(), permChangeRecordInfo.getAssignedObjectName(), permChangeRecordInfo.getAssigner().getNumber(), permChangeRecordInfo.getChangeTime());
    }

    @Override
    protected List _getAuthenMessageType(Context ctx) throws BOSException {
        ArrayList<String> messageTypeList = new ArrayList<String>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"SELECT DISTINCT FAuthenMessageType FROM T_PM_AuthenMessageType");
        try {
            while (rowSet.next()) {
                messageTypeList.add(rowSet.getString("FAuthenMessageType"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (messageTypeList == null || messageTypeList.isEmpty()) {
            messageTypeList.add("10");
        }
        return messageTypeList;
    }

    private class SendMailThread
    extends Thread {
        private Context ctx;
        private String receiveEmailAddress;
        private String body;

        public SendMailThread(Context ctx, String receiveEmailAddress, String body) {
            this.ctx = ctx;
            this.receiveEmailAddress = receiveEmailAddress;
            this.body = body;
        }

        @Override
        public void run() {
            try {
                this.sendEmail(this.ctx, this.receiveEmailAddress, this.body);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void sendEmail(Context ctx, String receiveEmailAddress, String body) throws EASBizException, BOSException {
            AuthenRecordControllerBean.this.sendMail(ctx, receiveEmailAddress, ResourceBase.getString((String)AuthenRecordControllerBean.RESOURCE, (String)"authen_message_title", (Locale)ctx.getLocale()), body);
        }
    }

    private class SendMessageThread
    extends Thread {
        private Context ctx;
        private String mobileNumber;
        private String body;

        public SendMessageThread(Context ctx, String mobileNumber, String body) {
            this.ctx = ctx;
            this.mobileNumber = mobileNumber;
            this.body = body;
        }

        @Override
        public void run() {
            try {
                this.sendMessage(this.ctx, this.mobileNumber, this.body);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void sendMessage(Context ctx, String receiveEmailAddress, String body) throws EASBizException, BOSException {
            MsgUtil.mobileMsgSend((Context)ctx, (String)body, (int)1, (boolean)false, null, (String)this.mobileNumber, null);
        }
    }
}

