/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.IOrgRangeSolution;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.IUserRoleOrgManager;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeHelper;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeSolutionFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.base.permission.UserRolePermCollection;
import com.kingdee.eas.base.permission.UserRolePermInfo;
import com.kingdee.eas.base.permission.app.AbstractOrgRangeControllerBean;
import com.kingdee.eas.base.permission.app.config.ConfigurationLoader;
import com.kingdee.eas.base.permission.app.helper.OrgRangeAppHelper;
import com.kingdee.eas.base.permission.app.helper.PermCacheHelper;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.IObjectCol2Map;
import com.kingdee.eas.base.permission.util.LogProxy;
import com.kingdee.eas.base.permission.util.LowTimeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.app.OrgAppUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrgRangeControllerBean
extends AbstractOrgRangeControllerBean {
    private Logger logger = Logger.getLogger((String)OrgRangeControllerBean.class.getName());
    static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private int count = 0;
    private Map cacheMap = new HashMap();
    private Map ctrlCacheMap = new HashMap();
    private Map cuUserCacheMap = new HashMap();
    private Map permCacheMap = new HashMap();
    private Map rolePermCache = new HashMap();
    private Map defaultOrgCache = new HashMap();

    @Override
    protected void _addNewCol(Context ctx, OrgRangeCollection orgRangeCol) throws BOSException, EASBizException {
        if (orgRangeCol == null || orgRangeCol.isEmpty()) {
            return;
        }
        String sql = "insert into t_pm_orgrange(fid,forgid,fuserid,ftype) values(?,?,?,?)";
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql);
            for (int i = 0; i < orgRangeCol.size(); ++i) {
                ps.setString(1, BOSUuid.create((BOSObjectType)this.getBOSType()).toString());
                ps.setString(2, orgRangeCol.get(i).getOrg().getId().toString());
                ps.setString(3, orgRangeCol.get(i).getUser().getId().toString());
                ps.setInt(4, orgRangeCol.get(i).getType().getValue());
                ps.execute();
            }
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)"", (Throwable)e);
                throw new BOSException("sqlerror", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PermCacheHelper.removePermCache(PermCacheHelper.ORGPERMCACHE, ctx.getCaller().toString());
        PermCacheHelper.removePermCache(PermCacheHelper.ORGRANGECACHE, ctx.getCaller().toString());
        return super._addnew(ctx, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._addnew(ctx, pk, model);
    }

    @Override
    protected OrgRangeCollection _findFullOrgCol(Context ctx, IObjectPK userPK, OrgRangeType bizOrgType) throws BOSException {
        return this.getOrgRangeCollection(ctx, userPK, bizOrgType, true);
    }

    @Override
    protected void _deleteByUserId(Context ctx, String userId, OrgRangeType orgRangeType) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)userId)) {
            throw new IllegalArgumentException("userid is null");
        }
        String sql = "delete where user.id = '" + userId + "'";
        if (orgRangeType != null) {
            sql = sql + " and type = " + orgRangeType.getValue();
        }
        this._delete(ctx, sql);
        IOrgRangeSolution iOrgRangeSolution = OrgRangeSolutionFactory.getLocalInstance(ctx);
        ArrayList<String> userStrList = new ArrayList<String>();
        userStrList.add(userId);
        iOrgRangeSolution.correctOrgRange(userStrList, null);
    }

    private List allCtrlUnitSet(Context ctx, List orgList) throws BOSException {
        String cacheKey = ToolUtils.aryToStr(orgList);
        if (this.ctrlCacheMap.containsKey(cacheKey)) {
            return (List)this.ctrlCacheMap.get(cacheKey);
        }
        ICtrlUnit iFullOrgUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
        CtrlUnitCollection ctrlCol = iFullOrgUnit.getCtrlUnitCollection("select * where id in (" + ToolUtils.aryToStr(orgList, true) + ")");
        List retList = ToolUtils.transCol2ListByPeroperty((IObjectCollection)ctrlCol, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                CtrlUnitInfo ctrlUnitInfo = (CtrlUnitInfo)obj;
                if (ctrlUnitInfo.getId() != null) {
                    return ctrlUnitInfo.getId().toString();
                }
                return null;
            }
        });
        this.ctrlCacheMap.put(cacheKey, retList);
        return retList;
    }

    private List allCuUser(Context ctx, List userList) throws BOSException {
        String cacheKey = ToolUtils.aryToStr(userList);
        if (this.cuUserCacheMap.containsKey(cacheKey)) {
            return (List)this.cuUserCacheMap.get(cacheKey);
        }
        IUser iUser = UserFactory.getLocalInstance(ctx);
        UserCollection ctrlCol = iUser.getUserCollection("select * where type = 10 and id in (" + ToolUtils.aryToStr(userList, true) + ")");
        List retList = ToolUtils.transCol2ListByPeroperty((IObjectCollection)ctrlCol, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                UserInfo userInfo = (UserInfo)obj;
                if (userInfo.getId() != null) {
                    return userInfo.getId().toString();
                }
                return null;
            }
        });
        this.cuUserCacheMap.put(cacheKey, retList);
        return retList;
    }

    private List alreadyHaveData(Context ctx, List userIdList, List orgList, OrgRangeType orgRangeType) throws EASBizException, BOSException {
        String cacheKey = ToolUtils.aryToStr(userIdList) + ToolUtils.aryToStr(orgList) + orgRangeType.getValue();
        if (this.cacheMap.containsKey(cacheKey)) {
            return (List)this.cacheMap.get(cacheKey);
        }
        OrgRangeCollection alreadyHaveCol = this.findFullOrgCol(ctx, userIdList, orgList, orgRangeType);
        List retList = ToolUtils.transCol2ListByPeroperty((IObjectCollection)alreadyHaveCol, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                OrgRangeInfo orgRangeInfo = (OrgRangeInfo)obj;
                if (orgRangeInfo != null) {
                    StringBuffer keyStr = new StringBuffer("");
                    if (orgRangeInfo.getUser() != null && orgRangeInfo.getUser().getId() != null) {
                        keyStr.append(orgRangeInfo.getUser().getId().toString());
                    }
                    keyStr.append(":");
                    if (orgRangeInfo.getOrg() != null && orgRangeInfo.getOrg().getId() != null) {
                        keyStr.append(orgRangeInfo.getOrg().getId().toString());
                    }
                    keyStr.append(":");
                    if (orgRangeInfo.getType() != null) {
                        keyStr.append(orgRangeInfo.getType().getValue());
                    }
                    return keyStr.toString();
                }
                return null;
            }
        });
        this.cacheMap.put(cacheKey, retList);
        return retList;
    }

    private void addInsertData(Context ctx, BOSObjectType bosType, PreparedStatement state, List userIdList, List orgList, OrgRangeType orgRangeType) throws BOSException, EASBizException {
        LowTimeHelper lowHelper = new LowTimeHelper();
        List alreadyHaveDataList = this.alreadyHaveData(ctx, userIdList, orgList, orgRangeType);
        lowHelper.printTime2Last("alreadyHaveData");
        List allCtrlList = this.allCtrlUnitSet(ctx, orgList);
        lowHelper.printTime2Last("allCtrlUnitSet");
        List allAdminUser = this.allCuUser(ctx, userIdList);
        lowHelper.printTime2Last("allCuUser");
        this.count = 0;
        int size = userIdList.size();
        for (int i = 0; i < size; ++i) {
            String userId = (String)userIdList.get(i);
            int sizej = orgList.size();
            for (int j = 0; j < sizej; ++j) {
                String orgId = (String)orgList.get(j);
                String newKeyStr = userId + ":" + orgId + ":" + orgRangeType.getValue();
                if (alreadyHaveDataList.contains(newKeyStr)) continue;
                String orgRangeId = BOSUuid.create((BOSObjectType)bosType).toString();
                if (allAdminUser.contains(userId)) {
                    if (!allCtrlList.contains(orgId)) continue;
                    this.insertData(state, orgRangeId, userId, orgId, orgRangeType);
                    continue;
                }
                this.insertData(state, orgRangeId, userId, orgId, orgRangeType);
            }
        }
        lowHelper.printTime2Last("for all orgrange");
    }

    private void insertData(PreparedStatement state, String orgRangeId, String userId, String orgId, OrgRangeType orgRangeType) throws BOSException {
        try {
            state.setString(1, orgRangeId);
            state.setString(2, userId);
            state.setString(3, orgId);
            state.setInt(4, orgRangeType.getValue());
            state.addBatch();
            ++this.count;
            if (this.count > 2000) {
                state.executeBatch();
                this.count = 0;
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _addOrgRangeBatch(Context ctx, List userIdList, List orgList, OrgRangeType orgRangeType) throws BOSException, EASBizException {
        PreparedStatement insertSystemUserSubOrgSmt;
        PreparedStatement insertSystemUserSmt;
        PreparedStatement insertSubOrgSmt;
        PreparedStatement insertSqlSmt;
        PreparedStatement state;
        Connection conn;
        block11: {
            String tableName;
            TableManager manager;
            IObjectPK logPk;
            block9: {
                block10: {
                    logPk = LogUtil.beginLog((Context)ctx, (String)EASCommonResource.getString((String)RESOURCE, (String)"ORGRANGE_ADDNEW", (Locale)ctx.getLocale()), (BOSObjectType)new BOSObjectType("FD3DC16D"), null, (String)this.getBatchOrgRangeLogDetail(ctx, userIdList, orgList, orgRangeType), (String)"bs_permission_orgRange_add");
                    manager = null;
                    tableName = null;
                    conn = this.getConnection(ctx);
                    state = null;
                    insertSqlSmt = null;
                    insertSubOrgSmt = null;
                    insertSystemUserSmt = null;
                    insertSystemUserSubOrgSmt = null;
                    manager = TableManager.getTableManager((Context)ctx);
                    if (manager != null) break block9;
                    this.logger.error((Object)"error ! batch assign org,Get Temp Table fail!");
                    if (manager == null || tableName == null) break block10;
                    manager.releaseTable(tableName);
                }
                SQLUtils.cleanup(state, (Connection)conn);
                SQLUtils.cleanup(insertSqlSmt, (Connection)conn);
                SQLUtils.cleanup(insertSubOrgSmt, (Connection)conn);
                SQLUtils.cleanup(insertSystemUserSmt, (Connection)conn);
                SQLUtils.cleanup(insertSystemUserSubOrgSmt, (Connection)conn);
                this.updateUserInfo(ctx, userIdList);
                return;
            }
            try {
                String userId;
                int i;
                tableName = manager.getTableName("OrgRangeBatch");
                String createSql = "create table " + tableName + " (FOrgId varchar(44))";
                manager.createTable(createSql);
                String insertTmpSql = "insert into " + tableName + " (forgid) values(?)";
                state = conn.prepareStatement(insertTmpSql);
                this.addInsertTmpData(ctx, state, orgList);
                String insertSql = "insert into t_pm_orgRange (fid,fuserid,forgid,ftype) select newbosid('FD3DC16D'),?,FOrgId,? from " + tableName + " tmp where not exists(select 1 from t_pm_orgRange o where o.forgid = tmp.forgid   and o.fuserid = ? and o.ftype=?)";
                String insertSystemUserSql = "insert into t_pm_orgRange (fid,fuserid,forgid,ftype) select newbosid('FD3DC16D'),?,FOrgId,? from " + tableName + " tmp where not exists (select 1 from t_pm_orgRange o where o.forgid = tmp.forgid  and o.fuserid = ? and o.ftype=?) and  exists (select fid from T_ORG_CtrlUnit where T_ORG_CtrlUnit.fid=tmp.forgId)";
                String insertSubOrgSql = "insert into T_PM_OrgRangeIncludeSubOrg (fid,fuserid, forgid,ftype,FISINCLUDESUBORG) select newbosid('4DC3DADF'),?,FOrgId,?,? from " + tableName + " tmp where not exists (select 1 from T_PM_OrgRangeIncludeSubOrg o where o.forgid = tmp.forgid   and o.fuserid = ? and o.ftype=?)";
                String insertSystemUserSubOrgSql = "insert into T_PM_OrgRangeIncludeSubOrg (fid,fuserid, forgid,ftype,FISINCLUDESUBORG) select newbosid('4DC3DADF'),?,FOrgId,?,0 from " + tableName + " tmp where not exists (select 1 from T_PM_OrgRangeIncludeSubOrg o where o.forgid = tmp.forgid  and o.fuserid = ? and o.ftype=?) and exists (select fid from T_ORG_CtrlUnit where T_ORG_CtrlUnit.fid=tmp.forgId)";
                String findSubOrg = "select admin1.flongnumber longnumber from T_PM_OrgRangeIncludeSubOrg subOrg inner join t_org_admin admin1 on subOrg.forgid = admin1.fid where subOrg.ftype=20 and subOrg.FISINCLUDESUBORG =1 and fuserid= ?";
                insertSqlSmt = conn.prepareStatement(insertSql);
                insertSubOrgSmt = conn.prepareStatement(insertSubOrgSql);
                insertSystemUserSmt = conn.prepareStatement(insertSystemUserSql);
                insertSystemUserSubOrgSmt = conn.prepareStatement(insertSystemUserSubOrgSql);
                String strParam = ParamManager.getParamValue((Context)ctx, null, (String)"AddUserOrgRangeIncludeSubOrg");
                boolean isAndSubOrg = "true".equals(strParam);
                for (i = 0; i < userIdList.size(); ++i) {
                    userId = (String)userIdList.get(i);
                    UserInfo userInfo = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId));
                    if (userInfo.getType().getValue() == 10) {
                        insertSystemUserSmt.setString(1, userId);
                        insertSystemUserSmt.setInt(2, orgRangeType.getValue());
                        insertSystemUserSmt.setString(3, userId);
                        insertSystemUserSmt.setInt(4, orgRangeType.getValue());
                        insertSystemUserSubOrgSmt.setString(1, userId);
                        insertSystemUserSubOrgSmt.setInt(2, orgRangeType.getValue());
                        insertSystemUserSubOrgSmt.setString(3, userId);
                        insertSystemUserSubOrgSmt.setInt(4, orgRangeType.getValue());
                        insertSystemUserSmt.addBatch();
                        insertSystemUserSubOrgSmt.addBatch();
                        continue;
                    }
                    int includeSubOrgType = 20 == orgRangeType.getValue() && isAndSubOrg ? 1 : 0;
                    insertSubOrgSmt.setString(1, userId);
                    insertSubOrgSmt.setInt(2, orgRangeType.getValue());
                    insertSubOrgSmt.setInt(3, includeSubOrgType);
                    insertSubOrgSmt.setString(4, userId);
                    insertSubOrgSmt.setInt(5, orgRangeType.getValue());
                    insertSqlSmt.setString(1, userId);
                    insertSqlSmt.setInt(2, orgRangeType.getValue());
                    insertSqlSmt.setString(3, userId);
                    insertSqlSmt.setInt(4, orgRangeType.getValue());
                    insertSqlSmt.addBatch();
                    insertSubOrgSmt.addBatch();
                }
                insertSqlSmt.executeBatch();
                insertSubOrgSmt.executeBatch();
                insertSystemUserSmt.executeBatch();
                insertSystemUserSubOrgSmt.executeBatch();
                for (i = 0; i < userIdList.size(); ++i) {
                    userId = (String)userIdList.get(i);
                    if (orgRangeType != OrgRangeType.ADMIN_ORG_TYPE || !isAndSubOrg) continue;
                    OrgRangeHelper.updateAdminOrgRange(ctx, userId);
                }
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
                if (manager == null || tableName == null) break block11;
            }
            catch (Exception e) {
                try {
                    this.logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (manager != null && tableName != null) {
                        manager.releaseTable(tableName);
                    }
                    SQLUtils.cleanup(state, (Connection)conn);
                    SQLUtils.cleanup(insertSqlSmt, (Connection)conn);
                    SQLUtils.cleanup(insertSubOrgSmt, (Connection)conn);
                    SQLUtils.cleanup(insertSystemUserSmt, (Connection)conn);
                    SQLUtils.cleanup(insertSystemUserSubOrgSmt, (Connection)conn);
                    this.updateUserInfo(ctx, userIdList);
                    throw throwable;
                }
            }
            manager.releaseTable(tableName);
        }
        SQLUtils.cleanup((Statement)state, (Connection)conn);
        SQLUtils.cleanup((Statement)insertSqlSmt, (Connection)conn);
        SQLUtils.cleanup((Statement)insertSubOrgSmt, (Connection)conn);
        SQLUtils.cleanup((Statement)insertSystemUserSmt, (Connection)conn);
        SQLUtils.cleanup((Statement)insertSystemUserSubOrgSmt, (Connection)conn);
        this.updateUserInfo(ctx, userIdList);
        return;
    }

    private void addInsertTmpData(Context ctx, PreparedStatement state, List orgList) throws SQLDataException, SQLException {
        this.count = 0;
        for (int i = 0; i < orgList.size(); ++i) {
            String orgId = (String)orgList.get(i);
            state.setString(1, orgId);
            state.addBatch();
            ++this.count;
            if (this.count <= 2000) continue;
            state.executeBatch();
            this.count = 0;
        }
        state.executeBatch();
        state.close();
    }

    @Override
    protected String _delOrgRangeBatch(Context ctx, List userIdList, List orgList, OrgRangeType orgRangeType) throws BOSException, EASBizException {
        if (userIdList == null || userIdList.isEmpty() || orgList == null || orgList.isEmpty() || orgRangeType == null) {
            return "true";
        }
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)EASCommonResource.getString((String)RESOURCE, (String)"ORGRANGE_ADDNEW", (Locale)ctx.getLocale()), (BOSObjectType)new BOSObjectType("FD3DC16D"), null, (String)this.getBatchOrgRangeLogDetail(ctx, userIdList, orgList, orgRangeType), (String)"bs_permission_orgRange_del");
        String delSubOrgSql = " delete from T_PM_OrgRangeIncludeSubOrg where fuserid =? and forgid = ? and ftype = " + orgRangeType.getValue();
        LowTimeHelper lowHelper = new LowTimeHelper();
        this.deleteOrgRange(ctx, delSubOrgSql, userIdList, orgList, orgRangeType);
        lowHelper.printTime2Last("delSubOrgSql");
        this.deleteOrgRangeSolution(ctx, userIdList, orgList);
        lowHelper.printTime2Last("deleteOrgRangeSolution");
        String delSql = " delete from t_pm_orgRange where fuserid =? and forgid = ? and ftype = " + orgRangeType.getValue();
        String message = this.deleteOrgRange(ctx, delSql, userIdList, orgList, orgRangeType);
        lowHelper.printTime2Last("deleteOrgRange");
        this.updateUserInfo(ctx, userIdList);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        return message;
    }

    private void deleteOrgRangeSolution(Context ctx, List userIdList, List orgList) throws BOSException, EASBizException {
        IOrgRangeSolution iOrgRangeSolution = OrgRangeSolutionFactory.getLocalInstance(ctx);
        iOrgRangeSolution.correctOrgRange(userIdList, orgList);
    }

    private String deleteOrgRange(Context ctx, String delSql, List userIdList, List orgList, OrgRangeType orgRangeType) throws BOSException, EASBizException {
        ArrayList<String> notDelUserOrgList = new ArrayList<String>();
        List defaultOrgall = this.getDefaultOrg(ctx, userIdList, orgList);
        ArrayList<String> defaultOrg = new ArrayList<String>();
        for (int i = 0; i < defaultOrgall.size(); ++i) {
            String orginfo = (String)defaultOrgall.get(i).toString().subSequence(0, defaultOrgall.get(i).toString().lastIndexOf(":"));
            defaultOrg.add(orginfo.substring(0, orginfo.lastIndexOf(":")));
        }
        Connection conn = this.getConnection(ctx);
        PreparedStatement state = null;
        ArrayList<String> allNotUserList = new ArrayList<String>();
        ArrayList<String> allNotOrgList = new ArrayList<String>();
        this.count = 0;
        int delSqlCount = 0;
        try {
            state = conn.prepareStatement(delSql);
            LowTimeHelper lowHelper = new LowTimeHelper();
            for (int i = 0; i < userIdList.size(); ++i) {
                String string = (String)userIdList.get(i);
                for (int j = 0; j < orgList.size(); ++j) {
                    String orgId = (String)orgList.get(j);
                    String keyStr = string + ":" + orgId;
                    if (!defaultOrg.contains(keyStr) || OrgRangeType.ADMIN_ORG_TYPE.equals((Object)orgRangeType)) {
                        state.setString(1, string);
                        state.setString(2, orgId);
                        state.addBatch();
                        ++delSqlCount;
                        ++this.count;
                        if (this.count > 2000) {
                            state.executeBatch();
                            this.count = 0;
                        }
                        if (!OrgRangeType.BIZ_ORG_TYPE.equals((Object)orgRangeType)) continue;
                        this.deleteRelativePermAndRole(ctx, (IObjectPK)new ObjectUuidPK(string), orgId);
                        continue;
                    }
                    notDelUserOrgList.add(keyStr);
                    allNotUserList.add(string);
                    allNotOrgList.add(orgId);
                }
            }
            state.executeBatch();
            lowHelper.printAllTime();
        }
        catch (SQLException e) {
            this.logger.error((Object)"sqlException :", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)state, (Connection)conn);
        }
        if (notDelUserOrgList.isEmpty()) {
            return "true";
        }
        String msg = "";
        for (Object e : allNotUserList) {
            for (int i = 0; i < defaultOrgall.size(); ++i) {
                if (defaultOrgall.get(i).toString().indexOf(e.toString()) <= -1) continue;
                String s = (String)defaultOrgall.get(i).toString().subSequence(defaultOrgall.get(i).toString().indexOf(":") + 1, defaultOrgall.get(i).toString().length());
                msg = msg + s.substring(s.indexOf(":") + 1, s.length()) + ";";
            }
        }
        if (msg.length() > 0) {
            this.writeLog(ctx, notDelUserOrgList, allNotUserList, allNotOrgList);
            return msg;
        }
        return "false";
    }

    private List getNotDelUserOrg(Context ctx, List userIdList, List orgList) throws BOSException, EASBizException {
        LowTimeHelper lowHelper = new LowTimeHelper();
        List userPermSet = this.getUserPerm(ctx, userIdList, orgList);
        lowHelper.printTime2Last("getUserPerm");
        userPermSet.addAll(this.getRolePerm(ctx, userIdList, orgList));
        lowHelper.printTime2Last("getRolePerm");
        return userPermSet;
    }

    private List getDefaultOrg(Context ctx, List userIdList, List orgList) throws BOSException, EASBizException {
        LowTimeHelper lowHelper = new LowTimeHelper();
        List defaultOrgPermSet = this.getDefaultPerm(ctx, userIdList, orgList);
        lowHelper.printTime2Last("getDefaultPerm");
        return defaultOrgPermSet;
    }

    private List getUserPerm(Context ctx, List userIdList, List orgList) throws BOSException {
        String keyStr = ToolUtils.aryToStr(userIdList) + ToolUtils.aryToStr(orgList);
        if (this.permCacheMap.containsKey(keyStr)) {
            return (List)this.permCacheMap.get(keyStr);
        }
        String sql = " select distinct fowner,forgid from t_pm_userorgperm where fowner in (" + ToolUtils.aryToStr(userIdList, true) + ") and  forgid in (" + ToolUtils.aryToStr(orgList, true) + ")";
        IRowSet iRowset = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> retList = new ArrayList<String>();
        try {
            while (iRowset.next()) {
                retList.add(iRowset.getString("fowner") + ":" + iRowset.getString("forgid"));
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"sql error!", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        this.permCacheMap.put(keyStr, retList);
        return retList;
    }

    private List getDefaultPerm(Context ctx, List userIdList, List orgList) throws BOSException {
        String keyStr = ToolUtils.aryToStr(userIdList) + ToolUtils.aryToStr(orgList);
        if (this.defaultOrgCache.containsKey(keyStr)) {
            return (List)this.defaultOrgCache.get(keyStr);
        }
        String sql = " select distinct a.FID,a.FDEFORGUNITID,a.FNUMBER as usernumber,b.FNAME_L2 as orgname from t_pm_user a,T_ORG_BASEUNIT b where a.FDEFORGUNITID = b.FID AND a.FID in (" + ToolUtils.aryToStr(userIdList, true) + ")";
        IRowSet iRowset = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> retList = new ArrayList<String>();
        try {
            while (iRowset.next()) {
                retList.add(iRowset.getString("FID") + ":" + iRowset.getString("FDEFORGUNITID") + ":" + iRowset.getString("usernumber") + ":" + iRowset.getString("orgname"));
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"sql error!", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        this.defaultOrgCache.put(keyStr, retList);
        return retList;
    }

    private List getRolePerm(Context ctx, List userIdList, List orgList) throws BOSException, EASBizException {
        String keyStr = ToolUtils.aryToStr(userIdList) + ToolUtils.aryToStr(orgList);
        if (this.rolePermCache.containsKey(keyStr)) {
            return (List)this.rolePermCache.get(keyStr);
        }
        IUserRoleOrgManager iUserRoleOrgManager = UserRoleOrgManagerFactory.getLocalInstance(ctx);
        UserRolePermCollection userRoelPermCol = iUserRoleOrgManager.getUserRolePermCol(userIdList, orgList, null);
        List retList = ToolUtils.transCol2ListByPeroperty((IObjectCollection)userRoelPermCol, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                UserRolePermInfo userRolePermInfo = (UserRolePermInfo)obj;
                if (userRolePermInfo != null && userRolePermInfo.getUserId() != null && userRolePermInfo.getUserId().getId() != null && userRolePermInfo.getOrgId() != null && userRolePermInfo.getOrgId().getId() != null) {
                    return userRolePermInfo.getUserId().getId().toString() + ":" + userRolePermInfo.getOrgId().getId().toString();
                }
                return null;
            }
        });
        this.rolePermCache.put(keyStr, retList);
        return retList;
    }

    private void writeLog(Context ctx, List notDelUserOrgList, List allUserList, List allOrgList) throws BOSException {
        Map userNameMap = this.getNotDelUserMap(ctx, allUserList);
        Map orgNameMap = this.getNotDelOrgMap(ctx, allOrgList);
        LogProxy logProxy = new LogProxy();
        StringBuffer detailStr = new StringBuffer("");
        detailStr.append(EASCommonResource.getString((String)RESOURCE, (String)"notDelUserOrg", (Locale)ctx.getLocale()));
        for (int i = 0; i < notDelUserOrgList.size(); ++i) {
            String keyStr = (String)notDelUserOrgList.get(i);
            int pos = keyStr.indexOf(":");
            if (pos == -1) continue;
            String userIdStr = keyStr.substring(0, pos);
            String orgIdStr = "";
            if (pos + 1 <= keyStr.length()) {
                orgIdStr = keyStr.substring(pos + 1, keyStr.length());
            }
            detailStr.append("(").append(EASCommonResource.getString((String)RESOURCE, (String)"userNumber4Log", (Locale)ctx.getLocale())).append(":");
            detailStr.append(StringUtils.cnulls(userNameMap.get(userIdStr))).append(",");
            detailStr.append(EASCommonResource.getString((String)RESOURCE, (String)"orgNumber4Log", (Locale)ctx.getLocale())).append(":");
            detailStr.append(StringUtils.cnulls(orgNameMap.get(orgIdStr))).append(");");
        }
        logProxy.beginLog(ctx, "delOrgRangeBatch", this.getBOSType(), null, detailStr.toString());
        logProxy.end();
    }

    private Map getNotDelUserMap(Context ctx, List allUserList) throws BOSException {
        IUser iUser = UserFactory.getLocalInstance(ctx);
        String oql = "select id,number ,name where id in(" + ToolUtils.aryToStr(allUserList, true) + ")";
        UserCollection userCol = iUser.getUserCollection(oql);
        return ToolUtils.transCol2ListByPeroperty((IObjectCollection)userCol, new IObjectCol2Map(){

            @Override
            public String getKey(Object obj) {
                UserInfo userInfo = (UserInfo)obj;
                if (userInfo != null && userInfo.getId() != null) {
                    return userInfo.getId().toString();
                }
                return null;
            }

            @Override
            public Object getList(Object obj) {
                UserInfo userInfo = (UserInfo)obj;
                if (userInfo != null && userInfo.getNumber() != null) {
                    return userInfo.getNumber();
                }
                return "";
            }
        });
    }

    private Map getNotDelOrgMap(Context ctx, List allOrgList) throws BOSException {
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        String oql = "select id,number ,name where id in(" + ToolUtils.aryToStr(allOrgList, true) + ")";
        FullOrgUnitCollection fullOrgUnitCol = iFullOrgUnit.getFullOrgUnitCollection(oql);
        return ToolUtils.transCol2ListByPeroperty((IObjectCollection)fullOrgUnitCol, new IObjectCol2Map(){

            @Override
            public String getKey(Object obj) {
                FullOrgUnitInfo fullOrgInfo = (FullOrgUnitInfo)obj;
                if (fullOrgInfo != null && fullOrgInfo.getId() != null) {
                    return fullOrgInfo.getId().toString();
                }
                return null;
            }

            @Override
            public Object getList(Object obj) {
                FullOrgUnitInfo fullOrgInfo = (FullOrgUnitInfo)obj;
                if (fullOrgInfo != null && fullOrgInfo.getNumber() != null) {
                    return fullOrgInfo.getNumber();
                }
                return "";
            }
        });
    }

    @Override
    protected IObjectCollection _findFullOrgCol(Context ctx, List userIdList, List orgIdList, OrgRangeType orgRangeType) throws BOSException, EASBizException {
        String oql = "select * " + this.getWhereStr(userIdList, orgIdList, orgRangeType);
        IOrgRange iOrgRange = OrgRangeFactory.getLocalInstance(ctx);
        return iOrgRange.getOrgRangeCollection(oql);
    }

    private String getWhereStr(List userIdList, List orgIdList, OrgRangeType orgRangeType) {
        String retStr = "";
        if (ToolUtils.isNullList(userIdList) && ToolUtils.isNullList(orgIdList) && orgRangeType == null) {
            return "";
        }
        retStr = " where ";
        String whereStr = "";
        if (!ToolUtils.isNullList(userIdList)) {
            whereStr = " user.id in (" + ToolUtils.aryToStr(userIdList, true) + ")";
        }
        if (!ToolUtils.isNullList(orgIdList)) {
            whereStr = whereStr + " and org.id in (" + ToolUtils.aryToStr(orgIdList, true) + ")";
        }
        if (orgRangeType != null) {
            whereStr = whereStr + " and type = " + orgRangeType.getValue();
        }
        if ((whereStr = whereStr.trim()).startsWith("and")) {
            whereStr = whereStr.substring(4, whereStr.length());
        }
        return retStr + whereStr;
    }

    @Override
    protected void _handleErrorOrgRangeData(Context ctx) throws BOSException, EASBizException {
        OrgRangeAppHelper.deleteDuplicateOrgRange(ctx);
        IObjectPK userPK = this.getCurrentUserPK(ctx);
        this.synOrgRange(ctx, userPK);
    }

    private IObjectPK getCurrentUserPK(Context ctx) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        return new ObjectUuidPK(userInfo.getId());
    }

    private void synOrgRange(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        this.synIncludeSubOrg(ctx, userPK);
        this.synOrgRangeNotSub(ctx, userPK);
    }

    private void synOrgRangeNotSub(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        String sql = "insert into t_pm_orgrange(fid,fuserid,forgid,ftype) select {0},{1},a.forgid,a.ftype from t_pm_orgrangeincludesuborg a left join   t_pm_orgrange b on a.fuserid=b.fuserid and a.forgid=b.forgid and a.ftype=b.ftype where a.fuserid={2} and a.fisincludesuborg=0 and b.fid is null";
        String newBosId = "newbosid('" + this.getBOSType() + "')";
        String userPKStr = "'" + userPK.toString() + "'";
        Object[] params = new String[]{newBosId, userPKStr, userPKStr};
        DbUtil.execute((Context)ctx, (String)MessageFormat.format(sql, params));
    }

    private void synIncludeSubOrg(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        String subOrgSql = this.getSubOrgSql(ctx, userPK);
        if (StringUtils.isEmpty((String)subOrgSql)) {
            return;
        }
        String sql = "insert into t_pm_orgrange (fid,fuserid,forgid,ftype) select {0},{1},orgId,{2} from ({3}) a  where orgId not in (select forgid from t_pm_orgrange where ftype={4} and fuserid={5})";
        String newBosId = "newbosid('" + this.getBOSType() + "')";
        String type = String.valueOf(20);
        String userPKStr = "'" + userPK.toString() + "'";
        Object[] params = new String[]{newBosId, userPKStr, type, subOrgSql, type, userPKStr};
        DbUtil.execute((Context)ctx, (String)MessageFormat.format(sql, params));
    }

    private String getSubOrgSql(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        Collection longNumList = OrgRangeAppHelper.getIncludeSubOrgLongNumList(ctx, userPK, OrgRangeType.ADMIN_ORG_TYPE);
        if (longNumList.size() < 1) {
            return "";
        }
        Iterator itr = longNumList.iterator();
        StringBuffer subSql = new StringBuffer();
        while (itr.hasNext()) {
            String longNumber = itr.next().toString();
            subSql.append("select fid orgId from t_org_admin where flongnumber like '").append(longNumber).append("!%' or flongnumber='").append(longNumber).append("' ").append(" union ");
        }
        String subSqlStr = subSql.toString();
        return subSqlStr.substring(0, subSqlStr.length() - 6);
    }

    @Override
    protected void _addOrgToSuperAdmin(Context ctx, IObjectValue orgInfo, OrgRangeType orgRangeType) throws BOSException, EASBizException {
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        FullOrgUnitInfo fullOrgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgInfo.get("id").toString()));
        List superOrgIdList = this.getSuperiorOrg(ctx, fullOrgUnitInfo);
        List userIdList = this._getUserIdListByOrgsAndType(ctx, superOrgIdList, orgRangeType);
        ArrayList<String> orgList = new ArrayList<String>();
        orgList.add(fullOrgUnitInfo.get("id").toString());
        this._addOrgRangeBatch(ctx, userIdList, orgList, orgRangeType);
    }

    @Override
    protected List _getUserIdListByOrgsAndType(Context ctx, List orgIdList, OrgRangeType orgRangeType) throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        String orgIdsString = ToolUtils.aryToStr(orgIdList);
        String sql = "select distinct fuserid from t_pm_orgrange a join t_pm_user b on a.fuserid=b.fid where b.ftype=10 and a.forgid in (" + orgIdsString + ") and a.ftype=" + orgRangeType.getValue() + " and b.fnumber<>'administrator' and b.fnumber<>'authenadmin'";
        Connection con = this.getConnection(ctx);
        PreparedStatement state = null;
        try {
            state = con.prepareStatement(sql);
            ResultSet ret = state.executeQuery();
            while (ret.next()) {
                String userId = ret.getString("fuserid");
                list.add(userId);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)state, (Connection)con);
        }
        return list;
    }

    private List getSuperiorOrg(Context ctx, FullOrgUnitInfo org) throws BOSException, EASBizException {
        ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
        String longNumber = org.getLongNumber();
        String[] superLongNumbers = OrgAppUtils.getAncestor((String)longNumber);
        String longNumberString = ToolUtils.aryToStr(superLongNumbers);
        String oql = "select id where longNumber in (" + longNumberString + ")";
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection orgCol = iFullOrgUnit.getFullOrgUnitCollection(oql);
        for (int i = 0; i < orgCol.size(); ++i) {
            list.add(orgCol.get(i).getId());
        }
        return list;
    }

    @Override
    protected void _handleErrorOrgRangeData(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        OrgRangeAppHelper.deleteDuplicateOrgRange(ctx, userPK);
        this.synOrgRange(ctx, userPK);
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private void updateUserInfo(Context ctx, List tragetUserIDs) throws BOSException, EASBizException {
        if (tragetUserIDs == null) {
            return;
        }
        Timestamp createtime = this.getTime();
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_PM_USER set flastupdateuserid=? ,flastupdatetime=? where fid=?");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(tragetUserIDs.size());
        for (int i = 0; i < tragetUserIDs.size(); ++i) {
            Object[] params = new Object[]{ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), createtime, tragetUserIDs.get(i)};
            paramList.add(params);
        }
        try {
            DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramList);
        }
        catch (Exception e) {
            this.logger.error((Object)"update lastupdatetime after operating organization range", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected List _getOrgIdByUserAndType(Context ctx, IObjectPK userPK, OrgRangeType type) throws BOSException, EASBizException {
        ArrayList<String> result = new ArrayList<String>();
        OrgRangeCollection coll = this.getOrgRangeCollection(ctx, userPK, type, false);
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            result.add(coll.get(i).getOrg().getId().toString());
        }
        return result;
    }

    private OrgRangeCollection getOrgRangeCollection(Context ctx, IObjectPK userPK, OrgRangeType type, boolean isAllItemSelected) throws BOSException {
        if (userPK == null) {
            throw new IllegalArgumentException("userPK is null!");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select ").append(isAllItemSelected ? "*" : "org.id").append(" where user = '").append(userPK.toString()).append("'");
        if (type != null) {
            sb.append(" and type = ").append(type.getValue());
        }
        sb.append(" order by org.level");
        return this.getOrgRangeCollection(ctx, sb.toString());
    }

    private void deleteRelativePermAndRole(Context ctx, IObjectPK userPK, String orgIds) throws BOSException, EASBizException {
        List deleteSqlList = this.getDeleteSqlList(userPK, orgIds);
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            for (int i = 0; i < deleteSqlList.size(); ++i) {
                SQLUtils.execute((Connection)con, (String)deleteSqlList.get(i).toString());
            }
        }
        catch (SQLException se) {
            this.logger.error((Object)se);
            throw new UserException(UserException.USER_CHANGE_FAIL);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private List getDeleteSqlList(IObjectPK userPK, String orgId) {
        String orgIds = "'" + orgId + "'";
        ArrayList<String> deleteSqlList = new ArrayList<String>();
        StringBuffer permOql = new StringBuffer();
        permOql.append("delete from t_pm_userorgperm where fowner='").append(userPK.toString()).append("' and forgid in(").append(orgIds).append(")");
        deleteSqlList.add(permOql.toString());
        StringBuffer roleOql = new StringBuffer();
        roleOql.append("delete from t_pm_userroleorg where fuserid='").append(userPK.toString()).append("' and forgid in(").append(orgIds).append(")");
        deleteSqlList.add(roleOql.toString());
        StringBuffer fieldOql = new StringBuffer();
        fieldOql.append("delete from T_PM_FIELDACCESS where fuserid='").append(userPK.toString()).append("' and forgid in(").append(orgIds).append(")");
        deleteSqlList.add(fieldOql.toString());
        List discreteTableList = this.getDiscreteTableList();
        for (int i = 0; i < discreteTableList.size(); ++i) {
            StringBuffer discreteOql = new StringBuffer();
            discreteOql.append("delete from ").append(discreteTableList.get(i).toString()).append(" where fuserid='").append(userPK.toString()).append("' and forgid in(").append(orgIds).append(")");
            deleteSqlList.add(discreteOql.toString());
        }
        return deleteSqlList;
    }

    private List getDiscreteTableList() {
        ArrayList<String> list = new ArrayList<String>();
        Collection discreteTableList = ConfigurationLoader.getInstance().getConfigurationInfo().getDiscretEntityTables().values();
        Iterator ite = discreteTableList.iterator();
        while (ite.hasNext()) {
            list.add(ite.next().toString());
        }
        return list;
    }

    private String getBatchOrgRangeLogDetail(Context ctx, List<String> userIdList, List<String> orgIdList, OrgRangeType orgRangeType) throws BOSException, EASBizException {
        int i;
        IUser iuser = UserFactory.getLocalInstance(ctx);
        IFullOrgUnit iorg = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        StringBuffer logContent = new StringBuffer("orgRangeType\u3010" + orgRangeType.toString() + "\u3011");
        logContent.append(" users\u3010");
        for (i = 0; i < userIdList.size(); ++i) {
            if (userIdList.get(i) == null) continue;
            UserInfo info = iuser.getUserInfo((IObjectPK)new ObjectStringPK(userIdList.get(i).toString()));
            logContent.append(info.getName() + "(" + info.getNumber() + ")");
            if (i >= userIdList.size() - 1) continue;
            logContent.append(",");
        }
        logContent.append("\u3011 orgs\u3010");
        for (i = 0; i < orgIdList.size(); ++i) {
            if (orgIdList.get(i) == null) continue;
            FullOrgUnitInfo orgInfo = iorg.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgIdList.get(i).toString()));
            logContent.append(orgInfo.getName() + "(" + orgInfo.getNumber() + ")");
            if (i >= orgIdList.size() - 1) continue;
            logContent.append(",");
        }
        logContent.append("\u3011");
        return logContent.toString();
    }
}

