/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.OrgRangeHelper;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgCollection;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgInfo;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeParam;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermCacheFacadeFactory;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.app.AbstractOrgRangeIncludeSubOrgControllerBean;
import com.kingdee.eas.base.permission.app.helper.OrgRangeAppHelper;
import com.kingdee.eas.base.permission.util.CacheUtil;
import com.kingdee.eas.base.permission.util.LogProxy;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.framework.util.FMQuerySqlBuilder;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.app.OrgAppUtils;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OrgRangeIncludeSubOrgControllerBean
extends AbstractOrgRangeIncludeSubOrgControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.OrgRangeIncludeSubOrgControllerBean");
    static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    @Override
    protected void _updateOrgRange(Context ctx, String userID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)userID)) {
            return;
        }
        String strSql = "Select T2.FLongNumber FLongNumber From T_PM_OrgRangeIncludeSubOrg T1 Left Join T_ORG_Admin T2 On T1.FOrgID = T2.FID Where T1.FUserID = '" + userID + "' And T1.FIsIncludeSubOrg = 1";
        StringBuffer whereSql = new StringBuffer();
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)strSql);
        try {
            while (rowset.next()) {
                String longNumber = rowset.getString("FLongNumber");
                if (whereSql.length() != 0) {
                    whereSql.append(" or ");
                }
                whereSql.append("FLongNumber like '" + longNumber + "!%' ");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
        }
        if (whereSql.toString().length() != 0) {
            String deleteSql = "Delete from T_PM_OrgRange  Where FUserID = '" + userID + "'  And FType = " + 20;
            DbUtil.execute((Context)ctx, (String)deleteSql);
            String insertSql = "Insert Into T_PM_OrgRange (FID, FUserID, FOrgID, FType) (select newbosid('FD3DC16D'),FUserID,FOrgID,FType from (Select '" + userID + "' as FUserID,FID as FOrgID," + 20 + " as FType From T_ORG_Admin Where " + whereSql.toString() + " Union  Select FUserID, FOrgID, FType From T_PM_OrgRangeIncludeSubOrg  Where FUserID = '" + userID + "'  And FType = " + 20 + ") range)";
            DbUtil.execute((Context)ctx, (String)insertSql);
        }
        PermCacheFacadeFactory.getLocalInstance(ctx).removeOrgPermCacheByUser(userID);
    }

    @Override
    protected void _updateAdminOrgRange(Context ctx, List userIDList) throws BOSException, EASBizException {
        String strSql = "Select FID,FPersonId From T_PM_User  Where FID in (" + ToolUtils.aryToStr(userIDList) + ")  And FPersonId Is Not Null";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)strSql.toString());
        try {
            while (rowset.next()) {
                String personId = rowset.getString("FPersonId");
                String userId = rowset.getString("FID");
                if (StringUtils.isEmpty((String)personId)) continue;
                PositionCollection postionCol = PersonFactory.getLocalInstance((Context)ctx).getPositions(BOSUuid.read((String)personId));
                for (int orgIndex = 0; orgIndex < postionCol.size(); ++orgIndex) {
                    PositionInfo positionInfo = postionCol.get(orgIndex);
                    this.updateAdminOrg(ctx, userId, positionInfo.getAdminOrgUnit().getId().toString(), positionInfo.isIsRespPosition());
                }
                PermCacheFacadeFactory.getLocalInstance(ctx).removeOrgPermCacheByUser(userId);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void updateAdminOrg(Context ctx, String userId, String orgId, boolean includsuborg) throws BOSException, EASBizException {
        OrgRangeIncludeSubOrgInfo orgRangeIncludeSubOrgInfo = this.getOrgRangeIncludeSubOrgInfo(ctx, userId, orgId);
        if (orgRangeIncludeSubOrgInfo == null) {
            ArrayList<String> orgIdCol = new ArrayList<String>();
            orgIdCol.add(orgId);
            this._saveOrgRange(ctx, new OrgRangeParam((IObjectPK)new ObjectStringPK(userId), OrgRangeType.ADMIN_ORG_TYPE, null, orgIdCol, null));
            if (!includsuborg) {
                return;
            }
            orgRangeIncludeSubOrgInfo = this.getOrgRangeIncludeSubOrgInfo(ctx, userId, orgId);
        }
        if (orgRangeIncludeSubOrgInfo != null) {
            if (includsuborg) {
                orgRangeIncludeSubOrgInfo.setIsIncludeSubOrg(includsuborg);
                this._saveOrgRange(ctx, new OrgRangeParam((IObjectPK)new ObjectStringPK(userId), OrgRangeType.ADMIN_ORG_TYPE, null, new ArrayList(), orgRangeIncludeSubOrgInfo));
            } else {
                logger.error((Object)("user orgrange is exists org , not sysnc deal! userId=" + userId + ",orgId=" + orgId));
            }
        }
    }

    private OrgRangeIncludeSubOrgInfo getOrgRangeIncludeSubOrgInfo(Context ctx, String userId, String orgId) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("id");
        select.add("org.id");
        select.add("org.longNumber");
        select.add("user.id");
        select.add("type");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)userId));
        filterInfo.getFilterItems().add(new FilterItemInfo("org.id", (Object)orgId));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)OrgRangeType.ADMIN_ORG_TYPE.getValue()));
        entityViewInfo.setSelector(select);
        entityViewInfo.setFilter(filterInfo);
        OrgRangeIncludeSubOrgCollection coll = this.getOrgRangeIncludeSubOrgCollection(ctx, entityViewInfo);
        if (coll != null && !coll.isEmpty()) {
            return coll.get(0);
        }
        return null;
    }

    @Override
    protected void _reCreateAdminOrgRange(Context ctx, List personIDList) throws BOSException, EASBizException {
        String strSql = "Select FID,FPersonId From T_PM_User  Where FPersonId in (" + ToolUtils.aryToStr(personIDList) + ") ";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)strSql);
        try {
            while (rowset.next()) {
                String personId = rowset.getString("FPersonId");
                String userId = rowset.getString("FID");
                if (StringUtils.isEmpty((String)personId)) continue;
                String deleteSql = "Delete From T_PM_OrgRangeIncludeSubOrg  Where FUserId = '" + userId + "'  And FType = " + 20 + ";";
                DbUtil.execute((Context)ctx, (String)deleteSql);
                PositionCollection postionCol = PersonFactory.getLocalInstance((Context)ctx).getPositions(BOSUuid.read((String)personId));
                for (int orgIndex = 0; orgIndex < postionCol.size(); ++orgIndex) {
                    String orgId;
                    String insertSql = null;
                    PositionInfo positionInfo = postionCol.get(orgIndex);
                    if (positionInfo.isIsRespPosition()) {
                        orgId = postionCol.get(orgIndex).getAdminOrgUnit().getId().toString();
                        insertSql = "Insert Into T_PM_OrgRangeIncludeSubOrg (FID, FUserID, FOrgID, FType,FIsIncludeSubOrg) Values( newbosid('4DC3DADF'),'" + userId + "','" + orgId + "'," + 20 + ",1);";
                    } else {
                        orgId = postionCol.get(orgIndex).getAdminOrgUnit().getId().toString();
                        insertSql = "Insert Into T_PM_OrgRangeIncludeSubOrg (FID, FUserID, FOrgID, FType) Values( newbosid('4DC3DADF'),'" + userId + "','" + orgId + "'," + 20 + ");";
                    }
                    DbUtil.execute((Context)ctx, (String)insertSql);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    protected void _initSubOrgByOldUserOrgRange(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        String sql;
        int subOrgCount;
        if (userPK == null) {
            // empty if block
        }
        if ((subOrgCount = this.getSqlDataCount(ctx, sql = " select count(fid) from T_PM_OrgRangeIncludeSubOrg where FUserID ='" + userPK.toString() + "'")) != 0) {
            return;
        }
        String orgRangeSql = " select count(fid) from T_PM_OrgRange where FUserID ='" + userPK.toString() + "'";
        int orgRangeCount = this.getSqlDataCount(ctx, orgRangeSql);
        if (orgRangeCount != 0 && subOrgCount == 0) {
            String initSql = "insert into T_PM_OrgRangeIncludeSubOrg(fid,fuserid,forgid,ftype,FIsIncludeSubOrg) select newbosid('4DC3DADF'),fuserid,forgid,ftype,0 from t_pm_orgrange where fuserid = '" + userPK + "'";
            DbUtil.execute((Context)ctx, (String)initSql);
        }
    }

    private int getSqlDataCount(Context ctx, String sql) throws BOSException {
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            int retCount = 0;
            if (rowset.next()) {
                retCount = rowset.getInt(1);
            }
            return retCount;
        }
        catch (SQLException se) {
            logger.info((Object)"sql exception ,", (Throwable)se);
            throw new BOSException((Throwable)se);
        }
    }

    @Override
    protected void _addAdminOrgToOrgRange(Context ctx, IObjectValue adminOrg) throws BOSException, EASBizException {
        AdminOrgUnitInfo adminOrgInfo = (AdminOrgUnitInfo)adminOrg;
        String longNumber = adminOrgInfo.getLongNumber();
        List userList = this.getAncesterOrgRangeIncludeSubOrgUserList(ctx, longNumber);
        ArrayList<String> orgIdList = new ArrayList<String>();
        orgIdList.add(adminOrgInfo.getId().toString());
        this.addOrgRange(ctx, userList, orgIdList);
    }

    @Override
    protected void _changeAdminOrgToOrgRange(Context ctx, IObjectValue newAdminOrg, String oldLongNumber) throws BOSException, EASBizException {
        AdminOrgUnitInfo adminOrgInfo = (AdminOrgUnitInfo)newAdminOrg;
        if (oldLongNumber.equals(adminOrgInfo.getLongNumber())) {
            return;
        }
        List oldUserList = this.getAncesterOrgRangeIncludeSubOrgUserList(ctx, oldLongNumber);
        List subOrgList = this.getSubOrgIdList(ctx, adminOrgInfo.getLongNumber());
        this.deleteOrgRange(ctx, oldUserList, subOrgList);
        this.deleteHaveOrgRangeIncludeSubOrg(ctx, adminOrgInfo.getLongNumber(), subOrgList);
        List newUserList = this.getAncesterOrgRangeIncludeSubOrgUserList(ctx, adminOrgInfo.getLongNumber());
        this.addOrgRange(ctx, newUserList, subOrgList);
        String BOSBAS001 = ParamManager.getParamValue((Context)ctx, null, (String)"BOSBAS_001");
        if (!Boolean.TRUE.toString().equalsIgnoreCase(BOSBAS001)) {
            oldUserList.removeAll(newUserList);
            if (!oldUserList.isEmpty()) {
                this.addOldSubOrgToNewSubOrg(ctx, oldUserList, adminOrgInfo.getId().toString(), subOrgList);
                this.addOrgRange(ctx, oldUserList, subOrgList);
            }
        }
    }

    private void deleteHaveOrgRangeIncludeSubOrg(Context ctx, String longNumber, List subOrgList) throws BOSException, EASBizException {
        String[] ancesters = OrgAppUtils.getAncestor((String)longNumber);
        StringBuffer oql = new StringBuffer();
        oql.append("select distinct fuserid from t_pm_orgrangeincludesuborg t1 join t_org_admin t2 on t1.forgid=t2.fid ").append(" where t1.fisincludesuborg=1 and t1.ftype = ").append(20).append(" and t2.flongnumber in (").append(ToolUtils.aryToStr(ancesters)).append(")").append(" and t2.flongnumber not like '").append(longNumber).append("%'");
        StringBuffer oql2 = new StringBuffer();
        oql2.append("select distinct fuserid from t_pm_orgrangeincludesuborg t1 join t_org_admin t2 on t1.forgid=t2.fid ").append(" where t1.ftype = ").append(20).append(" and t2.flongnumber like '").append(longNumber).append("%'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)oql2.toString());
        ArrayList<String> fuseridList = new ArrayList<String>();
        ArrayList<String> fuseridList2 = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                fuseridList.add(rowSet.getString(1));
            }
            while (rowSet2.next()) {
                fuseridList2.add(rowSet2.getString(1));
            }
            fuseridList.retainAll(fuseridList2);
            if (!fuseridList.isEmpty()) {
                String sql = "delete from t_pm_orgrangeincludesuborg where fuserid in (" + ToolUtils.aryToStr(fuseridList.toArray()) + ") and forgid in (" + ToolUtils.aryToStr(subOrgList) + ")";
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getAncesterOrgRangeIncludeSubOrgUserList", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addOldSubOrgToNewSubOrg(Context ctx, List userList, String adminOrgId, List orgIdList) throws BOSException, EASBizException {
        PreparedStatement state;
        Connection con;
        block6: {
            TableManager tm = null;
            String tableName = null;
            con = null;
            state = null;
            try {
                con = this.getConnection(ctx);
                tm = TableManager.getTableManager((Context)ctx);
                tableName = tm.getTableName("addorgrangeincludesuborg");
                String createSql = "create table " + tableName + " (fuserid varchar(44))";
                tm.createTable(createSql, con);
                StringBuffer insertOql = new StringBuffer();
                insertOql.append("insert into " + tableName + "(fuserid) values(?)");
                state = con.prepareStatement(insertOql.toString());
                for (int i = 0; i < userList.size(); ++i) {
                    state.setString(1, userList.get(i).toString());
                    state.addBatch();
                }
                state.executeBatch();
                String transferSql = "insert into t_pm_orgrangeincludesuborg(fid,fuserid,forgid,ftype,FISINCLUDESUBORG)  select newbosid('4DC3DADF'),fuserid,'" + adminOrgId + "'," + 20 + ",1 from " + tableName + " t where not exists(select 1 from t_pm_orgrangeincludesuborg where fuserid=t.fuserid and forgid='" + adminOrgId + "' and FISINCLUDESUBORG=1 and ftype=" + 20 + ")";
                DbUtil.execute((Context)ctx, (String)transferSql);
                if (tm == null || tableName == null) break block6;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"add org range error", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tm != null && tableName != null) {
                        tm.releaseTable(tableName);
                    }
                    SQLUtils.cleanup(state, (Connection)con);
                    throw throwable;
                }
            }
            tm.releaseTable(tableName);
        }
        SQLUtils.cleanup((Statement)state, (Connection)con);
    }

    private void changeAdminOrgToOrgRange(Context ctx, IObjectValue newAdminOrg) throws BOSException {
        ArrayList<String[]> paramList;
        AdminOrgUnitInfo adminOrgInfo = (AdminOrgUnitInfo)newAdminOrg;
        String adminID = adminOrgInfo.getId().toString();
        String adminLongNumber = adminOrgInfo.getLongNumber();
        String orgChildSql = "select fid from t_org_admin where flongNumber like '" + adminLongNumber + "!%'";
        ArrayList<String> lsChildren = new ArrayList<String>();
        String deleteOql = "delete from t_pm_orgrange where forgid=? and ftype=20";
        String notDelUserListSql = "select distinct fuserid from t_pm_orgrangeincludesuborg t1 inner join t_org_admin t2 on t1.forgid=t2.fid  where t1.ftype = 20 and t2.flongNumber  like '" + adminLongNumber + "%'";
        String insertSql = "insert into t_pm_orgrange(fid,fuserid,forgid,ftype) select newbosid('FD3DC16D'),fuserid,forgid,20 from T_PM_OrgRangeIncludeSubOrg orgSub where orgSub.Ftype = 20 and orgSub.forgid = '" + adminID + "' and fisincludesuborg = 0";
        try {
            IRowSet result0 = DbUtil.executeQuery((Context)ctx, (String)notDelUserListSql.toString());
            ArrayList<String> paramList0 = new ArrayList<String>();
            while (result0.next()) {
                paramList0.add(result0.getString("fuserid"));
            }
            if (paramList0 != null && !paramList0.isEmpty()) {
                deleteOql = deleteOql + " and fuserid not in(" + ToolUtils.aryToStr(paramList0.toArray()) + ")";
            }
            paramList = new ArrayList<String[]>();
            paramList.add(new String[]{adminID});
            IRowSet result1 = DbUtil.executeQuery((Context)ctx, (String)orgChildSql.toString());
            while (result1.next()) {
                String fChildId = result1.getString("fid");
                lsChildren.add(fChildId);
                paramList.add(new String[]{fChildId});
            }
            DbUtil.executeBatch((Context)ctx, (String)deleteOql, paramList);
            DbUtil.execute((Context)ctx, (String)insertSql);
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        String orgParentSql = "select fid from t_org_admin where fnumber in (" + ToolUtils.aryToStr(OrgAppUtils.getAncestor((String)adminLongNumber)) + ")";
        String insSql = "insert into t_pm_orgrange(fid,fuserid,forgid,ftype) select newbosid('FD3DC16D'),fuserid, ? ,20 from T_PM_OrgRangeIncludeSubOrg orgSub where orgSub.Ftype = 20 and orgSub.forgid = ? and orgSub.FisIncludesubOrg = 1";
        try {
            paramList = new ArrayList();
            IRowSet result2 = DbUtil.executeQuery((Context)ctx, (String)orgParentSql.toString());
            while (result2.next()) {
                String fParentId = result2.getString("fid");
                paramList.add(new String[]{adminID, fParentId});
                for (String strChildId : lsChildren) {
                    paramList.add(new String[]{strChildId, fParentId});
                }
            }
            DbUtil.executeBatch((Context)ctx, (String)insSql, paramList);
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private List getAncesterOrgRangeIncludeSubOrgUserList(Context ctx, String longNumber) throws BOSException, EASBizException {
        String[] ancesters = OrgAppUtils.getAncestor((String)longNumber);
        if (ancesters.length > 0) {
            ancesters = Arrays.copyOf(ancesters, ancesters.length - 1);
        }
        StringBuffer oql = new StringBuffer();
        oql.append("select distinct fuserid from t_pm_orgrangeincludesuborg t1 join t_org_admin t2 on t1.forgid=t2.fid ").append(" where t1.fisincludesuborg=1 and t1.ftype = ").append(20).append(" and t2.flongnumber in (").append(ToolUtils.aryToStr(ancesters)).append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        ArrayList<String> userList = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                userList.add(rowSet.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getAncesterOrgRangeIncludeSubOrgUserList", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return userList;
    }

    private void deleteOrgRange(Context ctx, List userList, List orgIdList) throws BOSException, EASBizException {
        String deleteOql = "delete from t_pm_orgrange where fuserid=? and forgid=? and ftype=20";
        Connection con = null;
        PreparedStatement state = null;
        try {
            con = this.getConnection(ctx);
            state = con.prepareStatement(deleteOql);
            for (int i = userList.size() - 1; i >= 0; --i) {
                for (int j = orgIdList.size() - 1; j >= 0; --j) {
                    state.setString(1, userList.get(i).toString());
                    state.setString(2, orgIdList.get(j).toString());
                    state.addBatch();
                }
            }
            state.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"delete error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(state, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)state, (Connection)con);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addOrgRange(Context ctx, List userList, List orgIdList) throws BOSException, EASBizException {
        PreparedStatement state;
        Connection con;
        block7: {
            TableManager tm = null;
            String tableName = null;
            con = null;
            state = null;
            try {
                con = this.getConnection(ctx);
                tm = TableManager.getTableManager((Context)ctx);
                tableName = tm.getTableName("addorgrange");
                String createSql = "create table " + tableName + " (fuserid varchar(44),forgid varchar(44))";
                tm.createTable(createSql);
                StringBuffer insertOql = new StringBuffer();
                insertOql.append("insert into " + tableName + "(fuserid,forgid) values(?,?)");
                state = con.prepareStatement(insertOql.toString());
                for (int i = 0; i < userList.size(); ++i) {
                    for (int j = 0; j < orgIdList.size(); ++j) {
                        state.setString(1, userList.get(i).toString());
                        state.setString(2, orgIdList.get(j).toString());
                        state.addBatch();
                    }
                }
                state.executeBatch();
                String transferSql = "insert into t_pm_orgrange(fid,fuserid,forgid,ftype)  select newbosid('FD3DC16D'),fuserid,forgid,20 from " + tableName + " t where not exists(select 1 from t_pm_orgrange where fuserid=t.fuserid and forgid=t.forgid and ftype=" + 20 + ")";
                DbUtil.execute((Context)ctx, (String)transferSql);
                if (tm == null || tableName == null) break block7;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"add org range error", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tm != null && tableName != null) {
                        tm.releaseTable(tableName);
                    }
                    SQLUtils.cleanup(state, (Connection)con);
                    throw throwable;
                }
            }
            tm.releaseTable(tableName);
        }
        SQLUtils.cleanup((Statement)state, (Connection)con);
    }

    private List getSubOrgIdList(Context ctx, String longNumber) throws BOSException, EASBizException {
        ArrayList<String> orgList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT distinct base.FID FROM T_ORG_STRUCTURE st LEFT OUTER JOIN T_ORG_BASEUNIT base on st.FUNITID = base.FID where base.FISADMINORGUNIT = 1 and st.FLONGNUMBER LIKE '").append(longNumber).append("%'");
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (result.next()) {
                orgList.add(result.getString("fid"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"get sub orgId list error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return orgList;
    }

    @Override
    protected Set _getOrgIdsByUserAndType(Context ctx, IObjectPK userPK, OrgRangeType orgRangeType) throws BOSException, EASBizException {
        HashSet<String> ret = new HashSet<String>();
        String oql = "select org.id where user.id='" + userPK.toString() + "' and type=" + orgRangeType.getValue();
        OrgRangeIncludeSubOrgCollection orgRangeCol = this.getOrgRangeIncludeSubOrgCollection(ctx, oql);
        for (int i = 0; i < orgRangeCol.size(); ++i) {
            ret.add(orgRangeCol.get(i).getOrg().getId().toString());
        }
        return ret;
    }

    @Override
    protected void _saveOrgRange(Context ctx, OrgRangeParam orgRangeParam) throws BOSException, EASBizException {
        long begin = System.currentTimeMillis();
        LogProxy logProxy = new LogProxy();
        this.beginLog(ctx, logProxy, orgRangeParam);
        logger.error((Object)("beginLog:cost :" + (System.currentTimeMillis() - begin)));
        Collection deletedOrgs = orgRangeParam.getDeletedOrgIds();
        Collection addedOrgs = orgRangeParam.getAddedOrgIds();
        OrgRangeIncludeSubOrgInfo changedOrgRange = orgRangeParam.getChangedOrgRangeIncludeSubOrg();
        boolean isDeleteAll = orgRangeParam.isDeleteAll();
        IObjectPK userPK = orgRangeParam.getUserPK();
        UserInfo userInfo = CacheUtil.getCacheUserInfo(ctx, userPK.toString());
        OrgRangeType orgRangeType = orgRangeParam.getOrgRangeType();
        if (isDeleteAll) {
            this.deleteAllByUserAndType(ctx, userPK, orgRangeType);
        }
        if (deletedOrgs != null && deletedOrgs.size() > 0) {
            Object manager = null;
            String tableName = null;
            try {
                if (deletedOrgs.size() > 500) {
                    tableName = this.createTempTable(ctx, deletedOrgs);
                    begin = System.currentTimeMillis();
                    String idsql = " select fid from " + tableName;
                    this.deleteOrgRanges(ctx, userPK, orgRangeType, idsql);
                    logger.error((Object)("deleteOrgRanges__\u4e34\u65f6\u8868 cost\uff1a" + (System.currentTimeMillis() - begin)));
                    begin = System.currentTimeMillis();
                    this.deleteOrgRangeIncludeSubOrgs(ctx, userPK, orgRangeType, idsql);
                    logger.error((Object)("deleteOrgRangeIncludeSubOrgs_\u4e34\u65f6\u8868 cost\uff1a" + (System.currentTimeMillis() - begin)));
                } else {
                    begin = System.currentTimeMillis();
                    this.deleteOrgRanges(ctx, userPK, orgRangeType, deletedOrgs);
                    logger.error((Object)("deleteOrgRanges_collection cost\uff1a" + (System.currentTimeMillis() - begin)));
                    begin = System.currentTimeMillis();
                    this.deleteOrgRangeIncludeSubOrgs(ctx, userPK, orgRangeType, deletedOrgs);
                    logger.error((Object)("deleteOrgRangeIncludeSubOrgs_collection cost\uff1a" + (System.currentTimeMillis() - begin)));
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                if (manager != null && tableName != null) {
                    manager.releaseTable(tableName);
                }
            }
        }
        if (addedOrgs != null && addedOrgs.size() > 0) {
            String strParam;
            if (OrgRangeType.ADMIN_ORG_TYPE.equals((Object)orgRangeType)) {
                addedOrgs = this.getNotIncludedOrgIds(ctx, userPK, addedOrgs);
            }
            boolean isAndSubOrg = "true".equals(strParam = ParamManager.getParamValue((Context)ctx, null, (String)"AddUserOrgRangeIncludeSubOrg")) && OrgRangeType.ADMIN_ORG_TYPE.equals((Object)orgRangeType) && !orgRangeParam.isImport();
            begin = System.currentTimeMillis();
            int isIncludeSubOrgType = isAndSubOrg ? 1 : 0;
            this.saveAddOrgs(ctx, userPK, orgRangeType, addedOrgs, isIncludeSubOrgType);
            logger.error((Object)("saveAddOrgs cost\uff1a" + (System.currentTimeMillis() - begin)));
            System.out.println("saveAddOrgs cost\uff1a" + (System.currentTimeMillis() - begin));
            if (isAndSubOrg) {
                OrgRangeHelper.updateAdminOrgRange(ctx, userPK.toString());
            }
        }
        if (changedOrgRange != null) {
            if (changedOrgRange.getId() == null) {
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                SelectorItemCollection select = new SelectorItemCollection();
                select.add("id");
                select.add("org.longNumber");
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)changedOrgRange.getUser().getId().toString()));
                filterInfo.getFilterItems().add(new FilterItemInfo("org.id", (Object)changedOrgRange.getOrg().getId().toString()));
                filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)changedOrgRange.getType().getValue()));
                entityViewInfo.setSelector(select);
                entityViewInfo.setFilter(filterInfo);
                OrgRangeIncludeSubOrgCollection coll = this.getOrgRangeIncludeSubOrgCollection(ctx, entityViewInfo);
                if (coll != null && !coll.isEmpty()) {
                    changedOrgRange.setId(coll.get(0).getId());
                    if (StringUtils.isEmpty((String)changedOrgRange.getOrg().getLongNumber())) {
                        changedOrgRange.getOrg().setLongNumber(coll.get(0).getOrg().getLongNumber());
                    }
                } else {
                    Locale l = ContextUtils.getLocaleFromEnv();
                    throw new BOSException(EASCommonResource.getString((String)RESOURCE, (String)"INCLUDE_SUBORG_ABSENT", (Locale)l));
                }
            }
            this.handleChangeIncludeSubOrg(ctx, changedOrgRange);
        } else {
            String findSubOrg = "select admin1.flongnumber longnumber,subOrg.FID fid from T_PM_OrgRangeIncludeSubOrg subOrg inner join t_org_admin admin1 on subOrg.forgid = admin1.fid where subOrg.ftype=20 and subOrg.FISINCLUDESUBORG =1 and fuserid= ? order by longnumber asc";
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)findSubOrg, (Object[])new Object[]{userPK.toString()});
            HashSet<String> notSubSet = new HashSet<String>();
            try {
                while (rowset.next()) {
                    String longnumber = rowset.getString("longnumber");
                    longnumber = longnumber + "!%";
                    String rangeIncludeId = rowset.getString("fid");
                    String isNotEqualsSql = "select count(1) flagNumber from (SELECT count(1) NUM1 FROM t_pm_orgrange range  left join t_org_admin ad  on range.FORGID = ad.FID   where FUSERID = ?  and range.ftype = 20 and ad.flongnumber LIKE ? ) NUMTable where  NUMTable.NUM1 != ( SELECT count(1)  FROM  t_org_admin where flongnumber LIKE ? )";
                    IRowSet rowset1 = DbUtil.executeQuery((Context)ctx, (String)isNotEqualsSql, (Object[])new Object[]{userPK.toString(), longnumber, longnumber});
                    rowset1.next();
                    Integer flagNumber = rowset1.getInt("flagNumber");
                    if (flagNumber <= 0) continue;
                    notSubSet.add(rangeIncludeId);
                    String rangOrgSql = "SELECT range.FORGID rangeOrgId  FROM t_pm_orgrange range  left join t_org_admin ad  on range.FORGID = ad.FID   where FUSERID = ? and range.ftype = 20 and ad.flongnumber LIKE ?  and range.FORGID not in (SELECT range.FOrgId subOrgId  FROM T_PM_OrgRangeIncludeSubOrg range where FUSERID = ? and range.ftype = 20  )";
                    IRowSet rowset2 = DbUtil.executeQuery((Context)ctx, (String)rangOrgSql, (Object[])new Object[]{userPK.toString(), longnumber, userPK.toString()});
                    while (rowset2.next()) {
                        String rangeOrgId = rowset2.getString("rangeOrgId");
                        String insertSql = "Insert Into T_PM_OrgRangeIncludeSubOrg (FID, FUserID, FOrgID, FType,FISINCLUDESUBORG) Values( newbosid('4DC3DADF'),'" + userPK + "','" + rangeOrgId + "'," + 20 + ",0);";
                        DbUtil.execute((Context)ctx, (String)insertSql);
                    }
                }
                if (notSubSet.size() > 0) {
                    FMQuerySqlBuilder sbs = new FMQuerySqlBuilder();
                    sbs.appendSql("update T_PM_OrgRangeIncludeSubOrg set FISINCLUDESUBORG = 0 ");
                    sbs.appendSql("  where FID in (");
                    sbs.appendParam(notSubSet.toArray());
                    sbs.appendSql(" ) ");
                    sbs.execute(ctx);
                }
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
                throw new BOSException((Throwable)throwables);
            }
        }
        if (this.isSystemOrgRange(orgRangeType, userInfo) || OrgRangeType.MANAGE_ORG_TYPE.equals((Object)orgRangeType)) {
            this.deleteOrgRangeSolutionEntry(ctx, userInfo, deletedOrgs);
        }
        PermCacheFacadeFactory.getLocalInstance(ctx).removeOrgPermCacheByUser(userPK.toString());
        this.updateUserInfo(ctx, userInfo.getId().toString());
        logProxy.end();
    }

    /*
     * Loose catch block
     */
    private String createTempTable(Context ctx, Collection deletedOrgs) throws BOSException {
        long begin = System.currentTimeMillis();
        ArrayList list = (ArrayList)deletedOrgs;
        Connection conn = null;
        String tableName = null;
        TableManager tableManager = null;
        try {
            tableManager = TableManager.getTableManager((Context)ctx);
            tableName = tableManager.getTableName("vt_delorgrange");
            StringBuffer createTable = new StringBuffer();
            createTable.append("CREATE TABLE ").append(tableName).append("(").append("fid varchar(44) PRIMARY KEY").append(")");
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("INSERT INTO ").append(tableName).append(" (fid ) VALUES(?)");
            tableManager.createTable(createTable.toString());
            conn = this.getConnection(ctx);
            PreparedStatement ps = conn.prepareStatement(insertSql.toString());
            int batchSize = 1000;
            Iterator iterator = deletedOrgs.iterator();
            int count = 0;
            while (iterator.hasNext()) {
                String id = iterator.next().toString();
                ps.setString(1, id);
                ps.addBatch();
                if (++count % batchSize != 0) continue;
                ps.executeBatch();
            }
            ps.executeBatch();
            SQLUtils.cleanup((Connection)conn);
        }
        catch (SQLException e) {
            logger.error((Object)"\u521b\u5efa\u4e34\u65f6\u8868\u5931\u8d25\uff01");
        }
        catch (Exception e2) {
            logger.error((Object)"\u521b\u5efa\u4e34\u65f6\u8868\u5931\u8d25\uff01");
            throw new BOSException((Throwable)e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            SQLUtils.cleanup(conn);
        }
        logger.error((Object)("\u521b\u5efa\u4e34\u65f6\u8868 cost" + (System.currentTimeMillis() - begin)));
        return tableName;
    }

    private void saveAddOrgs(Context ctx, IObjectPK userPK, OrgRangeType orgRangeType, Collection addedOrgs, int isIncludeSubOrgType) throws BOSException {
        TableManager tm = null;
        String tableName = null;
        try {
            tm = TableManager.getTableManager((Context)ctx);
            tableName = tm.getTableName("orgRangeAdd");
            String createSql = "create table " + tableName + " (fuserid varchar(44),forgid varchar(44),ftype int)";
            tm.createTable(createSql);
            long begin = System.currentTimeMillis();
            this.insertIntoTempTable(ctx, userPK, addedOrgs, orgRangeType, tableName);
            logger.error((Object)("\u4fdd\u5b58 orgrange insert temptable cost:" + (System.currentTimeMillis() - begin)));
            begin = System.currentTimeMillis();
            this.addOrgRangeBatch(ctx, userPK, orgRangeType, addedOrgs, tableName);
            logger.error((Object)("addOrgRangeBatch cost:" + (System.currentTimeMillis() - begin)));
            begin = System.currentTimeMillis();
            this.addOrgRangeIncludeSubOrgBatch(ctx, tableName, isIncludeSubOrgType);
            logger.error((Object)("addOrgRangeIncludeSubOrgBatch cost:" + (System.currentTimeMillis() - begin)));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tm != null && tableName != null) {
                tm.releaseTable(tableName);
            }
        }
    }

    private void insertIntoTempTable(Context ctx, IObjectPK userPK, Collection addedOrgs, OrgRangeType orgRangeType, String tableName) throws BOSException {
        Connection conn = this.getConnection(ctx);
        PreparedStatement state = null;
        try {
            String insertSql = "insert into " + tableName + "( fuserid,forgid,ftype) values(?,?,?)";
            state = conn.prepareStatement(insertSql);
            Iterator orgItr = addedOrgs.iterator();
            int i = 0;
            while (orgItr.hasNext()) {
                state.setString(1, userPK.toString());
                state.setString(2, orgItr.next().toString());
                state.setInt(3, orgRangeType.getValue());
                state.addBatch();
                if (i % 2000 == 0) {
                    state.executeBatch();
                }
                ++i;
            }
            state.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(state, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)state, (Connection)conn);
    }

    private void beginLog(Context ctx, LogProxy logProxy, OrgRangeParam orgRangeParam) throws BOSException, EASBizException {
        Locale l = ContextUtils.getLocaleFromEnv();
        String methodName = EASCommonResource.getString((String)RESOURCE, (String)"OrgRangeDeal", (Locale)l);
        BOSObjectType bizObjType = new UserInfo().getBOSType();
        IObjectPK instancePK = orgRangeParam.getUserPK();
        StringBuffer detail = new StringBuffer();
        String add4Log = EASCommonResource.getString((String)RESOURCE, (String)"add4Log", (Locale)l);
        String del4Log = EASCommonResource.getString((String)RESOURCE, (String)"del4Log", (Locale)l);
        String update4Log = EASCommonResource.getString((String)RESOURCE, (String)"update4Log", (Locale)l);
        String user = EASCommonResource.getString((String)RESOURCE, (String)"user", (Locale)l);
        String orgRangeType = EASCommonResource.getString((String)RESOURCE, (String)"OrgRangeType", (Locale)l);
        Collection deleteOrgIds = orgRangeParam.getDeletedOrgIds();
        Collection addOrgIds = orgRangeParam.getAddedOrgIds();
        OrgRangeIncludeSubOrgInfo changedOrgRange = orgRangeParam.getChangedOrgRangeIncludeSubOrg();
        IObjectPK userPK = orgRangeParam.getUserPK();
        UserInfo userInfo = CacheUtil.getCacheUserInfo(ctx, userPK.toString());
        String userNumber = userInfo.getNumber();
        detail.append(methodName + "\n");
        detail.append(user + ":" + userNumber + "\n");
        detail.append(orgRangeType + ":" + orgRangeParam.getOrgRangeType().getAlias() + "\n");
        if (deleteOrgIds != null && deleteOrgIds.size() > 0) {
            detail.append(del4Log + ":\n");
            detail.append(ToolUtils.aryToStr(this.getNumberColByOrgIdCol(ctx, deleteOrgIds))).append("\n");
        }
        if (addOrgIds != null && addOrgIds.size() > 0) {
            detail.append(add4Log + ":\n");
            detail.append(ToolUtils.aryToStr(this.getNumberColByOrgIdCol(ctx, addOrgIds))).append("\n");
        }
        if (changedOrgRange != null) {
            detail.append(update4Log + ":\n").append("id:" + changedOrgRange.getId() + "\n").append("change to include sub org:" + changedOrgRange.isIsIncludeSubOrg());
        }
        logProxy.beginLog(ctx, methodName, bizObjType, instancePK, detail.toString());
    }

    private Collection getNumberColByOrgIdCol(Context ctx, Collection idCol) throws BOSException, EASBizException {
        String ids = ToolUtils.aryToStr(idCol);
        String sql = "select fnumber from t_org_baseunit where fid in (" + ids + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> numberList = new ArrayList<String>();
        try {
            while (rs.next()) {
                numberList.add(rs.getString("fnumber"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return numberList;
    }

    private boolean isSystemOrgRange(OrgRangeType orgRangeType, UserInfo userInfo) {
        return Administrator.isAdminType(userInfo.getType()) && OrgRangeType.BIZ_ORG_TYPE.equals((Object)orgRangeType);
    }

    private void deleteAllByUserAndType(Context ctx, IObjectPK userPK, OrgRangeType orgRangeType) throws BOSException, EASBizException {
        String orgRangeDelete = "delete from t_pm_orgrange where fuserid='" + userPK.toString() + "' and ftype=" + orgRangeType.getValue();
        String orgRangeIncludeSubOrgDelete = "delete from t_pm_orgrangeincludesuborg where fuserid='" + userPK.toString() + "' and ftype=" + orgRangeType.getValue();
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            SQLUtils.execute((Connection)con, (String)orgRangeDelete);
            SQLUtils.execute((Connection)con, (String)orgRangeIncludeSubOrgDelete);
        }
        catch (SQLException e) {
            logger.error((Object)"deleteAllByUserAndType error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private void deleteOrgRanges(Context ctx, IObjectPK userPK, OrgRangeType orgRangeType, Collection deletedOrgs) throws BOSException, EASBizException {
        List includeSubOrgLongNumber;
        if (orgRangeType.equals((Object)OrgRangeType.ADMIN_ORG_TYPE) && (includeSubOrgLongNumber = this.getIncludeSubOrgAdminLongNumber(ctx, userPK, deletedOrgs)) != null && includeSubOrgLongNumber.size() > 0) {
            String sql = "delete from t_pm_orgrange where fuserid=? and FType = 20 and forgid in (select fid from t_org_admin where FLongNumber like ? )";
            PreparedStatement stmt = null;
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
                stmt = conn.prepareStatement(sql);
                for (int i = 0; i < includeSubOrgLongNumber.size(); ++i) {
                    stmt.setString(1, userPK.toString());
                    stmt.setString(2, includeSubOrgLongNumber.get(i).toString() + "!%");
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"deleteOrgRanges error", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
        String sql = "delete from t_pm_orgrange where fuserid='" + userPK.toString() + "' and ftype=" + orgRangeType.getValue() + " and forgid in (" + ToolUtils.aryToStr(deletedOrgs) + ")";
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            SQLUtils.execute((Connection)con, (String)sql);
        }
        catch (SQLException e) {
            logger.error((Object)"deleteOrgRanges error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private void deleteOrgRanges(Context ctx, IObjectPK userPK, OrgRangeType orgRangeType, String idsql) throws BOSException, EASBizException {
        List includeSubOrgLongNumber;
        if (orgRangeType.equals((Object)OrgRangeType.ADMIN_ORG_TYPE) && (includeSubOrgLongNumber = this.getIncludeSubOrgAdminLongNumber(ctx, userPK, idsql)) != null && includeSubOrgLongNumber.size() > 0) {
            String sql = "delete from t_pm_orgrange where fuserid=? and FType = 20 and forgid in (select fid from t_org_admin where FLongNumber like ? )";
            PreparedStatement stmt = null;
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
                stmt = conn.prepareStatement(sql);
                for (int i = 0; i < includeSubOrgLongNumber.size(); ++i) {
                    stmt.setString(1, userPK.toString());
                    stmt.setString(2, includeSubOrgLongNumber.get(i).toString() + "!%");
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"deleteOrgRanges error", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Delete FROM t_pm_orgrange where fuserid=? ").append(" and ftype=? ").append(" and forgid in (").append(idsql).append(")");
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = this.getConnection(ctx);
            statement = con.prepareStatement(sql.toString());
            statement.setString(1, userPK.toString());
            statement.setInt(2, orgRangeType.getValue());
            statement.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"deleteOrgRanges error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
    }

    private List getIncludeSubOrgAdminLongNumber(Context ctx, IObjectPK userPK, Collection orgIds) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select b.FLongNumber from t_pm_orgrangeincludesuborg a join t_org_admin b ").append(" on a.forgid=b.fid where a.fuserid=? and a.ftype=").append(20).append(" and fisIncludeSubOrg=1");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(StringUtils.cnulls((Object)userPK));
        if (orgIds != null && orgIds.size() > 0) {
            sql.append("and a.forgid in (");
            Iterator itr = orgIds.iterator();
            while (itr.hasNext()) {
                paramList.add(itr.next().toString());
                sql.append("?");
                if (!itr.hasNext()) continue;
                sql.append(",");
            }
            sql.append(")");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
        ArrayList<String> ret = new ArrayList<String>();
        try {
            while (rs.next()) {
                ret.add(rs.getString("FLongNumber"));
            }
        }
        catch (SQLException se) {
            logger.error((Object)"", (Throwable)se);
            throw new BOSException((Throwable)se);
        }
        return ret;
    }

    private List getIncludeSubOrgAdminLongNumber(Context ctx, IObjectPK userPK, String orgIdSql) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select b.FLongNumber from t_pm_orgrangeincludesuborg a join t_org_admin b ").append(" on a.forgid=b.fid where a.fuserid=? and a.ftype=").append(20).append(" and fisIncludeSubOrg=1").append(" and a.forgid in ( ").append(orgIdSql).append(")");
        Object[] params = new Object[]{userPK.toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        ArrayList<String> ret = new ArrayList<String>();
        try {
            while (rs.next()) {
                ret.add(rs.getString("FLongNumber"));
            }
        }
        catch (SQLException se) {
            logger.error((Object)"", (Throwable)se);
            throw new BOSException((Throwable)se);
        }
        return ret;
    }

    private Collection getNotIncludedOrgIds(Context ctx, IObjectPK userPK, Collection orgIds) throws BOSException, EASBizException {
        List includeSubOrgLongNumber = this.getIncludeSubOrgAdminLongNumber(ctx, userPK, Collections.emptyList());
        for (int i = 0; i < includeSubOrgLongNumber.size(); ++i) {
            Collection includedOrgIds = this.getIncludedOrgIds(ctx, includeSubOrgLongNumber.get(i).toString(), orgIds);
            orgIds.removeAll(includedOrgIds);
        }
        return orgIds;
    }

    private Collection getIncludedOrgIds(Context ctx, String longNumber, Collection orgIds) throws BOSException, EASBizException {
        ArrayList<String> includedOrgIds = new ArrayList<String>();
        if (orgIds == null || orgIds.size() < 1) {
            return includedOrgIds;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from t_org_admin where flongnumber like ? and fid in (");
        Iterator itr = orgIds.iterator();
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(longNumber + "!%");
        while (itr.hasNext()) {
            paramList.add(itr.next().toString());
            sql.append("?");
            if (!itr.hasNext()) continue;
            sql.append(",");
        }
        sql.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
        try {
            while (rs.next()) {
                includedOrgIds.add(rs.getString("fid"));
            }
        }
        catch (SQLException se) {
            logger.error((Object)"", (Throwable)se);
            throw new BOSException((Throwable)se);
        }
        return includedOrgIds;
    }

    private void deleteOrgRangeIncludeSubOrgs(Context ctx, IObjectPK userPK, OrgRangeType orgRangeType, Collection deletedOrgs) throws BOSException, EASBizException {
        String sql = "delete from t_pm_orgrangeincludesuborg where fuserid='" + userPK.toString() + "' and ftype=" + orgRangeType.getValue() + " and forgid in (" + ToolUtils.aryToStr(deletedOrgs) + ")";
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            SQLUtils.execute((Connection)con, (String)sql);
        }
        catch (SQLException e) {
            logger.error((Object)"deleteOrgRangeIncludeSubOrgs error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private void deleteOrgRangeIncludeSubOrgs(Context ctx, IObjectPK userPK, OrgRangeType orgRangeType, String idsql) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("delete from t_pm_orgrangeincludesuborg where fuserid=? and ftype=? and forgid in (").append(idsql).append(")");
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = this.getConnection(ctx);
            statement = con.prepareStatement(sb.toString());
            statement.setString(1, userPK.toString());
            statement.setInt(2, orgRangeType.getValue());
            statement.execute();
        }
        catch (SQLException e) {
            logger.error((Object)"deleteOrgRangeIncludeSubOrgs error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private void addOrgRangeBatch(Context ctx, IObjectPK userPK, OrgRangeType orgRangeType, Collection addedOrgs, String tmpTableName) throws BOSException, EASBizException {
        try {
            String bosType = new OrgRangeInfo().getBOSType().toString();
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO T_PM_OrgRange (FID, FUserID, FOrgID, FType) ").append("select newbosid('").append(bosType).append("'),fuserid,forgid,ftype from ").append(tmpTableName).append(" tmp where not exists ").append("(select 1 from t_pm_orgrange where fuserid=tmp.fuserid and forgid=tmp.forgid and ftype=tmp.ftype)");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            logger.error((Object)"addOrgRangeBatch error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void addOrgRangeIncludeSubOrgBatch(Context ctx, String tmpTableName, int isIncludeSubOrgType) throws BOSException, EASBizException {
        try {
            String bosType = new OrgRangeInfo().getBOSType().toString();
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO T_PM_OrgRangeIncludeSubOrg (FID, FUserID, FOrgID, FType,FIsIncludeSubOrg) ").append("select newbosid('").append(bosType).append("'),fuserid,forgid,ftype,? from ").append(tmpTableName).append(" tmp where not exists ").append("(select 1 from T_PM_OrgRangeIncludeSubOrg where fuserid=tmp.fuserid and forgid=tmp.forgid and ftype=tmp.ftype)");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{isIncludeSubOrgType});
        }
        catch (Exception e) {
            logger.error((Object)"addOrgRangeBatch error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void handleChangeIncludeSubOrg(Context ctx, OrgRangeIncludeSubOrgInfo orgRangeIncludeSubOrgInfo) throws BOSException, EASBizException {
        this.updateIsIncludeSubOrg(ctx, orgRangeIncludeSubOrgInfo);
        ObjectUuidPK userPK = new ObjectUuidPK(orgRangeIncludeSubOrgInfo.getUser().getId());
        if (orgRangeIncludeSubOrgInfo.isIsIncludeSubOrg()) {
            OrgRangeAppHelper.deleteSubOrgFromOrgRangeIncludeSub(ctx, orgRangeIncludeSubOrgInfo);
            this.deleteSubOrgFromOrgRange(ctx, (IObjectPK)userPK, orgRangeIncludeSubOrgInfo.getOrg().getLongNumber());
            this.addSubOrgToOrgRange(ctx, orgRangeIncludeSubOrgInfo);
        } else {
            this.deleteSubOrgFromOrgRange(ctx, (IObjectPK)userPK, orgRangeIncludeSubOrgInfo.getOrg().getLongNumber());
        }
    }

    private void updateIsIncludeSubOrg(Context ctx, OrgRangeIncludeSubOrgInfo orgRangeIncludeSubOrgInfo) throws BOSException, EASBizException {
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("isIncludeSubOrg"));
        this.updatePartial(ctx, orgRangeIncludeSubOrgInfo, selectorCol);
    }

    private void deleteSubOrgFromOrgRange(Context ctx, IObjectPK userPK, String longNumber) throws BOSException, EASBizException {
        String sql = "delete from t_pm_orgrange where fuserid=? and FType = 20 and forgid in (select fid from t_org_admin where FLongNumber like ? )";
        Object[] params = new Object[]{userPK.toString(), longNumber + "!%"};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    private void addSubOrgToOrgRange(Context ctx, OrgRangeIncludeSubOrgInfo orgRangeIncludeSubOrgInfo) throws BOSException, EASBizException {
        String insertSql = "insert into t_pm_orgrange(fid,ftype,fuserid,forgid) select newbosid('FD3DC16D')," + orgRangeIncludeSubOrgInfo.getType().getValue() + ",'" + orgRangeIncludeSubOrgInfo.getUser().getId().toString() + "',fid from t_org_admin where flongnumber like '" + orgRangeIncludeSubOrgInfo.getOrg().getLongNumber() + "!%'";
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            SQLUtils.execute((Connection)con, (String)insertSql);
        }
        catch (SQLException e) {
            logger.error((Object)"addSubOrgToOrgRange error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private void deleteOrgRangeSolutionEntry(Context ctx, UserInfo userInfo, Collection deleteCuIds) throws BOSException, EASBizException {
        if (userInfo.getType() != UserType.SYSTEM && !userInfo.isBizAdmin()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("delete  from T_PM_ORGRANGESOLUTIONENTRY where  forgrangesolutionid in ").append("(select a.fid from t_pm_orgrangesolution a ").append("join t_pm_user b on a.fcreatorid=b.fid where b.fid='").append(userInfo.getId().toString()).append("')").append(" and forgid in (select fid from t_org_baseunit where FControlUnitID in (").append(ToolUtils.aryToStr(deleteCuIds)).append("))");
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            SQLUtils.execute((Connection)con, (String)sql.toString());
        }
        catch (SQLException se) {
            logger.error((Object)se);
            throw new UserException(UserException.USER_SAVE_FAIL, se);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    @Override
    protected boolean _isIncludeBySuperOrgRange(Context ctx, IObjectPK userPK, String longNumber) throws BOSException, EASBizException {
        String[] ancesters = OrgAppUtils.getAncestor((String)longNumber);
        String sql = "select 1 from t_pm_orgrangeincludesuborg a join t_org_admin b on a.forgid=b.fid where a.fuserid='" + userPK + "' and a.ftype=" + 20 + " and FIsIncludeSubOrg=1  and b.flongnumber in (" + ToolUtils.aryToStr(ancesters) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private void updateUserInfo(Context ctx, String tragetUserID) throws BOSException, EASBizException {
        if (tragetUserID == null) {
            return;
        }
        Timestamp createtime = this.getTime();
        Object con = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_PM_USER set flastupdateuserid=? ,flastupdatetime=? where fid=?");
        Object[] params = new Object[]{ctx.getCaller().toString(), createtime, tragetUserID};
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        }
        catch (Exception e) {
            logger.error((Object)"update lastupdatetime after operating organization range", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _canGrantIncludeSubOrg(Context ctx, String userId, String orgId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from t_pm_orgrangeincludesuborg oris ").append(" inner join t_org_admin orgap on oris.forgid = orgap.fid ").append(" inner join t_org_admin orgac on charindex(orgap.flongnumber,orgac.flongnumber) > 0 and orgac.fid='").append(orgId).append("' where oris.ftype = ").append(20).append(" and oris.fisincludesuborg = 1 and oris.fuserid='").append(userId).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected Set _getOrgIdsByUserAndTypeUsingSQL(Context ctx, String userPK, OrgRangeType orgRangeType) throws BOSException, EASBizException {
        assert (!StringUtils.isEmpty((String)userPK));
        if (orgRangeType == null) {
            orgRangeType = OrgRangeType.BIZ_ORG_TYPE;
        }
        HashSet<String> result = new HashSet<String>();
        String sql = "select forgid from T_PM_OrgRangeIncludeSubOrg where fuserid = ? and ftype = ? ";
        Object[] params = new Object[]{userPK, orgRangeType.getValue()};
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)"select forgid from T_PM_OrgRangeIncludeSubOrg where fuserid = ? and ftype = ? ", (Object[])params);
            while (rowset.next()) {
                result.add(rowset.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public IObjectPK addnew(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        PermCacheFacadeFactory.getLocalInstance(ctx).removeOrgPermCacheByUser(ctx.getCaller().toString());
        return super._addnew(ctx, (IObjectValue)model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _getUserOrgRangeOrgInfo(Context ctx, UserInfo user, OrgRangeType orgRangeType) throws BOSException, EASBizException {
        HashMap<String, OrgUnitInfo> map;
        block11: {
            map = new HashMap<String, OrgUnitInfo>();
            StringBuilder execluseorg = new StringBuilder();
            if (OrgRangeType.MANAGE_ORG_TYPE.equals((Object)orgRangeType)) {
                execluseorg.append("'").append(user.getCU().getId().toString()).append("'");
            } else if (OrgRangeType.BIZ_ORG_TYPE.equals((Object)orgRangeType)) {
                execluseorg.append("'").append(user.getDefOrgUnit().getId().toString()).append("'");
                if (Administrator.isAdminType(user.getType())) {
                    execluseorg.append(",'").append(user.getCU().getId().toString()).append("'");
                }
            }
            String sql = "select range.forgid, org.fcontrolunitid,org.fisunion, org.fmaintaincuid from T_PM_OrgRangeIncludeSubOrg range inner join T_ORG_BASEUNIT org ON range.forgid =org.fid where range.fuserid = ? and range.ftype = ?  ";
            if (execluseorg.length() > 0) {
                sql = sql + " and range.forgId  not in (" + execluseorg + ")";
            }
            Connection connection = this.getConnection(ctx);
            PreparedStatement statement = null;
            ResultSet rs = null;
            try {
                statement = connection.prepareStatement(sql);
                statement.setObject(1, user.getId().toString());
                statement.setObject(2, orgRangeType.getValue());
                rs = statement.executeQuery();
                while (rs.next()) {
                    map.put(rs.getString("forgid"), this.getOrgInfo(rs));
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block11;
            }
            finally {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Statement)statement);
                SQLUtils.cleanup((Connection)connection);
            }
            SQLUtils.cleanup((Statement)statement);
            SQLUtils.cleanup((Connection)connection);
        }
        return map;
    }

    @Override
    protected void _addAdminOrgRangeByPosition(Context ctx, List userIdList, List adminOrgIdList, boolean isIncludeSubOrg) throws BOSException, EASBizException {
        if (userIdList == null && null == adminOrgIdList && userIdList.size() == 0 && adminOrgIdList.size() == 0) {
            logger.error((Object)"userList or orgList is null");
            return;
        }
        this.addOrgRangeBatch(ctx, userIdList, adminOrgIdList, OrgRangeType.ADMIN_ORG_TYPE, isIncludeSubOrg);
    }

    @Override
    protected void _deleteAdminOrgRangeByPosition(Context ctx, List userIdList, List adminOrgIdList) throws BOSException, EASBizException {
        Object manager = null;
        String tableName = null;
        long begin = System.currentTimeMillis();
        logger.error((Object)("beginLog:cost :" + (System.currentTimeMillis() - begin)));
        if (adminOrgIdList.size() > 500) {
            tableName = this.createTempTable(ctx, adminOrgIdList);
            begin = System.currentTimeMillis();
            String idsql = " select fid from " + tableName;
            for (int i = 0; i < userIdList.size(); ++i) {
                ObjectUuidPK userPK = new ObjectUuidPK(BOSUuid.read((String)((String)userIdList.get(i))));
                this.deleteOrgRanges(ctx, (IObjectPK)userPK, OrgRangeType.ADMIN_ORG_TYPE, idsql);
                this.deleteOrgRangeIncludeSubOrgs(ctx, (IObjectPK)userPK, OrgRangeType.ADMIN_ORG_TYPE, idsql);
            }
            logger.error((Object)("deleteOrgRangeIncludeSubOrgsAndOrgRanges_tempTable  cost\uff1a" + (System.currentTimeMillis() - begin)));
        } else {
            begin = System.currentTimeMillis();
            for (int i = 0; i < userIdList.size(); ++i) {
                ObjectUuidPK userPK = new ObjectUuidPK(BOSUuid.read((String)((String)userIdList.get(i))));
                this.deleteOrgRanges(ctx, (IObjectPK)userPK, OrgRangeType.ADMIN_ORG_TYPE, adminOrgIdList);
                this.deleteOrgRangeIncludeSubOrgs(ctx, (IObjectPK)userPK, OrgRangeType.ADMIN_ORG_TYPE, adminOrgIdList);
            }
            logger.error((Object)("deleteOrgRangeIncludeSubOrgs_collection cost\uff1a" + (System.currentTimeMillis() - begin)));
        }
    }

    private OrgUnitInfo getOrgInfo(ResultSet rs) throws UuidException, SQLException {
        FullOrgUnitInfo info = new FullOrgUnitInfo();
        info.setId(BOSUuid.read((String)rs.getString("forgid")));
        CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
        ctrlUnitInfo.setId(BOSUuid.read((String)rs.getString("fcontrolunitid")));
        info.setCU(ctrlUnitInfo);
        int fisunion = rs.getInt("fisunion");
        info.setIsUnion(fisunion == 1);
        if (fisunion == 1) {
            CtrlUnitInfo maintaincu = new CtrlUnitInfo();
            String fmaintaincuid = rs.getString("fmaintaincuid");
            maintaincu.setId(BOSUuid.read((String)(fmaintaincuid == null ? rs.getString("fcontrolunitid") : fmaintaincuid)));
            info.setMaintainCU(maintaincu);
        }
        return info;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addOrgRangeBatch(Context ctx, List userIdList, List orgList, OrgRangeType orgRangeType, Boolean isIncludeSubOrg) throws BOSException, EASBizException {
        PreparedStatement updateSubOrgSmt;
        PreparedStatement insertSubOrgSmt;
        PreparedStatement insertSqlSmt;
        PreparedStatement state;
        Connection conn;
        block14: {
            String tableName;
            TableManager manager;
            block12: {
                block13: {
                    manager = null;
                    tableName = null;
                    conn = this.getConnection(ctx);
                    state = null;
                    insertSqlSmt = null;
                    insertSubOrgSmt = null;
                    updateSubOrgSmt = null;
                    manager = TableManager.getTableManager((Context)ctx);
                    if (manager != null) break block12;
                    logger.error((Object)"error ! batch assign org,Get Temp Table fail!");
                    if (manager == null || tableName == null) break block13;
                    manager.releaseTable(tableName);
                }
                SQLUtils.cleanup(state, (Connection)conn);
                SQLUtils.cleanup(insertSqlSmt, (Connection)conn);
                SQLUtils.cleanup(insertSubOrgSmt, (Connection)conn);
                SQLUtils.cleanup(updateSubOrgSmt, (Connection)conn);
                return;
            }
            try {
                tableName = manager.getTableName("OrgRangeBatch");
                String createSql = "create table " + tableName + " (FOrgId varchar(44))";
                manager.createTable(createSql);
                String insertTmpSql = "insert into " + tableName + " (forgid) values(?)";
                state = conn.prepareStatement(insertTmpSql);
                this.addInsertTmpData(ctx, state, orgList);
                String insertSql = "insert into t_pm_orgRange (fid,fuserid,forgid,ftype) select newbosid('FD3DC16D'),?,FOrgId,? from " + tableName + " tmp where not exists(select 1 from t_pm_orgRange o where o.forgid = tmp.forgid   and o.fuserid = ? and o.ftype=?)";
                String insertSubOrgSql = "insert into T_PM_OrgRangeIncludeSubOrg (fid,fuserid, forgid,ftype,FISINCLUDESUBORG) select newbosid('4DC3DADF'),?,FOrgId,?,? from " + tableName + " tmp where not exists (select 1 from T_PM_OrgRangeIncludeSubOrg o where o.forgid = tmp.forgid   and o.fuserid = ? and o.ftype=?)";
                if (isIncludeSubOrg.booleanValue()) {
                    String updateSubOrgSql = "update T_PM_OrgRangeIncludeSubOrg o set FISINCLUDESUBORG = ? where exists (select 1 from " + tableName + " tmp where tmp.forgid = o.forgid and o.fuserid = ? and o.ftype = ?)";
                    updateSubOrgSmt = conn.prepareStatement(updateSubOrgSql);
                }
                insertSqlSmt = conn.prepareStatement(insertSql);
                insertSubOrgSmt = conn.prepareStatement(insertSubOrgSql);
                for (int i = 0; i < userIdList.size(); ++i) {
                    String userId = (String)userIdList.get(i);
                    insertSubOrgSmt.setString(1, userId);
                    insertSubOrgSmt.setInt(2, orgRangeType.getValue());
                    insertSubOrgSmt.setInt(3, isIncludeSubOrg != false ? 1 : 0);
                    insertSubOrgSmt.setString(4, userId);
                    insertSubOrgSmt.setInt(5, orgRangeType.getValue());
                    if (isIncludeSubOrg.booleanValue() && null != updateSubOrgSmt) {
                        updateSubOrgSmt.setInt(1, 1);
                        updateSubOrgSmt.setString(2, userId);
                        updateSubOrgSmt.setInt(3, orgRangeType.getValue());
                        updateSubOrgSmt.addBatch();
                    }
                    insertSqlSmt.setString(1, userId);
                    insertSqlSmt.setInt(2, orgRangeType.getValue());
                    insertSqlSmt.setString(3, userId);
                    insertSqlSmt.setInt(4, orgRangeType.getValue());
                    insertSqlSmt.addBatch();
                    insertSubOrgSmt.addBatch();
                }
                insertSqlSmt.executeBatch();
                insertSubOrgSmt.executeBatch();
                if (null != updateSubOrgSmt) {
                    updateSubOrgSmt.executeBatch();
                }
                if (isIncludeSubOrg.booleanValue()) {
                    for (Object userPk : userIdList) {
                        String userId = (String)userPk;
                        OrgRangeHelper.updateAdminOrgRange(ctx, userId);
                    }
                }
                if (manager == null || tableName == null) break block14;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (manager != null && tableName != null) {
                        manager.releaseTable(tableName);
                    }
                    SQLUtils.cleanup(state, (Connection)conn);
                    SQLUtils.cleanup(insertSqlSmt, (Connection)conn);
                    SQLUtils.cleanup(insertSubOrgSmt, (Connection)conn);
                    SQLUtils.cleanup(updateSubOrgSmt, (Connection)conn);
                    throw throwable;
                }
            }
            manager.releaseTable(tableName);
        }
        SQLUtils.cleanup((Statement)state, (Connection)conn);
        SQLUtils.cleanup((Statement)insertSqlSmt, (Connection)conn);
        SQLUtils.cleanup((Statement)insertSubOrgSmt, (Connection)conn);
        SQLUtils.cleanup((Statement)updateSubOrgSmt, (Connection)conn);
        return;
    }

    private void addInsertTmpData(Context ctx, PreparedStatement state, List orgList) throws SQLException {
        int count = 0;
        for (int i = 0; i < orgList.size(); ++i) {
            String orgId = (String)orgList.get(i);
            state.setString(1, orgId);
            state.addBatch();
            if (++count <= 2000) continue;
            state.executeBatch();
            count = 0;
        }
        state.executeBatch();
        state.close();
    }
}

