/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.OwnerPermExceptCollection;
import com.kingdee.eas.base.permission.OwnerPermExceptInfo;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.app.AbstractOwnerPermExceptControllerBean;
import com.kingdee.eas.base.permission.util.CacheUtil;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class OwnerPermExceptControllerBean
extends AbstractOwnerPermExceptControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.OwnerPermExceptControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    private void addNewExpectUser(Context ctx, PreparedStatement ps, List objTypeList, List userIdList, String cuId) throws SQLException {
        for (int index = 0; index < objTypeList.size(); ++index) {
            for (int userIndex = 0; userIndex < userIdList.size(); ++userIndex) {
                ps.setString(1, BOSUuid.create((BOSObjectType)this.getBOSType()).toString());
                ps.setString(2, userIdList.get(userIndex).toString());
                ps.setString(3, objTypeList.get(index).toString());
                ps.setString(4, cuId);
                ps.addBatch();
            }
        }
    }

    private void delExceptionUser(Context ctx, List objTypeList, List userIdList, String cuID) throws BOSException {
        String sql = " delete from T_PM_OwnerPermExcept where  FObjType in (" + ToolUtils.aryToStr(objTypeList, true) + ") and FControlUnitID = '" + cuID + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected OwnerPermExceptCollection _getOwnerPermExceptionCol(Context ctx, List objTypeList, IObjectPK cuOrgPK) throws BOSException, EASBizException {
        if (objTypeList == null || objTypeList.isEmpty()) {
            return new OwnerPermExceptCollection();
        }
        String oql = "select *,user.id where objType in (" + ToolUtils.aryToStr(objTypeList, true) + ") and CU.id = '" + cuOrgPK.toString() + "'";
        return this.getOwnerPermExceptCollection(ctx, oql);
    }

    @Override
    protected void _saveUser(Context ctx, List objTypeList, List userIdList, IObjectPK cuOrgId) throws BOSException, EASBizException {
        if (objTypeList == null || objTypeList.isEmpty() || cuOrgId == null) {
            return;
        }
        if (userIdList == null || userIdList.isEmpty()) {
            return;
        }
        TableManager manager = null;
        String tableName = null;
        Connection con = this.getConnection(ctx);
        PreparedStatement ps = null;
        try {
            manager = TableManager.getTableManager((Context)ctx);
            tableName = manager.getTableName("T_PM_OwnerPermExcept");
            String createSql = "create table " + tableName + " (fid varchar(44),FUserId varchar(44),FObjType varchar(44),FControlUnitID varchar(44))";
            manager.createTable(createSql);
            String sql = "insert into " + tableName + "(fid,FUserId,FObjType,FControlUnitID) values(?,?,?,?)";
            ps = con.prepareStatement(sql);
            for (int index = 0; index < objTypeList.size(); ++index) {
                for (int userIndex = 0; userIndex < userIdList.size(); ++userIndex) {
                    ps.setString(1, BOSUuid.create((BOSObjectType)this.getBOSType()).toString());
                    ps.setString(2, userIdList.get(userIndex).toString());
                    ps.setString(3, objTypeList.get(index).toString());
                    ps.setString(4, cuOrgId.toString());
                    ps.addBatch();
                }
            }
            ps.executeBatch();
            sql = "insert into T_PM_OwnerPermExcept select * from " + tableName + " t2 where not exists (select 1 from T_PM_OwnerPermExcept t1  where t1.fuserid = t2.fuserid and t1.fobjtype = t2.fobjtype and t1.fcontrolunitid = t2.fcontrolunitid)";
            ArrayList<IObjectPK> cuIds = new ArrayList<IObjectPK>();
            cuIds.add(cuOrgId);
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)RESOURCE, (String)"OWNER_EXCEPTION"), (BOSObjectType)new BOSObjectType("F2B4E25F"), null, (String)this.getLogDetail(ctx, objTypeList, userIdList, cuIds), (String)"bs_permission_specialDataPerm_otherOwner");
            DbUtil.execute((Context)ctx, (String)sql);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException("sql error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                if (manager != null && tableName != null) {
                    manager.releaseTable(tableName);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
        if (manager != null && tableName != null) {
            manager.releaseTable(tableName);
        }
        CacheUtil.clearRuleCache();
    }

    private String getLogDetail(Context ctx, List objTypeList, List userIdList, List cuOrgIds) {
        StringBuilder sb = new StringBuilder();
        try {
            int i;
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            sb.append(EASResource.getString((String)RESOURCE, (String)"ON_CTRLUNIT"));
            FullOrgUnitCollection orgColl = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection("select name where id in (" + ToolUtils.aryToStr(cuOrgIds) + ")");
            for (i = 0; i < orgColl.size(); ++i) {
                sb.append(orgColl.get(i).getName());
                sb.append(i == objTypeList.size() - 1 ? " " : ",");
            }
            sb.append(EASResource.getString((String)RESOURCE, (String)"BILL"));
            for (i = 0; i < objTypeList.size(); ++i) {
                String entityType = objTypeList.get(i).toString();
                EntityObjectInfo entity = loader.getEntity(new BOSObjectType(entityType));
                sb.append(entity.getAlias());
                sb.append(i == objTypeList.size() - 1 ? " " : ",");
            }
            sb.append(")").append(EASResource.getString((String)RESOURCE, (String)"SET_OWNER_EXCEPTION"));
            UserCollection userCollection = UserFactory.getLocalInstance(ctx).getUserCollection("select number where id in (" + ToolUtils.aryToStr(userIdList) + ")");
            for (int i2 = 0; i2 < userCollection.size(); ++i2) {
                sb.append(userCollection.get(i2).getNumber());
                sb.append(i2 == userCollection.size() - 1 ? " " : ",");
            }
            sb.append(")");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return sb.toString();
    }

    @Override
    protected void _addToMultiOrg(Context ctx, List orgList, IObjectCollection collection) throws BOSException, EASBizException {
        if (orgList == null || orgList.size() == 0 || collection == null || collection.size() == 0) {
            return;
        }
        OwnerPermExceptCollection ownerPermExceptCollection = (OwnerPermExceptCollection)collection;
        Connection conn = this.getConnection(ctx);
        TableManager manager = null;
        String tableName = null;
        PreparedStatement ps = null;
        StringBuilder sb = new StringBuilder();
        sb.append(EASResource.getString((String)RESOURCE, (String)"MULTI_ORG_ADDNEW"));
        FullOrgUnitCollection orgColl = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection("select name where id in (" + ToolUtils.aryToStr(orgList) + ")");
        for (int i = 0; i < orgColl.size(); ++i) {
            sb.append(orgColl.get(i).getName()).append(i == orgColl.size() - 1 ? " " : ",");
        }
        sb.append(")\n" + EASResource.getString((String)RESOURCE, (String)"BILL_AND_USER"));
        try {
            manager = TableManager.getTableManager((Context)ctx);
            tableName = manager.getTableName("T_PM_OwnerPermExcept");
            String createSql = "create table " + tableName + " (fid varchar(44),FUserId varchar(44),FObjType varchar(44),FControlUnitID varchar(44))";
            manager.createTable(createSql);
            String sql = "insert into " + tableName + "(fid,FUserId,FObjType,FControlUnitID) values(?,?,?,?)";
            ps = conn.prepareStatement(sql);
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            for (int j = 0; j < ownerPermExceptCollection.size(); ++j) {
                OwnerPermExceptInfo ownerPermExceptInfo = ownerPermExceptCollection.get(j);
                sb.append("(");
                EntityObjectInfo entity = loader.getEntity(new BOSObjectType(ownerPermExceptInfo.getObjType()));
                sb.append(entity.getAlias()).append(" ");
                sb.append(ownerPermExceptInfo.getUser().getNumber()).append(" )");
                for (int i = 0; i < orgList.size(); ++i) {
                    String userId = ownerPermExceptInfo.getUser().getId().toString();
                    String objType = ownerPermExceptInfo.getObjType().toString();
                    String fid = BOSUuid.create((BOSObjectType)this.getBOSType()).toString();
                    ps.setString(1, fid);
                    ps.setString(2, userId);
                    ps.setString(3, objType);
                    ps.setString(4, orgList.get(i).toString());
                    ps.addBatch();
                }
            }
            ps.executeBatch();
            sql = "insert into T_PM_OwnerPermExcept select * from " + tableName + " t2 where not exists (select 1 from T_PM_OwnerPermExcept t1  where t1.fuserid = t2.fuserid and t1.fobjtype = t2.fobjtype and t1.fcontrolunitid = t2.fcontrolunitid)";
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)RESOURCE, (String)"OWNER_EXCEPTION"), (BOSObjectType)new BOSObjectType("F2B4E25F"), null, (String)sb.toString(), (String)"bs_permission_specialDataPerm_otherOwner");
            DbUtil.execute((Context)ctx, (String)sql);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                if (manager != null && tableName != null) {
                    manager.releaseTable(tableName);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        if (manager != null && tableName != null) {
            manager.releaseTable(tableName);
        }
    }

    @Override
    protected void _delFromMultiOrg(Context ctx, List orgList, IObjectCollection collection) throws BOSException, EASBizException {
        int i;
        StringBuffer orgIds = new StringBuffer();
        if (orgList == null || orgList.size() == 0 || collection == null || collection.size() == 0) {
            return;
        }
        for (int i2 = 0; i2 < orgList.size(); ++i2) {
            if (i2 != orgList.size() - 1) {
                orgIds.append("'").append(orgList.get(i2)).append("',");
                continue;
            }
            orgIds.append("'").append(orgList.get(i2)).append("'");
        }
        OwnerPermExceptCollection ownerPermExceptCollection = (OwnerPermExceptCollection)collection;
        Connection conn = this.getConnection(ctx);
        PreparedStatement ps = null;
        String sql = "delete from T_PM_OwnerPermExcept where fuserid = ? and fobjtype = ? and fcontrolunitid in(" + orgIds.toString() + ")";
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        StringBuilder sb = new StringBuilder();
        sb.append(EASResource.getString((String)RESOURCE, (String)"MULTIORG_DELETE"));
        FullOrgUnitCollection orgColl = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection("select name where id in (" + orgIds + ")");
        for (i = 0; i < orgColl.size(); ++i) {
            sb.append(orgColl.get(i).getName()).append(i == orgColl.size() - 1 ? " " : ",");
        }
        sb.append(")\n" + EASResource.getString((String)RESOURCE, (String)"BILL_AND_USER"));
        try {
            ps = conn.prepareStatement(sql);
            for (i = 0; i < ownerPermExceptCollection.size(); ++i) {
                OwnerPermExceptInfo ownerPermExceptInfo = ownerPermExceptCollection.get(i);
                String userId = ownerPermExceptInfo.getUser().getId().toString();
                String objType = ownerPermExceptInfo.getObjType().toString();
                ps.setString(1, userId);
                ps.setString(2, objType);
                ps.addBatch();
                sb.append("(");
                EntityObjectInfo entity = loader.getEntity(new BOSObjectType(ownerPermExceptInfo.getObjType()));
                sb.append(entity.getAlias()).append(" ");
                sb.append(ownerPermExceptInfo.getUser().getNumber()).append(" )");
            }
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)RESOURCE, (String)"OWNER_EXCEPTION"), (BOSObjectType)new BOSObjectType("F2B4E25F"), null, (String)sb.toString(), (String)"bs_permission_specialDataPerm_otherOwner");
            ps.executeBatch();
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)RESOURCE, (String)"OWNER_EXCEPTION"), (BOSObjectType)new BOSObjectType("F2B4E25F"), null, (String)this.writeDeleteLog(ctx, new IObjectPK[]{pk}), (String)"bs_permission_specialDataPerm_otherOwner");
        super.delete(ctx, pk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        CacheUtil.clearRuleCache();
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)RESOURCE, (String)"OWNER_EXCEPTION"), (BOSObjectType)new BOSObjectType("F2B4E25F"), null, (String)this.writeDeleteLog(ctx, arrayPK), (String)"bs_permission_specialDataPerm_otherOwner");
        super._delete(ctx, arrayPK);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        CacheUtil.clearRuleCache();
    }

    private String writeDeleteLog(Context ctx, IObjectPK[] arrayPK) throws BOSException {
        StringBuilder sb = new StringBuilder();
        try {
            OwnerPermExceptCollection opeColl = this.getOwnerPermExceptCollection(ctx, "select *,user.id,user.number,cu.name where id in (" + ToolUtils.aryToStr(arrayPK) + ")");
            if (opeColl.size() == 0) {
                return "";
            }
            sb.append(EASResource.getString((String)RESOURCE, (String)"CTRLUNIT")).append(opeColl.get(0).getCU().getName()).append("):");
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo entity = loader.getEntity(new BOSObjectType(opeColl.get(0).getObjType()));
            sb.append(EASResource.getString((String)RESOURCE, (String)"BILL1")).append(entity.getAlias()).append(EASResource.getString((String)RESOURCE, (String)"CANCEL_OWNER_EXCEPTION"));
            for (int i = 0; i < opeColl.size(); ++i) {
                sb.append(opeColl.get(i).getUser().getNumber()).append(i == opeColl.size() - 1 ? " " : ",");
            }
            sb.append(")");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return sb.toString();
    }
}

