/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

final class RemoveAuthenSchemeManager {
    private static RemoveAuthenSchemeManager instance;
    private List<String> needRemoveTableNames;

    private RemoveAuthenSchemeManager() {
        this.initNeedDeleteTableName();
    }

    private void initNeedDeleteTableName() {
        this.needRemoveTableNames = new ArrayList<String>();
        this.needRemoveTableNames.add("t_pm_authenschemeorguser");
        this.needRemoveTableNames.add("t_pm_authenschemeperm");
        this.needRemoveTableNames.add("t_pm_authenschemerole");
        this.needRemoveTableNames.add("t_pm_authenschemerule");
    }

    public static synchronized RemoveAuthenSchemeManager getInstance() {
        if (instance == null) {
            instance = new RemoveAuthenSchemeManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAboutAuthenScheme(Connection con, String tableName, String authenSchemeId) throws SQLException {
        if (StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)authenSchemeId)) {
            return;
        }
        PreparedStatement preparedStatement = null;
        try {
            tableName = tableName.toLowerCase();
            StringBuffer cleanAboutAuthenSchemeSql = new StringBuffer();
            cleanAboutAuthenSchemeSql.append("delete from ").append(tableName).append(" ").append("where fauthenschemeid = ?");
            preparedStatement = con.prepareStatement(cleanAboutAuthenSchemeSql.toString());
            preparedStatement.setString(1, authenSchemeId);
            preparedStatement.execute();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(preparedStatement);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)preparedStatement);
    }

    public void cleanAboutAuthenScheme(Connection con, String authenSchemeId) throws SQLException {
        for (String needRemoveTableName : this.needRemoveTableNames) {
            this.cleanAboutAuthenScheme(con, needRemoveTableName, authenSchemeId);
        }
    }
}

