/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.app.AbstractBaseAuthenRecordAuthen;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RoleAssignPermAuthenRecordAuthen
extends AbstractBaseAuthenRecordAuthen {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.RoleAssignPermAuthenRecordAuthenImpl");
    private int MAX_RECORD_COUNT = 8000;
    private final String PERMITEM_TO_USER_MAP = "permItem2UserMap";
    private final String PERMITEM_TO_RULE = "permItem2Rule";
    private final String PERMITEM_TO_ASSIGNTYPE = "permItem2AssignType";
    static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    @Override
    protected String getDescription() {
        return EASResource.getString((String)RESOURCE, (String)"AUTHEN_ROLE_TASK");
    }

    @Override
    protected ResultSet queryNeedAuthenResultSet(Connection conn, String permChangeId) throws BOSException {
        PreparedStatement queryStatement = null;
        ResultSet resultSet = null;
        try {
            StringBuffer queryAllCanAuthenPermInfo = new StringBuffer();
            queryAllCanAuthenPermInfo.append("select change.fpermitemid permItem, snapview.fisrule isrule, ").append("snapview.fuserid userid, change.fassigntype assigntype ").append("from t_pm_rolepermchange as change ").append("inner join t_pm_authenschemesnapview as snapview on change.fpermchangeid = snapview.fpermchangerecordid and change.fpermitemid = snapview.fpermitemid ").append("inner join t_pm_authenrecord as record on record.fpermchangeid = change.fpermchangeid and record.fauthentorid = snapview.fuserid ").append("where change.fauthenstatus = ? and ").append("record.fauthenstatus = ? and ").append("snapview.fpermchangerecordid = ?");
            queryStatement = conn.prepareStatement(queryAllCanAuthenPermInfo.toString());
            queryStatement.setString(1, "10");
            queryStatement.setString(2, "10");
            queryStatement.setString(3, permChangeId);
            resultSet = queryStatement.executeQuery();
            return resultSet;
        }
        catch (Exception e) {
            SQLUtils.cleanup(resultSet, queryStatement);
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map getInformation(ResultSet resultSet) throws BOSException {
        try {
            HashMap permItem2UserMap = new HashMap();
            HashMap<String, Boolean> permItem2Rule = new HashMap<String, Boolean>();
            HashMap<String, String> permItem2AssignType = new HashMap<String, String>();
            String permItemId = null;
            String lastPermItem = null;
            boolean rule = false;
            String userId = null;
            String assigntType = null;
            HashSet<String> userIdSet = null;
            while (resultSet.next()) {
                permItemId = resultSet.getString("permItem");
                rule = resultSet.getBoolean("isrule");
                userId = resultSet.getString("userid");
                assigntType = resultSet.getString("assigntype");
                if (!permItemId.equals(lastPermItem)) {
                    userIdSet = (HashSet<String>)permItem2UserMap.get(permItemId);
                }
                if (userIdSet == null) {
                    userIdSet = new HashSet<String>();
                    permItem2UserMap.put(permItemId, userIdSet);
                }
                userIdSet.add(userId);
                permItem2Rule.put(permItemId, rule);
                permItem2AssignType.put(permItemId, assigntType);
                lastPermItem = permItemId;
            }
            HashMap<String, HashMap<String, Object>> information = new HashMap<String, HashMap<String, Object>>();
            information.put("permItem2UserMap", permItem2UserMap);
            information.put("permItem2Rule", permItem2Rule);
            information.put("permItem2AssignType", permItem2AssignType);
            return information;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Set getPassSet(Map information, String currentUserId) {
        Map permItem2UserMap = (Map)information.get("permItem2UserMap");
        Map permItem2Rule = (Map)information.get("permItem2Rule");
        Set permItemKeySet = permItem2UserMap.keySet();
        HashSet permItemIdSet = new HashSet();
        boolean rule = false;
        Set userIdSet = null;
        for (Object permItemIdObj : permItemKeySet) {
            rule = (Boolean)permItem2Rule.get(permItemIdObj);
            userIdSet = (Set)permItem2UserMap.get(permItemIdObj);
            if (!userIdSet.contains(currentUserId) || rule && userIdSet.size() != 1) continue;
            permItemIdSet.add(permItemIdObj);
        }
        return permItemIdSet;
    }

    @Override
    protected void updatePassData(Connection conn, Set passSet, Map information, String permChangeId) throws BOSException {
        PreparedStatement insertPermStatement = null;
        PreparedStatement updatePermStatement = null;
        PreparedStatement updateAuthenStatusStatement = null;
        try {
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into t_pm_roleperm(fid,froleid,fpermitemid,fpermtype,frulestructure,fruleexpr) ").append("select froleperm, froleid, fpermitemid, fpermtype, frulestructure, fruleexpr ").append("from t_pm_rolepermchange ").append("where fpermitemid = ? and ").append("fpermchangeid = ? and ").append("not exists (").append("select 1 ").append("from t_pm_roleperm rolep ").append("where rolep.froleid = t_pm_rolepermchange.froleid and ").append("rolep.fpermitemid = t_pm_rolepermchange.fpermitemid and ").append("rolep.fpermtype = t_pm_rolepermchange.fpermtype").append(")");
            StringBuffer updatePermSql = new StringBuffer();
            updatePermSql.append("update t_pm_roleperm roleperm ").append("set (frulestructure, fruleexpr) = (").append("select change.frulestructure, change.fruleexpr ").append("from t_pm_rolepermchange change ").append("where change.fuserorgperm = roleperm.fid and ").append("change.fpermchangeid = ?").append(") ").append("where roleperm.fid in (").append("select change2.fuserorgperm ").append("from t_pm_rolepermchange change2 ").append("where change2.fpermchangeid = ? and ").append("change2.fpermitemid = ?").append(")");
            StringBuffer updateAuthenStatusSql = new StringBuffer();
            updateAuthenStatusSql.append("update t_pm_rolepermchange ").append("set fauthenstatus = ? ").append("where fpermchangeid = ? and ").append("fpermitemid = ?");
            insertPermStatement = conn.prepareStatement(insertSql.toString());
            updatePermStatement = conn.prepareStatement(updatePermSql.toString());
            updateAuthenStatusStatement = conn.prepareStatement(updateAuthenStatusSql.toString());
            Map permItem2AssignType = (Map)information.get("permItem2AssignType");
            int insertCount = 0;
            int updatePermCount = 0;
            int updateStatusCount = 0;
            String assigntType = null;
            for (Object permItemIdObj : passSet) {
                assigntType = (String)permItem2AssignType.get((String)permItemIdObj);
                if ("10".equals(assigntType)) {
                    insertPermStatement.setObject(1, permItemIdObj);
                    insertPermStatement.setString(2, permChangeId);
                    insertPermStatement.addBatch();
                    ++insertCount;
                } else if ("30".equals(assigntType)) {
                    updatePermStatement.setString(1, permChangeId);
                    updatePermStatement.setString(2, permChangeId);
                    updatePermStatement.setObject(3, permItemIdObj);
                    updatePermStatement.addBatch();
                    ++updatePermCount;
                }
                updateAuthenStatusStatement.setString(1, "20");
                updateAuthenStatusStatement.setString(2, permChangeId);
                updateAuthenStatusStatement.setObject(3, permItemIdObj);
                updateAuthenStatusStatement.addBatch();
                ++updateStatusCount;
                if (insertCount > this.MAX_RECORD_COUNT) {
                    insertPermStatement.executeBatch();
                    insertPermStatement.clearBatch();
                    insertCount = 0;
                }
                if (updatePermCount > this.MAX_RECORD_COUNT) {
                    updatePermStatement.executeBatch();
                    updatePermStatement.clearBatch();
                    updatePermCount = 0;
                }
                if (updateStatusCount <= this.MAX_RECORD_COUNT) continue;
                updateAuthenStatusStatement.executeBatch();
                updateAuthenStatusStatement.clearBatch();
                updateStatusCount = 0;
            }
            if (insertCount > 0) {
                insertPermStatement.executeBatch();
                insertPermStatement.clearBatch();
                insertCount = 0;
            }
            if (updatePermCount > 0) {
                updatePermStatement.executeBatch();
                updatePermStatement.clearBatch();
                updatePermCount = 0;
            }
            if (updateStatusCount > 0) {
                updateAuthenStatusStatement.executeBatch();
                updateAuthenStatusStatement.clearBatch();
                updateStatusCount = 0;
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(insertPermStatement);
                SQLUtils.cleanup(updatePermStatement);
                SQLUtils.cleanup(updateAuthenStatusStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)insertPermStatement);
        SQLUtils.cleanup((Statement)updatePermStatement);
        SQLUtils.cleanup((Statement)updateAuthenStatusStatement);
    }

    @Override
    protected Set getNoPassSet(Map information, String currentUserId) {
        Map permItem2UserMap = (Map)information.get("permItem2UserMap");
        Map permItem2Rule = (Map)information.get("permItem2Rule");
        Set permItemKeySet = permItem2UserMap.keySet();
        HashSet permItemIdSet = new HashSet();
        boolean rule = false;
        Set userIdSet = null;
        for (Object permItemIdObj : permItemKeySet) {
            rule = (Boolean)permItem2Rule.get(permItemIdObj);
            userIdSet = (Set)permItem2UserMap.get(permItemIdObj);
            if (!userIdSet.contains(currentUserId)) continue;
            permItemIdSet.add(permItemIdObj);
        }
        return permItemIdSet;
    }

    @Override
    protected void updateNoPassData(Connection conn, Set noPassSet, Map information, String permChangeId) throws BOSException {
        PreparedStatement updateAuthenStatusStatement = null;
        try {
            StringBuffer updateAuthenStatusSql = new StringBuffer();
            updateAuthenStatusSql.append("update t_pm_rolepermchange ").append("set fauthenstatus = ? ").append("where fpermchangeid = ? and ").append("fpermitemid = ?");
            updateAuthenStatusStatement = conn.prepareStatement(updateAuthenStatusSql.toString());
            int count = 0;
            for (Object permItemIdObj : noPassSet) {
                updateAuthenStatusStatement.setString(1, "30");
                updateAuthenStatusStatement.setString(2, permChangeId);
                updateAuthenStatusStatement.setObject(3, permItemIdObj);
                updateAuthenStatusStatement.addBatch();
                if (++count <= this.MAX_RECORD_COUNT) continue;
                updateAuthenStatusStatement.executeBatch();
                updateAuthenStatusStatement.clearBatch();
                count = 0;
            }
            if (count > 0) {
                updateAuthenStatusStatement.executeBatch();
                updateAuthenStatusStatement.clearBatch();
                count = 0;
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(updateAuthenStatusStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)updateAuthenStatusStatement);
    }
}

