/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.ISecurity;
import com.kingdee.eas.base.permission.IUsbKeyUserMap;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.SecurityCollection;
import com.kingdee.eas.base.permission.SecurityFactory;
import com.kingdee.eas.base.permission.UsbKeyUserMapFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.AbstractUserEditUIHandler;
import com.kingdee.eas.base.permission.util.CacheUtil;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.LogProxy;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.BaseFrameService;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.util.StringUtils;
import java.util.List;

public class UserEditUIHandler
extends AbstractUserEditUIHandler {
    private static String ADDNEW = "ADDNEW";
    private static String VIEW = "VIEW";
    private static String EDIT = "EDIT";

    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        String operator = request.get("OprtState").toString();
        if (EDIT.equals(operator)) {
            BaseFrameService service = new BaseFrameService();
            service.requestMutextControl(request, response, context);
        }
        this.handleEditUser(request, response, context);
    }

    @Override
    protected void _handleActionAddNew(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        BOSObjectType orgBosType = (BOSObjectType)request.get("orgBosType");
        String methodAlias = (String)request.get("MethodAlias");
        String orgNumber = (String)request.get("OrgNumber");
        LogProxy logProxy = new LogProxy();
        logProxy.beginLog(context, methodAlias, orgBosType, null, orgNumber);
        ObjectUuidPK userPK = null;
        IUser iUser = UserFactory.getLocalInstance(context);
        String operator = request.get("OprtState").toString();
        UserInfo userInfo = (UserInfo)request.get("userInfo");
        if (ADDNEW.equals(operator)) {
            String deletedUserID = iUser.getDeletedUserID(userInfo.getNumber());
            if (StringUtils.isEmpty((String)deletedUserID)) {
                userPK = iUser.addnew((CoreBaseInfo)userInfo);
                userInfo.setId(BOSUuid.read((String)userPK.toString()));
                response.put((Object)"Fw_ObjectPK", (Object)userPK);
            } else {
                UserInfo deleteUserInfo = CacheUtil.getCacheUserInfo(context, deletedUserID);
                String cuIdStr = null;
                if (deleteUserInfo != null && deleteUserInfo.getCU() != null) {
                    cuIdStr = deleteUserInfo.getCU().getId().toString();
                }
                PermissionRangeHelper.getCUOrgRange(context).contains(cuIdStr);
                IUsbKeyUserMap iUsbKeyUserMap = UsbKeyUserMapFactory.getLocalInstance(context);
                iUsbKeyUserMap.useUsbKey4User(deleteUserInfo.getId().toString());
            }
        } else if (EDIT.equals(operator)) {
            userPK = new ObjectUuidPK(userInfo.getId());
            iUser.update((IObjectPK)userPK, (IObjectValue)userInfo, false);
            OrgRangeIncludeSubOrgFactory.getLocalInstance(context).updateOrgRange(userInfo.getId().toString());
        }
        logProxy.end();
        iUser.checkUserIsRelatedWithPerms((IObjectPK)new ObjectUuidPK(userInfo.getId()));
        Administrator.isCertifyAdmin(context, (IObjectPK)new ObjectStringPK(context.getCaller().toString()));
        PermissionRangeHelper.getUserOrgRange(context, (IObjectPK)new ObjectStringPK(context.getCaller().toString()), OrgRangeType.BIZ_ORG_TYPE);
        this.getSecurities(userInfo.getCU(), context);
        OrgRangeCollection orgRangeCol = userInfo.getOrgRange();
        if (orgRangeCol == null || orgRangeCol.isEmpty()) {
            return;
        }
        List orgIdList = ToolUtils.transCol2ListByPeroperty((IObjectCollection)orgRangeCol, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                OrgRangeInfo orgRangeInfo = (OrgRangeInfo)obj;
                if (orgRangeInfo == null || orgRangeInfo.getOrg() == null || orgRangeInfo.getOrg().getId() == null) {
                    return null;
                }
                if (orgRangeInfo.getOrg().isIsUnion()) {
                    return orgRangeInfo.getOrg().getId().toString();
                }
                return null;
            }
        });
        if (orgIdList == null || orgIdList.isEmpty()) {
            return;
        }
        IOrgStructure iOrgStructure = OrgStructureFactory.getLocalInstance((Context)context);
        iOrgStructure.getOrgStructureCollection("select *,tree.*,unit.* where unit.id in(" + ToolUtils.aryToStr(orgIdList, true) + ")");
    }

    private SecurityCollection getSecurities(CtrlUnitInfo cuInfo, Context context) throws Exception {
        SecurityCollection securities = null;
        StringBuffer buffer = new StringBuffer(200);
        buffer.append(" WHERE CU.id = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ");
        buffer.append(" OR CU.id = '").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("' ");
        buffer.append(" OR CU.id = '").append(cuInfo.getId().toString()).append("' ");
        buffer.append(" ORDER BY number ");
        ISecurity iSecurity = SecurityFactory.getLocalInstance(context);
        securities = iSecurity.getSecurityCollection(buffer.toString());
        return securities;
    }

    @Override
    protected void _handleActionPassword(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionAddOrg(RequestContext request, ResponseContext response, Context context) throws Exception {
        IOrgRange iOrgRange = OrgRangeFactory.getLocalInstance(context);
        IObjectPK curUserPK = (IObjectPK)request.get("curUserPK");
        OrgRangeType orgRangeType = (OrgRangeType)((Object)request.get("orgRangeType"));
        iOrgRange.findFullOrgCol(curUserPK, orgRangeType);
        boolean isSuperAuAdmin = Administrator.isSuperAdmin(curUserPK);
        List orgList = null;
        orgList = isSuperAuAdmin ? PermissionUtils.getAllCU(context) : PermissionRangeHelper.getBizUserCUOrgRange(context, curUserPK);
        StringBuffer oql = new StringBuffer("select * where id in (");
        for (int i = 0; i < orgList.size(); ++i) {
            String orgId = orgList.get(i).toString();
            if (i < orgList.size() - 1) {
                oql.append("'").append(orgId).append("', ");
                continue;
            }
            oql.append("'").append(orgId).append("') order by longNumber");
        }
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance((Context)context);
        FullOrgUnitCollection col = iFull.getFullOrgUnitCollection(oql.toString());
    }

    protected void _handleActionDelOrg(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionAddOrgSolution(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    private void handleEditUser(RequestContext request, ResponseContext reponse, Context context) throws Exception {
        if (request.get("userObjectUuidPK") != null) {
            UserFactory.getLocalInstance(context).getUserInfo((IObjectPK)((ObjectUuidPK)request.get("userObjectUuidPK")), ToolUtils.getEditSelectors());
        }
    }
}

