/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserGroupInfo;
import com.kingdee.eas.base.permission.app.AbstractUserGroupControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class UserGroupControllerBean
extends AbstractUserGroupControllerBean {
    private static Logger logger = Logger.getLogger(UserGroupControllerBean.class);
    static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberBlank(ctx, (DataBaseInfo)model);
        this.checkNumberDup(ctx, (DataBaseInfo)model);
        this.checkNameBlank(ctx, (DataBaseInfo)model);
        this.checkNameDup(ctx, (DataBaseInfo)model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberBlank(ctx, (DataBaseInfo)model);
        this.checkNumberDup(ctx, (DataBaseInfo)model);
        this.checkNameBlank(ctx, (DataBaseInfo)model);
        this.checkNameDup(ctx, (DataBaseInfo)model);
        UserGroupInfo userGroupInfo = this.getUserGroupInfo(ctx, pk);
        UserGroupInfo newValue = (UserGroupInfo)model;
        boolean isNotWriteLog = userGroupInfo.getName().equals(newValue.getName()) && userGroupInfo.getNumber().equals(newValue.getNumber());
        IObjectPK logPK = null;
        if (!isNotWriteLog) {
            logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)model.getBOSType(), null, (String)this.getUpdateLogDetail(newValue, userGroupInfo), (String)"bs_permission_userGroup_update");
        }
        super._update(ctx, pk, model);
        if (logPK != null) {
            LogUtil.afterLog((Context)ctx, logPK);
        }
    }

    private String getUpdateLogDetail(UserGroupInfo model, UserGroupInfo userGroupInfo) {
        StringBuilder logDetailSb = new StringBuilder();
        try {
            logDetailSb.append(EASResource.getString((String)RESOURCE, (String)"userGroup") + ": ").append(userGroupInfo.getNumber()).append(" ").append(userGroupInfo.getName());
            logDetailSb.append(" " + EASResource.getString((String)RESOURCE, (String)"UPDATE_TO") + ": ").append(model.getNumber()).append(" ").append(model.getName());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return logDetailSb.toString();
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String ID = ((UserGroupInfo)model).getId() == null ? null : ((UserGroupInfo)model).getId().toString();
        String number = ((UserGroupInfo)model).getNumber();
        StringBuffer buffer = new StringBuffer(50);
        buffer.append(" WHERE number = '").append(number).append("' ");
        if (!StringUtils.isEmpty((String)ID)) {
            buffer.append(" AND id <> '").append(ID).append("' ");
        }
        if (this.exists(ctx, buffer.toString())) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{number});
        }
    }

    protected void _moveTreeNode(Context ctx, IObjectValue sourceNode, IObjectValue targetNode) throws EASBizException, BOSException {
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)RESOURCE, (String)"MOVE_USERGROUP"), (BOSObjectType)sourceNode.getBOSType(), null, (String)this.getMoveNodeLogDetail((UserGroupInfo)sourceNode, (UserGroupInfo)targetNode), (String)"bs_permission_userGroup_move");
        super._moveTreeNode(ctx, sourceNode, targetNode);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private String getMoveNodeLogDetail(UserGroupInfo sourceNode, UserGroupInfo targetNode) {
        StringBuilder logDetailSb = new StringBuilder();
        try {
            logDetailSb.append(EASResource.getString((String)RESOURCE, (String)"MOVE_USERGROUP") + ": ").append(sourceNode.getNumber()).append(" ").append(sourceNode.getName());
            logDetailSb.append("; " + EASResource.getString((String)RESOURCE, (String)"NEW_SUP_IS") + ": ");
            if (targetNode == null) {
                logDetailSb.append(EASResource.getString((String)RESOURCE, (String)"userGroup"));
            } else {
                logDetailSb.append(targetNode.getNumber()).append(" ").append(targetNode.getName());
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return logDetailSb.toString();
    }
}

