/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.adapter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.MutiOrgPermParam;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.app.adapter.MutiOrgFilter;
import com.kingdee.eas.base.permission.app.adapter.PermissionServiceAdapterHelper;
import com.kingdee.eas.base.permission.app.service.CoopOrgHelper;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

public class MutiOrgPermissionServiceAdapter {
    private MutiOrgPermParam mutiOrgParam;
    private Logger logger = Logger.getLogger((String)MutiOrgPermissionServiceAdapter.class.getName());

    public boolean isMutiOrgPerm(IServiceContext serviceContext) {
        if (serviceContext == null || serviceContext.getContext() == null || serviceContext.getContext().get((Object)"MUTI_ORG_INFO") == null) {
            return false;
        }
        Object obj = serviceContext.getContext().get((Object)"MUTI_ORG_INFO");
        if (obj instanceof MutiOrgPermParam) {
            this.mutiOrgParam = (MutiOrgPermParam)obj;
            return true;
        }
        return false;
    }

    private boolean queryConditionOK() {
        if (this.mutiOrgParam == null || this.mutiOrgParam.getBosType() == null) {
            return false;
        }
        return this.mutiOrgParam.getOrgIdList() != null && !this.mutiOrgParam.getOrgIdList().isEmpty();
    }

    public void handleQueryDataPermission(IServiceContext serviceContext, PermItemInfo permItemInfo) throws EASBizException, BOSException {
        if (!permItemInfo.isEnableDataPermission()) {
            return;
        }
        if (!this.queryConditionOK()) {
            return;
        }
        IObjectPK userPK = serviceContext.getContext().getCaller();
        IPermission iPermission = PermissionFactory.getLocalInstance(serviceContext.getContext());
        FullOrgUnitCollection fullOrgCol = iPermission.getAuthorizedOrg(userPK, this.mutiOrgParam.getOrgType(), this.mutiOrgParam.getOrgTreePK(), permItemInfo.getName());
        List allPermOrgIdList = ToolUtils.transCol2ListByPeroperty((IObjectCollection)fullOrgCol, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                return ((FullOrgUnitInfo)obj).getId().toString();
            }
        });
        Collection lastPermCol = CollectionUtils.intersection((Collection)allPermOrgIdList, (Collection)this.mutiOrgParam.getOrgIdList());
        if (lastPermCol == null || lastPermCol.isEmpty()) {
            PermissionServiceAdapterHelper.bindPermissionContext(serviceContext, " WHERE ( id = '00000000-0000-0000-0000-00000000000013B7DE7F' AND id <> '00000000-0000-0000-0000-00000000000013B7DE7F' )");
            return;
        }
        MutiOrgFilter mutiOrgFilter = new MutiOrgFilter(BOSObjectType.create((String)permItemInfo.getObjectType()));
        String orgFieldName = this.getFieldNameFromCtx(serviceContext, permItemInfo) + ".id";
        String[] coopOrgFieldName = this.appendPropID(this.getCoopFieldNameFromCtx(serviceContext, permItemInfo));
        mutiOrgFilter.initMultiOrgFilterItem(serviceContext.getContext(), userPK, lastPermCol, orgFieldName, coopOrgFieldName, permItemInfo);
        PermissionServiceAdapterHelper.bindPermissionContext(serviceContext, mutiOrgFilter.getResFilterInfo());
    }

    private String getFieldNameFromCtx(IServiceContext serviceContext, PermItemInfo permItemInfo) throws EASBizException {
        String orgFieldStr = PermissionUtil.getBizOrgPropertyName(serviceContext.getContext(), BOSObjectType.create((String)permItemInfo.getObjectType()));
        if (StringUtils.isEmpty((String)orgFieldStr)) {
            throw new IllegalArgumentException("orgField is null!");
        }
        return orgFieldStr;
    }

    private String[] appendPropID(String[] fieldNames) {
        return CoopOrgHelper.appendPropID(fieldNames);
    }

    private String[] getCoopFieldNameFromCtx(IServiceContext serviceContext, PermItemInfo permItemInfo) throws EASBizException {
        String[] orgFieldStr = PermissionUtil.getBizOrgCoopPropertyName(serviceContext.getContext(), BOSObjectType.create((String)permItemInfo.getObjectType()));
        return orgFieldStr;
    }
}

