/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.agentuser;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import org.apache.log4j.Logger;

public class PersonHelper {
    private static Logger logger = Logger.getLogger(PersonHelper.class);

    public FullOrgUnitCollection addUserOrgRange(Context ctx, IObjectPK newUserPK, PersonInfo personInfo, UserInfo newUserInfo) throws BOSException, EASBizException {
        int i;
        FullOrgUnitCollection retOrgCol = new FullOrgUnitCollection();
        if (newUserPK == null) {
            logger.error((Object)"newUserPK is null!");
            return retOrgCol;
        }
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitInfo adminOrgUnit = iPerson.getPrimaryAdminOrgUnit(personInfo.getId());
        AdminOrgUnitCollection adminCol = iPerson.getAllAdminOrgUnit(personInfo.getId());
        if (adminOrgUnit == null) {
            throw new BOSException("person  adminOrg is null , person id is:" + personInfo.getId().toString());
        }
        OrgUnitCollection hrOrgCol = new OrgUnitCollection();
        OrgUnitCollection fiOrgCol = new OrgUnitCollection();
        int size = adminCol.size();
        for (int i2 = 0; i2 < size; ++i2) {
            AdminOrgUnitInfo oneAdminOrg = adminCol.get(i2);
            if (oneAdminOrg == null) continue;
            hrOrgCol.addCollection(this.getHrOrgColByAdmin(ctx, oneAdminOrg));
            fiOrgCol.addCollection(this.getFiOrgColByAdmin(ctx, oneAdminOrg));
        }
        if (hrOrgCol == null) {
            hrOrgCol = new OrgUnitCollection();
        }
        if (fiOrgCol != null) {
            hrOrgCol.addCollection(fiOrgCol);
        }
        if (hrOrgCol.size() == 0 && fiOrgCol.size() == 0) {
            hrOrgCol.add((OrgUnitInfo)personInfo.getCU());
        }
        this.updateUserDefOrg(ctx, newUserPK, adminOrgUnit, hrOrgCol.get(0));
        OrgRangeCollection orgRangeCol = new OrgRangeCollection();
        for (i = 0; i < hrOrgCol.size(); ++i) {
            OrgRangeInfo orgRangeInfo = new OrgRangeInfo();
            orgRangeInfo.setUser(newUserInfo);
            orgRangeInfo.setOrg(hrOrgCol.get(i));
            orgRangeInfo.setType(OrgRangeType.BIZ_ORG_TYPE);
            orgRangeCol.add(orgRangeInfo);
            retOrgCol.add(hrOrgCol.get(i).castToFullOrgUnitInfo());
        }
        int size2 = adminCol.size();
        for (i = 0; i < size2; ++i) {
            OrgRangeInfo adminOrgRangeInfo = new OrgRangeInfo();
            adminOrgRangeInfo.setUser(newUserInfo);
            adminOrgRangeInfo.setOrg((OrgUnitInfo)adminCol.get(i));
            adminOrgRangeInfo.setType(OrgRangeType.ADMIN_ORG_TYPE);
            orgRangeCol.add(adminOrgRangeInfo);
        }
        IOrgRange iOrgRange = OrgRangeFactory.getLocalInstance(ctx);
        iOrgRange.addNewCol(orgRangeCol);
        return retOrgCol;
    }

    public FullOrgUnitCollection addUserOrgRange(Context ctx, IObjectPK newUserPK, PersonInfo personInfo) throws BOSException, EASBizException {
        UserInfo newUserInfo = new UserInfo();
        newUserInfo.setId(BOSUuid.read((String)newUserPK.toString()));
        return this.addUserOrgRange(ctx, newUserPK, personInfo, newUserInfo);
    }

    public static void deleteUserOrgRange(Context ctx, String userId) throws EASBizException, BOSException {
        IOrgRange iOrgRange = OrgRangeFactory.getLocalInstance(ctx);
        iOrgRange.deleteByUserId(userId, null);
    }

    private OrgUnitCollection getHrOrgColByAdmin(Context ctx, AdminOrgUnitInfo adminOrg) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection retCol = iOrgUnitRelation.getToUnit(adminOrg.getId().toString(), 0, 16);
        if (retCol == null) {
            retCol = new OrgUnitCollection();
        }
        return retCol;
    }

    private OrgUnitCollection getFiOrgColByAdmin(Context ctx, AdminOrgUnitInfo adminOrg) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection retCol = iOrgUnitRelation.getToUnit(adminOrg.getId().toString(), 0, 1);
        if (retCol == null) {
            retCol = new OrgUnitCollection();
        }
        return retCol;
    }

    private void updateUserDefOrg(Context ctx, IObjectPK newUserPK, AdminOrgUnitInfo adminOrgUnit, OrgUnitInfo orgInfo) throws BOSException, EASBizException {
        if (newUserPK == null) {
            return;
        }
        IUser iUser = UserFactory.getLocalInstance(ctx);
        UserInfo tempUserInfo = iUser.getUserInfo(newUserPK);
        FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
        if (this.getOrgUnitId(orgInfo) != null) {
            fullOrgUnitInfo.setId(this.getOrgUnitId(orgInfo));
            tempUserInfo.setDefOrgUnit(fullOrgUnitInfo);
            iUser.update(newUserPK, (CoreBaseInfo)tempUserInfo);
        }
    }

    private BOSUuid getOrgUnitId(OrgUnitInfo orgInfo) {
        if (orgInfo != null) {
            return orgInfo.getId();
        }
        return null;
    }
}

