/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.clear.scan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.ScanStatusEnum;
import com.kingdee.eas.base.permission.app.clear.common.AbstractScan;
import com.kingdee.eas.base.permission.app.clear.common.PermClearUtils;
import com.kingdee.eas.base.permission.app.clear.scan.IPermClearStrategyScan;
import com.kingdee.eas.base.permission.app.clear.scan.PermClearScanResult;
import com.kingdee.eas.base.permission.app.clear.scan.PermClearStrategyScanBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PermClearScan
extends AbstractScan {
    public static final String selectStrategyIds = "selectStrategyIds[]";
    private String scanId;
    private PermClearScanResult scanGatherResult = new PermClearScanResult();
    private List<PermClearStrategyScanBean> strategyScanList = new ArrayList<PermClearStrategyScanBean>();

    @Override
    public void execScaning(Context ctx) throws BOSException {
        int finishedStrategys = 0;
        for (PermClearStrategyScanBean bean : this.strategyScanList) {
            bean.scan(ctx);
            this.scanGatherResult.setScanStrategys(++finishedStrategys);
        }
    }

    @Override
    public boolean refreshScan() {
        if (this.scanStatus == ScanStatusEnum.UNSTARTED) {
            return false;
        }
        this.scanUpdateTime = PermClearUtils.getDateStr(new Date());
        int usersCounts = 0;
        int permCounts = 0;
        int orgCounts = 0;
        int roleCounts = 0;
        int dataCounts = 0;
        for (PermClearStrategyScanBean bean : this.strategyScanList) {
            bean.refreshScan();
            IPermClearStrategyScan permClearStrategyScan = bean.getPermClearStrategyScan();
            usersCounts += permClearStrategyScan.getScanUsersCounts();
            permCounts += permClearStrategyScan.getScanPermCounts();
            orgCounts += permClearStrategyScan.getScanOrgCounts();
            roleCounts += permClearStrategyScan.getScanRoleCounts();
            dataCounts += permClearStrategyScan.getScanDataCounts();
        }
        this.scanGatherResult.setUsersCounts(usersCounts);
        this.scanGatherResult.setPermCounts(permCounts);
        this.scanGatherResult.setOrgCounts(orgCounts);
        this.scanGatherResult.setRoleCounts(roleCounts);
        this.scanGatherResult.setScanDataCounts(dataCounts);
        return this.isScanFinished;
    }

    public String getScanId() {
        return this.scanId;
    }

    public void setScanId(String scanId) {
        this.scanId = scanId;
    }

    @Override
    public String getScanStartTime() {
        return this.scanStartTime;
    }

    @Override
    public void setScanStartTime(String scanStartTime) {
        this.scanStartTime = scanStartTime;
    }

    @Override
    public String getScanEndTime() {
        return this.scanEndTime;
    }

    @Override
    public String getScanUpdateTime() {
        return this.scanUpdateTime;
    }

    @Override
    public void setScanUpdateTime(String scanUpdateTime) {
        this.scanUpdateTime = scanUpdateTime;
    }

    @Override
    public void setScanEndTime(String scanEndTime) {
        this.scanEndTime = scanEndTime;
    }

    @Override
    public ScanStatusEnum getScanStatus() {
        return this.scanStatus;
    }

    @Override
    public void setScanStatus(ScanStatusEnum scanStatus) {
        this.scanStatus = scanStatus;
    }

    public PermClearScanResult getScanGatherResult() {
        return this.scanGatherResult;
    }

    public void setScanGatherResult(PermClearScanResult scanGatherResult) {
        this.scanGatherResult = scanGatherResult;
    }

    public List<PermClearStrategyScanBean> getStrategyScanList() {
        return this.strategyScanList;
    }

    public void setStrategyScanList(List<PermClearStrategyScanBean> strategyScanList) {
        this.strategyScanList = strategyScanList;
    }
}

