/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.clear.scan.permrank;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.permission.ScanStatusEnum;
import com.kingdee.eas.base.permission.app.clear.common.AbstractScan;
import com.kingdee.eas.base.permission.app.clear.scan.IPermClearScanUnit;
import com.kingdee.eas.base.permission.app.clear.scan.permrank.PermRankScan;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class PermRankScanUnit
extends AbstractScan
implements IPermClearScanUnit {
    private static Logger logger = Logger.getLogger((String)PermRankScanUnit.class.getName());
    private static String scanSql1 = "select forgid,fpermitemid from t_Pm_Userorgperm where fowner = ?";
    private static String scanSql2 = "select forgid,froleid from t_Pm_Userroleorg  where fuserid = ?";
    protected String userId;
    protected String userNumber;
    protected String userName;
    private int permCounts = 0;
    private int orgCounts = 0;
    private int roleCounts = 0;

    @Override
    public void execScaning(Context ctx) throws BOSException, SQLException {
        HashSet<String> orgIds = new HashSet<String>();
        HashSet<String> roleIds = new HashSet<String>();
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(scanSql1);
            statement.setString(1, this.userId);
            rs = statement.executeQuery();
            while (rs.next()) {
                orgIds.add(rs.getString("forgid"));
                this.orgCounts = orgIds.size();
                ++this.permCounts;
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(scanSql2);
            statement.setString(1, this.userId);
            rs = statement.executeQuery();
            while (rs.next()) {
                orgIds.add(rs.getString("forgid"));
                roleIds.add(rs.getString("froleid"));
                this.orgCounts = orgIds.size();
                this.roleCounts = roleIds.size();
                ++this.permCounts;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        }
    }

    @Override
    public ScanStatusEnum getScanStatus() {
        return this.scanStatus;
    }

    @Override
    public int getScanDataCounts() {
        return this.permCounts;
    }

    @Override
    public int getScanUsersCounts() {
        return this.isScanFinished ? 1 : 0;
    }

    @Override
    public int getScanRoleCounts() {
        return this.roleCounts;
    }

    @Override
    public int getScanPermCounts() {
        return this.permCounts;
    }

    @Override
    public int getScanOrgCounts() {
        return this.orgCounts;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserNumber() {
        return this.userNumber;
    }

    public void setUserNumber(String userNumber) {
        this.userNumber = userNumber;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public static void main(String[] args) {
        String scan = new Gson().toJson((Object)new PermRankScanUnit());
        System.out.println(scan);
        PermRankScan permRankScan = (PermRankScan)new Gson().fromJson(scan, PermRankScan.class);
        scan = new Gson().toJson((Object)new PermRankScanUnit());
        System.out.println(scan);
    }
}

