/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.clear.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCRegister;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.permission.IPermClearTask;
import com.kingdee.eas.base.permission.PermClearTaskCollection;
import com.kingdee.eas.base.permission.PermClearTaskFactory;
import com.kingdee.eas.base.permission.PermClearTaskInfo;
import com.kingdee.eas.base.permission.PermClearTaskStatusEnum;
import com.kingdee.eas.base.permission.StrategyTypeEnum;
import com.kingdee.eas.base.permission.app.clear.task.PermClearQuartzManager;
import com.kingdee.eas.base.permission.app.clear.task.job.jobs.IdleUserClearJob;
import com.kingdee.eas.base.permission.app.clear.task.job.jobs.InvalidDataClearJob;
import com.kingdee.eas.base.permission.app.clear.task.job.jobs.PermRankClearJob;
import com.kingdee.eas.base.permission.app.clear.task.job.jobs.PermRepeatClearJob;
import com.kingdee.eas.common.EASBizException;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.quartz.JobDataMap;
import org.quartz.SchedulerException;

public class PermClearSchedulerManager {
    private static final Logger logger = Logger.getLogger(PermClearSchedulerManager.class);

    public static void startInitLoad() throws Exception {
        DCRegister dcRegister = new DCRegister();
        ArrayList dcList = dcRegister.getDCList();
        if (dcList == null || dcList.size() < 0) {
            return;
        }
        Iterator it = dcList.iterator();
        while (it.hasNext()) {
            String dataSourceAIS = ((DCInfo)it.next()).getNumber();
            Context ctx = new Context();
            ctx.setAIS(dataSourceAIS);
            PermClearSchedulerManager.initload(ctx);
        }
    }

    public static void initload(Context ctx) throws IOException, SchedulerException, ParseException, BOSException {
        PermClearQuartzManager.shutdownJobs();
        IPermClearTask iPermClearTask = PermClearTaskFactory.getLocalInstance(ctx);
        PermClearTaskCollection permClearTaskCollection = iPermClearTask.getPermClearTaskCollection("select * ,strategy.* where taskStatus in ('10','20','30')");
        for (int i = 0; i < permClearTaskCollection.size(); ++i) {
            PermClearTaskInfo permClearTaskInfo = permClearTaskCollection.get(i);
            PermClearSchedulerManager.tryLoadJob(ctx, permClearTaskInfo);
        }
    }

    public static boolean tryLoadJob(Context ctx, PermClearTaskInfo permClearTaskInfo) throws BOSException {
        String taskId = permClearTaskInfo.getId().toString();
        PermClearTaskStatusEnum taskStatus = permClearTaskInfo.getTaskStatus();
        if (taskStatus == PermClearTaskStatusEnum.submitted || taskStatus == PermClearTaskStatusEnum.waiting) {
            Timestamp planExecTime = permClearTaskInfo.getPlanExecTime();
            if (planExecTime.getTime() - new Date().getTime() > 10000L) {
                String strategyNumber = permClearTaskInfo.getStrategy().getNumber();
                Class jobClass = PermClearSchedulerManager.getJobClass(strategyNumber);
                String cron = PermClearSchedulerManager.getCron(planExecTime);
                PermClearQuartzManager.removeJob(taskId);
                JobDataMap jobDataMap = new JobDataMap();
                jobDataMap.put("eas-context", (Object)ctx);
                PermClearQuartzManager.addJob(taskId, jobDataMap, jobClass, cron);
                DbUtil.execute((Context)ctx, (String)"update T_PM_PermClearTask set ftaskStatus='20' where fid = ?", (Object[])new Object[]{taskId});
                return true;
            }
            DbUtil.execute((Context)ctx, (String)"update T_PM_PermClearTask set ftaskStatus='100' where fid = ?", (Object[])new Object[]{taskId});
        } else if (taskStatus == PermClearTaskStatusEnum.execing) {
            DbUtil.execute((Context)ctx, (String)"update T_PM_PermClearTask set ftaskStatus='50' where fid = ?", (Object[])new Object[]{taskId});
        }
        return false;
    }

    public static void tryLoadJob(Context ctx, String taskId) throws BOSException, EASBizException {
        IPermClearTask iPermClearTask = PermClearTaskFactory.getLocalInstance(ctx);
        PermClearTaskInfo permClearTaskInfo = iPermClearTask.getPermClearTaskInfo((IObjectPK)new ObjectStringPK(taskId));
        PermClearSchedulerManager.tryLoadJob(ctx, permClearTaskInfo);
    }

    public static Class getJobClass(String strategyNumber) {
        StrategyTypeEnum strategyTypeEnum = StrategyTypeEnum.getEnum(strategyNumber);
        if (strategyTypeEnum == StrategyTypeEnum.PermRank) {
            return PermRankClearJob.class;
        }
        if (strategyTypeEnum == StrategyTypeEnum.PermRpeat) {
            return PermRepeatClearJob.class;
        }
        if (strategyTypeEnum == StrategyTypeEnum.IdleUser) {
            return IdleUserClearJob.class;
        }
        if (strategyTypeEnum == StrategyTypeEnum.InvalidData) {
            return InvalidDataClearJob.class;
        }
        return null;
    }

    public static String getCron(Timestamp date) {
        SimpleDateFormat sdf = new SimpleDateFormat("ss mm HH dd MM ? yyyy");
        String formatTimeStr = "";
        if (date != null) {
            formatTimeStr = sdf.format(date);
        }
        return formatTimeStr;
    }

    public static void main(String[] args) {
    }
}

