/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.helper;

import com.kingdee.bos.framework.cache.CustomCacheService;
import java.util.List;
import org.apache.log4j.Logger;

public class PermCacheHelper {
    public static int FUNCTIONPERMCACHE = 0;
    public static int ORGPERMCACHE = 1;
    public static int ORGRANGECACHE = 2;
    public static int AUTHENPERMCACHE = 3;
    public static String NEEDAUTHEN = "needAuthen";
    private static Logger logger = Logger.getLogger(PermCacheHelper.class);
    static ThreadLocal<Long> timeThread = new ThreadLocal();
    static CustomCacheService functionPermCache = new CustomCacheService("permission.funcPerm");
    static CustomCacheService orgPermCache = new CustomCacheService("permission.orgPerm");
    static CustomCacheService orgRangePermCache = new CustomCacheService("permission.orgRangePerm");
    static CustomCacheService authenPermCache = new CustomCacheService("permission.authenPerm");

    public static Object getPermCacheValue(int cacheType, String key1, String key2) {
        Object result = null;
        switch (cacheType) {
            case 0: {
                long t1 = System.currentTimeMillis();
                result = functionPermCache.hget(key1, key2);
                if (result == null) {
                    timeThread.set(t1);
                } else {
                    logger.error((Object)("-------------hadcacheCOST-----functionPermCache------------" + (System.currentTimeMillis() - t1)));
                }
                return result;
            }
            case 1: {
                long t2 = System.currentTimeMillis();
                result = orgPermCache.hget(key1, key2);
                if (result == null) {
                    timeThread.set(t2);
                } else {
                    logger.error((Object)("-------------hadcacheCOST----orgPermCache-------------" + (System.currentTimeMillis() - t2)));
                }
                return result;
            }
            case 2: {
                long t3 = System.currentTimeMillis();
                result = orgRangePermCache.hget(key1, key2);
                if (result == null) {
                    timeThread.set(t3);
                } else {
                    logger.error((Object)("-------------hadcacheCOST-------orgRangePermCache----------" + (System.currentTimeMillis() - t3)));
                }
                return result;
            }
        }
        return null;
    }

    public static void putPermCacheValue(int cacheType, String key1, String key2, Object value) {
        long t1 = System.currentTimeMillis();
        switch (cacheType) {
            case 0: {
                functionPermCache.hset(key1, key2, value);
                break;
            }
            case 1: {
                orgPermCache.hset(key1, key2, value);
                break;
            }
            case 2: {
                orgRangePermCache.hset(key1, key2, value);
            }
        }
    }

    public static void removePermCache(int cacheType, String key) {
        switch (cacheType) {
            case 0: {
                functionPermCache.hdel(key);
                break;
            }
            case 1: {
                orgPermCache.hdel(key);
                break;
            }
            case 2: {
                orgRangePermCache.hdel(key);
            }
        }
    }

    public static void removePermCacheByField(int cacheType, String key, String field) {
        switch (cacheType) {
            case 0: {
                functionPermCache.hdel(key, field);
                break;
            }
            case 1: {
                orgPermCache.hdel(key, field);
                break;
            }
            case 2: {
                orgRangePermCache.hdel(key, field);
            }
        }
    }

    public static void updatePermCacheValue(int cacheType, String key, String field, Object value) {
        List valueList = null;
        switch (cacheType) {
            case 0: {
                break;
            }
            case 1: {
                valueList = (List)orgPermCache.hget(key, field);
                if (valueList == null || valueList.contains(value)) break;
                valueList.add(value);
                break;
            }
            case 2: {
                valueList = (List)orgRangePermCache.hget(key, field);
                if (valueList == null || valueList.contains(value)) break;
                valueList.add(value);
            }
        }
    }

    public static void removeCacheByType(int cacheType) {
        switch (cacheType) {
            case 0: {
                functionPermCache.removeAll();
                break;
            }
            case 1: {
                orgPermCache.removeAll();
                break;
            }
            case 2: {
                orgRangePermCache.removeAll();
            }
        }
    }
}

