/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.scheduler;

import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.eas.base.permission.app.scheduler.JobConfig;
import com.kingdee.eas.base.permission.app.scheduler.JobConfigsLoader;
import com.kingdee.eas.base.permission.app.scheduler.job.ReLoadJobConfigsJob;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.triggers.CronTriggerImpl;

public class PermissionScheduler {
    private static final Logger logger = Logger.getLogger(PermissionScheduler.class);
    private static String permissionSchedulerInstanceName = "permissionSchedulerCommon";
    private static StdSchedulerFactory schedulerFactory = null;
    private static String fileChangeCheckTriggerCron = "0 0/10 * * * ?";
    private static List<JobConfig> jobConfigs = new ArrayList<JobConfig>();
    private static Scheduler scheduler = null;

    private static void init() throws SchedulerException {
        Properties props = new Properties();
        props.put("org.quartz.scheduler.instanceName", permissionSchedulerInstanceName);
        props.put("org.quartz.scheduler.rmi.export", "false");
        props.put("org.quartz.scheduler.rmi.proxy", "false");
        props.put("org.quartz.scheduler.wrapJobExecutionInUserTransaction", "false");
        props.put("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        props.put("org.quartz.threadPool.threadCount", "10");
        props.put("org.quartz.threadPool.threadPriority", "5");
        props.put("org.quartz.threadPool.threadsInheritContextClassLoaderOfInitializingThread", "true");
        props.put("org.quartz.jobStore.misfireThreshold", "60000");
        props.put("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
        schedulerFactory = new StdSchedulerFactory(props);
    }

    public static void start() throws IOException, SchedulerException, ParseException {
        if (PermissionScheduler.isLicenseMainInstance()) {
            PermissionScheduler.init();
            List<JobConfig> loadJobConfigs = JobConfigsLoader.loadJobConfigs();
            PermissionScheduler.reStart(loadJobConfigs);
            logger.error((Object)"\u6743\u9650\u670d\u52a1\u8c03\u5ea6\u4efb\u52a1\u542f\u52a8\u5b8c\u6210\uff01");
        } else {
            logger.error((Object)"\u975e\u4e3b\u5b9e\u4f8b\u4e0d\u91cd\u590d\u542f\u52a8\u8c03\u52a8\u4efb\u52a1\uff01");
        }
    }

    public static void reStart(List<JobConfig> newJobConfigs) throws SchedulerException, ParseException {
        if (newJobConfigs == null) {
            return;
        }
        jobConfigs = newJobConfigs;
        if (scheduler != null && !scheduler.isShutdown()) {
            scheduler.shutdown();
        }
        scheduler = schedulerFactory.getScheduler();
        PermissionScheduler.registReLoadJobConfigsJob();
        PermissionScheduler.registJobs();
        scheduler.start();
    }

    private static void registReLoadJobConfigsJob() throws SchedulerException, ParseException {
        JobDetailImpl jobDetail = new JobDetailImpl();
        jobDetail.setName("reLoadJobConfigsJob");
        jobDetail.setJobClass(ReLoadJobConfigsJob.class);
        CronTriggerImpl cronTrigger = new CronTriggerImpl();
        cronTrigger.setCronExpression(fileChangeCheckTriggerCron);
        cronTrigger.setName("reLoadJobConfigsTrigger");
        scheduler.scheduleJob((JobDetail)jobDetail, (Trigger)cronTrigger);
    }

    private static boolean registJobs() {
        int name = 0;
        for (JobConfig jobConfig : jobConfigs) {
            try {
                String[] jobTriggers;
                if (jobConfig.isStop()) continue;
                for (String jobTrigger : jobTriggers = jobConfig.getJobTrigger()) {
                    JobDetailImpl jobDetail = new JobDetailImpl();
                    jobDetail.setName("reLoadJobConfigsJob" + ++name);
                    Class<?> clazz = Class.forName(jobConfig.getJobClass());
                    jobDetail.setJobClass(clazz);
                    CronTriggerImpl cronTrigger = new CronTriggerImpl();
                    cronTrigger.setCronExpression(jobTrigger);
                    cronTrigger.setName("reLoadJobConfigsTrigger" + name);
                    scheduler.scheduleJob((JobDetail)jobDetail, (Trigger)cronTrigger);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                e.printStackTrace();
            }
        }
        return true;
    }

    private static boolean isLicenseMainInstance() {
        ORMServiceLocation loc = new ORMServiceLocation("license");
        return loc.isLocal();
    }
}

