/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinItemCollection;
import com.kingdee.bos.metadata.query.JoinItemInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.FieldAccessCollection;
import com.kingdee.eas.base.permission.FieldAccessException;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.service.IFieldPermissionService;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FieldPermissionService
implements IFieldPermissionService {
    private static Logger logger = Logger.getLogger(FieldPermissionService.class);
    private Context context = null;
    private Map<String, EntityObjectInfo> bizEntityObjectInfosCache = new HashMap<String, EntityObjectInfo>();
    private IMetaDataLoader loader = null;
    public static final String NONE = "NONE";
    private static final String FIELDACCESS_KEY_SPLIT = "&";
    private static final String ENTITYMAPFIELD_SPLIT = "-";
    private static final String FIELDS_SPLIT = ".";
    private static final String ID = "id";

    public FieldPermissionService(Context context) {
        this.context = context;
        this.loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)context);
    }

    @Override
    public FieldPermission getFieldPermission(BOSObjectType bizObjectType, IObjectPK userPK, IObjectPK orgPK) throws BOSException, EASBizException {
        assert (bizObjectType != null && userPK != null);
        FieldPermission result = new FieldPermission();
        EntityObjectInfo entity = this.loader.getEntity(bizObjectType);
        if (!this.isEnableFieldPermission(entity)) {
            return result;
        }
        OrgType orgType = PermissionCommonUtil.getMainBizOrgType(entity);
        orgPK = PermissionUtil.getPermissionOrgPK(this.context, orgType, orgPK, null);
        if (orgPK == null) {
            throw new FieldAccessException(FieldAccessException.GET_ORG_FAIL);
        }
        ArrayList<String> bizObjectTypeStrs = new ArrayList<String>();
        bizObjectTypeStrs.add(bizObjectType.toString());
        FieldAccessCollection fieldAccessColl = new FieldAccessCollection();
        if (OrgType.NONE.equals((Object)orgType)) {
            fieldAccessColl = this.batchGetFieldAccessColl(userPK.toString(), bizObjectTypeStrs);
        } else {
            ArrayList<String> orgIds = new ArrayList<String>();
            orgIds.add(orgPK.toString());
            fieldAccessColl = this.batchGetFieldAccessColl(userPK.toString(), orgIds, bizObjectTypeStrs);
        }
        this.filterMinFieldAccessColl(fieldAccessColl);
        result.addCollection(fieldAccessColl);
        return result;
    }

    @Override
    public FieldPermission getQueryFieldPermission(IMetaDataPK queryPK, IObjectPK userPK, IObjectPK orgPK) throws BOSException, EASBizException {
        Map<String, FieldPermission> map;
        FieldPermission ret = new FieldPermission();
        if (queryPK == null) {
            return ret;
        }
        ArrayList<String> orgPKList = new ArrayList<String>();
        if (orgPK != null) {
            orgPKList.add(orgPK.toString());
        }
        if ((map = this.getQueryFieldPermission(queryPK, userPK, orgPKList)) != null && map.size() > 0) {
            ret = (FieldPermission)map.values().toArray()[0];
        }
        return ret;
    }

    @Override
    public Map<String, FieldPermission> getQueryFieldPermission(IMetaDataPK queryPK, IObjectPK userPK, Collection orgPKCol) throws BOSException, EASBizException {
        if (queryPK == null) {
            return new HashMap<String, FieldPermission>();
        }
        ArrayList<String> orgIds = new ArrayList<String>();
        if (orgPKCol != null) {
            for (Object orgPk : orgPKCol) {
                if (orgPk == null) continue;
                orgIds.add(orgPk.toString());
            }
        }
        return this.getQueryFieldPermissions(queryPK, userPK, orgIds);
    }

    private FieldAccessCollection batchGetFieldAccessColl(String userId, Collection<String> orgIds, Collection<String> bizObjectTypes) throws BOSException, EASBizException {
        String orgidsIn = ToolUtils.aryToStr(orgIds);
        String bizObjectTypesIn = ToolUtils.aryToStr(bizObjectTypes);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FORGID,                                                                ").append("        FBIZOBJECTTYPE,                                                        ").append("        FFIELDNAME,                                                            ").append("        FACCESSVALUE                                                           ").append("   FROM (                                                                      ").append("                                                                               ").append("         SELECT FORGID, FBIZOBJECTTYPE, FFIELDNAME, FACCESSVALUE               ").append("           FROM T_PM_FIELDACCESS                                               ").append("          WHERE FUSERID = ?                                                    ").append("            AND FORGID IN (" + orgidsIn + ")                                       ").append("            AND FBIZOBJECTTYPE IN (" + bizObjectTypesIn + ")                       ").append("                                                                               ").append("         UNION ALL                                                             ").append("                                                                               ").append("         SELECT URO.FORGID AS FORGID, FBIZOBJECTTYPE, FFIELDNAME, FACCESSVALUE ").append("           FROM T_PM_FIELDACCESS FA                                            ").append("          INNER JOIN T_PM_USERROLEORG URO                                      ").append("             ON FA.FROLEID = URO.FROLEID                                       ").append("          WHERE URO.FUSERID = ?                                                ").append("            AND URO.FORGID IN (" + orgidsIn + ")                                   ").append("            AND FA.FBIZOBJECTTYPE IN (" + bizObjectTypesIn + ")                    ").append("                                                                               ").append("         ) FIELDACCESS                                                         ").append("                                                                               ").append("  WHERE EXISTS (SELECT 1                                                       ").append("           FROM T_PM_FIELDACCESSSTRATEGY FT                                    ").append("          INNER JOIN T_ORG_BASEUNIT BASEORG                                    ").append("             ON FT.FCONTROLUNITID = BASEORG.FCONTROLUNITID                     ").append("          WHERE BASEORG.FID = FORGID                                           ").append("            AND FT.FBIZOBJECTTYPE = FIELDACCESS.FBIZOBJECTTYPE                 ").append("            AND FT.FFIELDNAME = FIELDACCESS.FFIELDNAME                         ").append("            AND FT.FENABLEACCESSCONTROL = '1')                                 ");
        Object[] params = new Object[]{userId, userId};
        IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])params);
        FieldAccessCollection fieldAccessColl = new FieldAccessCollection();
        try {
            while (rowSet.next()) {
                FieldAccessInfo info = new FieldAccessInfo();
                UserInfo user = new UserInfo();
                user.setId(BOSUuid.read((String)userId));
                String forgid = rowSet.getString("FORGID");
                FullOrgUnitInfo org = new FullOrgUnitInfo();
                org.setId(BOSUuid.read((String)forgid));
                String fbizobjecttype = rowSet.getString("FBIZOBJECTTYPE");
                String fieldName = rowSet.getString("FFIELDNAME");
                int accessValue = rowSet.getInt("FACCESSVALUE");
                info.setUser(user);
                info.setOrg(org);
                info.setBizObjectType(fbizobjecttype);
                info.setFieldName(fieldName);
                info.setAccessValue(accessValue);
                fieldAccessColl.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return fieldAccessColl;
    }

    private FieldAccessCollection batchGetFieldAccessColl(String userId, Collection<String> nonebizObjectTypes) throws BOSException, EASBizException {
        String bizObjectTypesIn = ToolUtils.aryToStr(nonebizObjectTypes);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FORGID,                                                                ").append("        FBIZOBJECTTYPE,                                                        ").append("        FFIELDNAME,                                                            ").append("        FACCESSVALUE                                                           ").append("   FROM (                                                                      ").append("                                                                               ").append("         SELECT FORGID, FBIZOBJECTTYPE, FFIELDNAME, FACCESSVALUE               ").append("           FROM T_PM_FIELDACCESS                                               ").append("          WHERE FUSERID = ?                                                    ").append("            AND FORGID = '11111111-1111-1111-1111-111111111111CCE7AED4'                          ").append("            AND FBIZOBJECTTYPE IN (" + bizObjectTypesIn + ")                       ").append("                                                                               ").append("         UNION ALL                                                             ").append("                                                                               ").append("         SELECT '11111111-1111-1111-1111-111111111111CCE7AED4' AS FORGID, FBIZOBJECTTYPE, FFIELDNAME, FACCESSVALUE ").append("           FROM T_PM_FIELDACCESS FA                                            ").append("          INNER JOIN T_PM_USERROLEORG URO                                      ").append("             ON FA.FROLEID = URO.FROLEID                                       ").append("          WHERE URO.FUSERID = ?                                                ").append("            AND FA.FBIZOBJECTTYPE IN (" + bizObjectTypesIn + ")                    ").append("                                                                               ").append("         ) FIELDACCESS                                                         ").append("                                                                               ").append("  WHERE EXISTS (SELECT 1                                                       ").append("           FROM T_PM_FIELDACCESSSTRATEGY FT                                    ").append("          INNER JOIN T_ORG_BASEUNIT BASEORG                                    ").append("             ON FT.FCONTROLUNITID = BASEORG.FCONTROLUNITID                     ").append("          WHERE BASEORG.FID = FORGID                                           ").append("            AND FT.FBIZOBJECTTYPE = FIELDACCESS.FBIZOBJECTTYPE                 ").append("            AND FT.FFIELDNAME = FIELDACCESS.FFIELDNAME                         ").append("            AND FT.FENABLEACCESSCONTROL = '1')                                 ");
        Object[] params = new Object[]{userId, userId};
        IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])params);
        FieldAccessCollection fieldAccessColl = new FieldAccessCollection();
        try {
            while (rowSet.next()) {
                FieldAccessInfo info = new FieldAccessInfo();
                UserInfo user = new UserInfo();
                user.setId(BOSUuid.read((String)userId));
                String forgid = rowSet.getString("FORGID");
                FullOrgUnitInfo org = new FullOrgUnitInfo();
                org.setId(BOSUuid.read((String)forgid));
                String fbizobjecttype = rowSet.getString("FBIZOBJECTTYPE");
                String fieldName = rowSet.getString("FFIELDNAME");
                int accessValue = rowSet.getInt("FACCESSVALUE");
                info.setUser(user);
                info.setOrg(org);
                info.setBizObjectType(fbizobjecttype);
                info.setFieldName(fieldName);
                info.setAccessValue(accessValue);
                fieldAccessColl.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return fieldAccessColl;
    }

    private void filterMinFieldAccessColl(FieldAccessCollection fieldAccessColl) {
        HashMap<String, FieldAccessInfo> minOrgFieldsValue = new HashMap<String, FieldAccessInfo>();
        int i = 0;
        while (i < fieldAccessColl.size()) {
            FieldAccessInfo fieldAccess = fieldAccessColl.get(i);
            String key = this.getUniqueKey(fieldAccess);
            FieldAccessInfo minFieldAccessInfo = (FieldAccessInfo)minOrgFieldsValue.get(key);
            if (minFieldAccessInfo == null) {
                minOrgFieldsValue.put(key, fieldAccess);
                ++i;
                continue;
            }
            if (fieldAccess.getAccessValue() < minFieldAccessInfo.getAccessValue()) {
                fieldAccessColl.removeObject((IObjectValue)minFieldAccessInfo);
                minOrgFieldsValue.put(key, fieldAccess);
                continue;
            }
            fieldAccessColl.removeObject((IObjectValue)fieldAccess);
        }
    }

    private boolean isEnableFieldPermission(EntityObjectInfo entity) {
        String value = entity.getExtendedProperty("enableFieldPermission");
        if (StringUtils.isEmpty((String)value)) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public Map<String, List<String>> getQueryFieldsMap(IMetaDataPK queryPK) throws BOSException, EASBizException {
        Map<String, List<String>> queryFields = new HashMap<String, List<String>>();
        QueryInfo queryInfo = this.loader.getQuery(queryPK);
        if (queryInfo == null) {
            logger.error((Object)(queryPK.toString() + " is been loaded return null ! "));
            return queryFields;
        }
        if (queryInfo instanceof JoinQueryInfo) {
            JoinQueryInfo joinQueryInfo = (JoinQueryInfo)queryInfo;
            queryFields = this.getJoinQueryFieldsStructs(joinQueryInfo);
        } else if (queryInfo instanceof UnionQueryInfo) {
            UnionQueryInfo unionQueryInfo = (UnionQueryInfo)queryInfo;
            queryFields = this.getUnionQueryFieldsMap(unionQueryInfo);
        }
        return queryFields;
    }

    private Map<String, List<String>> getUnionQueryFieldsMap(UnionQueryInfo parentUnionQueryInfo) throws BOSException, EASBizException {
        SubQueryInfo subQueryInfo = (SubQueryInfo)parentUnionQueryInfo.getMainObject();
        QueryInfo mainQueryInfo = subQueryInfo.getQueryRef();
        if (mainQueryInfo instanceof JoinQueryInfo) {
            JoinQueryInfo joinQueryInfo = (JoinQueryInfo)mainQueryInfo;
            return this.getJoinQueryFieldsStructs(joinQueryInfo);
        }
        if (mainQueryInfo instanceof UnionQueryInfo) {
            UnionQueryInfo unionQueryInfo = (UnionQueryInfo)mainQueryInfo;
            return this.getUnionQueryFieldsMap(unionQueryInfo);
        }
        throw new IllegalArgumentException("subQueryInfo is error!");
    }

    public Map<String, List<String>> getJoinQueryFieldsStructs(JoinQueryInfo queryInfo) throws BOSException, EASBizException {
        HashMap<String, List<String>> queryFields = new HashMap<String, List<String>>();
        PropertyUnitCollection propertyUnitCollection = queryInfo.getUnits();
        QueryFieldCollection queryFieldCollection = propertyUnitCollection.getQueryFields();
        for (int i = 0; i < queryFieldCollection.size(); ++i) {
            ArrayList<String> linkEntityFields;
            QueryFieldInfo queryFieldInfo = queryFieldCollection.get(i);
            List<String> queryFieldLinkEntityFields = this.getQueryFieldLinkEntityFields(queryFieldInfo, linkEntityFields = new ArrayList<String>());
            if (queryFieldLinkEntityFields == null || queryFieldLinkEntityFields.isEmpty()) continue;
            queryFields.put(queryFieldInfo.getName(), queryFieldLinkEntityFields);
        }
        return queryFields;
    }

    private Map<String, FieldPermission> getQueryFieldPermissions(IMetaDataPK queryPK, IObjectPK userPK, Collection<String> orgs) throws BOSException, EASBizException {
        Map<String, List<String>> queryfieldsMap = this.getQueryFieldsMap(queryPK);
        List<String> bizObjTypes = this.getAllBizObjTypes(queryfieldsMap);
        Map<String, FieldAccessCollection> orgFieldAccessCollection = this.batchgetOrgFieldAccessCollMap(userPK, orgs, bizObjTypes);
        Map<String, Map<String, FieldAccessInfo>> entityFieldPermissions = this.getEntityFieldPermissions(orgFieldAccessCollection);
        Set<String> keySet = entityFieldPermissions.keySet();
        HashMap<String, FieldPermission> FieldPermissions = new HashMap<String, FieldPermission>();
        for (String orgId : keySet) {
            Map<String, FieldAccessInfo> FieldAccessMap = entityFieldPermissions.get(orgId);
            FieldAccessCollection queryFieldAccessCollections = this.convertToQueryFieldAccessCollections(queryfieldsMap, FieldAccessMap);
            FieldPermission fieldPermission = new FieldPermission();
            fieldPermission.addCollection(queryFieldAccessCollections);
            FieldPermissions.put(orgId, fieldPermission);
        }
        return FieldPermissions;
    }

    private List<String> getAllBizObjTypes(Map<String, List<String>> queryfieldsMap) {
        HashSet<String> bizObjTypes = new HashSet<String>();
        Collection<List<String>> values = queryfieldsMap.values();
        for (List<String> objFields : values) {
            for (String objField : objFields) {
                String bizObjType = objField.substring(0, objField.indexOf(ENTITYMAPFIELD_SPLIT));
                bizObjTypes.add(bizObjType);
            }
        }
        return new ArrayList<String>(bizObjTypes);
    }

    private Map<String, Map<String, FieldAccessInfo>> getEntityFieldPermissions(Map<String, FieldAccessCollection> orgFieldAccessCollection) {
        HashMap<String, Map<String, FieldAccessInfo>> orgFieldAccessMap = new HashMap<String, Map<String, FieldAccessInfo>>();
        Set<String> keySet = orgFieldAccessCollection.keySet();
        for (String orgId : keySet) {
            FieldAccessCollection fieldAccessCollection = orgFieldAccessCollection.get(orgId);
            HashMap<String, FieldAccessInfo> queryFields = new HashMap<String, FieldAccessInfo>();
            for (int i = 0; i < fieldAccessCollection.size(); ++i) {
                FieldAccessInfo fieldAccessInfo = fieldAccessCollection.get(i);
                String bizObjectType = fieldAccessInfo.getBizObjectType();
                String fieldName = fieldAccessInfo.getFieldName();
                String key = this.getUnionKey(bizObjectType, fieldName);
                queryFields.put(key, fieldAccessInfo);
            }
            orgFieldAccessMap.put(orgId, queryFields);
        }
        return orgFieldAccessMap;
    }

    private Map<String, FieldAccessCollection> batchgetOrgFieldAccessCollMap(IObjectPK userPK, Collection<String> orgs, List<String> bizObjTypes) throws BOSException, EASBizException {
        FieldAccessCollection fieldAccessCollection = new FieldAccessCollection();
        FieldAccessCollection noneOrgfieldAccessCollection = new FieldAccessCollection();
        List<String> noneBizObjTypes = this.getNonebizObjTypes(bizObjTypes);
        bizObjTypes.removeAll(noneBizObjTypes);
        if (bizObjTypes.size() > 0) {
            fieldAccessCollection.addCollection(this.batchGetFieldAccessColl(userPK.toString(), orgs, bizObjTypes));
            this.filterMinFieldAccessColl(fieldAccessCollection);
        }
        if (noneBizObjTypes.size() > 0) {
            noneOrgfieldAccessCollection = this.batchGetFieldAccessColl(userPK.toString(), noneBizObjTypes);
            this.filterMinFieldAccessColl(noneOrgfieldAccessCollection);
        }
        return this.getOrgFieldAccessCollection(fieldAccessCollection, noneOrgfieldAccessCollection);
    }

    private Map<String, FieldAccessCollection> getOrgFieldAccessCollection(FieldAccessCollection fieldAccessCollection, FieldAccessCollection noneOrgfieldAccessCollection) {
        HashMap<String, FieldAccessCollection> orgFieldAccessMap = new HashMap<String, FieldAccessCollection>();
        for (int i = 0; i < fieldAccessCollection.size(); ++i) {
            FieldAccessInfo fieldAccessInfo = fieldAccessCollection.get(i);
            String orgId = fieldAccessInfo.getOrg().getId().toString();
            FieldAccessCollection fieldAccessCollection2 = (FieldAccessCollection)((Object)orgFieldAccessMap.get(orgId));
            if (fieldAccessCollection2 == null) {
                fieldAccessCollection2 = new FieldAccessCollection();
                fieldAccessCollection2.addCollection(noneOrgfieldAccessCollection);
                orgFieldAccessMap.put(orgId, fieldAccessCollection2);
            }
            fieldAccessCollection2.add(fieldAccessInfo);
        }
        return orgFieldAccessMap;
    }

    private List<String> getNonebizObjTypes(List<String> bizObjTypes) {
        ArrayList<String> noneBizObjTypes = new ArrayList<String>();
        Iterator<String> iterator = bizObjTypes.iterator();
        while (iterator.hasNext()) {
            String bizObjectType = iterator.next().toString();
            EntityObjectInfo entityObjectInfo = this.getEntityObjectInfo(bizObjectType);
            OrgType orgType = PermissionCommonUtil.getMainBizOrgType(entityObjectInfo);
            if (!OrgType.NONE.equals((Object)orgType)) continue;
            noneBizObjTypes.add(bizObjectType);
        }
        return noneBizObjTypes;
    }

    private FieldAccessCollection convertToQueryFieldAccessCollections(Map<String, List<String>> queryfieldsMap, Map<String, FieldAccessInfo> entityFieldPermissions) {
        FieldAccessCollection fieldAccessCollection = new FieldAccessCollection();
        Set<String> queryNames = queryfieldsMap.keySet();
        for (String queryName : queryNames) {
            List<String> entityFieldList = queryfieldsMap.get(queryName);
            FieldAccessInfo fieldAccessInfo = null;
            int minAccessValue = 3;
            String minBizBosType = "";
            for (String entityFieldKey : entityFieldList) {
                int accessValue;
                fieldAccessInfo = entityFieldPermissions.get(entityFieldKey);
                if (fieldAccessInfo == null || (accessValue = fieldAccessInfo.getAccessValue()) >= minAccessValue) continue;
                minAccessValue = accessValue;
                minBizBosType = fieldAccessInfo.getBizObjectType().toString();
            }
            if (fieldAccessInfo == null) continue;
            FieldAccessInfo fieldAccessInfo2 = new FieldAccessInfo();
            fieldAccessInfo2.setAccessValue(minAccessValue);
            fieldAccessInfo2.setFieldName(queryName);
            fieldAccessInfo2.setBizObjectType(StringUtils.isEmpty((String)minBizBosType) ? fieldAccessInfo.getBizObjectType() : minBizBosType);
            fieldAccessCollection.add(fieldAccessInfo2);
        }
        return fieldAccessCollection;
    }

    public void convertToEntityFieldAccessCollection(FieldAccessCollection fieldAccessCollection) {
        for (int i = 0; i < fieldAccessCollection.size(); ++i) {
            PropertyInfo propertyInfo;
            FieldAccessInfo fieldAccessInfo = fieldAccessCollection.get(i);
            String bizObjectType = fieldAccessInfo.getBizObjectType();
            String fieldName = fieldAccessInfo.getFieldName();
            EntityObjectInfo entityObjectInfo = this.getEntityObjectInfo(bizObjectType);
            int index = fieldName.indexOf(FIELDS_SPLIT);
            while (index > -1 && (propertyInfo = entityObjectInfo.getPropertyByName(fieldName.substring(0, index))) instanceof LinkPropertyInfo) {
                LinkPropertyInfo linkPro = (LinkPropertyInfo)propertyInfo;
                RelationshipInfo relationshipInfo = linkPro.getRelationship();
                entityObjectInfo = relationshipInfo.getSupplierObject();
                fieldName = fieldName.substring(index + 1);
                index = fieldName.indexOf(FIELDS_SPLIT);
            }
            String realBizObjectType = entityObjectInfo.getType().toString();
            if (bizObjectType.equals(realBizObjectType)) continue;
            FieldAccessInfo realfieldAccessInfo = (FieldAccessInfo)fieldAccessInfo.clone();
            realfieldAccessInfo.setBizObjectType(realBizObjectType);
            realfieldAccessInfo.setFieldName(fieldName);
            fieldAccessCollection.add(realfieldAccessInfo);
        }
    }

    private EntityObjectInfo getEntityObjectInfo(String bizObjectType) {
        EntityObjectInfo entityObjectInfo = this.bizEntityObjectInfosCache.get(bizObjectType);
        if (entityObjectInfo == null) {
            entityObjectInfo = this.loader.getEntity(BOSObjectType.create((String)bizObjectType));
            this.bizEntityObjectInfosCache.put(bizObjectType, entityObjectInfo);
        }
        return entityObjectInfo;
    }

    private List<String> getQueryFieldLinkEntityFields(QueryFieldInfo queryFieldInfo, List<String> linkEntityFields) {
        PropertyRefCollection propertyRefCollection = queryFieldInfo.getPropertyRefs();
        if (propertyRefCollection.size() != 1) {
            return null;
        }
        PropertyRefInfo propertyRefInfo = propertyRefCollection.get(0);
        PropertyInfo propertyInfo = propertyRefInfo.getRefProperty();
        if (propertyInfo == null) {
            return null;
        }
        if (ID.equals(propertyInfo.getName())) {
            return null;
        }
        SubEntityInfo querySubEntityInfo = propertyRefInfo.getSubEntity();
        if (querySubEntityInfo == null) {
            return null;
        }
        EntityObjectInfo querySubEntity = querySubEntityInfo.getEntityRef();
        if (querySubEntity == null) {
            return null;
        }
        BOSObjectType bOSObjectType = querySubEntity.getType();
        if (bOSObjectType == null) {
            return null;
        }
        linkEntityFields.add(this.getUnionKey(bOSObjectType.toString(), propertyInfo.getName()));
        return this.getQueryFieldLinkEntitys(querySubEntityInfo, linkEntityFields);
    }

    private List<String> getQueryFieldLinkEntitys(SubEntityInfo querySubEntityInfo, List<String> linkEntityFields) {
        Object[] suppelierSubEntityAndPro = this.getSupplierRelationPro(querySubEntityInfo);
        if (suppelierSubEntityAndPro != null) {
            LinkPropertyInfo linkPro;
            LinkPropertyInfo parentlinkPro;
            SubEntityInfo suppelierSubEntity = (SubEntityInfo)suppelierSubEntityAndPro[0];
            PropertyInfo supplierPro = (PropertyInfo)suppelierSubEntityAndPro[1];
            PropertyInfo clientPro = (PropertyInfo)suppelierSubEntityAndPro[2];
            EntityObjectInfo supplierEntityObjectInfo = suppelierSubEntity.getEntityRef();
            BOSObjectType supplierBOSObjectType = supplierEntityObjectInfo.getType();
            if (supplierPro instanceof LinkPropertyInfo) {
                linkEntityFields.add(this.getUnionKey(supplierBOSObjectType.toString(), supplierPro.getName()));
            } else if (clientPro instanceof LinkPropertyInfo && PermissionCommonUtil.isEntry(parentlinkPro = (LinkPropertyInfo)clientPro) && (linkPro = this.getEntryPro(supplierEntityObjectInfo, parentlinkPro.getRelationship())) != null) {
                int lastIndex = linkEntityFields.size() - 1;
                String entry = linkEntityFields.get(lastIndex);
                String fieldName = entry.substring(entry.indexOf(ENTITYMAPFIELD_SPLIT) + 1);
                String addEntry = this.getUnionKey(supplierBOSObjectType.toString(), linkPro.getName(), fieldName);
                linkEntityFields.remove(lastIndex);
                linkEntityFields.add(addEntry);
            }
            this.getQueryFieldLinkEntitys(suppelierSubEntity, linkEntityFields);
        }
        return linkEntityFields;
    }

    private Object[] getSupplierRelationPro(SubEntityInfo clientSubEntity) {
        JoinItemCollection joinItems;
        SubEntityInfo suppelierSubEntity = null;
        PropertyInfo supplierPro = null;
        PropertyInfo clientPro = null;
        JoinCollection joins = clientSubEntity.getJoinsFromSupplier();
        if (joins != null && joins.size() == 1 && (joinItems = joins.get(0).getJoinItems()) != null && joinItems.size() == 1) {
            PropertyRefCollection propertyRefs2;
            SubEntityInfo relationSubEntity1 = null;
            PropertyInfo relationPropertyInfo1 = null;
            SubEntityInfo relationSubEntity2 = null;
            PropertyInfo relationPropertyInfo2 = null;
            JoinItemInfo joinItemInfo = joinItems.get(0);
            PropertyRefCollection propertyRefs = joinItemInfo.getLeftField().getPropertyRefs();
            if (propertyRefs != null && propertyRefs.size() == 1) {
                PropertyRefInfo propertyRefInfo = propertyRefs.get(0);
                relationSubEntity1 = propertyRefInfo.getSubEntity();
                relationPropertyInfo1 = propertyRefInfo.getRefProperty();
            }
            if ((propertyRefs2 = joinItemInfo.getRightField().getPropertyRefs()) != null && propertyRefs2.size() == 1) {
                PropertyRefInfo propertyRefInfo2 = propertyRefs2.get(0);
                relationSubEntity2 = propertyRefInfo2.getSubEntity();
                relationPropertyInfo2 = propertyRefInfo2.getRefProperty();
            }
            if (relationSubEntity1 != clientSubEntity) {
                suppelierSubEntity = relationSubEntity1;
                supplierPro = relationPropertyInfo1;
                clientPro = relationPropertyInfo2;
            } else {
                suppelierSubEntity = relationSubEntity2;
                supplierPro = relationPropertyInfo2;
                clientPro = relationPropertyInfo1;
            }
        }
        if (suppelierSubEntity == null || supplierPro == null || clientPro == null) {
            return null;
        }
        Object[] objs = new Object[]{suppelierSubEntity, supplierPro, clientPro};
        return objs;
    }

    private LinkPropertyInfo getEntryPro(EntityObjectInfo mainObject, RelationshipInfo relationshipInfo) {
        PropertyCollection properties = mainObject.getInheritedNoDuplicatedProperties();
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            LinkPropertyInfo linkPropertyInfo;
            PropertyInfo propertyInfo = properties.get(i);
            if (!(propertyInfo instanceof LinkPropertyInfo) || !(linkPropertyInfo = (LinkPropertyInfo)propertyInfo).getRelationship().getFullName().equals(relationshipInfo.getFullName())) continue;
            return linkPropertyInfo;
        }
        return null;
    }

    public List<String> getQueryFieldLinkEntitys(QueryInfo queryInfo, String queryFieldName, List<String> linkEntityFields) throws BOSException, EASBizException {
        if (queryInfo instanceof JoinQueryInfo) {
            JoinQueryInfo joinQueryInfo = (JoinQueryInfo)queryInfo;
            this.getJoinQueryFieldsStructsByQueryFieldName(joinQueryInfo, queryFieldName, linkEntityFields);
        } else if (queryInfo instanceof UnionQueryInfo) {
            UnionQueryInfo unionQueryInfo = (UnionQueryInfo)queryInfo;
            this.getUnioQueryFieldsStructsByQueryFieldName(unionQueryInfo, queryFieldName, linkEntityFields);
        }
        return linkEntityFields;
    }

    private List<String> getUnioQueryFieldsStructsByQueryFieldName(UnionQueryInfo parentUnionQueryInfo, String queryFieldName, List<String> linkEntityFields) throws BOSException, EASBizException {
        SubQueryInfo subQueryInfo = (SubQueryInfo)parentUnionQueryInfo.getMainObject();
        QueryInfo mainQueryInfo = subQueryInfo.getQueryRef();
        if (mainQueryInfo instanceof JoinQueryInfo) {
            JoinQueryInfo joinQueryInfo = (JoinQueryInfo)mainQueryInfo;
            return this.getJoinQueryFieldsStructsByQueryFieldName(joinQueryInfo, queryFieldName, linkEntityFields);
        }
        if (mainQueryInfo instanceof UnionQueryInfo) {
            UnionQueryInfo unionQueryInfo = (UnionQueryInfo)mainQueryInfo;
            return this.getUnioQueryFieldsStructsByQueryFieldName(unionQueryInfo, queryFieldName, linkEntityFields);
        }
        throw new IllegalArgumentException("subQueryInfo is error!");
    }

    public List<String> getJoinQueryFieldsStructsByQueryFieldName(JoinQueryInfo queryInfo, String queryFieldName, List<String> linkEntityFields) throws BOSException, EASBizException {
        PropertyUnitCollection propertyUnitCollection = queryInfo.getUnits();
        QueryFieldCollection queryFieldCollection = propertyUnitCollection.getQueryFields();
        for (int i = 0; i < queryFieldCollection.size(); ++i) {
            QueryFieldInfo queryFieldInfo = queryFieldCollection.get(i);
            if (!queryFieldInfo.getRealName().equals(queryFieldName)) continue;
            return this.getQueryFieldLinkEntityFields(queryFieldInfo, linkEntityFields);
        }
        return linkEntityFields;
    }

    private String getUniqueKey(FieldAccessInfo fieldAccessInfo) {
        BOSUuid orgId;
        FullOrgUnitInfo orgInfo;
        BOSUuid userId;
        String key = "";
        UserInfo userInfo = fieldAccessInfo.getUser();
        if (userInfo != null && (userId = userInfo.getId()) != null) {
            key = key + userId.toString();
        }
        if ((orgInfo = fieldAccessInfo.getOrg()) != null && (orgId = orgInfo.getId()) != null) {
            key = key + (StringUtils.isEmpty((String)key) ? orgId.toString() : FIELDACCESS_KEY_SPLIT + orgId.toString());
        }
        String bizObjectType = fieldAccessInfo.getBizObjectType();
        key = key + (StringUtils.isEmpty((String)key) ? bizObjectType : FIELDACCESS_KEY_SPLIT + bizObjectType);
        String fieldName = fieldAccessInfo.getFieldName();
        key = key + (StringUtils.isEmpty((String)key) ? fieldName : FIELDACCESS_KEY_SPLIT + fieldName);
        return key;
    }

    private String getUnionKey(String bizBosType, String ... fieldNames) {
        String longFieldName = "";
        for (String fieldName : fieldNames) {
            longFieldName = StringUtils.isEmpty((String)longFieldName) ? fieldName : longFieldName + FIELDS_SPLIT + fieldName;
        }
        return bizBosType + ENTITYMAPFIELD_SPLIT + longFieldName;
    }
}

