/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionConstant;
import com.kingdee.eas.base.permission.app.util.BizObjectOrgUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;

public class BizObjectOrgHelper {
    public IObjectPK getCoreBillBaseBizOrgPK(Context context, BOSObjectType objectType, Object bizData) throws EASBizException, BOSException {
        String parentPropertyName = this.getBizObjOrgPropertyName(context, objectType);
        if (parentPropertyName == null) {
            return null;
        }
        return this.getMainOrgObjValueInfo(context, bizData, parentPropertyName);
    }

    public String getBizObjOrgPropertyName(Context context, BOSObjectType objectType) throws EASBizException {
        String parentPropertyName = null;
        if (BizObjectOrgUtil.isSubFromCoreBillBase(context, objectType)) {
            parentPropertyName = BizObjectOrgUtil.getBizOrgPropertyName(context, objectType);
        } else if (BizObjectOrgUtil.isSubFromCoreBillBase(context, objectType, PermissionConstant.CORE_BILL_ENTRY_BASE_TYPE)) {
            parentPropertyName = BizObjectOrgUtil.getSubBizOrgPropertyName(context, objectType);
        }
        return parentPropertyName;
    }

    public IObjectPK getMainOrgObjValueInfo(Context context, Object bizData, String parentPropertyName) throws BOSException, UuidException, EASBizException {
        String orgIdStr;
        if (bizData == null) {
            return null;
        }
        IObjectPK targetPK = this.getPKFromObj(bizData);
        IObjectValue subValueInfo = null;
        if (bizData instanceof IObjectValue) {
            subValueInfo = (IObjectValue)bizData;
        } else if (bizData instanceof IObjectPK && targetPK != null) {
            BOSObjectType bosType = BOSUuid.read((String)targetPK.toString()).getType();
            subValueInfo = BizObjectOrgUtil.getBizValue(context, bosType, targetPK, parentPropertyName);
        }
        if (subValueInfo != null && !StringUtils.isEmpty((String)(orgIdStr = StringUtils.cnulls((String)BizObjectOrgUtil.getBizValueByFormula(context, subValueInfo, parentPropertyName + ".id"))))) {
            return new ObjectStringPK(orgIdStr);
        }
        return null;
    }

    private IObjectPK getPKFromObj(Object bizData) {
        if (bizData == null) {
            return null;
        }
        if (bizData instanceof IObjectValue) {
            IObjectValue targetValueInfo = (IObjectValue)bizData;
            String idStr = StringUtils.cnulls((Object)targetValueInfo.get(targetValueInfo.getPKField()));
            if (!StringUtils.isEmpty((String)idStr)) {
                return new ObjectStringPK(idStr);
            }
        } else if (bizData instanceof IObjectPK) {
            return (IObjectPK)bizData;
        }
        return null;
    }
}

