/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util.interior;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.SynStateEnum;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.util.UserLogUtil;
import com.kingdee.eas.base.permission.app.util.interior.IUserLicenseGroupHelper;
import com.kingdee.eas.base.permission.app.util.interior.LicenseUseSrvFactory;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupTool;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicGroupDiffInfo;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupInfoEx;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupsInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

@Deprecated
public class UpdUserLicenseGroupHelper
implements IUserLicenseGroupHelper {
    private static Logger logger = Logger.getLogger((String)UpdUserLicenseGroupHelper.class.getName());
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    Context ctx;
    UserInfo user;
    String userId;
    UserLicenseGroupsInfo userLicenseGroups;
    UserLicenseGroupsInfo updLicenseGroups;
    UserLicGroupDiffInfo userLicGroupDiffInfo;

    public UpdUserLicenseGroupHelper(Context ctx, String userId) {
        this.ctx = ctx;
        try {
            this.user = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId));
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.user = new UserInfo(userId);
        }
        this.userLicenseGroups = UserLicenseGroupTool.getUserLicenseGroups(ctx, this.user);
        this.userLicGroupDiffInfo = new UserLicGroupDiffInfo(this.user, this.userLicenseGroups.getLsLicGroups());
        this.userId = userId;
    }

    public UpdUserLicenseGroupHelper(Context ctx, UserInfo user) {
        this(ctx, user, UserLicenseGroupTool.getUserLicenseGroups(ctx, user));
    }

    public UpdUserLicenseGroupHelper(Context ctx, UserInfo user, UserLicenseGroupsInfo userLicenseGroups) {
        this.ctx = ctx;
        this.user = user;
        this.userId = user.getId().toString();
        this.userLicenseGroups = userLicenseGroups;
        this.userLicGroupDiffInfo = new UserLicGroupDiffInfo(user);
        this.userLicGroupDiffInfo.setLsLicGroups(userLicenseGroups.getLsLicGroups());
    }

    public UserInfo getUser() {
        return this.user;
    }

    public void setUser(UserInfo user) {
        this.user = user;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public UserLicenseGroupsInfo getUserLicenseGroups() {
        return this.userLicenseGroups;
    }

    public void setUserLicenseGroups(UserLicenseGroupsInfo userLicenseGroups) {
        this.userLicenseGroups = userLicenseGroups;
    }

    public UserLicenseGroupsInfo getUpdLicenseGroups() {
        return this.updLicenseGroups;
    }

    public void setUpdLicenseGroups(UserLicenseGroupsInfo updLicenseGroups) {
        this.updLicenseGroups = updLicenseGroups;
    }

    public UserLicGroupDiffInfo getUserLicGroupDiffInfo() {
        return this.userLicGroupDiffInfo;
    }

    public void setUserLicGroupDiffInfo(UserLicGroupDiffInfo userLicGroupDiffInfo) {
        this.userLicGroupDiffInfo = userLicGroupDiffInfo;
    }

    public void addUpdUserLicenseGroupInfo(UserLicenseGroupInfoEx userLicGroupInfo) {
        if (this.updLicenseGroups == null) {
            this.updLicenseGroups = new UserLicenseGroupsInfo(this.user);
        }
        userLicGroupInfo.setSynUser(SynStateEnum.SYN_NO);
        userLicGroupInfo.setUser(this.user);
        this.updLicenseGroups.removeLicGroups(userLicGroupInfo.getGroupNumber());
        this.updLicenseGroups.addLicGroups(userLicGroupInfo);
    }

    @Override
    public boolean exec() throws BOSException, EASBizException {
        if (this.updLicenseGroups == null) {
            return true;
        }
        try {
            this.updUserLicGroup(this.updLicenseGroups.getLsLicGroups());
            this.updUserLicGroupDif(this.userLicGroupDiffInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BOSException();
        }
        this.logUpdLicenseGroup();
        return true;
    }

    private void updUserLicGroup(List<UserLicenseGroupInfoEx> licenseGroupInfos) throws BOSException, EASBizException {
        String sql = "update T_PM_UserLicenseGroup set FuserId=?,FGroupNumber=?,FSynUser=?,FIsActive=? where fid=?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        int size = licenseGroupInfos.size();
        for (int i = 0; i < size; ++i) {
            UserLicenseGroupInfoEx ulgiEx = licenseGroupInfos.get(i);
            if (ulgiEx.getUpdateParams() == null) continue;
            paramsList.add(ulgiEx.getUpdateParams());
        }
        if (paramsList.size() == 0) {
            return;
        }
        try {
            DbUtil.executeBatch((Context)this.ctx, (String)sql, paramsList);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BOSException();
        }
        for (UserLicenseGroupInfoEx groupEx : licenseGroupInfos) {
            if (LicenseUseSrvFactory.getLocalInstance(this.ctx).disAssignUsersGroup(this.ctx, groupEx.getGroupNumber(), 1)) continue;
            throw new BOSException();
        }
    }

    private void updUserLicGroupDif(UserLicGroupDiffInfo licenseGroupDifInfo) throws BOSException {
        if (licenseGroupDifInfo.getDeleteParams() == null || licenseGroupDifInfo.getInsertParams() == null) {
            return;
        }
        String deleteSql = "delete from t_pm_userLicGroupDiff where FuserId = ?";
        String insertSql = "insert into t_pm_userLicGroupDiff(FuserId,FgroupStr,Fname,Fnumber,FCell,FEMail,FForbidden,FIsDelete,FUid)  values( ?   ,     ?,      ?,     ?,    ?,      ?,      ?,        ?,       ?)";
        ArrayList<Object[]> paramsListdel = new ArrayList<Object[]>();
        ArrayList<Object[]> paramsListins = new ArrayList<Object[]>();
        ArrayList<Object[]> paramsListupdUser = new ArrayList<Object[]>();
        paramsListdel.add(licenseGroupDifInfo.getDeleteParams());
        paramsListins.add(licenseGroupDifInfo.getInsertParams());
        paramsListupdUser.add(licenseGroupDifInfo.getUpdateUserParams());
        try {
            if (paramsListdel.size() > 0) {
                DbUtil.executeBatch((Context)this.ctx, (String)deleteSql, paramsListdel);
            }
            if (paramsListins.size() > 0) {
                DbUtil.executeBatch((Context)this.ctx, (String)insertSql, paramsListins);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BOSException();
        }
    }

    private void logUpdLicenseGroup() {
        if (this.updLicenseGroups == null || this.updLicenseGroups.getLsLicGroups() == null) {
            return;
        }
        List<UserLicenseGroupInfoEx> updgroups = this.updLicenseGroups.getLsLicGroups();
        for (UserLicenseGroupInfoEx groupex : updgroups) {
            if (groupex.isIsActive()) {
                UserLogUtil.log(this.ctx, groupex.getUser().getId().toString(), EASResource.getString((String)RESOURCE, (String)"activeGroup", (Locale)new Locale("l1")) + ": " + groupex.getGroupNumber(), EASResource.getString((String)RESOURCE, (String)"activeGroup", (Locale)new Locale("l2")) + ": " + groupex.getGroupNumber(), EASResource.getString((String)RESOURCE, (String)"activeGroup", (Locale)new Locale("l3")) + ": " + groupex.getGroupNumber());
                continue;
            }
            UserLogUtil.log(this.ctx, groupex.getUser().getId().toString(), EASResource.getString((String)RESOURCE, (String)"activeGroup", (Locale)new Locale("l1")) + ": " + groupex.getGroupNumber(), EASResource.getString((String)RESOURCE, (String)"cancelGroup", (Locale)new Locale("l2")) + ": " + groupex.getGroupNumber(), EASResource.getString((String)RESOURCE, (String)"cancelGroup", (Locale)new Locale("l3")) + ": " + groupex.getGroupNumber());
        }
    }
}

