/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.service.helper.ekey;

import com.kingdee.eas.base.permission.service.helper.ekey.PermissionNativeTool;
import com.kingdee.eas.base.permission.util.LogUtil;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class LoadNativeDllHelper {
    private static Logger logger = Logger.getLogger((String)LoadNativeDllHelper.class.getName());
    public static final String EKEY_DLL_NAME = "ekey.dll";
    public static final String USBKEY_DRIVER = "MWTokenAPI.dll";

    public static boolean checkHaveFile(String fullFileName) throws IOException {
        logger.info((Object)LogUtil.filterLogForging("check path is:" + fullFileName));
        logger.info((Object)LogUtil.filterLogForging("java.library.path is: " + System.getProperty("java.library.path")));
        File file = new File(fullFileName);
        boolean hasFile = file.exists();
        if (!hasFile) {
            logger.debug((Object)("load fileName is:" + fullFileName));
            throw new IOException("filename not found!");
        }
        logger.debug((Object)(fullFileName + " is exist!"));
        return hasFile;
    }

    public static boolean checkHaveDll(String dllName) throws IOException {
        if (dllName == null || dllName.trim().length() == 0) {
            logger.info((Object)"dllName is null!");
            return false;
        }
        logger.debug((Object)("dll File name is :" + dllName));
        return LoadNativeDllHelper.checkHaveFile(dllName);
    }

    public static void ensureFileExist(String dllName) throws IOException {
        if (!LoadNativeDllHelper.checkHaveDll(dllName)) {
            throw new IOException("dllName is not found!");
        }
    }

    public static void loadFile(String filename) throws IOException {
        LoadNativeDllHelper.debugInfo("system.load... now!");
        filename = LoadNativeDllHelper.getDllFileName(filename);
        LoadNativeDllHelper.debugInfo("filename = " + filename);
        LoadNativeDllHelper.checkHaveFile(filename);
        LoadNativeDllHelper.debugInfo("System.load(" + filename + ");");
        System.load(filename);
        LoadNativeDllHelper.debugInfo("system.load successful!");
    }

    private static void debugInfo(String debugInfo) {
        logger.debug((Object)debugInfo);
    }

    public static String getDllFileName(String dllName) {
        String filePath = System.getProperty("easclient.root");
        if (filePath == null || filePath.trim().length() == 0) {
            return dllName;
        }
        if (filePath.endsWith(File.separator)) {
            return filePath + dllName;
        }
        return filePath + File.separator + dllName;
    }

    public static String getSystemRoot() throws IOException {
        PermissionNativeTool tool = new PermissionNativeTool();
        logger.debug((Object)"tool.getSystemPath() now!");
        return tool.getWin32Path();
    }
}

