/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util.cloud;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ICloudRegistSrv;
import com.kingdee.eas.base.license.ILicenseSrv;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.service.ValidateCommunicationFactory;
import com.kingdee.eas.base.permission.service.comstrategy.CommunicationInfo;
import com.kingdee.eas.base.permission.util.cloud.HttpsClientUtil;
import com.kingdee.eas.base.permission.util.cloud.ShrCloud;
import com.kingdee.eas.base.permission.util.cloud.SyncShrUserToCloudExecuteHandler;
import com.kingdee.eas.base.permission.util.cloud.UpdateCloudUserStatusExecuteHandler;
import com.kingdee.eas.base.permission.util.cloud.activiation.UserNoActiviationHelper;
import com.kingdee.eas.base.permission.util.cloud.bean.CloudUserInfo;
import com.kingdee.eas.base.permission.util.cloud.kbc.CloudLicenseUtil;
import com.kingdee.eas.base.permission.util.cloud.kbc.SyncUsersToCloudBean;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;

public final class SynShrUserToCloudUtils {
    private static final Logger logger = Logger.getLogger(SynShrUserToCloudUtils.class);
    public static final String SYNC_NOACTIVIATION_KEY = "SYNC_NOACTIVIATION_KEY";
    private static ConcurrentHashMap<String, Object> resultCacheKey = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Object> syncCacheKey = new ConcurrentHashMap();
    private static long isLastCommunicationInfoUpdateTime = System.currentTimeMillis();
    private static CommunicationInfo communicationInfo = null;
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    public static synchronized String syncShrUserToCloud(Context ctx, List<CloudUserInfo> syncData) throws EASBizException, BOSException {
        SynShrUserToCloudUtils.clearSyncResultCacheKey();
        ArrayList<CloudUserInfo> sysDataClone = new ArrayList<CloudUserInfo>(syncData);
        SynShrUserToCloudUtils.noActiviationUsersDeal(sysDataClone, ctx);
        SynShrUserToCloudUtils.filterSync(sysDataClone, ctx);
        String execResult = new SyncShrUserToCloudExecuteHandler(ctx).exec(sysDataClone);
        SynShrUserToCloudUtils.syncOtherLicense(ctx, sysDataClone);
        SynShrUserToCloudUtils.refreshCommunicationInfo(ctx);
        return execResult;
    }

    public static void syncOtherLicense(Context ctx, List<CloudUserInfo> syncData) throws BOSException, EASBizException {
        List<String> productInstanceIDs = CloudLicenseUtil.getOtherProductInstanceIDs(ctx);
        for (String productInstanceID : productInstanceIDs) {
            new SyncUsersToCloudBean(productInstanceID, syncData).execSync();
        }
    }

    private static void filterSync(List<CloudUserInfo> syncData, Context ctx) {
        ArrayList<CloudUserInfo> syncDataClone = new ArrayList<CloudUserInfo>(syncData);
        for (CloudUserInfo cloudUser : syncDataClone) {
            String errorMsg = SynShrUserToCloudUtils.checkNeedSync(cloudUser, ctx);
            if (StringUtils.isEmpty((String)errorMsg)) continue;
            syncData.remove(cloudUser);
        }
    }

    public static void noActiviationUsersDeal(List<CloudUserInfo> syncData, Context ctx) throws BOSException {
        ArrayList<String> noActiviationSyncUsers = new ArrayList<String>();
        boolean supportNoActiviation = UserNoActiviationHelper.isSupportNoActiviation(ctx);
        if (!supportNoActiviation) {
            SynShrUserToCloudUtils.addSyncCache(SYNC_NOACTIVIATION_KEY, noActiviationSyncUsers);
            return;
        }
        List<String> noActiviationUsers = UserNoActiviationHelper.getNoActiviationUsersIgnoreCase(ctx);
        for (int i = 0; i < syncData.size(); ++i) {
            CloudUserInfo cloudUserInfo = syncData.get(i);
            String erp_account = cloudUserInfo.getErp_account();
            if (!noActiviationUsers.contains(erp_account)) continue;
            cloudUserInfo.setPhone("");
            cloudUserInfo.setEmail("");
            noActiviationSyncUsers.add(erp_account);
        }
        SynShrUserToCloudUtils.addSyncCache(SYNC_NOACTIVIATION_KEY, noActiviationSyncUsers);
    }

    public static boolean isCurSyncNoActiviationUser(String erpNumber, Context ctx) {
        List<String> syncNoActiviationUsers = null;
        try {
            syncNoActiviationUsers = (List<String>)SynShrUserToCloudUtils.getSyncCache(SYNC_NOACTIVIATION_KEY);
            if (syncNoActiviationUsers == null) {
                boolean supportNoActiviation = UserNoActiviationHelper.isSupportNoActiviation(ctx);
                if (!supportNoActiviation) {
                    return false;
                }
                syncNoActiviationUsers = UserNoActiviationHelper.getNoActiviationUsersIgnoreCase(ctx);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (syncNoActiviationUsers == null) {
            return false;
        }
        return syncNoActiviationUsers.contains(erpNumber);
    }

    public static String checkNeedSync(CloudUserInfo cloudUser, Context ctx) {
        String error = "";
        if (SynShrUserToCloudUtils.isCurSyncNoActiviationUser(cloudUser.getErp_account(), ctx)) {
            return error;
        }
        if (StringUtils.isEmpty((String)cloudUser.getPhone()) && StringUtils.isEmpty((String)cloudUser.getEmail()) && cloudUser.getIs_delete() != 1 && cloudUser.getStatus() != 0) {
            int needPhone = 1;
            int needEmail = 0;
            CommunicationInfo communicationInfo = SynShrUserToCloudUtils.getCommunicationInfo(ctx);
            if (communicationInfo != null) {
                needPhone = communicationInfo.getNeedPhone();
                needEmail = communicationInfo.getNeedEmail();
            }
            Locale locale = Locale.CHINESE;
            if (ctx == null) {
                locale = SysContext.getSysContext().getLocale();
            } else {
                ctx.getLocale();
            }
            error = needPhone == 1 && needEmail == 0 ? EASCommonResource.getString((String)RESOURCE, (String)"phoneNullError", (Locale)locale) : (needPhone == 0 && needEmail == 1 ? EASCommonResource.getString((String)RESOURCE, (String)"emailNullError", (Locale)locale) : (needPhone == 1 && needEmail == 1 ? EASCommonResource.getString((String)RESOURCE, (String)"phoneAndEmailIsNullError", (Locale)locale) : (needPhone == 2 && needEmail == 2 ? EASCommonResource.getString((String)RESOURCE, (String)"phoneAndEmailIsALLNullError", (Locale)locale) : EASCommonResource.getString((String)RESOURCE, (String)"phoneAndEmailIsALLNullError", (Locale)locale))));
        }
        return error;
    }

    public static void refreshCommunicationInfo(Context ctx) {
        communicationInfo = null;
        SynShrUserToCloudUtils.getCommunicationInfo(ctx);
    }

    public static CommunicationInfo getCommunicationInfo(Context ctx) {
        if (communicationInfo != null && System.currentTimeMillis() - isLastCommunicationInfoUpdateTime < 600000L) {
            return communicationInfo;
        }
        try {
            UserNoActiviationHelper.doCloudCommunicationStategy(ctx);
            isLastCommunicationInfoUpdateTime = System.currentTimeMillis();
            communicationInfo = ctx != null ? ValidateCommunicationFactory.getLocalInstance(ctx).getCloudCommunicationStategy() : ValidateCommunicationFactory.getRemoteInstance().getCloudCommunicationStategy();
        }
        catch (Exception e) {
            logger.error((Object)"SynShrUserToCloudUtils.getCommunicationInfo error !", (Throwable)e);
        }
        return communicationInfo;
    }

    public static String updateCloudUserStatus(Context ctx, List<CloudUserInfo> syncData) throws EASBizException, BOSException {
        UpdateCloudUserStatusExecuteHandler pagingHandler = new UpdateCloudUserStatusExecuteHandler(ctx);
        return pagingHandler.exec(syncData);
    }

    public static String getSyncResultKey(String resultStr) {
        Map map = SynShrUserToCloudUtils.paraseExecResult(resultStr);
        JSONObject obj = map == null ? null : map.get("data");
        if (null == obj) {
            return "";
        }
        return String.valueOf(obj.get((Object)"key"));
    }

    public static int getErrorCode(String resultStr) {
        Map map = SynShrUserToCloudUtils.paraseExecResult(resultStr);
        return Integer.parseInt(String.valueOf(map == null ? "0" : (map.get("errcode") == null ? "0" : map.get("errcode"))));
    }

    public static Map paraseExecResult(String execResult) {
        return JSONObject.parseObject((String)execResult);
    }

    public static boolean isSynComplete(Context ctx, String key) {
        String resultStr = SynShrUserToCloudUtils.getSynResult(ctx, key);
        return 0 == SynShrUserToCloudUtils.getErrorCode(resultStr);
    }

    public static boolean isImportingOrgmember(String execResult) {
        return 1534 == SynShrUserToCloudUtils.getErrorCode(execResult);
    }

    public static boolean isWaitTimeOut(long startTime, long endTime) {
        return endTime - startTime > 5000L;
    }

    public static ConcurrentHashMap<String, Object> getSimpleCache() {
        return resultCacheKey;
    }

    public static void clearSyncResultCacheKey() {
        resultCacheKey.clear();
        syncCacheKey.clear();
    }

    public static void waitSyncResultToCache(Context ctx, String execResult) {
        String value = SynShrUserToCloudUtils.getSyncResultKey(execResult);
        String synResult = SynShrUserToCloudUtils.getSynResult(ctx, value);
        if (!StringUtils.isEmpty((String)value)) {
            SynShrUserToCloudUtils.addSyncResultKeyToCache(value, synResult);
        }
    }

    public static void addSyncResultKeyToCache(String key, String value) {
        resultCacheKey.put(key, value);
    }

    public static void addSyncCache(String key, Object value) {
        syncCacheKey.put(key, value);
    }

    public static Object getSyncCache(String key) {
        return syncCacheKey.get(key);
    }

    public static String getSynResult(Context ctx, String key) {
        Map<String, String> config = SynShrUserToCloudUtils.getCloudConfig(ctx);
        Map<String, String> param = SynShrUserToCloudUtils.assembleGetReqCommonParam(ctx);
        param.put("key", key);
        String url = SynShrUserToCloudUtils.appendUrlParam(SynShrUserToCloudUtils.assembleUrl(config, "kdproduct/prod_instance/member/sync_result"), param);
        String result = "";
        result = SynShrUserToCloudUtils.executeHttpGet(url, param);
        long waitingTime = 0L;
        while (result == null || 0 != SynShrUserToCloudUtils.getErrorCode(result) && waitingTime < 30000L) {
            try {
                Thread.sleep(200L);
                waitingTime += 200L;
            }
            catch (InterruptedException e) {
                logger.error((Object)e);
            }
            if (SynShrUserToCloudUtils.getErrorCode(result = SynShrUserToCloudUtils.executeHttpGet(url, param)) != 400) continue;
            logger.error((Object)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff0cerrorCode:400");
            break;
        }
        return result;
    }

    public static String getSync(Context ctx, String key) {
        Map<String, String> config = SynShrUserToCloudUtils.getCloudConfig(ctx);
        Map<String, String> param = SynShrUserToCloudUtils.assembleGetReqCommonParam(ctx);
        param.put("key", key);
        String url = SynShrUserToCloudUtils.appendUrlParam(SynShrUserToCloudUtils.assembleUrl(config, "kdproduct/member/sync/data"), param);
        return SynShrUserToCloudUtils.executeHttpGet(url, param);
    }

    public static List<org.apache.commons.httpclient.NameValuePair> assembleParamData(Context ctx, Map<String, String> config, List<CloudUserInfo> pageData, String sync_id, int is_finish) {
        List<org.apache.commons.httpclient.NameValuePair> param = SynShrUserToCloudUtils.getCommonParam(ctx, config);
        param.add(SynShrUserToCloudUtils.createNameValuePair("sync_id", sync_id));
        param.add(SynShrUserToCloudUtils.createNameValuePair("is_finish", is_finish + ""));
        param.add(SynShrUserToCloudUtils.createNameValuePair("data", SynShrUserToCloudUtils.convertToJsonString(pageData)));
        return param;
    }

    public static List<org.apache.commons.httpclient.NameValuePair> assembleUpdateUserStatusParamData(Context ctx, Map<String, String> config, List<CloudUserInfo> pageData) {
        List<org.apache.commons.httpclient.NameValuePair> param = SynShrUserToCloudUtils.getCommonParam(ctx, config);
        CloudUserInfo cloudUser = null;
        StringBuffer disableUIdStr = new StringBuffer();
        StringBuffer enableUIdStr = new StringBuffer();
        int size = pageData.size();
        for (int i = 0; i < size; ++i) {
            cloudUser = pageData.get(i);
            if (cloudUser.getUid() == 0) continue;
            if (1 == cloudUser.getStatus()) {
                enableUIdStr.append(cloudUser.getUid()).append(",");
                continue;
            }
            disableUIdStr.append(cloudUser.getUid()).append(",");
        }
        if (enableUIdStr.length() > 0) {
            enableUIdStr.deleteCharAt(enableUIdStr.length() - 1);
        }
        if (disableUIdStr.length() > 0) {
            disableUIdStr.deleteCharAt(disableUIdStr.length() - 1);
        }
        param.add(SynShrUserToCloudUtils.createNameValuePair("disable", disableUIdStr.toString()));
        param.add(SynShrUserToCloudUtils.createNameValuePair("enable", enableUIdStr.toString()));
        return param;
    }

    public static org.apache.commons.httpclient.NameValuePair[] convertParamToArray(List<org.apache.commons.httpclient.NameValuePair> param) {
        return param.toArray(new org.apache.commons.httpclient.NameValuePair[param.size()]);
    }

    public static String convertToJsonString(List<CloudUserInfo> obj) {
        return JSONObject.toJSONString(obj);
    }

    public static String assembleUrl(Map<String, String> config, String api) {
        String url = config.get("cloud.server.url");
        String executeUrl = url.endsWith("/") ? url + api : url + "/" + api;
        return executeUrl;
    }

    public static List<org.apache.commons.httpclient.NameValuePair> getCommonParam(Context ctx, Map<String, String> config) {
        ArrayList<org.apache.commons.httpclient.NameValuePair> param = new ArrayList<org.apache.commons.httpclient.NameValuePair>();
        param.add(SynShrUserToCloudUtils.createNameValuePair("client_id", config.get("cloud.client.id")));
        param.add(SynShrUserToCloudUtils.createNameValuePair("client_secret", config.get("cloud.client.secret")));
        param.add(SynShrUserToCloudUtils.createNameValuePair("prod_inst_code", ShrCloud.getProductInstanceID(ctx)));
        return param;
    }

    private static org.apache.commons.httpclient.NameValuePair createNameValuePair(String name, String value) {
        return new org.apache.commons.httpclient.NameValuePair(name, value);
    }

    public static String executeHttpPost(String url, List<org.apache.commons.httpclient.NameValuePair> param) throws IOException {
        if (!StringUtils.isEmpty((String)url) && url.toLowerCase().startsWith("https")) {
            return SynShrUserToCloudUtils.executeHttpsPost(url, param);
        }
        return SynShrUserToCloudUtils.doExecuteHttpPost(url, SynShrUserToCloudUtils.convertParamToArray(param));
    }

    public static String executeHttpsPost(String url, List<org.apache.commons.httpclient.NameValuePair> params) throws IOException {
        ArrayList<NameValuePair> httpsParams = new ArrayList<NameValuePair>();
        for (org.apache.commons.httpclient.NameValuePair param : params) {
            httpsParams.add((NameValuePair)new BasicNameValuePair(param.getName(), param.getValue()));
        }
        try {
            return HttpsClientUtil.post(url, httpsParams);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static String executeHttpGet(String url, Map<String, String> param) {
        if (!StringUtils.isEmpty((String)url) && url.toLowerCase().startsWith("https")) {
            logger.error((Object)MessageFormat.format(" url is {0},params is{1}  ", url, param.toString()));
            return HttpsClientUtil.get(url);
        }
        return SynShrUserToCloudUtils.doExecuteHttpGet(url, param);
    }

    public static String executeHttpPut(String url, List<org.apache.commons.httpclient.NameValuePair> param) {
        return SynShrUserToCloudUtils.doExecuteHttpPut(url, SynShrUserToCloudUtils.convertParamToArray(param));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doExecuteHttpPut(String url, org.apache.commons.httpclient.NameValuePair[] param) {
        HttpClient httpClient = new HttpClient();
        PutMethod method = new PutMethod(url);
        method.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        String responseBody = null;
        try {
            method.setQueryString(param);
            int statusCode = httpClient.executeMethod((HttpMethod)method);
            responseBody = method.getResponseBodyAsString();
            if (200 == statusCode) {
                logger.error((Object)MessageFormat.format(" doExecuteHttpPut state success url is {0},response content is{1}  ", url, responseBody));
            }
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            method.releaseConnection();
        }
        return responseBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doExecuteHttpGet(String url, Map<String, String> param) {
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
        GetMethod method = new GetMethod(url);
        method.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        String responseBody = null;
        logger.error((Object)MessageFormat.format(" url is {0},params is{1}  ", url, param.toString()));
        try {
            int statusCode = httpClient.executeMethod((HttpMethod)method);
            if (200 == statusCode) {
                logger.error((Object)MessageFormat.format(" doExecuteHttpGet state success url is {0}", url));
            }
            responseBody = method.getResponseBodyAsString();
            logger.error((Object)MessageFormat.format(" response body is {0},status is {1}", responseBody, statusCode));
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            method.releaseConnection();
        }
        return responseBody;
    }

    public static String doExecuteHttpPost(String url, org.apache.commons.httpclient.NameValuePair[] param) throws IOException {
        HttpClient httpClient = new HttpClient();
        PostMethod method = new PostMethod(url);
        String responseBody = "";
        method.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        method.setRequestHeader("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
        try {
            method.setRequestBody(param);
            int responseCode = httpClient.executeMethod((HttpMethod)method);
            responseBody = method.getResponseBodyAsString();
        }
        catch (HttpException e) {
            logger.error((Object)("SynShrUserToCloudUtils.doExecuteHttpPost:HttpException =" + (Object)((Object)e)));
            throw e;
        }
        catch (IOException e) {
            logger.error((Object)("SynShrUserToCloudUtils.doExecuteHttpPost:IOException =" + e));
            throw e;
        }
        finally {
            method.releaseConnection();
        }
        return responseBody;
    }

    public static String appendUrlParam(String url, Map<String, String> param) {
        if (url == null || param.isEmpty()) {
            return url;
        }
        StringBuilder newUrl = new StringBuilder(url);
        if (url.indexOf("?") == -1) {
            newUrl.append("?");
        } else {
            newUrl.append("&");
        }
        for (Map.Entry<String, String> entry : param.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            newUrl.append(name);
            newUrl.append("=");
            newUrl.append(value);
            newUrl.append("&");
        }
        return newUrl.toString();
    }

    public static Map<String, String> getCloudConfig(Context ctx) {
        HashMap<String, String> config = new HashMap<String, String>();
        config = new HashMap();
        config.put("cloud.server.url", EasCloud.CLOUD_URL);
        config.put("cloud.client.id", EasCloud.CLIENT_ID);
        config.put("cloud.client.secret", EasCloud.CLIENT_SECRET);
        config.put("club.server.url", "http://clubtest.kingdee.com");
        boolean isRequireHttps = false;
        try {
            String paravalue = ParamManager.getParamValue((Context)ctx, null, (String)"syncUsersIsRequireHttps");
            isRequireHttps = "true".equals(paravalue);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (isRequireHttps) {
            config.put("cloud.server.url", "https://api.kingdee.com/");
        }
        return config;
    }

    public static IRowSet executeQuery(Context ctx, String sql) throws BOSException {
        IRowSet rowSet = null;
        rowSet = null == ctx ? SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL() : DbUtil.executeQuery((Context)ctx, (String)sql);
        return rowSet;
    }

    public static JSONArray getCloudRegistUserInfoFromLicense(Context ctx) {
        ICloudRegistSrv cloudRegistSrv = SynShrUserToCloudUtils.getCloudRegistSrv(ctx);
        String cloudUserString = "";
        return JSONArray.parseArray((String)cloudUserString);
    }

    public static ICloudRegistSrv getCloudRegistSrv(Context ctx) {
        ICloudRegistSrv cloudRegistSrv = null;
        try {
            cloudRegistSrv = null == ctx ? CloudRegistSrvAgentFactory.getRemoteInstance() : CloudRegistSrvAgentFactory.getLocalInstanceWithContext((Context)ctx);
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
        return cloudRegistSrv;
    }

    public static Map<String, String> findCloudUserFromLocalLicenseFile(JSONArray localcloudUsers, String localUserNumber) {
        JSONObject object = null;
        HashMap<String, String> localFileUserMap = new HashMap<String, String>();
        if (localcloudUsers == null) {
            return localFileUserMap;
        }
        int size = localcloudUsers.size();
        for (int i = 0; i < size; ++i) {
            object = localcloudUsers.getJSONObject(i);
            String cloudName = object.getString("cloudName");
            String cloudUuId = object.getString("cloudUuId");
            String erpNumber = object.getString("erpNumber");
            String group = object.getString("group");
            if (!localUserNumber.equals(erpNumber)) continue;
            localFileUserMap.put("cloudName", cloudName);
            localFileUserMap.put("cloudUuId", cloudUuId);
            localFileUserMap.put("erpNumber", erpNumber);
            localFileUserMap.put("group", group);
            break;
        }
        return localFileUserMap;
    }

    public static String downloadLicense(Context ctx) {
        File file = null;
        try {
            file = ctx == null ? File.createTempFile(String.valueOf(System.currentTimeMillis()), ".zip") : File.createTempFile(String.valueOf(System.currentTimeMillis()), ".zip", new File(SynShrUserToCloudUtils.getTempFilePath()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String filePath = file.getPath();
        String url = SynShrUserToCloudUtils.assembleDownloadLicenseUrl(ctx);
        try {
            SynShrUserToCloudUtils.doDownloadLicense(url, filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filePath;
    }

    public static String assembleDownloadLicenseUrl(Context ctx) {
        Map<String, String> config = SynShrUserToCloudUtils.getCloudConfig(ctx);
        Map<String, String> dowloadParam = SynShrUserToCloudUtils.assembleGetReqCommonParam(ctx);
        dowloadParam.put("is_zip", "1");
        String url = SynShrUserToCloudUtils.appendUrlParam(SynShrUserToCloudUtils.assembleUrl(config, "kdproduct/prod_instance/licence/download"), dowloadParam);
        return url;
    }

    public static Map<String, String> assembleGetReqCommonParam(Context ctx) {
        Map<String, String> config = SynShrUserToCloudUtils.getCloudConfig(ctx);
        HashMap<String, String> getReqParam = new HashMap<String, String>();
        getReqParam.put("client_id", config.get("cloud.client.id"));
        getReqParam.put("client_secret", config.get("cloud.client.secret"));
        getReqParam.put("prod_inst_code", ShrCloud.getProductInstanceID(ctx));
        return getReqParam;
    }

    public static boolean uploadLicenseFile(String fileId, String licenseFilePath) throws BOSException {
        InputStream input = null;
        boolean flag = true;
        try {
            input = new BufferedInputStream(new FileInputStream(licenseFilePath));
            int position = 0;
            int readSize = 0x500000;
            int totalSize = input.available();
            readSize = readSize < totalSize ? readSize : totalSize;
            ICloudRegistSrv irs = CloudRegistSrvAgentFactory.getRemoteInstance();
            while (position < totalSize) {
                byte[] bf = new byte[readSize];
                input.read(bf, 0, readSize);
                irs.uploadCloudLicenseFile(fileId, bf);
                readSize = totalSize - (position += readSize) < readSize ? totalSize - position : readSize;
            }
        }
        catch (Exception e1) {
            flag = false;
            logger.error((Object)("updload license file cause " + e1));
            throw new BOSException((Throwable)e1);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception e2) {
                    logger.error((Object)e2);
                }
            }
        }
        return flag;
    }

    private static boolean doDownloadLicense(String url, String filePath) throws Exception {
        OutputStream out = null;
        boolean flag = true;
        InputStream in = null;
        HttpURLConnection conn = null;
        try {
            logger.debug((Object)("download license url: " + url));
            URL realUrl = new URL(url);
            conn = (HttpURLConnection)realUrl.openConnection();
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3600000);
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("Accept-Charset", "utf-8");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.connect();
            in = conn.getInputStream();
            if (conn.getContentType().indexOf("text") > -1) {
                throw new Exception("download fail");
            }
            out = new FileOutputStream(filePath);
            byte[] b = new byte[8096];
            int i = 0;
            while ((i = in.read(b)) != -1) {
                out.write(b, 0, i);
                out.flush();
            }
        }
        catch (Exception e) {
            flag = false;
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (conn != null) {
                    conn.disconnect();
                }
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return flag;
    }

    public static ILicenseSrv getLicenseSrvAgent() {
        ILicenseSrvAgent agent = null;
        try {
            agent = LicenseSrvAgentFactory.getRemoteInstance();
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
        return agent;
    }

    public static String getTempFilePath() {
        return System.getProperties().getProperty("EAS_HOME") + File.separator + "iotmpdir";
    }

    public static boolean removeTempFile(String path) {
        boolean flag = true;
        File file = new File(path);
        if (file.exists()) {
            flag = file.delete();
        }
        return flag;
    }

    public static void writeSyncLog(Context ctx, String logContent) {
        String logFile = SynShrUserToCloudUtils.assembleLogFile(ctx);
        SynShrUserToCloudUtils.doWriteLog(logContent, logFile);
    }

    public static void writeSyncLog(Context ctx, String logContent, String fileName) {
        String logFile = SynShrUserToCloudUtils.assembleLogFile(ctx, fileName);
        SynShrUserToCloudUtils.doWriteLog(logContent, logFile);
    }

    public static void writeCloudParamLog(Context ctx) {
        String logFile = SynShrUserToCloudUtils.getTempFilePath() + File.separator + "cloud_user_cfg.log";
        Map<String, String> config = SynShrUserToCloudUtils.getCloudConfig(ctx);
        String downloadLicenseUrl = SynShrUserToCloudUtils.assembleDownloadLicenseUrl(ctx);
        StringBuffer buffer = new StringBuffer();
        buffer.append("[runtime cfg:]").append("\n");
        buffer.append("[c_i:]").append(config.get("cloud.client.id")).append("\n");
        buffer.append("[c_s:]").append(config.get("cloud.client.secret")).append("\n");
        buffer.append("[pic:]").append(ShrCloud.getProductInstanceID(ctx)).append("\n");
        buffer.append("[downloadLicenseUrl:]").append(downloadLicenseUrl).append("\n");
        SynShrUserToCloudUtils.doWriteLog(buffer.toString(), logFile);
    }

    public static void writeSyncResultLog(Context ctx, String logContent) {
        String logFile = SynShrUserToCloudUtils.getTempFilePath() + File.separator + "syncResult.log";
        SynShrUserToCloudUtils.doWriteLog(logContent, logFile);
    }

    public static String assembleLogFile(Context ctx, String fileName) {
        String logFile = "";
        logFile = ctx == null ? System.getProperties().getProperty("user.dir") + File.separator + fileName : SynShrUserToCloudUtils.getTempFilePath() + File.separator + fileName;
        return logFile;
    }

    public static String assembleLogFile(Context ctx) {
        String logFile = "";
        logFile = ctx == null ? System.getProperties().getProperty("user.dir") + File.separator + "syncUser.log" : SynShrUserToCloudUtils.getTempFilePath() + File.separator + "syncUser.log";
        return logFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doWriteLog(String logContent, String logFile) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(logFile);
            ((OutputStream)out).write(logContent.getBytes());
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<String, String> paraseRequestResult(String requestResult) {
        Map obj = (Map)JSONObject.parse((String)requestResult);
        return obj;
    }

    public static String getReturnErrcode(String requestResult) {
        Map<String, String> obj = SynShrUserToCloudUtils.paraseRequestResult(requestResult);
        if (null == obj) {
            return "";
        }
        return String.valueOf(obj.get("errcode"));
    }

    public static String getReturnDes(String requestResult) {
        Map<String, String> obj = SynShrUserToCloudUtils.paraseRequestResult(requestResult);
        if (null == obj) {
            return "";
        }
        return obj.get("description_cn");
    }

    public static String formatDateToString(Date date, String pattern) {
        String dateString = "";
        if (date != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            dateString = sdf.format(date);
        }
        return dateString;
    }

    public static String assembleCountSql(String sourceSql) {
        String sql = "select count(1) totalCount from (" + sourceSql + ") temp";
        return sql;
    }

    public static int getTotalCount(Context ctx, String sql) {
        int totalCount = 0;
        try {
            IRowSet rs = SynShrUserToCloudUtils.executeQuery(ctx, SynShrUserToCloudUtils.assembleCountSql(sql));
            while (rs.next()) {
                totalCount = rs.getInt(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return totalCount;
    }

    public static String assemblePagingSql(int top, String sourceSql) {
        return "SELECT TOP " + top + " * from (" + sourceSql + ") temp";
    }

    public static boolean isSQLServerDB(Context ctx) {
        boolean flag = false;
        try {
            flag = 3 == KSqlUtil.getDbType((Connection)EJBFactory.getConnection((Context)ctx));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return flag;
    }
}

