/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util.cloud;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.framework.ejb.EJBUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ICloudRegistSrv;
import com.kingdee.eas.base.license.file.LicenseFileErrorException;
import com.kingdee.eas.base.license.file.cloudRegist.CloudRegistMemoryManager;
import com.kingdee.eas.base.license.file.cloudRegist.CloudRegistUserInfo;
import com.kingdee.eas.base.permission.AssembleCloudUserTypeEnum;
import com.kingdee.eas.base.permission.IPermUIGroupMapping;
import com.kingdee.eas.base.permission.IUserFacade;
import com.kingdee.eas.base.permission.PermUIGroupMappingCollection;
import com.kingdee.eas.base.permission.PermUIGroupMappingFactory;
import com.kingdee.eas.base.permission.SynShrUserToCloudFacadeFactory;
import com.kingdee.eas.base.permission.UserFacadeFactory;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupTool;
import com.kingdee.eas.base.permission.util.cloud.SynShrUserToCloudUtils;
import com.kingdee.eas.base.permission.util.cloud.bean.CloudUserInfo;
import com.kingdee.eas.base.permission.util.cloud.bean.CloudUserSyncDetailResultInfo;
import com.kingdee.eas.base.permission.util.cloud.bean.CloudUserSyncResultInfo;
import com.kingdee.eas.base.permission.util.cloud.bean.CloudUserSyncReturnDataInfo;
import com.kingdee.eas.base.permission.util.cloud.bean.CloudUserSyncReturnDetailDataInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public final class SynUserToCloudHelper {
    private static final Logger logger = Logger.getLogger(SynUserToCloudHelper.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    public static String syncShrUserToCloud(Context ctx) throws EASBizException, BOSException {
        SynShrUserToCloudUtils.clearSyncResultCacheKey();
        StringBuffer syncStr = new StringBuffer();
        List<CloudUserInfo> syncDisableUserData = SynUserToCloudHelper.removeDuplicates(SynUserToCloudHelper.assembleCloudDisableUserInfoByPage(ctx));
        String syncDisableUserStr = SynShrUserToCloudUtils.syncShrUserToCloud(ctx, syncDisableUserData);
        syncStr.append(syncDisableUserStr);
        List<CloudUserInfo> syncEnableUserData = SynUserToCloudHelper.removeDuplicates(SynUserToCloudHelper.assembleCloudEnableUserInfoByPage(ctx));
        String syncEnableUserStr = SynShrUserToCloudUtils.syncShrUserToCloud(ctx, syncEnableUserData);
        syncStr.append(syncEnableUserStr);
        SynShrUserToCloudUtils.writeCloudParamLog(ctx);
        return syncStr.toString();
    }

    public static List<CloudUserInfo> getSyncUserList(Context ctx) throws EASBizException, BOSException {
        SynShrUserToCloudUtils.clearSyncResultCacheKey();
        List<CloudUserInfo> syncDisableUserData = SynUserToCloudHelper.removeDuplicates(SynUserToCloudHelper.assembleCloudDisableUserInfoByPage(ctx));
        List<CloudUserInfo> syncEnableUserData = SynUserToCloudHelper.removeDuplicates(SynUserToCloudHelper.assembleCloudEnableUserInfoByPage(ctx));
        if (syncEnableUserData != null && syncDisableUserData != null) {
            if (syncDisableUserData.size() > syncEnableUserData.size()) {
                syncDisableUserData.addAll(syncEnableUserData);
                return syncDisableUserData;
            }
            syncEnableUserData.addAll(syncDisableUserData);
            return syncEnableUserData;
        }
        if (syncEnableUserData != null) {
            return syncEnableUserData;
        }
        return syncDisableUserData;
    }

    public static List<CloudUserInfo> removeDuplicates(List<CloudUserInfo> syncEnableUserData) {
        ArrayList<CloudUserInfo> targetData = new ArrayList<CloudUserInfo>();
        CloudUserInfo cloudUser = null;
        HashMap<String, CloudUserInfo> m = new HashMap<String, CloudUserInfo>();
        int size = syncEnableUserData.size();
        for (int i = 0; i < size; ++i) {
            cloudUser = syncEnableUserData.get(i);
            String erp_account = cloudUser.getErp_account();
            if (m.get(erp_account) != null) continue;
            m.put(erp_account, cloudUser);
            targetData.add(cloudUser);
        }
        return targetData;
    }

    public static String syncShrUserToCloudForClient() throws EASBizException, BOSException {
        return SynShrUserToCloudFacadeFactory.getRemoteInstance().syncShrUserToCloudPaging();
    }

    public static String syncShrUserToCloudInBackground(Context ctx) throws EASBizException, BOSException {
        StringBuffer logBuffer = new StringBuffer();
        logBuffer.append(" [start time]\uff1a ").append(SynShrUserToCloudUtils.formatDateToString(new java.util.Date(), "yyyy-MM-dd HH:mm:ss")).append("\n");
        String syncUserStr = SynUserToCloudHelper.syncShrUserToCloud(ctx);
        logBuffer.append(" [syncUserStr]\uff1a ").append(syncUserStr).append("\n");
        String licenseFilePath = SynShrUserToCloudUtils.downloadLicense(ctx);
        logBuffer.append(" [licenseFilePath]\uff1a ").append(licenseFilePath).append("\n");
        String fileId = String.valueOf(System.currentTimeMillis());
        logBuffer.append(" [fileId]\uff1a ").append(fileId).append("\n");
        boolean uploadSuccess = SynShrUserToCloudUtils.uploadLicenseFile(fileId, licenseFilePath);
        logBuffer.append(" [uploadSuccess]\uff1a ").append(uploadSuccess).append("\n");
        boolean isSuccess = SynUserToCloudHelper.checkUploadIsSuccess(ctx, fileId);
        logBuffer.append(" [parse License isSuccess]\uff1a ").append(isSuccess).append("\n");
        if (isSuccess) {
            int num = SynUserToCloudHelper.importUserFromCloud(ctx);
            logBuffer.append(" [importUserFromCloud number]\uff1a ").append(num).append("\n");
        }
        boolean isRemove = SynShrUserToCloudUtils.removeTempFile(licenseFilePath);
        logBuffer.append(" [removeTempFile is ]\uff1a ").append(licenseFilePath).append("\n");
        logBuffer.append(" [removeTempFile state ]\uff1a ").append(isRemove);
        logBuffer.append(" [end time]\uff1a ").append(SynShrUserToCloudUtils.formatDateToString(new java.util.Date(), "yyyy-MM-dd HH:mm:ss")).append("\n");
        SynShrUserToCloudUtils.writeSyncResultLog(ctx, logBuffer.toString());
        return logBuffer.toString();
    }

    public static CloudUserSyncDetailResultInfo getSyncResultInfo(Context ctx, String key) {
        String json = SynShrUserToCloudUtils.getSynResult(ctx, key);
        return (CloudUserSyncDetailResultInfo)JSONObject.parseObject((String)json, CloudUserSyncDetailResultInfo.class);
    }

    public static CloudUserSyncReturnDataInfo getSyncInfo(Context ctx, String key) {
        String json = SynShrUserToCloudUtils.getSync(ctx, key);
        return (CloudUserSyncReturnDataInfo)JSONObject.parseObject((String)json, CloudUserSyncReturnDataInfo.class);
    }

    public static List<JSONObject> getSyncList(Context ctx) {
        ConcurrentHashMap<String, Object> cache = SynShrUserToCloudUtils.getSimpleCache();
        Set cacheKeySet = cache.keySet();
        ArrayList<JSONObject> resultTotal = new ArrayList<JSONObject>();
        for (String key : cacheKeySet) {
            resultTotal.addAll(SynUserToCloudHelper.assembleSyncData(ctx, key));
        }
        return resultTotal;
    }

    public static List<JSONObject> getSyncResultList(Context ctx) {
        ConcurrentHashMap<String, Object> cache = SynShrUserToCloudUtils.getSimpleCache();
        Set cacheKeySet = cache.keySet();
        ArrayList<JSONObject> resultTotal = new ArrayList<JSONObject>();
        for (String key : cacheKeySet) {
            String result = (String)cache.get(key);
            resultTotal.addAll(SynUserToCloudHelper.assembleSyncResultData(ctx, key, result));
        }
        return resultTotal;
    }

    public static List<JSONObject> assembleSyncData(Context ctx, String key) {
        CloudUserSyncReturnDataInfo res = SynUserToCloudHelper.getSyncInfo(ctx, key);
        List<CloudUserSyncReturnDetailDataInfo> resultlist = res.getData();
        String json = JSONObject.toJSONString(resultlist);
        logger.error((Object)("assembleSyncData result==" + json));
        List _data = JSONObject.parseArray((String)json, JSONObject.class);
        return _data == null ? new ArrayList() : _data;
    }

    public static List<JSONObject> assembleSyncResultData(Context ctx, String key, String result) {
        CloudUserSyncDetailResultInfo res = (CloudUserSyncDetailResultInfo)JSONObject.parseObject((String)result, CloudUserSyncDetailResultInfo.class);
        List<CloudUserSyncResultInfo> resultlist = res.getData();
        String json = JSONObject.toJSONString(resultlist);
        logger.error((Object)("assembleSyncResultData result==" + json));
        List _data = JSONObject.parseArray((String)json, JSONObject.class);
        ArrayList<JSONObject> avliableData = new ArrayList<JSONObject>();
        JSONObject o = null;
        if (_data != null) {
            int size = _data.size();
            for (int i = 0; i < size; ++i) {
                o = (JSONObject)_data.get(i);
                o.put("gender", (Object)SynUserToCloudHelper.convetGenderValueToAlias(o));
                o.put("status", (Object)SynUserToCloudHelper.convetStatusValueToAlias(o));
                o.put("is_delete", (Object)SynUserToCloudHelper.convetIsDeleteValueToAlias(o));
                avliableData.add(o);
            }
        }
        return avliableData;
    }

    private static String convetGenderValueToAlias(JSONObject obj) {
        int gender = Integer.parseInt(String.valueOf(obj.get((Object)"gender")));
        String alias = "";
        if (0 == gender) {
            alias = EASResource.getString((String)RESOURCE, (String)"male");
        } else if (1 == gender) {
            alias = EASResource.getString((String)RESOURCE, (String)"female");
        } else if (2 == gender) {
            alias = EASResource.getString((String)RESOURCE, (String)"secret");
        }
        return alias;
    }

    private static String convetStatusValueToAlias(JSONObject obj) {
        int status = Integer.parseInt(String.valueOf(obj.get((Object)"status")));
        String alias = "";
        if (0 == status) {
            alias = EASResource.getString((String)RESOURCE, (String)"DISABLE");
        } else if (1 == status) {
            alias = EASResource.getString((String)RESOURCE, (String)"ENABLE");
        }
        return alias;
    }

    private static String convetIsDeleteValueToAlias(JSONObject obj) {
        int status = Integer.parseInt(String.valueOf(obj.get((Object)"is_delete")));
        String alias = "";
        if (0 == status) {
            alias = EASResource.getString((String)RESOURCE, (String)"no");
        } else if (1 == status) {
            alias = EASResource.getString((String)RESOURCE, (String)"yes");
        }
        return alias;
    }

    public static boolean checkUploadIsSuccess(Context ctx, String fileId) {
        String result = SynShrUserToCloudUtils.getCloudRegistSrv(ctx).getRebelLicenseStatus(fileId);
        JSONObject o = JSONObject.parseObject((String)result);
        return o.getBoolean("success");
    }

    public static String updateCloudUserStatus(Context ctx) throws EASBizException, BOSException {
        List<CloudUserInfo> syncData = SynUserToCloudHelper.assembleCloudUserInfo(ctx);
        return SynShrUserToCloudUtils.updateCloudUserStatus(ctx, syncData);
    }

    public static PermUIGroupMappingCollection getPermUIGroupMapping(Context ctx) throws BOSException {
        IPermUIGroupMapping iPermUIGroupMapping = null;
        iPermUIGroupMapping = null == ctx ? PermUIGroupMappingFactory.getRemoteInstance() : PermUIGroupMappingFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("group"));
        sic.add(new SelectorItemInfo("permItem.id"));
        return iPermUIGroupMapping.getPermUIGroupMappingCollection(view);
    }

    public static List<CloudUserInfo> assembleCloudUserInfoByPage(Context ctx) throws BOSException {
        IUserFacade iuserFac = SynUserToCloudHelper.getSynUserToCloudFacade(ctx);
        try {
            return iuserFac.assembleCloudUserInfo();
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<CloudUserInfo> assembleCloudDisableUserInfoByPage(Context ctx) throws BOSException {
        IUserFacade iuserFac = SynUserToCloudHelper.getSynUserToCloudFacade(ctx);
        try {
            return iuserFac.assembleDisableCloudUserInfo();
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<CloudUserInfo> assembleCloudEnableUserInfoByPage(Context ctx) throws BOSException {
        IUserFacade iuserFac = SynUserToCloudHelper.getSynUserToCloudFacade(ctx);
        try {
            return iuserFac.assembleEnableCloudUserInfo();
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String assembleCloudUserInfoByPageSql(Context ctx) {
        Timestamp lastUpdateTime = SynUserToCloudHelper.getSynLastUpdateTime(ctx);
        String sql = SynUserToCloudHelper.getUserPermissionInfoSql(ctx, lastUpdateTime);
        return sql;
    }

    public static String assembleCloudDisableUserInfoByPageSql(Context ctx) {
        Timestamp lastUpdateTime = SynUserToCloudHelper.getSynLastUpdateTime(ctx);
        String sql = SynUserToCloudHelper.getDisableUserPermissionInfoSql(ctx, lastUpdateTime);
        return sql;
    }

    public static String assembleCloudEnableUserInfoByPageSql(Context ctx) {
        Timestamp lastUpdateTime = SynUserToCloudHelper.getSynLastUpdateTime(ctx);
        String sql = SynUserToCloudHelper.getEnabledUserPermissionInfoSql(ctx, lastUpdateTime);
        return sql;
    }

    private static void mergeCloudUserGroupName(Map<String, CloudUserInfo> mpUseridClouduser, Map<String, String> mpUseridGroupname1, Map<String, String> mpUseridGroupname2) {
        for (String userid : mpUseridClouduser.keySet()) {
            CloudUserInfo cui = mpUseridClouduser.get(userid);
            cui.mergeGroupName(mpUseridGroupname1.get(userid));
            cui.mergeGroupName(mpUseridGroupname2.get(userid));
        }
    }

    public static List<CloudUserInfo> doAssembleCloudUserInfoByPage(Context ctx, String sql) throws BOSException {
        long t1 = System.currentTimeMillis();
        List<CloudUserInfo> cloudUserInfos = new ArrayList<CloudUserInfo>();
        Map<String, CloudUserInfo> mpUseridClouduser = SynUserToCloudHelper.getdoAssembleCloudUserInfo(ctx, null);
        Map<String, String> mpUseridGroupname1 = SynUserToCloudHelper.getCloudUserGroupMappingByUserorgperm(ctx, null);
        Map<String, String> mpUseridGroupname2 = SynUserToCloudHelper.getCloudUserMappingGroupByUserroleorg(ctx, null);
        SynUserToCloudHelper.mergeCloudUserGroupName(mpUseridClouduser, mpUseridGroupname1, mpUseridGroupname2);
        SynUserToCloudHelper.mergeOtherDataCenterUserGroup(ctx, mpUseridClouduser);
        cloudUserInfos.addAll(mpUseridClouduser.values());
        long t2 = System.currentTimeMillis();
        logger.error((Object)("SynUserToCloudHelper.doAssembleCloudUserInfoByPage(Context ctx, String sql):executeQuery cost time=" + (t2 - t1)));
        Map licenseUsersInfo = null;
        try {
            licenseUsersInfo = CloudRegistMemoryManager.getInstance().getRegistUserMapGroup();
        }
        catch (LicenseFileErrorException e) {
            logger.error((Object)"SynUserToCloudHelper.doAssembleCloudUserInfoByPage(Context ctx, String sql):getRegistUserMapGroup error.");
        }
        if (licenseUsersInfo != null) {
            cloudUserInfos = SynUserToCloudHelper.removeUnchangeUser(cloudUserInfos, licenseUsersInfo);
        }
        long t3 = System.currentTimeMillis();
        logger.error((Object)("SynUserToCloudHelper.doAssembleCloudUserInfoByPage(Context ctx, String sql):removeUnchangeUser cost time=" + (t3 - t2)));
        return cloudUserInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mergeOtherDataCenterUserGroup(Context ctx, Map<String, CloudUserInfo> mpUseridClouduser) {
        Set dataSourceAISs = EJBFactory.getQueryDataSources();
        Hashtable htDataSourceEJBUtils = EJBFactory.getQueryDSCache();
        if (dataSourceAISs == null || dataSourceAISs.size() < 0) {
            return;
        }
        String currDataSourceAIS = ctx.getAIS();
        Map<String, CloudUserInfo> mpUseridCloudusertemp = null;
        Map<String, String> mpUseridGroupnametemp1 = null;
        Map<String, String> mpUseridGroupnametemp2 = null;
        for (String dataSourceAIS : dataSourceAISs) {
            if (currDataSourceAIS.equalsIgnoreCase(dataSourceAIS)) continue;
            EJBUtils ejbUtil = (EJBUtils)htDataSourceEJBUtils.get(dataSourceAIS);
            try {
                mpUseridCloudusertemp = SynUserToCloudHelper.getdoAssembleCloudUserInfo(ctx, ejbUtil.getConnection());
                mpUseridGroupnametemp1 = SynUserToCloudHelper.getCloudUserGroupMappingByUserorgperm(ctx, ejbUtil.getConnection());
                mpUseridGroupnametemp2 = SynUserToCloudHelper.getCloudUserMappingGroupByUserroleorg(ctx, ejbUtil.getConnection());
                SynUserToCloudHelper.mergeCloudUserGroupName(mpUseridCloudusertemp, mpUseridGroupnametemp1, mpUseridGroupnametemp2);
            }
            catch (BOSException e) {
                logger.error((Object)("SynUserToCloudHelper.mergeOtherDataCenterUserGroup:getdoAssembleCloudUserInfo,ctx.getAis=" + ctx.getAIS()));
            }
            catch (SQLException e) {
                logger.error((Object)("SynUserToCloudHelper.mergeOtherDataCenterUserGroup:getdoAssembleCloudUserInfo,ejbUtil.getConnection() error.ctx.getAis=" + ctx.getAIS()));
            }
            if (mpUseridCloudusertemp == null) continue;
            for (String userId : mpUseridClouduser.keySet()) {
                CloudUserInfo cui1 = mpUseridClouduser.get(userId);
                CloudUserInfo cui2 = mpUseridCloudusertemp.get(userId);
                cui1.mergeGroupName(cui2);
            }
        }
    }

    private static List<CloudUserInfo> removeUnchangeUser(List<CloudUserInfo> cloudUserInfos, Map<String, CloudRegistUserInfo> licenseUsersInfos) {
        if (licenseUsersInfos == null) {
            return null;
        }
        ArrayList<CloudUserInfo> changeCloudUsers = new ArrayList<CloudUserInfo>();
        int len = cloudUserInfos.size();
        for (int i = 0; i < len; ++i) {
            CloudUserInfo cui = cloudUserInfos.get(i);
            if (!SynUserToCloudHelper.isNeedUpdateToCloud(cui, licenseUsersInfos.get(cui.getErp_account()))) continue;
            changeCloudUsers.add(cui);
        }
        return changeCloudUsers;
    }

    private static boolean isNeedUpdateToCloud(CloudUserInfo cloudUserInfo, CloudRegistUserInfo licenseUsersInfo) {
        return !cloudUserInfo.equals(licenseUsersInfo);
    }

    public static List<CloudUserInfo> assembleCloudUserInfo(Context ctx) throws BOSException {
        ArrayList<CloudUserInfo> list = new ArrayList();
        if (ctx == null) {
            try {
                list = UserFacadeFactory.getRemoteInstance().assembleCloudUserInfo();
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
        } else {
            try {
                list = UserFacadeFactory.getLocalInstance(ctx).assembleCloudUserInfo();
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
        }
        return list;
    }

    public static List<CloudUserInfo> assembleCloudUserInfoByType(Context ctx, AssembleCloudUserTypeEnum type) throws BOSException {
        ArrayList<CloudUserInfo> list = new ArrayList();
        if (ctx == null) {
            try {
                list = UserFacadeFactory.getRemoteInstance().assembleUserCloudInfoByType(type.getValue());
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
        } else {
            try {
                list = UserFacadeFactory.getLocalInstance(ctx).assembleUserCloudInfoByType(type.getValue());
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
        }
        return list;
    }

    public static IUserFacade getSynUserToCloudFacade(Context ctx) {
        IUserFacade interfacce = null;
        if (ctx == null) {
            try {
                interfacce = UserFacadeFactory.getRemoteInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                interfacce = UserFacadeFactory.getLocalInstance(ctx);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return interfacce;
    }

    public static List<CloudUserInfo> doAssembleCloudUserByRowSet(Context ctx, IRowSet rowSet) throws BOSException {
        ArrayList<CloudUserInfo> syncData = new ArrayList<CloudUserInfo>();
        JSONArray localcloudUsers = SynShrUserToCloudUtils.getCloudRegistUserInfoFromLicense(ctx);
        HashMap<String, CloudUserInfo> userMap = new HashMap<String, CloudUserInfo>();
        try {
            while (rowSet.next()) {
                String userId = rowSet.getString("userId");
                String group = rowSet.getString("groupName");
                if (null == userMap.get(userId)) {
                    CloudUserInfo cloudUserInfo = SynUserToCloudHelper.assembleCloudUserInfo((ResultSet)rowSet, localcloudUsers);
                    userMap.put(userId, cloudUserInfo);
                    syncData.add(cloudUserInfo);
                    continue;
                }
                if (StringUtils.isEmpty((String)group)) continue;
                CloudUserInfo source = (CloudUserInfo)userMap.get(userId);
                String sourceGroup = source.getProd_group();
                source.setProd_group(SynUserToCloudHelper.margetGroup(sourceGroup, group));
                userMap.put(userId, source);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return syncData;
    }

    private static String margetGroup(String sourceGroup, String newGroup) {
        if (StringUtils.isEmpty((String)newGroup)) {
            return sourceGroup;
        }
        StringBuffer group = new StringBuffer();
        if (!StringUtils.isEmpty((String)sourceGroup)) {
            if (!sourceGroup.toString().contains(newGroup)) {
                group.append(sourceGroup);
                group.append(";");
                group.append(newGroup);
            } else {
                group.append(sourceGroup);
            }
        } else {
            group.append(newGroup);
        }
        return group.toString();
    }

    private static CloudUserInfo assembleCloudUserInfo(ResultSet userOrgPermRowSet, JSONArray localcloudUsers) throws SQLException {
        CloudUserInfo cloudUserInfo = new CloudUserInfo();
        Date birthday = userOrgPermRowSet.getDate("birthday");
        String uname = userOrgPermRowSet.getString("uname");
        String uNumber = userOrgPermRowSet.getString("unumber");
        String pNumber = userOrgPermRowSet.getString("pnumber");
        String email = userOrgPermRowSet.getString("email");
        String cell = userOrgPermRowSet.getString("cell");
        String position = userOrgPermRowSet.getString("posName");
        int gender = userOrgPermRowSet.getInt("gender");
        String dept = userOrgPermRowSet.getString("dept");
        String idno = userOrgPermRowSet.getString("fidcardno");
        int status = userOrgPermRowSet.getInt("FForbidden");
        int isDelete = userOrgPermRowSet.getInt("FIsDelete");
        Map<String, String> localFileUserMap = SynShrUserToCloudUtils.findCloudUserFromLocalLicenseFile(localcloudUsers, uNumber);
        String _uid = localFileUserMap.get("cloudUuId");
        cloudUserInfo.setBirthday(SynUserToCloudHelper.paraseDateToString(birthday));
        cloudUserInfo.setDepartment(dept);
        cloudUserInfo.setEmail(email);
        cloudUserInfo.setErp_account(uNumber);
        int cloud_gender = 0;
        cloud_gender = 1 == gender ? 0 : (2 == gender ? 1 : 2);
        cloudUserInfo.setGender(cloud_gender);
        cloudUserInfo.setIdno(idno);
        cloudUserInfo.setMid(pNumber);
        cloudUserInfo.setName(uname);
        cloudUserInfo.setPhone(cell);
        cloudUserInfo.setPosition(position);
        cloudUserInfo.setStatus(status == 1 ? 0 : 1);
        cloudUserInfo.setIs_delete(isDelete);
        if (!StringUtils.isEmpty((String)_uid)) {
            int uid = Integer.parseInt(_uid);
            cloudUserInfo.setUid(uid);
        }
        return cloudUserInfo;
    }

    private static String paraseDateToString(java.util.Date birthday) {
        return SynShrUserToCloudUtils.formatDateToString(birthday, "yyyy-MM-dd");
    }

    public static String getUserPermissionInfoSql(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        String userPerm = SynUserToCloudHelper.assembleAllRolePermSql(ctx, lastUpdateTime);
        String userRolePerm = SynUserToCloudHelper.assembleAllUserPermSql(ctx, lastUpdateTime);
        sql.append(SynUserToCloudHelper.wrapSql(userPerm));
        sql.append(" union ");
        sql.append(SynUserToCloudHelper.wrapSql(userRolePerm));
        return sql.toString();
    }

    public static String assembleAllRolePermSql(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        String userRolePerm = SynUserToCloudHelper.assembleUserRolePerm(ctx, lastUpdateTime);
        sql.append(userRolePerm);
        return sql.toString();
    }

    public static String assembleAllUserPermSql(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        String userPerm = SynUserToCloudHelper.assembleUserPerm(ctx, lastUpdateTime);
        sql.append(userPerm);
        return sql.toString();
    }

    public static String getEnabledUserPermissionInfoSql(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        String userPerm = SynUserToCloudHelper.assembleEnabledUserRolePermSql(ctx, lastUpdateTime);
        String userRolePerm = SynUserToCloudHelper.assembleEnabledUserPermSql(ctx, lastUpdateTime);
        sql.append(userPerm);
        sql.append(" union ");
        sql.append(userRolePerm);
        return sql.toString();
    }

    public static String getDisableUserPermissionInfoSql(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        String userPerm = SynUserToCloudHelper.assembleDisableUserPermSql(ctx, lastUpdateTime);
        String userRolePerm = SynUserToCloudHelper.assembleDisableUserRolePermSql(ctx, lastUpdateTime);
        sql.append(userPerm);
        sql.append(" union ");
        sql.append(userRolePerm);
        return sql.toString();
    }

    public static String assembleEnabledUserRolePermSql(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        String userRolePerm = SynUserToCloudHelper.assembleUserRolePerm(ctx, lastUpdateTime);
        sql.append(userRolePerm);
        sql.append(SynUserToCloudHelper.assembleUserStatusFilter(0));
        sql.append(SynUserToCloudHelper.assembleUserDefaultOrderByLastUpdateTime());
        return SynUserToCloudHelper.wrapSql(sql.toString());
    }

    public static String assembleEnabledUserPermSql(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        String userPerm = SynUserToCloudHelper.assembleUserPerm(ctx, lastUpdateTime);
        sql.append(userPerm);
        sql.append(SynUserToCloudHelper.assembleUserStatusFilter(0));
        sql.append(SynUserToCloudHelper.assembleUserDefaultOrderByLastUpdateTime());
        return SynUserToCloudHelper.wrapSql(sql.toString());
    }

    public static String assembleDisableUserRolePermSql(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        String userRolePerm = SynUserToCloudHelper.assembleUserRolePerm(ctx, lastUpdateTime);
        sql.append(userRolePerm);
        sql.append(SynUserToCloudHelper.assembleUserStatusFilter(1));
        sql.append(SynUserToCloudHelper.assembleUserDefaultOrderByLastUpdateTime());
        return SynUserToCloudHelper.wrapSql(sql.toString());
    }

    public static String assembleDisableUserPermSql(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        String userPerm = SynUserToCloudHelper.assembleUserPerm(ctx, lastUpdateTime);
        sql.append(userPerm);
        sql.append(SynUserToCloudHelper.assembleUserStatusFilter(1));
        sql.append(SynUserToCloudHelper.assembleUserDefaultOrderByLastUpdateTime());
        return SynUserToCloudHelper.wrapSql(sql.toString());
    }

    private static String assembleUserStatusFilter(int status) {
        return " and u.FForbidden = " + status;
    }

    private static String assembleUserDefaultOrderByLastUpdateTime() {
        return " order by u.FLASTUPDATETIME asc ";
    }

    private static String wrapSql(String sourceSql) {
        return "select temp.* from (" + sourceSql + ")temp ";
    }

    private static void addFilter(StringBuffer sql, Timestamp lastUpdateTime) {
        if (null != lastUpdateTime) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateStr = format.format(lastUpdateTime);
            sql.append(" and u.FLASTUPDATETIME >={ts'").append(dateStr).append("'}");
            logger.error((Object)MessageFormat.format(" lastUpdateTime is {0}", lastUpdateTime.toLocaleString()));
        } else {
            logger.error((Object)" lastUpdateTime is null");
        }
    }

    private static String assembleUserPerm(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        if (SynShrUserToCloudUtils.isSQLServerDB(ctx)) {
            sql.append(" select top 100 percent ");
        } else {
            sql.append(" select  ");
        }
        sql.append("  u.fid as userId, u.fname_l2 as uname,u.fnumber as unumber,u.FLASTUPDATETIME ");
        sql.append(" ,u.FForbidden,u.FIsDelete ");
        sql.append(" ,u.FCell cell,u.FEMail email,person.fgender gender,person.FIDCARDNO,person.fnumber pnumber");
        sql.append(" ,person.FBirthday birthday");
        sql.append(" ,admin.fname_l2 as dept ");
        sql.append(" ,pos.fname_l2 as posName ");
        sql.append(" ,pgm.fgroupName as groupName ");
        sql.append(" from t_pm_user  u ");
        sql.append(" inner join t_bd_person person on person.fid = u.fpersonid ");
        sql.append(" inner join T_ORG_PositionMember pm on pm.fpersonid = person.fid ");
        sql.append(" inner join T_ORG_Position pos on pm.FPositionID = pos.fid ");
        sql.append(" inner join t_org_admin admin on admin.fid = pos.FAdminOrgUnitId ");
        sql.append(" left join t_pm_userorgperm up on up.fowner = u.fid ");
        sql.append(" left join T_PM_PermItem pi on pi.fid = up.fpermitemid ");
        sql.append(" left join " + UserLicenseGroupTool.getPermUIGroupTableName(ctx) + " pgm on pgm.FPERMITEMID= pi.fid ");
        sql.append(" where u.fid not in('256c221a-0106-1000-e000-10d7c0a813f413B7DE7F','00000000-0000-0000-0000-00000000000013B7DE7F') ");
        sql.append(" and pm.FIsPrimary=1 ");
        SynUserToCloudHelper.addFilter(sql, lastUpdateTime);
        return sql.toString();
    }

    private static String assembleUserRolePerm(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        if (SynShrUserToCloudUtils.isSQLServerDB(ctx)) {
            sql.append(" select top 100 percent ");
        } else {
            sql.append(" select  ");
        }
        sql.append("  u.fid as userId, u.fname_l2 as uname,u.fnumber as unumber,u.FLASTUPDATETIME ");
        sql.append(" ,u.FForbidden,u.FIsDelete ");
        sql.append(" ,u.FCell cell,u.FEMail email,person.fgender gender,person.FIDCARDNO,person.fnumber pnumber");
        sql.append(" ,person.FBirthday birthday");
        sql.append(" ,admin.fname_l2 as dept ");
        sql.append(" ,pos.fname_l2 as posName ");
        sql.append(" ,pgm.fgroupName as groupName ");
        sql.append(" from t_pm_user  u ");
        sql.append(" inner join t_bd_person person on person.fid = u.fpersonid ");
        sql.append(" inner join T_ORG_PositionMember pm on pm.fpersonid = person.fid ");
        sql.append(" inner join T_ORG_Position pos on pm.FPositionID = pos.fid ");
        sql.append(" inner join t_org_admin admin on admin.fid = pos.FAdminOrgUnitId ");
        sql.append(" left join t_pm_userroleorg uroleorg on uroleorg.fuserId = u.fid ");
        sql.append(" left join t_pm_role urole on urole.fid = uroleorg.FRoleID ");
        sql.append(" left join t_pm_roleperm rp on rp.FRoleID = urole.fid ");
        sql.append(" left join T_PM_PermItem pi on pi.fid = rp.fpermitemid ");
        sql.append(" left join " + UserLicenseGroupTool.getPermUIGroupTableName(ctx) + " pgm on pgm.FPERMITEMID= pi.fid ");
        sql.append(" where u.fid not in('256c221a-0106-1000-e000-10d7c0a813f413B7DE7F','00000000-0000-0000-0000-00000000000013B7DE7F') ");
        sql.append(" and pm.FIsPrimary=1 ");
        SynUserToCloudHelper.addFilter(sql, lastUpdateTime);
        return sql.toString();
    }

    public static IRowSet getPersonInfo(Set<String> personNumbers) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select  ");
        sql.append("  u.fid as userId, u.fname_l2  uname,u.fnumber unumber ");
        sql.append(" ,u.FForbidden,u.FIsDelete ,u.FCell cell,u.FEMail email ");
        sql.append(" ,person.fgender gender,person.FIDCARDNO idCardNO,person.fnumber pnumber");
        sql.append(" ,person.FBirthday birthday");
        sql.append(" ,admin.fname_l2  dept ");
        sql.append(" ,pos.fname_l2  posName ");
        sql.append(" from t_pm_user  u ");
        sql.append(" inner join t_bd_person person on person.fid = u.fpersonid ");
        sql.append(" inner join T_ORG_PositionMember pm on pm.fpersonid = person.fid ");
        sql.append(" inner join T_ORG_Position pos on pm.FPositionID = pos.fid ");
        sql.append(" inner join t_org_admin admin on admin.fid = pos.FAdminOrgUnitId ");
        sql.append(" where u.fid not in('256c221a-0106-1000-e000-10d7c0a813f413B7DE7F','00000000-0000-0000-0000-00000000000013B7DE7F') ");
        sql.append(" and pm.FIsPrimary=1 ");
        sql.append(SynUserToCloudHelper.addPeronNumberFilter(personNumbers));
        try {
            return SynShrUserToCloudUtils.executeQuery(null, sql.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String addPeronNumberFilter(Set<String> personNumbers) {
        if (personNumbers == null || personNumbers.size() == 0) {
            return " ";
        }
        return " and person.fnumber in " + SynUserToCloudHelper.convetSetToString(personNumbers) + "";
    }

    public static String convetSetToString(Set<String> set) {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>(set);
        sb.append("(");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append("'");
                sb.append((String)list.get(i));
                sb.append("')");
                continue;
            }
            if (i != size - 1) {
                sb.append("'");
                sb.append((String)list.get(i));
                sb.append("', ");
                continue;
            }
            sb.append("'");
            sb.append((String)list.get(i));
            sb.append("')");
        }
        return sb.toString();
    }

    public static Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Timestamp getSynLastUpdateTime(Context ctx) {
        String sql = "select flastupdatetime from T_PM_SynShrUserToCloud";
        try {
            IRowSet rs = SynShrUserToCloudUtils.executeQuery(ctx, sql);
            if (rs.next()) {
                return rs.getTimestamp(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int importUserFromCloud(Context ctx) {
        String cloudUserString;
        ICloudRegistSrv cloudRegistSrv = null;
        IUserFacade userFacade = null;
        try {
            if (null == ctx) {
                userFacade = UserFacadeFactory.getRemoteInstance();
                cloudRegistSrv = CloudRegistSrvAgentFactory.getRemoteInstance();
            } else {
                userFacade = UserFacadeFactory.getLocalInstance(ctx);
                cloudRegistSrv = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int page = 0;
        int rows = 500;
        int successCount = 0;
        while (!StringUtils.isEmpty((String)(cloudUserString = cloudRegistSrv.getCloudRegistUser(page * rows, rows)))) {
            ++page;
        }
        return successCount;
    }

    public static Map<String, Map<String, String>> convetToUserDatas(List<CloudUserInfo> data) {
        HashMap<String, Map<String, String>> users = new HashMap<String, Map<String, String>>(data.size());
        HashMap<String, String> map = null;
        String group = "";
        String genderAlias = "";
        for (CloudUserInfo u : data) {
            map = new HashMap<String, String>();
            map.put("userNumber", u.getErp_account());
            map.put("userName", u.getName());
            map.put("personNumber", u.getMid());
            map.put("deptName", u.getDepartment());
            int gender = u.getGender();
            genderAlias = 0 == gender ? EASResource.getString((String)RESOURCE, (String)"female") : (1 == gender ? EASResource.getString((String)RESOURCE, (String)"male") : EASResource.getString((String)RESOURCE, (String)"secret"));
            map.put("gender", genderAlias);
            map.put("birthday", u.getBirthday());
            map.put("idCardNO", u.getIdno());
            map.put("email", u.getEmail());
            map.put("phone", u.getPhone());
            map.put("position", u.getPosition());
            group = u.getProd_group();
            String no = EASResource.getString((String)RESOURCE, (String)"no");
            if (group == null) {
                map.put("SLF", no);
                map.put("PRF", no);
                map.put("SYS", no);
            } else {
                String yes = EASResource.getString((String)RESOURCE, (String)"yes");
                if (group.indexOf("SLF") != -1) {
                    map.put("SLF", yes);
                } else {
                    map.put("SLF", no);
                }
                if (group.indexOf("PRF") != -1) {
                    map.put("PRF", yes);
                } else {
                    map.put("PRF", no);
                }
                if (group.indexOf("SYS") != -1) {
                    map.put("SYS", yes);
                } else {
                    map.put("SYS", no);
                }
            }
            users.put(u.getErp_account(), map);
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, CloudUserInfo> getdoAssembleCloudUserInfo(Context ctx, Connection conn) throws BOSException {
        HashMap<String, CloudUserInfo> mpUserCloudInfo = new HashMap<String, CloudUserInfo>();
        if (ctx == null) {
            return mpUserCloudInfo;
        }
        String sqlConstants = "select  u.fid as userId, u.fname_l2 as uname, u.fnumber as unumber, u.FLASTUPDATETIME, u.FForbidden, u.FIsDelete  ,u.FCell cell, u.FEMail email, person.fgender gender, person.FIDCARDNO, person.fnumber pnumber, person.FBirthday birthday , admin.fname_l2 as dept, pos.fname_l2 as posName  from t_pm_user  u  left join t_bd_person person on person.fid = u.fpersonid  left join T_ORG_PositionMember pm on pm.fpersonid = person.fid  left join T_ORG_Position pos on pm.FPositionID = pos.fid  left join t_org_admin admin on admin.fid = pos.FAdminOrgUnitId ";
        Statement statement = null;
        ResultSet rs = null;
        try {
            if (conn == null) {
                conn = EJBFactory.getConnection((Context)ctx);
            }
            statement = conn.createStatement();
            statement.setFetchSize(1000);
            rs = statement.executeQuery(sqlConstants);
            JSONArray localcloudUsers = SynShrUserToCloudUtils.getCloudRegistUserInfoFromLicense(ctx);
            while (rs.next()) {
                String userId = rs.getString(1);
                CloudUserInfo cloudUserInfo = SynUserToCloudHelper.assembleCloudUserInfo(rs, localcloudUsers);
                mpUserCloudInfo.put(userId, cloudUserInfo);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"SynUserToCloudHelper.getdoAssembleCloudUserInfo-1");
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return mpUserCloudInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getCloudUserGroupMappingByUserorgperm(Context ctx, Connection conn) throws BOSException {
        HashMap<String, String> mpUserGroupMap = new HashMap<String, String>();
        if (ctx == null) {
            return mpUserGroupMap;
        }
        String sqlUserorgperm = "select up.fowner , pgm.fgroupName from t_pm_userorgperm up  inner join T_PM_PermItem pi on pi.fid = up.fpermitemid  inner join " + UserLicenseGroupTool.getPermUIGroupTableName(ctx) + " pgm on pgm.FPERMITEMID= pi.fid ";
        Statement statement = null;
        ResultSet rs = null;
        try {
            if (conn == null) {
                conn = EJBFactory.getConnection((Context)ctx);
            }
            statement = conn.createStatement();
            statement.setFetchSize(1000);
            rs = statement.executeQuery(sqlUserorgperm);
            while (rs.next()) {
                String key = rs.getString(1);
                String value = rs.getString(2);
                if (mpUserGroupMap.get(key) != null) {
                    value = (String)mpUserGroupMap.get(key) + ";" + value;
                }
                mpUserGroupMap.put(key, value);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"SynUserToCloudHelper.getCloudUserGroupMappingByUserorgperm-1");
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return mpUserGroupMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getCloudUserMappingGroupByUserroleorg(Context ctx, Connection conn) throws BOSException {
        HashMap<String, String> mpUserGroupMap = new HashMap<String, String>();
        if (ctx == null) {
            return mpUserGroupMap;
        }
        String sqluserroleorg = "select uroleorg.fuserId , pgm.fgroupName from t_pm_userroleorg uroleorg  inner join t_pm_role urole on urole.fid = uroleorg.FRoleID   inner join t_pm_roleperm rp on rp.FRoleID = urole.fid   inner join T_PM_PermItem pi on pi.fid = rp.fpermitemid   inner join " + UserLicenseGroupTool.getPermUIGroupTableName(ctx) + " pgm on pgm.FPERMITEMID= pi.fid ";
        Statement statement = null;
        ResultSet rs = null;
        try {
            if (conn == null) {
                conn = EJBFactory.getConnection((Context)ctx);
            }
            statement = conn.createStatement();
            statement.setFetchSize(1000);
            rs = statement.executeQuery(sqluserroleorg);
            while (rs.next()) {
                String key = rs.getString(1);
                String value = rs.getString(2);
                String groupName = (String)mpUserGroupMap.get(key);
                if (groupName != null) {
                    if (groupName.indexOf(value) < 0) {
                        groupName = groupName + ";" + value;
                    }
                    mpUserGroupMap.put(key, groupName);
                    continue;
                }
                mpUserGroupMap.put(key, value);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"SynUserToCloudHelper.getCloudUserMappingGroupByUserroleorg-1");
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return mpUserGroupMap;
    }
}

