/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util.cloud.kbc;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.permission.util.cloud.HttpsClientUtil;
import com.kingdee.eas.base.permission.util.cloud.bean.CloudUserInfo;
import com.kingdee.eas.base.permission.util.cloud.kbc.dto.SyncUserResult;
import com.kingdee.eas.base.permission.util.cloud.kbc.dto.SyncUserResultGet;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.common.EASBizException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;

public class SyncUsersToCloudBean {
    private static Logger logger = Logger.getLogger(SyncUsersToCloudBean.class);
    public static final String SYNUSER_API = "kdproduct/member/sync/data";
    public static final String SYNUSER_RESULT_API = "kdproduct/prod_instance/member/sync_result";
    public static final int SYNC_MAXUSER_COUNT = 100;
    private String productInstanceID = null;
    private String syncFailContent = null;
    private List<CloudUserInfo> syncData = new ArrayList<CloudUserInfo>();
    private List<CloudUserInfo> syncfailResult = new ArrayList<CloudUserInfo>();
    private List<SyncUserResultGet.SyncUserResultGetData> cloudSyncfailResult = new ArrayList<SyncUserResultGet.SyncUserResultGetData>();

    public SyncUsersToCloudBean(String productInstanceID, List<CloudUserInfo> syncData) {
        this.productInstanceID = productInstanceID;
        this.syncData = syncData;
    }

    public SyncUsersToCloudBean execSync() throws EASBizException, BOSException {
        Iterator<CloudUserInfo> iterator = this.syncData.iterator();
        ArrayList<CloudUserInfo> pageData = new ArrayList<CloudUserInfo>();
        int sn = 0;
        while (iterator.hasNext()) {
            pageData.add(iterator.next());
            if (pageData.size() < 100 && iterator.hasNext()) continue;
            String sync_id = System.currentTimeMillis() + (long)(sn + 1) + "";
            this.doPagingSync(pageData, sync_id, iterator.hasNext() ? 1 : 2, this.productInstanceID);
            pageData.clear();
        }
        return this;
    }

    public boolean doPagingSync(List<CloudUserInfo> pagingData, String sync_id, int is_finish, String productInstanceId) throws BOSException {
        boolean isSyncSuccess = false;
        SyncUserResult syncUserResult = this.doSynUsers(pagingData, sync_id, is_finish, productInstanceId);
        if (syncUserResult == null) {
            this.syncfailResult.addAll(pagingData);
        } else if (syncUserResult.isSuccess()) {
            SyncUserResultGet waitSyncResult = this.waitSyncResult(syncUserResult.getKey(), 30000L);
            if (waitSyncResult == null) {
                this.syncfailResult.addAll(pagingData);
            } else if (waitSyncResult.isSuccess()) {
                this.cloudSyncfailResult.addAll(waitSyncResult.getData());
                isSyncSuccess = true;
            } else {
                this.syncfailResult.addAll(pagingData);
            }
        } else {
            this.syncfailResult.addAll(pagingData);
        }
        return isSyncSuccess;
    }

    public SyncUserResult doSynUsers(List<CloudUserInfo> pagingData, String sync_id, int is_finish, String productInstanceId) throws BOSException {
        ArrayList<NameValuePair> param = new ArrayList<NameValuePair>();
        param.add((NameValuePair)new BasicNameValuePair("client_id", EasCloud.CLIENT_ID));
        param.add((NameValuePair)new BasicNameValuePair("client_secret", EasCloud.CLIENT_SECRET));
        param.add((NameValuePair)new BasicNameValuePair("prod_inst_code", productInstanceId));
        param.add((NameValuePair)new BasicNameValuePair("sync_id", sync_id));
        param.add((NameValuePair)new BasicNameValuePair("is_finish", String.valueOf(is_finish)));
        String data = new Gson().toJson(pagingData);
        param.add((NameValuePair)new BasicNameValuePair("data", data));
        String url = EasCloud.CLOUD_URL + SYNUSER_API;
        String result = "";
        try {
            result = HttpsClientUtil.post(EasCloud.CLOUD_URL + SYNUSER_API, param);
        }
        catch (Exception e) {
            logger.error((Object)("http post error\uff01url:" + url + ";data:" + data), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        SyncUserResult syncUserResult = null;
        try {
            syncUserResult = (SyncUserResult)new Gson().fromJson(result, SyncUserResult.class);
        }
        catch (Exception e) {
            logger.error((Object)("doSynUsers() fromJson to Object error! \u5f85\u8f6c\u6362\u5185\u5bb9:" + result), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return syncUserResult;
    }

    public SyncUserResultGet waitSyncResult(String syncId, long timeOut) throws BOSException {
        String synReusltUrl = SyncUsersToCloudBean.getSynReusltUrl(this.productInstanceID, syncId);
        String result = "";
        SyncUserResultGet syncUserResultGet = null;
        long start = System.currentTimeMillis();
        do {
            try {
                result = HttpsClientUtil.get(synReusltUrl);
            }
            catch (Exception e) {
                logger.error((Object)("http get error\uff01url:" + synReusltUrl), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            try {
                syncUserResultGet = (SyncUserResultGet)new Gson().fromJson(result, SyncUserResultGet.class);
                if (!syncUserResultGet.isImporting()) break;
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                logger.error((Object)("waitSyncResult() fromJson to Object error! \u5f85\u8f6c\u6362\u5185\u5bb9:" + result), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        } while (System.currentTimeMillis() - start > timeOut);
        return syncUserResultGet;
    }

    public static String getSynReusltUrl(String productInstanceId, String reskey) {
        String url = EasCloud.CLOUD_URL + SYNUSER_RESULT_API + "?client_id=" + EasCloud.CLIENT_ID + "&client_secret=" + EasCloud.CLIENT_SECRET + "&prod_inst_code=" + productInstanceId + "&key=" + reskey;
        return url;
    }

    public List<CloudUserInfo> getSyncfailResult() {
        return this.syncfailResult;
    }

    public List<SyncUserResultGet.SyncUserResultGetData> getCloudSyncfailResult() {
        return this.cloudSyncfailResult;
    }

    public static void main(String[] args) throws Exception {
        String pageingData = SyncUsersToCloudBean.read("D:\\KBC\u591a\u8bb8\u53ef\u6587\u4ef6\u6d4b\u8bd5\\syncUsreData.json");
        ArrayList<NameValuePair> param = new ArrayList<NameValuePair>();
        param.add((NameValuePair)new BasicNameValuePair("client_id", EasCloud.CLIENT_ID));
        param.add((NameValuePair)new BasicNameValuePair("client_secret", EasCloud.CLIENT_SECRET));
        param.add((NameValuePair)new BasicNameValuePair("prod_inst_code", "16496670101dcabcbd11a4bdbdcb35ce"));
        param.add((NameValuePair)new BasicNameValuePair("sync_id", String.valueOf(System.currentTimeMillis())));
        param.add((NameValuePair)new BasicNameValuePair("is_finish", String.valueOf(1)));
        param.add((NameValuePair)new BasicNameValuePair("data", pageingData));
        String res = HttpsClientUtil.post(EasCloud.CLOUD_URL + SYNUSER_API, param);
        System.out.print(res);
        SyncUserResult cloudResult = (SyncUserResult)new Gson().fromJson(res, SyncUserResult.class);
        if (cloudResult.isSuccess()) {
            String key = cloudResult.getData().getKey();
            Thread.sleep(2000L);
            String string = HttpsClientUtil.get(SyncUsersToCloudBean.getSynReusltUrl("16496670101dcabcbd11a4bdbdcb35ce", key));
            System.out.println(string);
            String string1 = HttpsClientUtil.get(SyncUsersToCloudBean.getSynReusltUrl("16496670101dcabcbd11a4bdbdcb35ce", key));
            System.out.println(string1);
            SyncUserResultGet syncUserResultGet = (SyncUserResultGet)new Gson().fromJson(string, SyncUserResultGet.class);
            System.out.println(syncUserResultGet.getData().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String read(String fileName) {
        StringBuilder data = new StringBuilder();
        BufferedReader lnr = null;
        FileInputStream fow = null;
        InputStreamReader ir = null;
        try {
            String input;
            fow = new FileInputStream(fileName);
            ir = new InputStreamReader((InputStream)fow, "UTF-8");
            lnr = new LineNumberReader(ir);
            while ((input = ((LineNumberReader)lnr).readLine()) != null) {
                String trimmedInput = input.trim();
                data.append(trimmedInput);
            }
        }
        catch (IOException e) {
            logger.error((Object)("Read file exception: " + e.getMessage()), (Throwable)e);
        }
        finally {
            try {
                if (lnr != null) {
                    lnr.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)("Close file stream exception: " + e.getMessage()), (Throwable)e);
            }
            try {
                if (ir != null) {
                    ir.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)("Close file stream exception: " + e.getMessage()), (Throwable)e);
            }
            try {
                if (fow != null) {
                    fow.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)("Close file stream exception: " + e.getMessage()), (Throwable)e);
            }
        }
        return data.toString();
    }
}

