/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.xuntong;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class RSAUtils {
    private static final Logger logger = Logger.getLogger(RSAUtils.class);

    public static KeyPair genKeyPair() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(1024);
        return kpg.genKeyPair();
    }

    public static PrivateKey restorePrivateKey(byte[] bytes) throws Exception {
        PKCS8EncodedKeySpec pkcs = new PKCS8EncodedKeySpec(bytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(pkcs);
    }

    public static PublicKey restorePublicKey(byte[] bytes) throws Exception {
        X509EncodedKeySpec pkcs = new X509EncodedKeySpec(bytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(pkcs);
    }

    public static byte[] encrypt(byte[] src, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, key);
        return cipher.doFinal(src);
    }

    public static byte[] deEncrypt(byte[] dest, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, key);
        return cipher.doFinal(dest);
    }

    public static byte[] sign(byte[] src, PrivateKey prvKey) throws Exception {
        Signature sig = Signature.getInstance("MD5withRSA");
        sig.initSign(prvKey);
        sig.update(src);
        return sig.sign();
    }

    public static boolean verifySign(byte[] src, byte[] dest, PublicKey pubKey) throws Exception {
        Signature sig = Signature.getInstance("MD5withRSA");
        sig.initVerify(pubKey);
        sig.update(src);
        return sig.verify(dest);
    }

    public static byte[] encryptLarger(byte[] data, Key key) throws Exception {
        Cipher rsa = RSAUtils.getRSACipher();
        rsa.init(1, key);
        SecureRandom random = new SecureRandom();
        byte[] secretKey = new byte[16];
        random.nextBytes(secretKey);
        Cipher aes = Cipher.getInstance("AES/GCM/PKCS5Padding", "BC");
        SecretKeySpec k = new SecretKeySpec(secretKey, "AES");
        aes.init(1, k);
        byte[] ciphedKey = rsa.doFinal(secretKey);
        byte[] ciphedData = aes.doFinal(data);
        byte[] result = new byte[128 + ciphedData.length];
        System.arraycopy(ciphedKey, 0, result, 0, 128);
        System.arraycopy(ciphedData, 0, result, 128, ciphedData.length);
        return result;
    }

    public static byte[] saltEncrypt(byte[] src, String key) throws Exception {
        int i;
        byte[] keybts = new byte[8];
        byte[] temp = key.getBytes("UTF-8");
        for (i = 0; i < temp.length && i < 8; ++i) {
            keybts[i] = temp[i];
        }
        if (temp.length < 8) {
            for (i = temp.length; i < 8; ++i) {
                keybts[i] = 0;
            }
        }
        SecretKeySpec deskey = new SecretKeySpec(keybts, "DES");
        Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
        IvParameterSpec iv = new IvParameterSpec(keybts);
        cipher.init(1, (Key)deskey, iv);
        byte[] encryptBts = cipher.doFinal(src);
        return encryptBts;
    }

    public static byte[] deEncryptLarger(byte[] data, Key key) throws Exception {
        Cipher rsa = RSAUtils.getRSACipher();
        rsa.init(2, key);
        byte[] secretKeyData = new byte[128];
        System.arraycopy(data, 0, secretKeyData, 0, secretKeyData.length);
        byte[] cipherData = new byte[data.length - secretKeyData.length];
        System.arraycopy(data, secretKeyData.length, cipherData, 0, cipherData.length);
        byte[] secretKey = rsa.doFinal(secretKeyData);
        Cipher aes = Cipher.getInstance("AES/GCM/PKCS5Padding", "BC");
        SecretKeySpec k = new SecretKeySpec(secretKey, "AES");
        aes.init(1, k);
        byte[] deciphedData = aes.doFinal(cipherData);
        return deciphedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTo(byte[] keyBytes, String filePath) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            file = new File(filePath);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(keyBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static String encrypt(String input, Key key) throws Exception {
        byte[] encryptedData = RSAUtils.encryptLarger(input.getBytes("UTF-8"), key);
        String encrpyted = new String(Base64.encodeBase64((byte[])encryptedData), "UTF-8");
        return encrpyted;
    }

    public static String decrypt(String input, Key key) throws Exception {
        byte[] base64Data = Base64.decodeBase64((byte[])input.getBytes("UTF-8"));
        byte[] decrptedData = RSAUtils.deEncryptLarger(base64Data, key);
        return new String(decrptedData, "UTF-8");
    }

    public static Cipher getRSACipher() {
        Cipher rsa = null;
        try {
            rsa = Cipher.getInstance("RSA/ECB/OAEPWithMD5AndMGF1Padding");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)"this should never happen", (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            logger.error((Object)"this should never happen", (Throwable)e);
        }
        return rsa;
    }

    public static void main(String[] args) {
        KeyPair keyPair = null;
        try {
            keyPair = RSAUtils.genKeyPair();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (keyPair == null) {
            return;
        }
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        byte[] publicKeyBytes = publicKey.getEncoded();
        byte[] privateKeyBytes = privateKey.getEncoded();
        RSAUtils.writeTo(publicKeyBytes, "D:/mcloud.public.key");
        RSAUtils.writeTo(privateKeyBytes, "D:/mcloud.private.key");
    }
}

