/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.gpt.dynamic.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.gpt.dynamic.response.OpenAPIResponse;
import com.kingdee.bos.gpt.dynamic.response.talk.Answer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpUtils {
    private static Logger log = Logger.getLogger(HttpUtils.class);
    private static PoolingHttpClientConnectionManager poolConnManager = null;
    private static CloseableHttpClient httpClient;
    private static final int TIME_OUT = 60000;

    public static CloseableHttpClient getConnection() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(60000).build();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolConnManager).setDefaultRequestConfig(config).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(2, false)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGet(String url) {
        HttpGet httpGet = new HttpGet(url);
        CloseableHttpResponse response = null;
        try {
            long startTime = System.currentTimeMillis();
            response = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            log.info((Object)String.format("url: %s, statusCode: %s, consume time: %s ms", url, statusCode, System.currentTimeMillis() - startTime));
            HttpEntity entity = response.getEntity();
            if (statusCode != 200 || entity == null) {
                log.error((Object)String.format("\u8bf7\u6c42%s\u8fd4\u56de\u9519\u8bef\u7801\u6216\u8fd4\u56de\u4e3a\u7a7a\uff1a%s", url, statusCode));
                String string = null;
                return string;
            }
            String string = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            log.error((Object)"http\u8bf7\u6c42\u5f02\u5e38\uff01", (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String httpPost(String url, Map<String, Object> params) {
        return HttpUtils.httpPost(url, params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String url, Map<String, Object> params, Map<String, String> headers) {
        HttpPost httpPost = new HttpPost(url);
        CloseableHttpResponse response = null;
        try {
            JSONObject json = new JSONObject();
            for (String key : params.keySet()) {
                json.put(key, params.get(key));
            }
            json.put("stream", (Object)false);
            httpPost.setEntity((HttpEntity)new StringEntity(json.toString(), "UTF-8"));
            if (headers != null) {
                for (String headName : headers.keySet()) {
                    httpPost.addHeader(headName, headers.get(headName));
                }
            }
            long startTime = System.currentTimeMillis();
            httpPost.setHeader("Content-Type", "application/json");
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            log.info((Object)String.format("url: %s, statusCode: %s, consume time: %s ms", url, statusCode, System.currentTimeMillis() - startTime));
            HttpEntity entity = response.getEntity();
            if (statusCode != 200 || entity == null) {
                log.error((Object)String.format("\u8bf7\u6c42%s\u8fd4\u56de\u9519\u8bef\u7801\u6216\u8fd4\u56de\u4e3a\u7a7a\uff1a%s", url, statusCode));
                String string = null;
                return string;
            }
            String responseStr = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            log.error((Object)String.format("\u8fd4\u56de\u7ed3\u679c\uff1a%s", responseStr));
            String string = responseStr;
            return string;
        }
        catch (IOException e) {
            log.error((Object)"http\u8bf7\u6c42\u5f02\u5e38\uff01", (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpStream(String url, Map<String, Object> params, Map<String, String> headers) {
        HttpPost httpPost = new HttpPost(url);
        CloseableHttpResponse response = null;
        try {
            JSONObject json = new JSONObject();
            for (String key : params.keySet()) {
                json.put(key, params.get(key));
            }
            json.put("stream", (Object)true);
            httpPost.setEntity((HttpEntity)new StringEntity(json.toString(), "UTF-8"));
            if (headers != null) {
                for (String headName : headers.keySet()) {
                    httpPost.addHeader(headName, headers.get(headName));
                }
            }
            long startTime = System.currentTimeMillis();
            httpPost.setHeader("Content-Type", "application/json");
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            log.info((Object)String.format("url: %s, statusCode: %s, consume time: %s ms", url, statusCode, System.currentTimeMillis() - startTime));
            HttpEntity entity = response.getEntity();
            if (statusCode != 200 || entity == null) {
                log.error((Object)String.format("\u8bf7\u6c42%s\u8fd4\u56de\u9519\u8bef\u7801\u6216\u8fd4\u56de\u4e3a\u7a7a\uff1a%s", url, statusCode));
                String resp = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                log.error((Object)String.format("\u8fd4\u56de\u7ed3\u679c\uff1a%s", resp));
                String string = null;
                return string;
            }
            StringBuffer responseStr = new StringBuffer();
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(entity.getContent()));
                while ((line = reader.readLine()) != null) {
                    JSONObject answerJs = JSON.parseObject((String)line);
                    if ("0".equals(answerJs.getString("errCode"))) {
                        responseStr.append(answerJs.getString("llmValue"));
                        continue;
                    }
                    responseStr.append("\n").append(answerJs.getString("errMsg"));
                    break;
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException line) {}
                }
            }
            OpenAPIResponse<Answer> openAPIResponse = new OpenAPIResponse<Answer>();
            Answer answer = new Answer();
            answer.setLlmValue(responseStr.toString());
            openAPIResponse.setData(answer);
            openAPIResponse.setStatus(true);
            log.error((Object)String.format("\u8fd4\u56de\u7ed3\u679c\uff1a%s", responseStr.toString()));
            String string = JSON.toJSONString(openAPIResponse);
            return string;
        }
        catch (IOException e) {
            log.error((Object)"http\u8bf7\u6c42\u5f02\u5e38\uff01", (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static {
        try {
            log.info((Object)"\u521d\u59cb\u5316HttpClient~~~\u5f00\u59cb");
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslsf).build();
            poolConnManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            poolConnManager.setMaxTotal(640);
            poolConnManager.setDefaultMaxPerRoute(320);
            httpClient = HttpUtils.getConnection();
            log.info((Object)"\u521d\u59cb\u5316HttpClient~~~\u7ed3\u675f");
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

