/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.app.AbstractAffairBatchProcessFacadeControllerBean;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.batch.BatchProcessedResult;
import com.kingdee.eas.hr.emp.IPersonWorkExpCur;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.PersonWorkExpCurCollection;
import com.kingdee.eas.hr.emp.PersonWorkExpCurFactory;
import java.util.List;
import org.apache.log4j.Logger;

public class AffairBatchProcessFacadeControllerBean
extends AbstractAffairBatchProcessFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.affair.app.AffairBatchProcessFacadeControllerBean");

    @Override
    protected BatchProcessedResult _processPerson(Context ctx, List personInfos, String billID) throws BOSException, EASBizException {
        if (personInfos == null || personInfos.size() <= 0) {
            return null;
        }
        BatchProcessedResult result = new BatchProcessedResult();
        PersonInfo personInfo = null;
        String personID = null;
        int size = personInfos.size();
        for (int i = 0; i < size; ++i) {
            EmployeeTypeInfo empType;
            personInfo = (PersonInfo)personInfos.get(i);
            personID = personInfo.getId().toString();
            personInfo = this.getPersonInfo(ctx, personID);
            PersonPositionInfo ppInfo = this.getPersonPositionInfo(ctx, personID);
            if (ppInfo != null) {
                personInfo.put("personPosition", (Object)ppInfo);
                if (ppInfo.getDimissionReason() != null) {
                    personInfo.put("dimissionReason", (Object)ppInfo.getDimissionReason());
                }
            }
            if ((empType = personInfo.getEmployeeType()) != null && empType.getInService().getValue() == 1) {
                PositionMemberCollection postRelCols = this.getPositionMemberCollections(ctx, personID);
                if (postRelCols != null) {
                    personInfo.put("positionMember", (Object)postRelCols);
                }
            } else {
                PersonWorkExpCurCollection personWorkExpCur = this.getPersonWorkExpCurCollections(ctx, personID);
                if (personWorkExpCur != null) {
                    personInfo.put("PersonWorkExpCur", (Object)personWorkExpCur);
                }
            }
            result.add((Object)personInfo);
        }
        return result;
    }

    private PersonInfo getPersonInfo(Context ctx, String personId) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("employeeType.*"));
        selector.add(new SelectorItemInfo("employeeClassify.*"));
        return PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId), selector);
    }

    private PersonPositionInfo getPersonPositionInfo(Context ctx, String personId) throws BOSException, EASBizException {
        StringBuffer oqlb = new StringBuffer();
        oqlb.append("select ");
        oqlb.append("id,");
        oqlb.append("personDep.id,");
        oqlb.append("personDep.name,");
        oqlb.append("personDep.number,");
        oqlb.append("personDep.displayName,");
        oqlb.append("primaryPosition.id,");
        oqlb.append("primaryPosition.name,");
        oqlb.append("primaryPosition.job.id,");
        oqlb.append("primaryPosition.job.name,");
        oqlb.append("jobStartDate,");
        oqlb.append("lenOfActualService,");
        oqlb.append("enterDate,");
        oqlb.append("leftDate,");
        oqlb.append("joinDate,");
        oqlb.append("joinGroupDate,");
        oqlb.append("jobLevel.id,");
        oqlb.append("jobLevel.number,");
        oqlb.append("jobLevel.name,");
        oqlb.append("jobGrade.id,");
        oqlb.append("jobGrade.name,");
        oqlb.append("jobGrade.number,");
        oqlb.append("tryoutMonth,");
        oqlb.append("formalDate,");
        oqlb.append("dimissionReason.id,");
        oqlb.append("dimissionReason.number,");
        oqlb.append("dimissionReason.name,");
        oqlb.append("dimissionReason.dimissionReasonType.id,");
        oqlb.append("dimissionReason.dimissionReasonType.number,");
        oqlb.append("dimissionReason.dimissionReasonType.name,");
        oqlb.append("dimissionReason.isPermission,");
        oqlb.append("gkAdmin.id");
        oqlb.append(" where person.id='");
        oqlb.append(personId);
        oqlb.append("'");
        PersonPositionCollection c = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(oqlb.toString());
        if (c.size() > 0) {
            return c.get(0);
        }
        return null;
    }

    private PositionMemberCollection getPositionMemberCollections(Context ctx, String personId) throws BOSException, EASBizException {
        String oql = "select beginDate, endDate, position.id, position.name, position.number, position.job.id, position.job.name, position.job.number, id, position.adminOrgUnit.id, position.adminOrgUnit.name, position.adminOrgUnit.displayName,personRZType.id,personRZType.nuber,personRZType.name,isPrimary where person.id = '" + personId + "' ";
        PositionMemberCollection c = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(oql);
        if (c.size() > 0) {
            return c;
        }
        return null;
    }

    private PersonWorkExpCurCollection getPersonWorkExpCurCollections(Context ctx, String personId) throws BOSException, EASBizException {
        String oql;
        IPersonWorkExpCur ipwxc = PersonWorkExpCurFactory.getLocalInstance((Context)ctx);
        PersonWorkExpCurCollection c = ipwxc.getPersonWorkExpCurCollection(oql = "select position.id,position.name,position.number,position.job.id,position.job.number,position.job.name,position.adminOrgUnit.id,position.adminOrgUnit.name,position.adminOrgUnit.displayName,position.adminOrgUnit.number,personRZType.id,personRZType.name,personRZType.number where person.id = '" + personId + "' order by isPrimary desc,endDate desc");
        if (c.size() > 0) {
            return c;
        }
        return null;
    }
}

