/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryInfo;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillFactory;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.SourceBillTypeEnum;
import com.kingdee.eas.hr.affair.app.HRAffairBillBizBean;
import com.kingdee.eas.hr.base.AffairActionReasonInfo;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.EnrollSourceCollection;
import com.kingdee.eas.hr.base.EnrollSourceFactory;
import com.kingdee.eas.hr.base.EnrollSourceInfo;
import com.kingdee.eas.hr.base.EntityFieldMappingCollection;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HROrgContextManagerFacadeFactory;
import com.kingdee.eas.hr.base.app.his.HistoryVersionUtil;
import com.kingdee.eas.hr.base.app.util.EmpLaborRelationUtil;
import com.kingdee.eas.hr.base.util.HRCheckUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.base.util.MappingApplyUtil;
import com.kingdee.eas.hr.base.util.ShrIDCardNOPassportCheckUtil;
import com.kingdee.eas.hr.emp.IPersonOptFacade;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonEnrollHistoryFactory;
import com.kingdee.eas.hr.emp.PersonEnrollHistoryInfo;
import com.kingdee.eas.hr.emp.PersonOptFacadeFactory;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.app.PersonOptBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.ml.util.MutilanUtils;
import com.kingdee.shr.preentry.PreEntryFactory;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class EmpEnrollBillBizBean
extends HRAffairBillBizBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.affair.app.EmpEnrollBillBizBean");
    private static final String RES = "com.kingdee.eas.hr.affair.EnrollResource";
    private static final String EmpEnrollBizBillPersonPositionInfo = "EmpEnrollBizBillPersonPositionInfo";
    private static final String EmpEnrollBizBillPersonInfo = "EmpEnrollBizBillPersonInfo";
    private static final String ENTRYID = "entryid";
    public static final String PREENTRYID = "preEntryID";
    public static final String DELETEENTRYIDS = "deleteEntryIds";

    @Override
    protected String getInnerState() {
        return null;
    }

    @Override
    protected String getOldAdminField() {
        return null;
    }

    @Override
    protected String getOldPositionField() {
        return null;
    }

    @Override
    protected void _check(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        String preentryId;
        if (entry.get(this.getPersonField()) == null) {
            entry.put(this.getPersonField(), (Object)new PersonInfo());
        }
        super._check(ctx, entry);
        EmpEnrollBizBillEntryInfo enrollEntry = (EmpEnrollBizBillEntryInfo)entry;
        EmpEnrollBizBillInfo bill = enrollEntry.getBill();
        String billID = null;
        if (bill != null && bill.getId() != null) {
            billID = bill.getId().toString();
        }
        String IDCardNo = enrollEntry.getIDCardNo();
        String passportNo = enrollEntry.getPassportNo();
        String entryId = null;
        if (entry.getId() != null) {
            entryId = enrollEntry.getId().toString();
        }
        HashMap<String, Object> excludeIdMap = null;
        if (bill != null && bill.get(DELETEENTRYIDS) != null) {
            excludeIdMap = new HashMap<String, Object>();
            excludeIdMap.put("exEntryIdList", bill.get(DELETEENTRYIDS));
        }
        if (StringUtils.isEmpty((String)(preentryId = enrollEntry.getString(PREENTRYID))) && !StringUtils.isEmpty((String)entryId) && PreEntryFactory.getLocalInstance((Context)ctx).exists("where personBillId = '" + entryId + "'")) {
            preentryId = PreEntryFactory.getLocalInstance((Context)ctx).getPreEntryCollection("where personBillId = '" + entryId + "'").get(0).getId().toString();
        }
        ShrIDCardNOPassportCheckUtil.checkIsIdCardNOPassportDuplicate((Context)ctx, (String)IDCardNo, (String)passportNo, null, (String)entryId, (String)preentryId, (boolean)true, (String)enrollEntry.getEmpName(), excludeIdMap);
        String personID = null;
        if (enrollEntry.getExistPersonID() != null) {
            personID = enrollEntry.getExistPersonID().toString();
        }
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CtrlUnitInfo ctrlInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        PersonInfo info = new PersonInfo();
        info.setCU(ctrlInfo);
        String strCurCompany = codingRuleManager.getCurrentAppOUID((IObjectValue)info);
        if (!codingRuleManager.isExist((IObjectValue)info, strCurCompany)) {
            HRCheckUtil.getPersonNumberCheckInstanceForEmpEnroll((String)billID, (String)personID).check(enrollEntry.getEmpNumber(), ctx);
        }
    }

    protected void doWithPriorityThingEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        EmpEnrollBizBillEntryInfo entryInfo = (EmpEnrollBizBillEntryInfo)entry;
        PersonInfo pInfo = this.savePersonInfo(ctx, entryInfo);
        entryInfo.setPerson(pInfo);
        entryInfo.put(EmpEnrollBizBillPersonInfo, pInfo);
    }

    protected void doWithCommonRelationEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
    }

    protected void doWithSpecialFiledsEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        PersonInfo pInfo;
        PersonPositionInfo ppInfo;
        EmpEnrollBizBillEntryInfo entryInfo = (EmpEnrollBizBillEntryInfo)entry;
        if (entryInfo.isEnrollAgain() && (ppInfo = (PersonPositionInfo)entry.get(EmpEnrollBizBillPersonPositionInfo)) != null) {
            this.saveReEnrollHistory(ctx, ppInfo);
        }
        if ((pInfo = (PersonInfo)entry.get(EmpEnrollBizBillPersonInfo)) == null) {
            return;
        }
        Object[] param = new Object[]{pInfo.getId().toString(), entryInfo.getId().toString()};
        DbUtil.execute((Context)ctx, (String)"Update T_HR_EmpEnrollBizBillEntry SET FPersonID = ? where FID = ? ", (Object[])param);
        DbUtil.execute((Context)ctx, (String)"Update T_HR_AffairBizHistory SET FPersonID = ? where FEntryID = ? ", (Object[])param);
        param = new Object[]{pInfo.getId().toString(), entryInfo.getBill().getId().toString(), entry.getId().toString()};
        DbUtil.execute((Context)ctx, (String)"update T_HR_HRAffairBiz set FPersonID = ? where FBillID = ? and FEntryID = ?", (Object[])param);
        DbUtil.execute((Context)ctx, (String)"update T_HR_AffairBizDetail set FPersonID = ? where FBillID = ? and FEntryID = ?", (Object[])param);
        EmpEnrollBizBillEntryInfo empEnrollEntryInfo = (EmpEnrollBizBillEntryInfo)entry;
        this.doWithEmpLaborRelatioinFields(ctx, empEnrollEntryInfo, pInfo);
    }

    private void doWithEmpLaborRelatioinFields(Context ctx, EmpEnrollBizBillEntryInfo entryInfo, PersonInfo personInfo) throws EASBizException, BOSException {
        EmpLaborRelationInfo.EnrollInfo enrollInfo = new EmpLaborRelationInfo.EnrollInfo();
        enrollInfo.setEnrollAgain(entryInfo.isEnrollAgain());
        enrollInfo.setEnrollDate(entryInfo.getEnrollDate());
        enrollInfo.setPlanFormalDate(entryInfo.getPlanFormalDate());
        enrollInfo.setTryoutMonth(entryInfo.getProbation());
        EmpLaborRelationUtil.doWithEnrollEmpLaborRelatioinFields((Context)ctx, (EmpLaborRelationInfo.EnrollInfo)enrollInfo, (String)personInfo.getId().toString());
    }

    protected void doWithOtherChangeEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
    }

    protected PersonInfo savePersonInfo(Context ctx, EmpEnrollBizBillEntryInfo info) throws BOSException, EASBizException {
        PersonInfo pInfo = this.getPersonInfo(ctx, null, info);
        this.doWithPersonOtherInfo(ctx, info, pInfo);
        PersonPositionInfo ppInfo = this.preparedPersonPositionInfo(ctx, info, pInfo);
        pInfo.put("personPosition", (Object)ppInfo);
        pInfo.put("notNeedGenerateObjectNumber", (Object)true);
        info.put(EmpEnrollBizBillPersonPositionInfo, ppInfo);
        pInfo.put(ENTRYID, (Object)info.getId().toString());
        IPersonOptFacade iPersonOptFacade = PersonOptFacadeFactory.getLocalInstance((Context)ctx);
        PersonOptBaseInfo personOptInfo = new PersonOptBaseInfo();
        personOptInfo.setPerson(pInfo);
        personOptInfo.setPersonPosition(ppInfo);
        personOptInfo.setFromInitialize(false);
        if (SourceBillTypeEnum.PREENTRY.equals((Object)info.getSourceBillType())) {
            personOptInfo.setFromSSC(true);
        } else {
            EmpEnrollBizBillInfo billInfo = EmpEnrollBizBillFactory.getLocalInstance(ctx).getEmpEnrollBizBillInfo((IObjectPK)new ObjectUuidPK(info.getBill().getId().toString()));
            personOptInfo.setFromSSC(billInfo.isIsFromSSC());
        }
        Date effectDate = null;
        if (this.getEntryEffectDateField() != null) {
            effectDate = info.getDate(this.getEntryEffectDateField());
            effectDate = effectDate != null ? DateTimeUtils.truncateDate((Date)effectDate) : info.getBizDate();
        }
        if (!info.isEnrollAgain()) {
            IObjectPK pkPerson = iPersonOptFacade.personAddNew(effectDate, personOptInfo);
            pInfo.setId(BOSUuid.read((String)pkPerson.toString()));
        } else {
            pInfo.setId(info.getExistPersonID());
            iPersonOptFacade.personUpdate(effectDate, personOptInfo);
        }
        return pInfo;
    }

    private void doWithPersonOtherInfo(Context ctx, EmpEnrollBizBillEntryInfo info, PersonInfo personInfo) {
        String entityName = "com.kingdee.eas.hr.emp.app.PersonOtherInfo";
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection propColl = entityInfo.getPropertiesRuntime();
        int size = propColl.size();
        for (int i = 0; i < size; ++i) {
            String propName = propColl.get(i).getName();
            if (this.isPersonOtherInfoExcludeField(propName) || !info.containsKey(propName)) continue;
            personInfo.put(propName, info.get(propName));
        }
    }

    private boolean isPersonOtherInfoExcludeField(String key) {
        return key.equals("id") || key.equals("person");
    }

    public PersonInfo getPersonInfo(Context ctx, PersonInfo pInfo, EmpEnrollBizBillEntryInfo info) throws BOSException, EASBizException {
        if (info == null) {
            return null;
        }
        if (pInfo == null) {
            pInfo = new PersonInfo();
        }
        EmpEnrollBizBillInfo bill = info.getBill();
        pInfo.setEmployeeType(info.getEmpType());
        pInfo.setNumber(info.getEmpNumber());
        if (!StringUtils.isEmpty((String)info.getEmpName())) {
            pInfo.setName(info.getEmpName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            pInfo.setName(info.getEmpName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            pInfo.setName(info.getEmpName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
        }
        if (!StringUtils.isEmpty((String)info.getLastName())) {
            pInfo.setLastName(info.getLastName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            pInfo.setLastName(info.getLastName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            pInfo.setLastName(info.getLastName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
        }
        if (!StringUtils.isEmpty((String)info.getMiddleName())) {
            pInfo.setMiddleName(info.getMiddleName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            pInfo.setMiddleName(info.getMiddleName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            pInfo.setMiddleName(info.getMiddleName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
        }
        if (!StringUtils.isEmpty((String)info.getFirstName())) {
            pInfo.setFirstName(info.getFirstName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            pInfo.setFirstName(info.getFirstName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            pInfo.setFirstName(info.getFirstName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
        }
        MutilanUtils.setMultiFieldValueBeanToBean((IObjectValue)info, (String)"nativePlace", (IObjectValue)pInfo, (String)"nativePlace");
        pInfo.setPassportNO(info.getPassportNo());
        pInfo.setIdCardNO(info.getIDCardNo());
        pInfo.setGender(info.getGender());
        pInfo.setBirthday(info.getBirthday());
        if (!StringUtils.isEmpty((String)info.getGlobalRoaming()) && !StringUtils.isEmpty((String)info.getNCell())) {
            pInfo.setGlobalRoaming(info.getGlobalRoaming().trim());
            pInfo.setNCell(info.getNCell().trim());
        }
        if (!StringUtils.isEmpty((String)info.getTelNum())) {
            pInfo.setCell(info.getTelNum().trim());
        }
        if (!StringUtils.isEmpty((String)info.getEmail())) {
            pInfo.setEmail(info.getEmail().trim());
        }
        pInfo.setFolk(info.getMyFolk());
        pInfo.setStanding(info.getStanding());
        pInfo.setIdCardAddress(info.getIdCardAddress());
        pInfo.setIdCardBeginDate(info.getIdCardStartDate());
        pInfo.setIdCardEndDate(info.getIdCardEndDate());
        pInfo.setIdCardIssueOrg(info.getIdCardIssued());
        pInfo.setDescription(info.getDescription());
        pInfo.setHireDate(info.getBizDate());
        pInfo.setEFFDT(info.getBizDate());
        HROrgUnitInfo hrOrg = bill.getHrOrgUnit();
        if (hrOrg != null) {
            CtrlUnitInfo cu = hrOrg.getCU();
            if (cu == null) {
                cu = HROrgContextManagerFacadeFactory.getLocalInstance((Context)ctx).getCUByHRO(hrOrg);
            }
            pInfo.setCU(cu);
        }
        pInfo.setHrOrgUnit(hrOrg);
        PersonPositionInfo posInfo = new PersonPositionInfo();
        posInfo.setPersonDep(info.getAdminOrg());
        pInfo.put("personposition", (Object)posInfo);
        if (bill.getId() != null) {
            pInfo.put("PersonEnroll", (Object)bill.getId().toString());
            pInfo.put("isEnroll", (Object)true);
        }
        String hrOrgID = null;
        if (hrOrg != null) {
            hrOrgID = hrOrg.getId().toString();
        }
        if (info.isEnrollAgain()) {
            pInfo.setId(info.getExistPersonID());
            pInfo.put("isEnrollAgain", (Object)"true");
        }
        MappingApplyUtil.setValueByMapping((Context)ctx, (IObjectValue)pInfo, (IObjectValue)info, (String)"entrys", (EntityFieldMappingCollection)MappingApplyUtil.getFieldMappingCollection((Context)ctx, (IObjectValue)bill, (String)hrOrgID));
        return pInfo;
    }

    private PersonPositionInfo preparedPersonPositionInfo(Context ctx, EmpEnrollBizBillEntryInfo enrolInfo, PersonInfo perInfo) throws EASBizException, BOSException {
        IPersonPosition ipp = PersonPositionFactory.getLocalInstance((Context)ctx);
        PersonPositionInfo ppInfo = null;
        if (!enrolInfo.isEnrollAgain()) {
            ppInfo = new PersonPositionInfo();
            if (ppInfo.getJoinGroupDate() == null) {
                ppInfo.setJoinGroupDate(enrolInfo.getEnrollDate());
            }
        } else {
            ppInfo = ipp.getPersonPositionInfo("select * where person.id = '" + perInfo.getId().toString() + "'");
            ppInfo.setLeftDate(null);
            ppInfo.setDimissionReason(null);
            ppInfo.setIsEnrollAgain(true);
            ppInfo.setJoinCompanyYears(0.0f);
        }
        ppInfo.setPerson(perInfo);
        ppInfo.setJoinGroupDateCur(enrolInfo.getEnrollDate());
        if (ppInfo.getJoinGroupDate() == null) {
            ppInfo.setJoinGroupDate(enrolInfo.getEnrollDate());
        }
        ppInfo.setJoinDate(enrolInfo.getEnrollDate());
        ppInfo.setJobSequence(enrolInfo.getJobSequence());
        EmpEnrollBizBillInfo billInfo = enrolInfo.getBill();
        ppInfo.setHrOrgUnit(billInfo.getHrOrgUnit());
        ppInfo.setPrimaryPosition(enrolInfo.getPosition());
        ppInfo.setPersonDep(enrolInfo.getAdminOrg());
        ppInfo.setCompany(HRUtilExtend.getCompany((Context)ctx, (AdminOrgUnitInfo)enrolInfo.getAdminOrg()));
        ppInfo.setJoinDate(enrolInfo.getEnrollDate());
        ppInfo.setEFFDT(enrolInfo.getEnrollDate());
        ppInfo.setLEFFDT(HistoryUtil.getMaxDate());
        ppInfo.setStartDateTime(ppInfo.getEFFDT());
        ppInfo.setEndDateTime(HistoryVersionUtil.getMaxEndDate());
        ppInfo.setVersion(1);
        ppInfo.setIsLatestInAday(true);
        return ppInfo;
    }

    public EnrollSourceInfo getEnrollSourceInfoByAffairActionReason(Context ctx, AffairActionReasonInfo affaircReasonInfo) throws BOSException {
        EnrollSourceInfo sourceInfo = null;
        StringBuffer oql = new StringBuffer();
        oql.append("select id where affairActionReason='").append(affaircReasonInfo.getId()).append("'");
        EnrollSourceCollection coll = EnrollSourceFactory.getLocalInstance((Context)ctx).getEnrollSourceCollection(oql.toString());
        if (coll.size() > 0) {
            sourceInfo = coll.get(0);
        }
        return sourceInfo;
    }

    private void saveReEnrollHistory(Context ctx, PersonPositionInfo ppInfo) throws EASBizException, BOSException {
        PersonEnrollHistoryInfo pnhInfo = new PersonEnrollHistoryInfo();
        pnhInfo.setPerson(ppInfo.getPerson());
        pnhInfo.setEnterDate(ppInfo.getEnterDate());
        pnhInfo.setLeftDate(ppInfo.getLeftDate());
        pnhInfo.setJoinDate(ppInfo.getJoinDate());
        pnhInfo.setJoinGroupDate(ppInfo.getJoinGroupDate());
        PersonEnrollHistoryFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)pnhInfo);
    }

    @Override
    protected boolean isNeedCheckJobLevelGradeRange() {
        return true;
    }
}

