/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.FluctuationBillEntryCollection;
import com.kingdee.eas.hr.affair.FluctuationBillEntryFactory;
import com.kingdee.eas.hr.affair.FluctuationBillEntryInfo;
import com.kingdee.eas.hr.affair.FluctuationBillFactory;
import com.kingdee.eas.hr.affair.FluctuationBillInfo;
import com.kingdee.eas.hr.affair.HRAffairBaseInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.HRAffairPersonPreProcessFacadeFactory;
import com.kingdee.eas.hr.affair.app.AbstractFluctuationBillControllerBean;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.FlucTypeBizEnum;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.base.IEmployeeType;
import com.kingdee.eas.hr.base.batch.BatchProcessedResult;
import com.kingdee.eas.hr.base.util.HRCheckUtil;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonDegreeCollection;
import com.kingdee.eas.hr.emp.PersonDegreeFactory;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.org.PersonPlanFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FluctuationBillControllerBean
extends AbstractFluctuationBillControllerBean {
    @Override
    protected HashMap _getFluctuationBillSelfData(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PersonInfo pInfo = (PersonInfo)info;
        String oql = "select id where person.id = '" + pInfo.getId().toString() + "' and (bill.bizState = 0 or bill.bizState = 1)";
        IDynamicObject idy = DynamicObjectFactory.getLocalInstance((Context)ctx);
        if (idy.exists(new FluctuationBillEntryInfo().getBOSType(), oql)) {
            throw new HRAffairException(HRAffairException.PERSON_IS_IN_PROCESS, new Object[]{pInfo.getName(), ""});
        }
        IPersonPosition ipp = PersonPositionFactory.getLocalInstance((Context)ctx);
        PersonPositionCollection ppc = ipp.getPersonPositionCollection("select jobGrade.id, jobGrade.name, jobGrade.number where person.id = '" + pInfo.getId().toString() + "'");
        if (ppc.size() > 0) {
            map.put("OldJobGrade", ppc.get(0).getJobGrade());
        }
        oql = "SELECT T1.FBirthday,T2.FEnterDate FROM T_BD_Person T1,T_HR_PersonPosition T2";
        oql = oql + " WHERE T1.FID = T2.FPersonID AND T1.FID = '" + pInfo.getId().toString() + "'";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)oql);
        try {
            while (rows.next()) {
                ArrayList<Date> value = new ArrayList<Date>();
                value.add(rows.getDate(1));
                value.add(rows.getDate(2));
                map.put("Birthday_EnterDate", value);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        oql = "select degree.name, diploma.name, graduateSchool, specialty where isHighest = 1 and person.id = '" + pInfo.getId().toString() + "'";
        PersonDegreeCollection pdc = PersonDegreeFactory.getLocalInstance((Context)ctx).getPersonDegreeCollection(oql);
        if (pdc.size() > 0) {
            ArrayList<String> value = null;
            value = new ArrayList<String>();
            if (pdc.get(0).getDegree() != null) {
                value.add(pdc.get(0).getDegree().getName());
            } else {
                value.add(null);
            }
            value.add(pdc.get(0).getGraduateSchool());
            value.add(pdc.get(0).getSpecialty());
            if (pdc.get(0).getDiploma() != null) {
                value.add(pdc.get(0).getDiploma().getName());
            } else {
                value.add(null);
            }
            map.put("HighestPersonDegree", value);
        }
        oql = "select jobStartDate, lenOfActualService, enterDate, joinDate, joinGroupDate, jobLevel.id, jobLevel.number, jobLevel.name, jobGrade.id, jobGrade.name, jobGrade.number where person.id = '" + pInfo.getId().toString() + "'";
        ppc = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(oql);
        if (ppc.size() > 0) {
            map.put("PersonPosition", ppc.get(0));
        }
        return map;
    }

    @Override
    protected void checkBillEntry(Context ctx, HRAffairBaseInfo model) throws BOSException, EASBizException {
        super.checkBillEntry(ctx, model);
        if (model instanceof FluctuationBillInfo) {
            FluctuationBillEntryCollection entries = ((FluctuationBillInfo)model).getEntries();
            String billID = null;
            if (model.getId() != null) {
                billID = model.getId().toString();
            }
            if (entries != null) {
                FluctuationBillEntryInfo tempEntry = null;
                String personID = null;
                PositionInfo newPosition = null;
                ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
                int size = entries.size();
                for (int i = 0; i < size; ++i) {
                    FluctuationBillEntryInfo entry = entries.get(i);
                    persons.add(entry.getPerson());
                    if (entry.getType() != null && FlucTypeBizEnum.EmpTypeTransition.equals((Object)entry.getType().getBiz())) {
                        if (entry.getPerson() != null && entry.getPerson().getId() != null) {
                            personID = entry.getPerson().getId().toString();
                        }
                        HRCheckUtil.getPersonNumberCheckInstanceForFluc((String)billID, personID).check(entry.getEmployeeNumber(), ctx);
                    }
                    if ((newPosition = entry.getNewPosition()) == null) continue;
                    if (entry.getId() == null) {
                        boolean isOnTheStrengh = false;
                        EmployeeTypeInfo empTypeInfo = entry.getNewEmpType();
                        if (empTypeInfo != null) {
                            IEmployeeType etBean = EmployeeTypeFactory.getLocalInstance((Context)ctx);
                            empTypeInfo = etBean.getEmployeeTypeInfo("select id, isOnTheStrength where id = '" + empTypeInfo.getId().toString() + "'");
                            isOnTheStrengh = empTypeInfo.isIsOnTheStrength();
                        } else {
                            isOnTheStrengh = HRUtil.getEmployeTypeIsOnTheStrengthById((Context)ctx, (String)personID);
                        }
                        if (!isOnTheStrengh) continue;
                        PersonPlanFactory.getLocalInstance((Context)ctx).canAddPerson(newPosition.getId().toString());
                        continue;
                    }
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("id"));
                    selector.add(new SelectorItemInfo("newPosition.id"));
                    selector.add(new SelectorItemInfo("newPosition.name"));
                    tempEntry = FluctuationBillEntryFactory.getLocalInstance(ctx).getFluctuationBillEntryInfo((IObjectPK)new ObjectUuidPK(entry.getId()), selector);
                    if (tempEntry.getNewPosition() != null && newPosition.getId().equals((Object)tempEntry.getNewPosition().getId())) continue;
                    PersonPlanFactory.getLocalInstance((Context)ctx).canAddPerson(newPosition.getId().toString());
                }
                BatchProcessedResult result = HRAffairPersonPreProcessFacadeFactory.getLocalInstance(ctx).preProcessFlucPerson(persons, billID);
                if (result == null) {
                    return;
                }
                if (result.isHasValidInfo()) {
                    throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Object[])new String[]{result.getInvalidInfo()});
                }
            }
        }
    }

    protected String getPermItemNameDelete() {
        return "FluctuationBill_Delete";
    }

    protected String getPermItemNameAddnew() {
        return "FluctuationBill_AddNew";
    }

    protected String getPermItemNameEdit() {
        return "FluctuationBill_Edit";
    }

    @Override
    protected void _setFlucPosition(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._update(ctx, pk, model);
    }

    @Override
    protected String getResource(Context ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"30_HRAffairBaseControllerBean", (Locale)ctx.getOriginLocale());
    }

    @Override
    protected void checkEffectData(Context ctx, String billID) throws BOSException, EASBizException {
        FluctuationBillInfo billInfo = FluctuationBillFactory.getLocalInstance(ctx).getFluctuationBillInfo((IObjectPK)new ObjectUuidPK(billID));
        FluctuationBillEntryCollection entryCol = billInfo.getEntries();
        java.util.Date now = new java.util.Date();
        boolean result = false;
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            FluctuationBillEntryInfo entryInfo = entryCol.get(i);
            if (!now.after(entryInfo.getEffectDate())) continue;
            result = true;
            break;
        }
        if (result) {
            throw new HRAffairException(HRAffairException.CAN_NOT_UNAUDIT);
        }
    }

    @Override
    protected String getEntryIdStr(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FluctuationBillInfo billInfo = FluctuationBillFactory.getLocalInstance(ctx).getFluctuationBillInfo(pk);
        FluctuationBillEntryCollection billEntryCol = billInfo.getEntries();
        StringBuffer billEntryIdStr = new StringBuffer();
        int size = billEntryCol.size();
        for (int i = 0; i < size; ++i) {
            billEntryIdStr.append("'");
            billEntryIdStr.append(billEntryCol.get(i).getId().toString());
            if (i == size - 1) {
                billEntryIdStr.append("'");
                continue;
            }
            billEntryIdStr.append("',");
        }
        return billEntryIdStr.toString();
    }

    @Override
    protected void _saveFaChange(Context ctx, Map map) throws BOSException, EASBizException {
    }
}

