/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.job.IJobService;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.EnrollBillEntryFactory;
import com.kingdee.eas.hr.affair.EnrollBillEntryInfo;
import com.kingdee.eas.hr.affair.EnrollBillInfo;
import com.kingdee.eas.hr.affair.FireBillEntryFactory;
import com.kingdee.eas.hr.affair.FireBillEntryInfo;
import com.kingdee.eas.hr.affair.FireBillInfo;
import com.kingdee.eas.hr.affair.FluctuationBillEntryFactory;
import com.kingdee.eas.hr.affair.FluctuationBillEntryInfo;
import com.kingdee.eas.hr.affair.FluctuationBillInfo;
import com.kingdee.eas.hr.affair.HRAffairBaseInfo;
import com.kingdee.eas.hr.affair.HRAffairEntryBaseInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.HRAffairState;
import com.kingdee.eas.hr.affair.HireBillEntryFactory;
import com.kingdee.eas.hr.affair.HireBillEntryInfo;
import com.kingdee.eas.hr.affair.HireBillInfo;
import com.kingdee.eas.hr.affair.ResignBillEntryFactory;
import com.kingdee.eas.hr.affair.ResignBillEntryInfo;
import com.kingdee.eas.hr.affair.ResignBillInfo;
import com.kingdee.eas.hr.affair.RetireBillEntryFactory;
import com.kingdee.eas.hr.affair.RetireBillEntryInfo;
import com.kingdee.eas.hr.affair.RetireBillInfo;
import com.kingdee.eas.hr.affair.SubmitStateEnum;
import com.kingdee.eas.hr.affair.app.AbstractHRAffairBaseControllerBean;
import com.kingdee.eas.hr.affair.app.HRAffairAppUtils;
import com.kingdee.eas.hr.base.BillEntryJobProcessCollection;
import com.kingdee.eas.hr.base.BillEntryJobProcessFactory;
import com.kingdee.eas.hr.base.BillEntryJobProcessInfo;
import com.kingdee.eas.hr.base.CodingRuleManageFacadeFactory;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.time.LeaveBillInfo;
import com.kingdee.eas.hr.time.LeaveReportBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.Locale;

public class HRAffairBaseControllerBean
extends AbstractHRAffairBaseControllerBean {
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        this._setPassState(ctx, ((HRAffairBaseInfo)model).getId());
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        this._setNoPassState(ctx, ((HRAffairBaseInfo)model).getId());
    }

    @Override
    protected IObjectPK _submit2(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this._submit(ctx, (IObjectValue)((CoreBaseInfo)model));
    }

    protected void setNumberFromCodingRule(Context ctx, HRBillBaseInfo model) throws BOSException, EASBizException {
    }

    protected void setNumberFromCodingRuleEx(Context ctx, HRBillBaseInfo model) throws BOSException, EASBizException {
        String number = CodingRuleManageFacadeFactory.getLocalInstance((Context)ctx).getNumberFromCodingRule((IObjectValue)model, null, (String)model.get("tNumber"));
        if (number != null) {
            model.setNumber(number);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRAffairBaseInfo info = (HRAffairBaseInfo)model;
        this.setNumberFromCodingRuleEx(ctx, info);
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new HRAffairException(HRAffairException.BILLNUM_NOT_INPUT);
        }
        if (!(model instanceof LeaveBillInfo) && !(model instanceof LeaveReportBillInfo) && info.getBizState() == null) {
            info.setBizState(HRAffairState.TEMP);
        }
        info.setApplyDate(DateTimeUtils.truncateDate((Date)info.getApplyDate()));
        this.checkBillEntry(ctx, info);
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    @Override
    protected void _setPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        int value = HRAffairAppUtils.isAffairEffectImmediatly(ctx) ? 1 : 0;
        this.saveInnerStateByValue(ctx, billId.toString(), value);
        this._setState(ctx, billId, HRAffairState.COMPLETE);
    }

    @Override
    protected void _setNoPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, HRAffairState.STOP);
    }

    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, HRAffairState.APPROVE);
    }

    protected void _checkCanDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HRAffairBaseInfo info = (HRAffairBaseInfo)this._getValue(ctx, pk);
        if (info.getBizState().getValue() != 0 && info.getBizState().getValue() != -1) {
            throw new HRAffairException(HRAffairException.HRBILL_CAN_NOT_DELETE);
        }
    }

    @Override
    protected void _setState(Context ctx, BOSUuid billId, HRAffairState state) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        HRAffairBaseInfo info = (HRAffairBaseInfo)this._getValue(ctx, "select id,number,bizState where id = '" + pk.toString() + "'");
        StringBuffer auditLog = new StringBuffer();
        String description = null;
        description = info instanceof EnrollBillInfo ? ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"25_HRAffairBaseControllerBean", (Locale)ctx.getLocale()) : (info instanceof HireBillInfo ? ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"26_HRAffairBaseControllerBean", (Locale)ctx.getLocale()) : (info instanceof FireBillInfo ? ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"27_HRAffairBaseControllerBean", (Locale)ctx.getLocale()) : (info instanceof ResignBillInfo ? ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"28_HRAffairBaseControllerBean", (Locale)ctx.getLocale()) : (info instanceof RetireBillInfo ? ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"29_HRAffairBaseControllerBean", (Locale)ctx.getLocale()) : (info instanceof FluctuationBillInfo ? ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"30_HRAffairBaseControllerBean", (Locale)ctx.getLocale()) : ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"31_HRAffairBaseControllerBean", (Locale)ctx.getLocale()))))));
        auditLog.append(" ");
        auditLog.append(info.getNumber());
        auditLog.append(" ");
        description = description + "_" + ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"32_HRAffairBaseControllerBean", (Locale)ctx.getLocale());
        IObjectPK logPK = LogUtil.beginLogWithDescription((Context)ctx, (String)"batchAudit", (BOSObjectType)billId.getType(), (IObjectPK)pk, (String)auditLog.toString(), (String)description);
        info.setBizState(state);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("bizState"));
        this.updatePartial(ctx, (CoreBaseInfo)info, selectors);
        if (state.getValue() == 3) {
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("*"));
            sc.add(new SelectorItemInfo("entries.*"));
            if (info instanceof FluctuationBillInfo) {
                sc.add(new SelectorItemInfo("entries.oldPosition.id"));
                sc.add(new SelectorItemInfo("entries.newPosition.id"));
                sc.add(new SelectorItemInfo("entries.oldPosition.CU.id"));
                sc.add(new SelectorItemInfo("entries.newPosition.CU.id"));
                sc.add(new SelectorItemInfo("entries.oldPosition.hrOrgUnit.id"));
                sc.add(new SelectorItemInfo("entries.newPosition.hrOrgUnit.id"));
                sc.add(new SelectorItemInfo("entries.oldJobLevel.id"));
                sc.add(new SelectorItemInfo("entries.newJobLevel.id"));
                sc.add(new SelectorItemInfo("entries.oldJobGrade.id"));
                sc.add(new SelectorItemInfo("entries.newJobGrade.id"));
                sc.add(new SelectorItemInfo("entries.dispatchNum"));
                sc.add(new SelectorItemInfo("entries.type.id"));
                sc.add(new SelectorItemInfo("entries.type.number"));
                sc.add(new SelectorItemInfo("entries.type.name"));
                sc.add(new SelectorItemInfo("entries.type.type"));
                sc.add(new SelectorItemInfo("entries.fluBeforeJoinDate"));
                sc.add(new SelectorItemInfo("entries.fluAfterJoinDate"));
                sc.add(new SelectorItemInfo("entries.resumeId"));
                info = (HRAffairBaseInfo)this._getValue(ctx, (IObjectPK)pk, sc);
            } else if (info instanceof HireBillInfo) {
                info = (HRAffairBaseInfo)this._getValue(ctx, (IObjectPK)pk, sc);
            } else if (info instanceof ResignBillInfo) {
                info = (HRAffairBaseInfo)this._getValue(ctx, (IObjectPK)pk, sc);
            } else if (info instanceof RetireBillInfo) {
                info = (HRAffairBaseInfo)this._getValue(ctx, (IObjectPK)pk, sc);
            } else if (info instanceof FireBillInfo) {
                info = (HRAffairBaseInfo)this._getValue(ctx, (IObjectPK)pk, sc);
            } else if (info instanceof EnrollBillInfo) {
                sc.add(new SelectorItemInfo("entries.position.CU.id"));
                sc.add(new SelectorItemInfo("entries.position.hrOrgUnit.id"));
                sc.add(new SelectorItemInfo("entries.position.adminOrgUnit.id"));
                sc.add(new SelectorItemInfo("entries.resumeId"));
                sc.add(new SelectorItemInfo("entries.enrollSource.id"));
                sc.add(new SelectorItemInfo("entries.enrollSource.name"));
                sc.add(new SelectorItemInfo("entries.enrollSource.number"));
                info = (HRAffairBaseInfo)this._getValue(ctx, (IObjectPK)pk, sc);
            } else {
                info = (HRAffairBaseInfo)this._getValue(ctx, (IObjectPK)pk);
            }
            IObjectCollection entries = (IObjectCollection)info.get("entries");
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                ((HRAffairEntryBaseInfo)entries.getObject(i)).put("HRO", info.getHrOrgUnit());
                ((HRAffairEntryBaseInfo)entries.getObject(i)).put("CU", info.getCU());
            }
            HRAffairAppUtils.saveRelevantData(ctx, entries, info.getInnerState() == 1);
        }
        if (logPK != null) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
    }

    @Override
    protected void _setEditState(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        this._setState(ctx, billId, HRAffairState.EDIT);
    }

    protected void _dispachIntermitNumber(Context ctx, IObjectPK pk) throws CodingRuleException, EASBizException, BOSException {
        CodingRuleManageFacadeFactory.getLocalInstance((Context)ctx).recycleNumber(pk, null, null);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._checkCanDelete(ctx, pk);
        this._dispachIntermitNumber(ctx, pk);
        super._delete(ctx, pk);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return super._getLogInfo(ctx, pk);
    }

    @Override
    protected void _batchPassAudit(Context ctx, String[] billIds) throws BOSException, EASBizException {
        for (int i = 0; i < billIds.length; ++i) {
            this._setPassState(ctx, BOSUuid.read((String)billIds[i]));
            this.saveMultiApproveInfo(ctx, billIds[i]);
        }
    }

    private String getStr(String resourcStr) {
        return EASResource.getString((String)("com.kingdee.eas.hr.affair.HRAffairResource." + resourcStr));
    }

    private void saveMultiApproveInfo(Context ctx, String billId) throws BOSException, EASBizException {
        IMultiApprove im = MultiApproveFactory.getLocalInstance((Context)ctx);
        MultiApproveInfo info = new MultiApproveInfo();
        info.setIsPass(ApproveResult.PASS);
        info.setOpinion(this.getStr("Lbl_Direct_Audit_Opnion"));
        BOSUuid id = BOSUuid.read((String)billId);
        info.setBillId(id);
        info.setBosTypeStr(id.getType().toString());
        im.addnew((CoreBaseInfo)info);
    }

    private void saveInnerStateByValue(Context ctx, String billId, int value) throws BOSException, EASBizException {
        HRAffairBaseInfo info = (HRAffairBaseInfo)this._getValue(ctx, "select id, innerState where id = '" + billId + "'");
        info.setInnerState(value);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("innerState"));
        this.updatePartial(ctx, (CoreBaseInfo)info, selectors);
    }

    @Override
    protected void _test(Context ctx, BOSUuid pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _setEffectDate(Context ctx, BOSUuid entryId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(entryId);
        String type = entryId.getType().toString();
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("bill.hrOrgUnit.id"));
        sc.add(new SelectorItemInfo("bill.cu.*"));
        HRAffairEntryBaseInfo info = null;
        if (type.equals(new FluctuationBillEntryInfo().getBOSType().toString())) {
            sc.add(new SelectorItemInfo("oldPosition.id"));
            sc.add(new SelectorItemInfo("newPosition.id"));
            sc.add(new SelectorItemInfo("oldPosition.CU.id"));
            sc.add(new SelectorItemInfo("newPosition.CU.id"));
            sc.add(new SelectorItemInfo("oldPosition.hrOrgUnit.id"));
            sc.add(new SelectorItemInfo("newPosition.hrOrgUnit.id"));
            sc.add(new SelectorItemInfo("oldJobLevel.id"));
            sc.add(new SelectorItemInfo("newJobLevel.id"));
            sc.add(new SelectorItemInfo("oldJobGrade.id"));
            sc.add(new SelectorItemInfo("newJobGrade.id"));
            sc.add(new SelectorItemInfo("dispatchNum"));
            sc.add(new SelectorItemInfo("type.id"));
            sc.add(new SelectorItemInfo("type.number"));
            sc.add(new SelectorItemInfo("type.name"));
            sc.add(new SelectorItemInfo("type.type"));
            sc.add(new SelectorItemInfo("resumeBaseID"));
            info = (HRAffairEntryBaseInfo)FluctuationBillEntryFactory.getLocalInstance(ctx).getValue((IObjectPK)pk, sc);
        } else if (type.equals(new HireBillEntryInfo().getBOSType().toString())) {
            info = (HRAffairEntryBaseInfo)HireBillEntryFactory.getLocalInstance(ctx).getValue((IObjectPK)pk, sc);
        } else if (type.equals(new ResignBillEntryInfo().getBOSType().toString())) {
            info = (HRAffairEntryBaseInfo)ResignBillEntryFactory.getLocalInstance(ctx).getValue((IObjectPK)pk, sc);
        } else if (type.equals(new RetireBillEntryInfo().getBOSType().toString())) {
            info = (HRAffairEntryBaseInfo)RetireBillEntryFactory.getLocalInstance(ctx).getValue((IObjectPK)pk, sc);
        } else if (type.equals(new FireBillEntryInfo().getBOSType().toString())) {
            info = (HRAffairEntryBaseInfo)FireBillEntryFactory.getLocalInstance(ctx).getValue((IObjectPK)pk, sc);
        } else if (type.equals(new EnrollBillEntryInfo().getBOSType().toString())) {
            sc.add(new SelectorItemInfo("position.CU.id"));
            sc.add(new SelectorItemInfo("position.hrOrgUnit.id"));
            info = (HRAffairEntryBaseInfo)EnrollBillEntryFactory.getLocalInstance(ctx).getValue((IObjectPK)pk, sc);
        }
        if (info != null) {
            info.put("HRO", ((HRBillBaseInfo)info.get("bill")).getHrOrgUnit());
            info.put("CU", ((HRBillBaseInfo)info.get("bill")).getCU());
            String billId = ((HRBillBaseInfo)info.get("bill")).getId().toString();
            HRAffairBaseInfo billInfo = (HRAffairBaseInfo)this._getValue(ctx, "select id, innerState where id = '" + billId + "'");
            HRAffairAppUtils.saveRelevantData(ctx, (IObjectValue)info, billInfo.getInnerState() == 1);
        }
    }

    protected void checkBillEntry(Context ctx, HRAffairBaseInfo model) throws BOSException, EASBizException {
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.preProcess(ctx, pk, model);
        this.checkBillEntry(ctx, (HRAffairBaseInfo)model);
        super._update(ctx, pk, model);
    }

    protected void preProcess(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected Date _getCurrentDate(Context ctx) throws BOSException {
        return DateTimeUtils.truncateDate((Date)new Date());
    }

    @Override
    protected void _passUnaudit(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        HRAffairBaseInfo baseInfo = (HRAffairBaseInfo)billInfo;
        String billID = baseInfo.getId().toString();
        this.checkEffectData(ctx, billID);
        this.updateBillState(ctx, billID);
        MultiApproveFactory.getLocalInstance((Context)ctx).delete("WHERE billId = '" + billID + "'");
    }

    protected void checkEffectData(Context ctx, String billID) throws BOSException, EASBizException {
    }

    private void updateBillState(Context ctx, String billID) throws BOSException, EASBizException {
        BOSUuid billId = BOSUuid.read((String)billID);
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        HRAffairBaseInfo info = (HRAffairBaseInfo)this._getValue(ctx, "select id, innerState where id = '" + billID + "'");
        info.setBizState(HRAffairState.TEMP);
        info.setSubmitState(SubmitStateEnum.NO_SUBMIT);
        info.setBizDate(null);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("bizState"));
        selectors.add(new SelectorItemInfo("submitState"));
        selectors.add(new SelectorItemInfo("bizDate"));
        this.updatePartial(ctx, (CoreBaseInfo)info, selectors);
        this.dropJobProcess(ctx, this.getEntryIdStr(ctx, (IObjectPK)pk));
    }

    protected String getEntryIdStr(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        return null;
    }

    protected void dropJobProcess(Context ctx, String billEntryIdStr) throws EASBizException, BOSException {
        block8: {
            BillEntryJobProcessCollection bejpCol = BillEntryJobProcessFactory.getLocalInstance((Context)ctx).getBillEntryJobProcessCollection("where billEntryId in (" + billEntryIdStr + ")");
            StringBuffer jobProcessIdStr = new StringBuffer();
            int size = bejpCol.size();
            for (int i = 0; i < size; ++i) {
                BillEntryJobProcessInfo bejpInfo = bejpCol.get(i);
                jobProcessIdStr.append("'");
                jobProcessIdStr.append(bejpInfo.getJobProcessId());
                if (i == size - 1) {
                    jobProcessIdStr.append("'");
                    continue;
                }
                jobProcessIdStr.append("',");
            }
            if (jobProcessIdStr == null || jobProcessIdStr.length() == 0) {
                return;
            }
            IJobService jobService = JobServiceFactory.getLocalInstance((Context)ctx);
            String sql = "SELECT FID FROM T_JOB_Trigger WHERE FJobDefID in (" + jobProcessIdStr + ")";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.next()) {
                    rs.beforeFirst();
                    while (rs.next()) {
                        String triggerId = rs.getString(1);
                        jobService.disableTrigger(triggerId);
                    }
                    break block8;
                }
                throw new HRAffairException(HRAffairException.TRY_LATER_TIME);
            }
            catch (HRAffairException e1) {
                throw e1;
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected String getResource(Context ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"31_HRAffairBaseControllerBean", (Locale)ctx.getLocale());
    }
}

