/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.AbstractBillExtendEntryInfo;
import com.kingdee.eas.hr.base.BillExtendConfig;
import com.kingdee.eas.hr.base.BillExtendEntryCollection;
import com.kingdee.eas.hr.base.BillExtendEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.IBillExtendEntry;
import com.kingdee.eas.hr.base.Param;
import com.kingdee.eas.hr.base.app.BillExtendBeanFactory;
import com.kingdee.eas.hr.base.app.IBillExtendBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;

public abstract class AbstractBillExtendBean
implements IBillExtendBean {
    private BillExtendConfig config = null;
    private String configName = null;

    @Override
    public BillExtendConfig getExtendConfig() throws Exception {
        return this.config;
    }

    @Override
    public void setExtendConfig(BillExtendConfig config) throws Exception {
        this.config = config;
        this.configName = config.getName();
    }

    protected HashMap getExtendInfo(Context ctx, HashSet entryIDs) throws BOSException, EASBizException {
        if (this.config == null || entryIDs == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelector());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entryID", (Object)entryIDs, CompareType.INCLUDE));
        view.setFilter(filter);
        BillExtendEntryCollection col = this.getExtendBizInterface(ctx).getBillExtendEntryCollection(view);
        HashMap<String, BillExtendEntryInfo> map = null;
        if (col != null && col.size() > 0) {
            map = new HashMap<String, BillExtendEntryInfo>();
            BillExtendEntryInfo exInfo = null;
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                exInfo = col.get(i);
                map.put(exInfo.getEntryID().toString(), exInfo);
            }
        }
        return map;
    }

    public void after_getBillValue(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectCollection entries = (IObjectCollection)model.get("entrys");
        if (entries == null) {
            return;
        }
        HashSet<String> entryIDs = new HashSet<String>();
        String id = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            id = ((HRBillBaseEntryInfo)entries.getObject(i)).getId().toString();
            entryIDs.add(id);
        }
        HashMap result = this.getExtendInfo(ctx, entryIDs);
        if (result == null) {
            return;
        }
        HRBillBaseEntryInfo entry = null;
        int size2 = entries.size();
        for (int i = 0; i < size2; ++i) {
            entry = (HRBillBaseEntryInfo)entries.getObject(i);
            id = entry.getId().toString();
            entry.put(this.configName, result.get(id));
        }
    }

    public void after_getBillCollection(Context ctx, IObjectCollection model) throws BOSException, EASBizException {
        if (model != null) {
            HRBillBaseInfo bill = null;
            int size = model.size();
            for (int i = 0; i < size; ++i) {
                bill = (HRBillBaseInfo)model.getObject(i);
                this.after_getBillValue(ctx, (IObjectValue)bill);
            }
        }
    }

    public void after_addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        HRBillBaseInfo info = (HRBillBaseInfo)model;
        HRBillBaseInfo sendInfo = info.getSendValue();
        IObjectCollection entries = (IObjectCollection)model.get("entrys");
        IObjectCollection sEntries = (IObjectCollection)sendInfo.get("entrys");
        if (entries == null || sEntries == null) {
            return;
        }
        CoreBaseCollection col = new CoreBaseCollection();
        HRBillBaseEntryInfo entry = null;
        BillExtendEntryInfo ex = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = (HRBillBaseEntryInfo)entries.getObject(i);
            ex = this.getExtendEntryInfo(entry, sEntries);
            if (ex == null) continue;
            col.add((CoreBaseInfo)ex);
        }
        this.getExtendBizInterface(ctx).addnew(col);
    }

    protected BillExtendEntryInfo getExtendEntryInfo(HRBillBaseEntryInfo entry, IObjectCollection sEntries) {
        String entryKey = this.config.getMapping().getEntryKey();
        String[] keys = StringUtils.split((String)entryKey, (String)",");
        AbstractBillExtendEntryInfo exInfo = null;
        Object v = null;
        Object sv = null;
        HRBillBaseEntryInfo sEntry = null;
        int size = sEntries.size();
        for (int i = 0; !(i >= size || (exInfo = (BillExtendEntryInfo)(sEntry = (HRBillBaseEntryInfo)sEntries.getObject(i)).get(this.configName)) != null && entry.getId().equals((Object)exInfo.getEntryID())); ++i) {
            boolean isRight = true;
            for (int j = 0; j < keys.length; ++j) {
                v = entry.get(keys[j]);
                sv = sEntry.get(keys[j]);
                isRight = isRight && Param.isEqual(v, sv);
            }
            if (isRight) break;
        }
        if (exInfo != null) {
            exInfo.setEntryID(entry.getId());
        }
        return exInfo;
    }

    public void after_update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        HRBillBaseInfo info = (HRBillBaseInfo)model;
        HRBillBaseInfo sendInfo = info.getSendValue();
        IObjectCollection entries = (IObjectCollection)model.get("entrys");
        IObjectCollection sEntries = (IObjectCollection)sendInfo.get("entrys");
        if (entries == null || sEntries == null) {
            return;
        }
        CoreBaseCollection updateCol = null;
        CoreBaseCollection addNewCol = null;
        StringBuffer entryIDs = null;
        BillExtendEntryInfo ex = null;
        HRBillBaseEntryInfo entry = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = (HRBillBaseEntryInfo)entries.getObject(i);
            ex = this.getExtendEntryInfo(entry, sEntries);
            if (ex == null) continue;
            if (ex.getId() != null) {
                if (updateCol == null) {
                    updateCol = new CoreBaseCollection();
                }
                updateCol.add((CoreBaseInfo)ex);
            } else {
                if (addNewCol == null) {
                    addNewCol = new CoreBaseCollection();
                }
                addNewCol.add((CoreBaseInfo)ex);
            }
            if (entryIDs == null) {
                entryIDs = new StringBuffer();
            } else {
                entryIDs.append(",");
            }
            entryIDs.append("'");
            entryIDs.append(entry.getId());
            entryIDs.append("'");
        }
        if (updateCol != null) {
            this.getExtendBizInterface(ctx).update(updateCol);
        }
        if (addNewCol != null) {
            this.getExtendBizInterface(ctx).addnew(addNewCol);
        }
        if (entryIDs != null) {
            String billID = ((HRBillBaseInfo)model).getId().toString();
            String sql = this.getDeleteSql(ctx, "e.fid not in(" + entryIDs + ")");
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{billID});
        }
    }

    public void after_delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = this.getDeleteSql(ctx, null);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
    }

    private String getDeleteSql(Context ctx, String condition) throws BOSException, EASBizException {
        String extendTable = BillExtendBeanFactory.getExtendTable(ctx, this.config);
        String entryTable = BillExtendBeanFactory.getBillEntryTable(ctx, this.config.getMapping());
        if (StringUtils.isEmpty((String)extendTable) || StringUtils.isEmpty((String)entryTable)) {
            return null;
        }
        StringBuffer delete = new StringBuffer();
        delete.append(" delete from ");
        delete.append(extendTable);
        delete.append(" where fid in (select t.fid from ");
        delete.append(extendTable);
        delete.append(" as t inner join ");
        delete.append(entryTable);
        delete.append(" as e on e.fid = t.FEntryID ");
        delete.append(" where e.FBillID = ?");
        if (!StringUtils.isEmpty((String)condition)) {
            delete.append(" and ");
            delete.append(condition);
        }
        delete.append(")");
        return delete.toString();
    }

    protected IBillExtendEntry getExtendBizInterface(Context ctx) throws BOSException, EASBizException {
        return BillExtendBeanFactory.getLocalInstance(ctx, this.config);
    }

    public void after_entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        this.extendEffect(ctx, entry, (BillExtendEntryInfo)entry.get(this.configName));
    }

    protected abstract void extendEffect(Context var1, HRBillBaseEntryInfo var2, BillExtendEntryInfo var3) throws BOSException, EASBizException;

    protected abstract SelectorItemCollection getSelector();
}

