/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.AssignTypeEnum;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmpPostExperienceHisFactory;
import com.kingdee.eas.hr.base.EmpPostExperienceHisInfo;
import com.kingdee.eas.hr.base.HRBizDefineTypeEnum;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.HRInitInfo;
import com.kingdee.eas.hr.base.IEmpPosOrgRelation;
import com.kingdee.eas.hr.base.IEmpPostExperienceHis;
import com.kingdee.eas.hr.base.IHRInit;
import com.kingdee.eas.hr.base.app.AbstractEmpExpHisUpgradeFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class EmpExpHisUpgradeFacadeControllerBean
extends AbstractEmpExpHisUpgradeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.EmpExpHisUpgradeFacadeControllerBean");
    private static final AssignTypeEnum mainAssignType = AssignTypeEnum.MAIN;
    private static final AssignTypeEnum parttimeAssignType = AssignTypeEnum.PARTTIME;
    private static final HRBizDefineTypeEnum resignAction = HRBizDefineTypeEnum.RESIGN;
    private static final String UPGRADE_KEY = "isEmpPostExperienceHisHasUpdate";
    private IEmpPosOrgRelation iEmpPosOrgRelation;
    private IEmpPostExperienceHis iEmpPostExperienceHis;
    private IPerson iPerson;

    private void init(Context ctx) throws BOSException {
        this.iEmpPosOrgRelation = EmpPosOrgRelationFactory.getLocalInstance(ctx);
        this.iEmpPostExperienceHis = EmpPostExperienceHisFactory.getLocalInstance(ctx);
        this.iPerson = PersonFactory.getLocalInstance((Context)ctx);
    }

    private void doUpgrade(Context ctx) throws BOSException, EASBizException {
        HRInitInfo updateInitInfo;
        String isUpdateSql;
        IHRInit iHRInit = HRInitFactory.getLocalInstance(ctx);
        if (iHRInit.exists(isUpdateSql = " where key='isEmpPostExperienceHisHasUpdate'") && !"true".equals(iHRInit.getHRInitInfo(isUpdateSql).getValue()) && "false".equals((updateInitInfo = iHRInit.getHRInitInfo(isUpdateSql)).getValue())) {
            this.doProcess(ctx);
            updateInitInfo.setValue("true");
            iHRInit.save((CoreBaseInfo)updateInitInfo);
        }
    }

    private void doProcess(Context ctx) throws BOSException, EASBizException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("insert into T_HR_EmpPostExperienceHis (FAdminOrgID,FEffdt,FLeffdt,FAssignType,FID,FPersonID,FPositionID)").append(" select fadminorgid,feffdt,fleffdt,fassigntype,newbosid('F8D314CB'),fpersonid,fpositionid from T_HR_EmpOrgRelation").append(" where  fisinner=1 and fpersonid not in (select fpersonid from T_HR_EmpPostExperienceHis)");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        StringBuffer sbGroupPerson = this.getGroupPersonOql();
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sbGroupPerson.toString(), (Object[])new Object[0]);
        long start = 0L;
        long end = 0L;
        if (logger.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            while (iRowSet.next()) {
                String personId = iRowSet.getString("FPersonId");
                this.doProcessByPersonId(personId);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (logger.isDebugEnabled()) {
            end = System.currentTimeMillis();
            logger.debug((Object)MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label116", (Context)ctx), end - start));
        }
    }

    private void doProcessByPersonId(String personId) throws BOSException, EASBizException {
        StringBuffer sbColByPerson1;
        EmpPosOrgRelationCollection parttimeEmpRelationColByPerson;
        int j;
        int sizeByPerson;
        StringBuffer sbColByPerson;
        EmpPosOrgRelationCollection mainEmpRelationColByPerson;
        String deletePersonEmpExperienceOql = "where person = '" + personId + "'";
        if (this.iEmpPostExperienceHis.exists(deletePersonEmpExperienceOql)) {
            this.iEmpPostExperienceHis.delete(deletePersonEmpExperienceOql);
        }
        if ((mainEmpRelationColByPerson = this.iEmpPosOrgRelation.getEmpPosOrgRelationCollection((sbColByPerson = this.getMainAssignTypeByPersonOql(personId)).toString())).size() > 0) {
            EmpPosOrgRelationInfo preInfo = mainEmpRelationColByPerson.get(0);
            EmpPostExperienceHisInfo hisInfo = this.initByRelationInfo(preInfo);
            sizeByPerson = mainEmpRelationColByPerson.size();
            for (j = 1; j < sizeByPerson; ++j) {
                EmpPosOrgRelationInfo tempInfo = mainEmpRelationColByPerson.get(j);
                HRBizDefineTypeEnum currentActionType = tempInfo.getAction().getBizDefineType();
                if (currentActionType == resignAction) {
                    this.iEmpPostExperienceHis.save(hisInfo);
                    if (++j >= sizeByPerson) continue;
                    hisInfo = this.initByRelationInfo(mainEmpRelationColByPerson.get(j));
                    continue;
                }
                if (tempInfo.getAdminOrg().getId().equals((Object)hisInfo.getAdminOrg().getId()) && tempInfo.getPosition().getId().equals((Object)hisInfo.getPosition().getId()) && DateTimeUtils.format((Date)hisInfo.getLeffdt()).equals(DateTimeUtils.format((Date)DateUtil.getBeforeDay((Date)tempInfo.getEFFDT())))) {
                    hisInfo.setLeffdt(tempInfo.getLEFFDT());
                    continue;
                }
                this.iEmpPostExperienceHis.save(hisInfo);
                hisInfo = this.initByRelationInfo(tempInfo);
            }
            if (hisInfo.getId() == null) {
                this.iEmpPostExperienceHis.save(hisInfo);
            }
        }
        if ((parttimeEmpRelationColByPerson = this.iEmpPosOrgRelation.getEmpPosOrgRelationCollection((sbColByPerson1 = this.getParttimeTypeByPersonOql(personId)).toString())).size() > 0) {
            sizeByPerson = parttimeEmpRelationColByPerson.size();
            for (j = 0; j < sizeByPerson; ++j) {
                EmpPostExperienceHisInfo hisInfo = this.initByRelationInfo(parttimeEmpRelationColByPerson.get(j));
                this.iEmpPostExperienceHis.save(hisInfo);
            }
        }
    }

    private EmpPostExperienceHisInfo initByRelationInfo(EmpPosOrgRelationInfo firstInfo) {
        EmpPostExperienceHisInfo empPostExperienceHisInfo = new EmpPostExperienceHisInfo();
        empPostExperienceHisInfo.setAdminOrg(firstInfo.getAdminOrg());
        empPostExperienceHisInfo.setPosition(firstInfo.getPosition());
        empPostExperienceHisInfo.setAssignType(firstInfo.getAssignType());
        empPostExperienceHisInfo.setEffdt(firstInfo.getEFFDT());
        empPostExperienceHisInfo.setLeffdt(firstInfo.getLEFFDT());
        empPostExperienceHisInfo.setPerson(firstInfo.getPerson());
        return empPostExperienceHisInfo;
    }

    private StringBuffer getMainAssignTypeByPersonOql(String personId) {
        return new StringBuffer("select action.bizDefineType, adminOrg, position, person, effdt, leffdt, assignType, laborRelation.laborRelationState where isInner = 1 and assignType = ").append(mainAssignType.getValue()).append(" and person ='").append(personId).append("'").append(" order by effdt asc");
    }

    private StringBuffer getParttimeTypeByPersonOql(String personId) {
        return new StringBuffer("select action.bizDefineType, adminOrg, position, person, effdt, leffdt, assignType, laborRelation.laborRelationState where isInner = 1 and assignType = ").append(parttimeAssignType.getValue()).append(" and person ='").append(personId).append("'").append(" order by effdt asc");
    }

    private StringBuffer getGroupPersonOql() {
        return new StringBuffer("select distinct FPersonId from T_HR_EmpOrgRelation where FIsInner = 1 group by FPersonId having count(FPersonId) >1 ");
    }

    @Override
    protected void _upgradeAllForMan(Context ctx) throws BOSException, EASBizException {
        this.init(ctx);
        this.doProcess(ctx);
    }

    @Override
    protected void _upgradeAllFromEmpPostRelation(Context ctx) throws BOSException, EASBizException {
        this.init(ctx);
        System.out.println("process EmpExpHisUpgradeFacadeControllerBean._upgradeFromEmpPostRelation");
        this.doUpgrade(ctx);
    }

    @Override
    protected void _upgradeByPersonId(Context ctx, String personId) throws BOSException, EASBizException {
        this.init(ctx);
        this.doProcessByPersonId(personId);
    }

    @Override
    protected void _upgradeByPersonNumForMan(Context ctx, String personNum) throws BOSException, EASBizException {
        this.init(ctx);
        PersonCollection personCollection = this.iPerson.getPersonCollection(" select id where number = '" + personNum + "'");
        if (personCollection != null && personCollection.size() > 0) {
            String personId = personCollection.get(0).getId().toString();
            this.doProcessByPersonId(personId);
        }
    }
}

