/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmpJobGradeCollection;
import com.kingdee.eas.hr.base.EmpJobGradeFactory;
import com.kingdee.eas.hr.base.EmpJobGradeInfo;
import com.kingdee.eas.hr.base.app.AbstractEmpJobGradeFacadeControllerBean;
import com.kingdee.eas.hr.base.app.EmpJobGradeFacadeHelper;
import com.kingdee.eas.hr.org.JobGradeInfo;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EmpJobGradeFacadeControllerBean
extends AbstractEmpJobGradeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.EmpJobGradeFacadeControllerBean");

    @Override
    protected IObjectCollection _getAffairRelateEmpJobGrade(Context ctx, String affairEntryID, String personID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personID) || StringUtils.isEmpty((String)affairEntryID)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
        filterInfo.getFilterItems().add(new FilterItemInfo("flowAffairID", (Object)affairEntryID));
        filterInfo.setMaskString("#0 and #1 ");
        view.setFilter(filterInfo);
        view.setSelector(this.getSelector());
        return EmpJobGradeFactory.getLocalInstance(ctx).getEmpJobGradeCollection(view);
    }

    @Override
    protected IObjectCollection _getStartDateAfterAppointDateRecord(Context ctx, String personID, Date appointDate) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personID) || appointDate == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
        filterInfo.getFilterItems().add(new FilterItemInfo("effectStartDate", (Object)appointDate, CompareType.GREATER));
        filterInfo.setMaskString("#0 and #1");
        view.setFilter(filterInfo);
        view.setSelector(this.getSelector());
        return EmpJobGradeFactory.getLocalInstance(ctx).getEmpJobGradeCollection(view);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("workRelation"));
        sic.add(new SelectorItemInfo("jobGrade.id"));
        sic.add(new SelectorItemInfo("jobGrade.name"));
        sic.add(new SelectorItemInfo("jobGrade.number"));
        sic.add(new SelectorItemInfo("effectStartDate"));
        sic.add(new SelectorItemInfo("effectEndDate"));
        sic.add(new SelectorItemInfo("flowAffairID"));
        sic.add(new SelectorItemInfo("id"));
        return sic;
    }

    @Override
    protected void _recoveryEmpJobGrade(Context ctx, IObjectCollection empJobGradeColl, String affairEntryID) throws BOSException, EASBizException {
        EmpJobGradeInfo info = null;
        EmpJobGradeCollection empRelationStateColl = (EmpJobGradeCollection)empJobGradeColl;
        if (empRelationStateColl == null || empRelationStateColl.size() == 0) {
            return;
        }
        info = empRelationStateColl.get(0);
        EmpJobGradeFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(info.getId()));
        EmpJobGradeFacadeHelper.updatePersonPositonJobGrade(ctx, info);
    }

    @Override
    protected IObjectValue _getAppointDateEmpJobGrade(Context ctx, String personID, Date appointDate) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personID) || appointDate == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
        filterInfo.getFilterItems().add(new FilterItemInfo("effectStartDate", (Object)appointDate, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("effectEndDate", (Object)appointDate, CompareType.GREATER_EQUALS));
        filterInfo.setMaskString("#0 and #1 and #2 ");
        view.setFilter(filterInfo);
        view.setSelector(this.getSelector());
        EmpJobGradeCollection empJobGradeColl = EmpJobGradeFactory.getLocalInstance(ctx).getEmpJobGradeCollection(view);
        if (empJobGradeColl == null || empJobGradeColl.size() == 0) {
            return null;
        }
        return empJobGradeColl.get(0);
    }

    @Override
    protected void _createEmpJobGrade(Context ctx, String personID, String affairEntryID, Date effectDate, IObjectValue jobGradeInfo) throws BOSException, EASBizException {
        PersonInfo pInfo = new PersonInfo();
        pInfo.setId(BOSUuid.read((String)personID));
        EmpJobGradeInfo empJobGradeInfo = new EmpJobGradeInfo();
        empJobGradeInfo.setPerson(pInfo);
        empJobGradeInfo.setEffectStartDate(effectDate);
        empJobGradeInfo.setFlowAffairID(affairEntryID);
        empJobGradeInfo.setJobGrade((JobGradeInfo)jobGradeInfo);
        EmpJobGradeFactory.getLocalInstance(ctx).addnew(empJobGradeInfo);
        EmpJobGradeFacadeHelper.updatePersonPositonJobGrade(ctx, empJobGradeInfo);
    }
}

