/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpFlowInOutCollection;
import com.kingdee.eas.hr.base.EmpFlowInOutFactory;
import com.kingdee.eas.hr.base.EmpFlowInOutInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationChangeInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmpPositionInfo;
import com.kingdee.eas.hr.base.app.FlowInOutQueryHelper;
import com.kingdee.eas.hr.base.util.HRUtil;

public class FlowInOutHelper {
    public EmpFlowInOutInfo getActiveFlowInOutInfo(Context ctx, String empPosOrgRelationID) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("empPosOrgRelation.id", (Object)empPosOrgRelationID));
        filterInfo.getFilterItems().add(new FilterItemInfo("positionstatus", (Object)new Integer(0), CompareType.GREATER));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        EmpFlowInOutCollection coll = EmpFlowInOutFactory.getLocalInstance(ctx).getEmpFlowInOutCollection(view);
        if (coll != null && coll.size() > 0) {
            if (coll.size() > 1) {
                // empty if block
            }
            return coll.get(0);
        }
        return null;
    }

    public EmpFlowInOutInfo getInActiveFlowInOutInfo(Context ctx, String empPosOrgRelationID) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("empPosOrgRelation.id", (Object)empPosOrgRelationID));
        filterInfo.getFilterItems().add(new FilterItemInfo("positionstatus", (Object)new Integer(0), CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        EmpFlowInOutCollection coll = EmpFlowInOutFactory.getLocalInstance(ctx).getEmpFlowInOutCollection(view);
        if (coll != null && coll.size() > 0) {
            if (coll.size() > 1) {
                // empty if block
            }
            return coll.get(0);
        }
        return null;
    }

    public void updateOldInActiveRecordEndDate(Context ctx, EmpPosOrgRelationChangeInfo changeInfo) throws BOSException, EASBizException {
        FlowInOutQueryHelper queryHelper = new FlowInOutQueryHelper();
        EmpFlowInOutInfo oldInActiveInfo = queryHelper.getInActiveEmpPosOrgRelaByPositionAndDate(ctx, changeInfo.getStartDate(), changeInfo.getPositionInfo());
        if (oldInActiveInfo != null) {
            oldInActiveInfo.setFlowOutAffairID(changeInfo.getEntryID());
            oldInActiveInfo.setLEFFDT(HRUtil.getBeforeDate(changeInfo.getStartDate()));
            EmpFlowInOutFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(oldInActiveInfo.getId().toString()), (CoreBaseInfo)oldInActiveInfo);
        }
    }

    public void updateOldInActiveRecordEndDate(Context ctx, EmpPosOrgRelationInfo info) throws BOSException, EASBizException {
        EmpPosOrgRelationChangeInfo changeInfo = new EmpPosOrgRelationChangeInfo();
        changeInfo.setEntryID(info.getFlowInAffairID());
        changeInfo.setStartDate(info.getEFFDT());
        EmpPositionInfo positionInfo = new EmpPositionInfo();
        positionInfo.setPersonInfo(info.getPerson());
        positionInfo.setPositionInfo(info.getPosition());
        positionInfo.setAdminInfo(info.getAdminOrg());
        positionInfo.setAssignType(info.getAssignType());
        positionInfo.setPositionStateEnum(info.getPositionstatus());
        changeInfo.setPositionInfo(positionInfo);
        this.updateOldInActiveRecordEndDate(ctx, changeInfo);
    }

    public EmpFlowInOutInfo prepareAddNewInfo(EmpPosOrgRelationInfo info) {
        EmpFlowInOutInfo newInfo = new EmpFlowInOutInfo();
        HistoryUtil.cloneInfo((IObjectValue)info, (IObjectValue)newInfo);
        newInfo.setParent(null);
        newInfo.setEmpPosOrgRelation(info);
        newInfo.setBizDate(info.getEFFDT());
        newInfo.setId(BOSUuid.create((BOSObjectType)newInfo.getBOSType()));
        return newInfo;
    }

    public void updateOldInActiveRecordEndDate(Context ctx, EmpPosOrgRelationChangeInfo changeInfo, boolean sameDatePersonChange) throws EASBizException, BOSException {
        FlowInOutQueryHelper queryHelper = new FlowInOutQueryHelper();
        EmpFlowInOutInfo oldInActiveInfo = queryHelper.getInActiveEmpPosOrgRelaByPositionAndDate(ctx, changeInfo.getStartDate(), changeInfo.getPositionInfo());
        if (oldInActiveInfo != null) {
            oldInActiveInfo.setFlowOutAffairID(changeInfo.getEntryID());
            if (sameDatePersonChange) {
                oldInActiveInfo.setLEFFDT(changeInfo.getStartDate());
            } else {
                oldInActiveInfo.setLEFFDT(HRUtil.getBeforeDate(changeInfo.getStartDate()));
            }
            EmpFlowInOutFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(oldInActiveInfo.getId().toString()), (CoreBaseInfo)oldInActiveInfo);
        }
    }
}

