/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.HRInitCollection;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.HRInitInfo;
import com.kingdee.eas.hr.base.HROrgContextManagerFacadeFactory;
import com.kingdee.eas.hr.base.app.AbstractHRInitControllerBean;
import com.kingdee.eas.hr.base.util.CodingRuleData;
import com.kingdee.eas.hr.compensation.CmpOutFunctionFactory;
import com.kingdee.eas.hr.compensation.ICmpOutFunction;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.List;
import org.apache.log4j.Logger;

public class HRInitControllerBean
extends AbstractHRInitControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.HRInitControllerBean");

    @Override
    protected int _getJobSystemScheme(Context ctx) throws BOSException, EASBizException {
        return this.getBooleanKeyValue(ctx, "JOB_SYSTEM_SCHEMA", false);
    }

    @Override
    protected int _getSPSchema(Context ctx) throws BOSException, EASBizException {
        return this.getBooleanKeyValue(ctx, "SALARAIATPOINT_SCHEMA", true);
    }

    @Override
    protected int _getInitCmpItemAccount(Context ctx, boolean isCUFilter) throws BOSException, EASBizException {
        return this.getBooleanKeyValue(ctx, "IS_USE_CMPITEMACCOUNT", isCUFilter);
    }

    private int getBooleanKeyValue(Context ctx, String key, boolean isCUFilter) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer("where key='");
        oql.append(key).append("' ");
        if (isCUFilter) {
            oql.append(" and hrOrgUnit='").append(ContextUtil.getCurrentHRUnit((Context)ctx).getId()).append("'");
        }
        if (!this.exists(ctx, oql.toString())) {
            return -1;
        }
        HRInitInfo hrInitInfo = this.getHRInitInfo(ctx, oql.toString());
        String value = hrInitInfo.getValue();
        if (value.equalsIgnoreCase("0")) {
            return 0;
        }
        return 1;
    }

    @Override
    protected void _isFinishGroupBaseDataUpdate(Context ctx) throws BOSException, EASBizException {
        int isFinish = this.getBaseDataUpdateIsFinish(ctx);
        if (isFinish == 0) {
            throw new BaseException(BaseException.GROUPBASEDATA_UPDATE_NOTFINISH);
        }
    }

    private int getBaseDataUpdateIsFinish(Context ctx) throws EASBizException, BOSException {
        String oql = " where key='IS_BASEDATA_UPDATE_TO600'";
        if (!this.exists(ctx, oql)) {
            return 0;
        }
        HRInitInfo hrInitInfo = this.getHRInitInfo(ctx, oql);
        String value = hrInitInfo.getValue();
        if (value.equalsIgnoreCase("0")) {
            return 0;
        }
        return 1;
    }

    private int getIntKeyValue(Context ctx, String key, boolean isCUFilter) throws BOSException, EASBizException {
        String oql = "where key='" + key + "' ";
        if (isCUFilter) {
            oql = oql + " and hrOrgUnit='" + ContextUtil.getCurrentHRUnit((Context)ctx).getId() + "'";
        }
        if (!this.exists(ctx, oql)) {
            return -1;
        }
        HRInitInfo hrInitInfo = this.getHRInitInfo(ctx, oql);
        String value = hrInitInfo.getValue();
        return Integer.parseInt(value);
    }

    private String getStringKeyValue(Context ctx, String key, boolean isCUFilter) throws BOSException, EASBizException {
        String oql = "where key='" + key + "' ";
        if (isCUFilter) {
            oql = oql + " and hrOrgUnit='" + ContextUtil.getCurrentHRUnit((Context)ctx).getId() + "'";
        }
        if (!this.exists(ctx, oql)) {
            return null;
        }
        HRInitInfo hrInitInfo = this.getHRInitInfo(ctx, oql);
        return hrInitInfo.getValue();
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRInitInfo info = (HRInitInfo)model;
        String oql = "where key='" + info.getKey() + "' ";
        if (((Boolean)info.get("IS_CU_FILTER")).booleanValue()) {
            oql = oql + " and hrOrgUnit='" + ContextUtil.getCurrentHRUnit((Context)ctx).getId() + "'";
        }
        if (this.exists(ctx, oql)) {
            HRInitInfo oldInfo = this.getHRInitInfo(ctx, oql);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(oldInfo.getId()), (IObjectValue)info);
            return null;
        }
        info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        return super._addnew(ctx, (IObjectValue)info);
    }

    @Override
    protected String _getJXCurrency(Context ctx) throws BOSException, EASBizException {
        return this.getStringKeyValue(ctx, "JX_CURRENCY", true);
    }

    @Override
    protected int _getInitYear(Context ctx) throws BOSException, EASBizException {
        return this.getIntKeyValue(ctx, "INIT_YEAR", true);
    }

    @Override
    protected void _finishInit(Context ctx) throws BOSException, EASBizException {
        if (this.getSPSchema(ctx) == -1) {
            throw new BaseException(BaseException.HRINIT_FINISH_ERROR_2);
        }
        if (this.getInitYear(ctx) == -1) {
            throw new BaseException(BaseException.HRINIT_FINISH_ERROR_3);
        }
        if (this.getJXCurrency(ctx) == null) {
            throw new BaseException(BaseException.HRINIT_FINISH_ERROR_4);
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.base.app.HRInitPersonIsFinishQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId()));
        fi.getFilterItems().add(new FilterItemInfo("EmployeeType.id", null));
        fi.getFilterItems().add(new FilterItemInfo("idCardNO", null));
        fi.getFilterItems().add(new FilterItemInfo("passportNO", null));
        fi.setMaskString("#0 and (#1 or (#2 and #3))");
        viewInfo.setFilter(fi);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        StringBuffer names = null;
        try {
            while (rows.next()) {
                if (names == null) {
                    names = new StringBuffer(rows.getString("name"));
                    continue;
                }
                names.append(",");
                names.append(rows.getString("name"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (names != null) {
            Object[] param = new Object[]{names};
            throw new BaseException(BaseException.HRINIT_FINISH_ERROR_6, param);
        }
        ICmpOutFunction iCmpOutFunction = CmpOutFunctionFactory.getLocalInstance((Context)ctx);
        iCmpOutFunction.initCmp();
        String sql = "UPDATE T_HR_HRInit SET FIsFinish=1 WHERE FHROrgUnitID='" + ContextUtil.getCurrentHRUnit((Context)ctx).getId() + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected boolean _isFinishInit(Context ctx) throws BOSException, EASBizException {
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            return false;
        }
        String oql = "where hrOrgUnit.id='" + ContextUtil.getCurrentHRUnit((Context)ctx).getId() + "' AND key='JX_CURRENCY'";
        if (!this.exists(ctx, oql)) {
            return false;
        }
        HRInitInfo info = this.getHRInitInfo(ctx, oql);
        if (!info.isIsFinish()) {
            return false;
        }
        return info.isIsFinish();
    }

    private void checkExistHRO(Context ctx) throws BOSException, EASBizException {
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            throw new BaseException(BaseException.HRINIT_NOT_HRUNIT);
        }
    }

    @Override
    protected void _isInitFinish(Context ctx) throws BOSException, EASBizException {
        this.checkExistHRO(ctx);
        String oql = "where hrOrgUnit.id='" + ContextUtil.getCurrentHRUnit((Context)ctx).getId() + "' AND key='JX_CURRENCY'";
        if (!this.exists(ctx, oql)) {
            throw new BaseException(BaseException.HRINIT_FINISH_ERROR_5);
        }
        HRInitInfo info = this.getHRInitInfo(ctx, oql);
        if (!info.isIsFinish()) {
            throw new BaseException(BaseException.HRINIT_FINISH_ERROR_5);
        }
    }

    @Override
    protected void _isInitFinish(Context ctx, HROrgUnitInfo hrOrgUnit) throws BOSException, EASBizException {
        this.checkExistHRO(hrOrgUnit);
        String oql = "where hrOrgUnit.id='" + hrOrgUnit.getId() + "' AND key='JX_CURRENCY'";
        if (!this.exists(ctx, oql)) {
            throw new BaseException(BaseException.HRINIT_FINISH_ERROR_5);
        }
        HRInitInfo info = this.getHRInitInfo(ctx, oql);
        if (!info.isIsFinish()) {
            throw new BaseException(BaseException.HRINIT_FINISH_ERROR_5);
        }
    }

    private void checkExistHRO(HROrgUnitInfo hrOrgUnit) throws BOSException, EASBizException {
        if (hrOrgUnit == null) {
            throw new BaseException(BaseException.HRINIT_NOT_HRUNIT);
        }
    }

    @Override
    protected int _getInitBenefit(Context ctx) throws BOSException, EASBizException {
        this.checkExistHRO(ctx);
        return this.getBooleanKeyValue(ctx, "INIT_BENEFIT", true);
    }

    @Override
    protected int _getInitTechPost(Context ctx) throws BOSException, EASBizException {
        return this.getBooleanKeyValue(ctx, "INIT_TECHPOST", false);
    }

    @Override
    protected CodingRuleData _getCodingRuleData(Context ctx, IObjectValue bizObject) throws BOSException, EASBizException {
        CodingRuleData data = null;
        ICodingRuleManager iCrm = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String companyId = iCrm.getCurrentAppOUID(bizObject);
        if (!StringUtils.isEmpty((String)companyId)) {
            data = new CodingRuleData();
            data.setOrgId(companyId);
            data.setExistRule(iCrm.isExist(bizObject, companyId));
            if (data.isExistRule()) {
                data.setAddView(iCrm.isAddView(bizObject, companyId));
                data.setUseIntermitNumber(iCrm.isUseIntermitNumber(bizObject, companyId));
                data.setModifable(iCrm.isModifiable(bizObject, companyId));
                if (data.isUseIntermitNumber()) {
                    data.setNumber(iCrm.readNumber(bizObject, companyId));
                } else {
                    data.setNumber(iCrm.getNumber(bizObject, companyId));
                }
            }
        }
        return data;
    }

    @Override
    protected CodingRuleData _getCodingRuleData(Context ctx, IObjectValue bizObject, String OrgId) throws BOSException, EASBizException {
        CodingRuleData data = null;
        ICodingRuleManager iCrm = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (!StringUtils.isEmpty((String)OrgId)) {
            data = new CodingRuleData();
            data.setOrgId(OrgId);
            data.setExistRule(iCrm.isExist(bizObject, OrgId));
            if (data.isExistRule()) {
                data.setAddView(iCrm.isAddView(bizObject, OrgId));
                data.setUseIntermitNumber(iCrm.isUseIntermitNumber(bizObject, OrgId));
                data.setModifable(iCrm.isModifiable(bizObject, OrgId));
                if (data.isUseIntermitNumber()) {
                    data.setNumber(iCrm.readNumber(bizObject, OrgId));
                } else {
                    data.setNumber(iCrm.getNumber(bizObject, OrgId));
                }
            }
        }
        return data;
    }

    @Override
    protected int _isPositionRelatedHROrgFinished(Context ctx, String positionID) throws BOSException, EASBizException {
        int finished = -1;
        if (StringUtils.isEmpty((String)positionID)) {
            return finished;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("adminOrgUnit.id"));
        PositionInfo position = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(positionID), selector);
        if (position == null || position.getAdminOrgUnit() == null) {
            return finished;
        }
        String adminId = position.getAdminOrgUnit().getId().toString();
        HROrgUnitInfo hrOrg = HROrgContextManagerFacadeFactory.getLocalInstance(ctx).getHROByAdminOrgUnitID(adminId);
        if (hrOrg == null) {
            return finished;
        }
        finished = this.isFinishInit(ctx, hrOrg.getId().toString()) ? 1 : 0;
        return finished;
    }

    @Override
    protected boolean _isPersonReleatedHROrgInitFinished(Context ctx, List personIDs) throws BOSException, EASBizException {
        if (personIDs == null || personIDs.size() <= 0) {
            return false;
        }
        StringBuffer verifySql = new StringBuffer();
        verifySql.append(" select top 1 I.FID from T_HR_HRInit I ");
        verifySql.append(" inner join T_ORG_HRO H ON I.FHROrgUnitID = H.FID ");
        verifySql.append(" INNER JOIN T_ORG_UnitRelation U ON U.FToUnitID = H.FID ");
        verifySql.append(" inner join t_org_admin a on U.FFromUnitID = a.fid ");
        verifySql.append(" inner join T_ORG_Position p on p.FAdminOrgUnitID = a.fid ");
        verifySql.append(" inner join T_ORG_PositionMember pm on pm.FPositionID = p.fid ");
        verifySql.append(" where  U.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5' ");
        verifySql.append(" and I.FKey='JX_CURRENCY' and I.FIsFinish = 1");
        verifySql.append(" and pm.FPersonID in (");
        int size = personIDs.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                verifySql.append(",");
            }
            verifySql.append("'");
            verifySql.append((String)personIDs.get(i));
            verifySql.append("'");
        }
        verifySql.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)verifySql.toString());
        return rowSet.size() > 0;
    }

    private boolean isFinishInit(Context ctx, String hrOrgUnitID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)hrOrgUnitID)) {
            return false;
        }
        String oql = "where hrOrgUnit.id='" + hrOrgUnitID + "' AND key='JX_CURRENCY'";
        if (!this.exists(ctx, oql)) {
            return false;
        }
        HRInitInfo info = this.getHRInitInfo(ctx, oql);
        return info.isIsFinish();
    }

    @Override
    protected void _checkFinishInitAndGroupBaseDataUpdate(Context ctx) throws BOSException, EASBizException {
        this._isInitFinish(ctx);
        this._isFinishGroupBaseDataUpdate(ctx);
    }

    @Override
    protected CodingRuleData _getCodingRuleReadNum(Context ctx, IObjectValue bizObject, String orgId) throws BOSException, EASBizException {
        CodingRuleData data = null;
        ICodingRuleManager iCrm = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (!StringUtils.isEmpty((String)orgId)) {
            data = new CodingRuleData();
            data.setOrgId(orgId);
            data.setExistRule(iCrm.isExist(bizObject, orgId));
            if (data.isExistRule()) {
                data.setAddView(iCrm.isAddView(bizObject, orgId));
                data.setUseIntermitNumber(iCrm.isUseIntermitNumber(bizObject, orgId));
                data.setModifable(iCrm.isModifiable(bizObject, orgId));
                data.setNumber(iCrm.readNumber(bizObject, orgId));
            }
        }
        return data;
    }

    @Override
    protected boolean _isAdminOrgRelatedHROrgFinished(Context ctx, String adminOrgId) throws BOSException, EASBizException {
        HROrgUnitInfo hrOrg = HROrgContextManagerFacadeFactory.getLocalInstance(ctx).getHROByAdminOrgUnitID(adminOrgId);
        if (hrOrg == null) {
            return false;
        }
        return this.isFinishInit(ctx, hrOrg.getId().toString());
    }

    @Override
    protected int _getApplyK3SysParam(Context ctx) throws BOSException, EASBizException {
        return this.getBooleanKeyValue(ctx, "applyK3KaoQingSystem", false);
    }

    @Override
    protected HRInitInfo _getShrSytemUpdateInfo(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("key", (Object)"IS_SHRSYSTEM_UPDATE"));
        viewInfo.setFilter(filter);
        HRInitCollection initColl = HRInitFactory.getLocalInstance(ctx).getHRInitCollection(viewInfo);
        if (initColl.size() > 0) {
            return initColl.get(0);
        }
        return null;
    }

    @Override
    protected int _isShrSytemUpdateFinish(Context ctx) throws BOSException, EASBizException {
        return this.getBooleanKeyValue(ctx, "IS_SHRSYSTEM_UPDATE", false);
    }
}

