/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.base.PlugInApplyMethod;
import com.kingdee.eas.hr.base.PlugInParam;
import com.kingdee.eas.hr.base.app.AbstractPlugInBean;
import com.kingdee.eas.hr.base.app.IPlugInBean;
import com.kingdee.eas.hr.base.app.PlugInBeanParam;
import com.kingdee.eas.hr.base.util.IReflectMethod;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PlugInBeanProxy
extends AbstractPlugInBean
implements IReflectMethod {
    private static Logger logger = Logger.getLogger(PlugInBeanProxy.class);
    private String applyClass = null;
    private List plugIns = new ArrayList();
    private List plugInClasses = new ArrayList();

    public void addPlugIn(String plugInClass) {
        if (!StringUtils.isEmpty((String)plugInClass)) {
            this.plugInClasses.add(plugInClass);
        }
    }

    public String getApplyClass() {
        return this.applyClass;
    }

    public void setApplyClass(String applyClass) {
        this.applyClass = applyClass;
    }

    public void newInstance(Context ctx) {
        this.plugIns.clear();
        if (this.plugInClasses != null) {
            IPlugInBean plugIn = null;
            int size = this.plugInClasses.size();
            for (int i = 0; i < size; ++i) {
                try {
                    String pClass = (String)this.plugInClasses.get(i);
                    plugIn = (IPlugInBean)Class.forName(pClass).newInstance();
                    this.plugIns.add(plugIn);
                    logger.debug((Object)("PlugIn:new Instance " + pClass));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"2_PlugInBeanProxy", (Locale)ctx.getOriginLocale()), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void setPlugInParam(PlugInParam plugInParam) {
        super.setPlugInParam(plugInParam);
        if (this.plugIns != null) {
            int size = this.plugIns.size();
            for (int i = 0; i < size; ++i) {
                ((IPlugInBean)this.plugIns.get(i)).setPlugInParam(plugInParam);
            }
        }
    }

    public void callMethod(PlugInBeanParam param, String prefix) throws Exception {
        if (param == null) {
            return;
        }
        PlugInApplyMethod pMethod = param.getCurrentMethod();
        String mName = pMethod.getName();
        IPlugInBean plugIn = null;
        Method method = null;
        if (!StringUtils.isEmpty((String)prefix)) {
            String head = mName.substring(0, 1);
            mName = prefix + head.toUpperCase() + mName.substring(1);
        }
        if (this.plugIns != null) {
            int size = this.plugIns.size();
            for (int i = 0; i < size; ++i) {
                plugIn = (IPlugInBean)this.plugIns.get(i);
                plugIn.setPlugInParam(param);
                try {
                    method = plugIn.getClass().getMethod(mName, null);
                    if (method == null) continue;
                    method.invoke((Object)plugIn, null);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void reflectMethod(String methodName, Class[] pClass, Object[] param) throws Exception {
        if (this.plugIns != null) {
            Object plugIn = null;
            Method method = null;
            int size = this.plugIns.size();
            for (int i = 0; i < size; ++i) {
                plugIn = this.plugIns.get(i);
                try {
                    method = plugIn.getClass().getMethod(methodName, pClass);
                    if (method == null) continue;
                    method.invoke(plugIn, param);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
    }
}

