/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.ClassLocationEnum;
import com.kingdee.eas.hr.base.PlugInApplyClassFactory;
import com.kingdee.eas.hr.base.PlugInApplyClassInfo;
import com.kingdee.eas.hr.base.PlugInConfigCollection;
import com.kingdee.eas.hr.base.PlugInConfigInfo;
import com.kingdee.eas.hr.base.app.AbstractPlugInConfigControllerBean;
import com.kingdee.eas.hr.base.app.IPlugInBean;
import com.kingdee.eas.hr.base.app.PlugInBeanFactory;
import com.kingdee.eas.hr.base.util.PlugInManagerUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class PlugInConfigControllerBean
extends AbstractPlugInConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.PlugInConfigControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PlugInConfigInfo info = (PlugInConfigInfo)model;
        String sql = "select isnull(max(FLoadOrder),-1) from t_hr_pluginconfig where FApplyClassID = '" + info.getApplyClass().getId() + "'";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                info.setLoadOrder(rows.getInt(1) + 1);
            } else {
                info.setLoadOrder(0);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        IObjectPK pk = super._addnew(ctx, model);
        if (info.isEnable()) {
            this.updateServerPlugInConfig(ctx, info.getApplyClass());
        }
        return pk;
    }

    private void updateServerPlugInConfig(Context ctx, PlugInApplyClassInfo appClass) throws BOSException, EASBizException {
        if (appClass == null) {
            return;
        }
        if (ClassLocationEnum.app.equals((Object)appClass.getLocation())) {
            PlugInBeanFactory.setNeedSyn(ctx);
        }
    }

    private void updateServerPlugInConfig(Context ctx, String configIDs) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)configIDs)) {
            return;
        }
        StringBuffer synSql = new StringBuffer();
        synSql.append(" select top 1 c.Fid from T_HR_PlugInConfig c ");
        synSql.append(" inner join T_HR_PlugInApplyClass a on a.FID = c.FApplyClassID");
        synSql.append(" where c.FID in(");
        synSql.append(configIDs);
        synSql.append(") and a.FLocation = 0");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)synSql.toString());
        if (rowSet.size() > 0) {
            PlugInBeanFactory.setNeedSyn(ctx);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
        if (pk != null) {
            this.updateServerPlugInConfig(ctx, "'" + pk + "'");
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
        if (pk != null) {
            this.updateServerPlugInConfig(ctx, "'" + pk + "'");
        }
    }

    @Override
    protected void _setOrder(Context ctx, List idOrder, String applyClassId) throws BOSException, EASBizException {
        int i;
        if (idOrder == null || StringUtils.isEmpty((String)applyClassId)) {
            return;
        }
        SelectorItemCollection updateField = new SelectorItemCollection();
        updateField.add(new SelectorItemInfo("loadOrder"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        HashSet ids = new HashSet();
        int size = idOrder.size();
        for (int i2 = 0; i2 < size; ++i2) {
            ids.add(idOrder.get(i2));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("applyClass.id", (Object)applyClassId));
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.NOTINCLUDE));
        filter.setMaskString("#0 and #1");
        viewInfo.setFilter(filter);
        viewInfo.getSorter().add(new SorterItemInfo("loadOrder"));
        PlugInConfigCollection col = this.getPlugInConfigCollection(ctx, viewInfo);
        PlugInConfigInfo model = null;
        boolean isSyn = false;
        int size2 = idOrder.size();
        for (i = 0; i < size2; ++i) {
            model = this.getPlugInConfigInfo(ctx, (IObjectPK)new ObjectUuidPK((String)idOrder.get(i)));
            model.setLoadOrder(i);
            if (model.isEnable()) {
                isSyn = true;
            }
            this._updatePartial(ctx, (IObjectValue)model, updateField);
        }
        if (col != null) {
            i = 0;
            int j = idOrder.size();
            int size3 = col.size();
            while (i < size3) {
                model = col.get(i);
                model.setLoadOrder(j);
                if (model.isEnable()) {
                    isSyn = true;
                }
                this._updatePartial(ctx, (IObjectValue)model, updateField);
                ++i;
                ++j;
            }
        }
        if (isSyn) {
            this.updateServerPlugInConfig(ctx, PlugInApplyClassFactory.getLocalInstance(ctx).getPlugInApplyClassInfo((IObjectPK)new ObjectUuidPK(applyClassId)));
        }
    }

    @Override
    protected void _setUsable(Context ctx, boolean enable, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() <= 0) {
            return;
        }
        StringBuffer idStr = new StringBuffer();
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                idStr.append(",");
            }
            idStr.append("'");
            idStr.append(ids.get(i));
            idStr.append("'");
        }
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_HR_PlugInConfig set FEnable = ");
        updateSql.append(enable ? 1 : 0);
        updateSql.append(" where FId in (");
        updateSql.append(idStr);
        updateSql.append(")");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        this.updateServerPlugInConfig(ctx, idStr.toString());
    }

    @Override
    protected void _verifyAppPlugIn(Context ctx, String plugInClass) throws BOSException, EASBizException {
        PlugInManagerUtil.verifyPlugInClass(plugInClass, IPlugInBean.class);
    }
}

