/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app.config;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.hr.base.util.XMLReader;
import com.kingdee.util.StringUtils;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class HRBillBaseConfigReader
extends XMLReader {
    private static HashMap cache = new HashMap();
    public static final String ROOT = "HRBillBase";
    public static final String FIELD = "field";
    public static final String FUNCTION = "function";
    public static final String FACTORY = "factory";
    public static final String OBJECT = "object";

    public HRBillBaseConfigReader(InputStream byteStream) {
        super(byteStream);
    }

    public HRBillBaseConfigReader(Reader charStream) {
        super(charStream);
    }

    public HRBillBaseConfigReader(String fileName) throws BOSException {
        super(fileName);
    }

    public static HRBillBaseConfigReader getConfig(Class caller, String fileName) throws BOSException {
        if (caller == null || fileName == null) {
            return null;
        }
        String key = caller.getName() + "|" + fileName;
        if (cache.containsKey(key)) {
            return (HRBillBaseConfigReader)cache.get(key);
        }
        HRBillBaseConfigReader reader = new HRBillBaseConfigReader(HRBillBaseConfigReader.getInputStream(caller, fileName));
        cache.put(key, reader);
        return reader;
    }

    public String get(String type, String name) {
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)type)) {
            return null;
        }
        List fields = this.getRoot().getChildren(type);
        Element f = null;
        if (fields != null) {
            int size = fields.size();
            for (int i = 0; i < size; ++i) {
                f = (Element)fields.get(i);
                if (!name.equals(f.getAttribute("name").getValue())) continue;
                return f.getText();
            }
        }
        return null;
    }

    public String getField(String name) {
        return this.get(FIELD, name);
    }

    public String getFunction(String name) {
        return this.get(FUNCTION, name);
    }

    public Object getObject(String name) {
        String value = this.get(OBJECT, name);
        if (!StringUtils.isEmpty((String)value)) {
            try {
                return Class.forName(value).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String getFactory(String name) {
        return this.get(FACTORY, name);
    }

    public static Document buildDemoConfig() {
        Element root = new Element(ROOT);
        Document doc = new Document(root);
        Element field = new Element(FIELD);
        field.setAttribute("name", "bill");
        field.setText("bill");
        root.addContent((Content)field);
        field = new Element(FIELD);
        field.setAttribute("name", "entry");
        field.setText("entrys");
        root.addContent((Content)field);
        field = new Element(FIELD);
        field.setAttribute("name", "entry_effect_date");
        field.setText("bizDate");
        root.addContent((Content)field);
        Element function = new Element(FUNCTION);
        function.setAttribute("name", "entry_effect");
        function.setText("com.kingdee.eas.hr.affair.app.EmpEnrollBizBillEffectFunction");
        root.addContent((Content)function);
        Element factory = new Element(FACTORY);
        factory.setAttribute("name", "entry_instance_factory");
        factory.setText("com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryFactory");
        root.addContent((Content)factory);
        Element bizObj = new Element(OBJECT);
        bizObj.setAttribute("name", "entry_effect");
        bizObj.setText("com.kingdee.eas.hr.affair.app.EmpEnrollBillBizBean");
        root.addContent((Content)bizObj);
        return doc;
    }

    public static final void main(String[] args) throws Exception {
    }
}

