/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpAffairBizBillException;
import com.kingdee.eas.hr.base.EmpPosOrgRelationChangeInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmpPositionInfo;
import com.kingdee.eas.hr.base.HRBizData;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.HRBizDefineTypeEnum;
import com.kingdee.eas.hr.base.PositionStatuEnum;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.base.app.EmpPostExperienceHisHelper;
import com.kingdee.eas.hr.base.app.his.HistoryVersionUtil;
import com.kingdee.eas.hr.base.app.util.EmpPosOrgUtil;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.PersonPositionOptFacadeFactory;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptPersonPositionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHREmpPosOrgRelationDomainUtil {
    private static Logger logger = LoggerFactory.getLogger(SHREmpPosOrgRelationDomainUtil.class);

    private SHREmpPosOrgRelationDomainUtil() {
    }

    public static EmpPosOrgRelationInfo prepareAddNewInfo(EmpPosOrgRelationChangeInfo changeInfo) {
        HRBizData bizdata = changeInfo.getHrBizData();
        EmpPosOrgRelationInfo newInfo = new EmpPosOrgRelationInfo();
        newInfo.setFlowInAffairID(changeInfo.getEntryID());
        newInfo.setActionType(changeInfo.getActionType());
        newInfo.setActionReason(changeInfo.getActionReason());
        newInfo.setPositionstatus(changeInfo.getPositionInfo().getPositionStateEnum());
        newInfo.setAction(changeInfo.getActionDef());
        newInfo.setRemark(changeInfo.getRemark());
        newInfo.setEFFDT(changeInfo.getStartDate());
        newInfo.setLEFFDT(HRUtil.getMaxEndDate());
        newInfo.setStartDateTime(bizdata.getStartDateTime());
        newInfo.setEndDateTime(HistoryVersionUtil.getMaxEndDate());
        newInfo.setAdminOrg(changeInfo.getPositionInfo().getAdminInfo());
        newInfo.setPerson(changeInfo.getPositionInfo().getPersonInfo());
        newInfo.setPosition(changeInfo.getPositionInfo().getPositionInfo());
        newInfo.setAssignType(changeInfo.getPositionInfo().getAssignType());
        newInfo.setLaborRelation(changeInfo.getLaborRelationInfo());
        newInfo.setIsIncount(SHREmpPosOrgRelationDomainUtil.isTrue(changeInfo.getIsIncount()));
        newInfo.setIsEnrolled(SHREmpPosOrgRelationDomainUtil.isTrue(changeInfo.getIsEnrolled()));
        newInfo.setOptBackDate(changeInfo.getOptBackDate());
        newInfo.setHrOrgUnit(changeInfo.getHrOrgUnitInfo());
        newInfo.setCompany(changeInfo.getPositionInfo().getCompany());
        newInfo.setId(BOSUuid.create((BOSObjectType)newInfo.getBOSType()));
        newInfo.setEFFDT(DateTimeUtils.truncateDate((Date)changeInfo.getStartDate()));
        if (newInfo.getLEFFDT() != null) {
            newInfo.setLEFFDT(DateTimeUtils.truncateDate((Date)newInfo.getLEFFDT()));
        } else {
            newInfo.setLEFFDT(HRUtil.getMaxEndDate());
        }
        if (newInfo.getPositionstatus() == null) {
            newInfo.setPositionstatus(PositionStatuEnum.Active);
        }
        newInfo.setIsSystem(true);
        newInfo.setIsInner(true);
        newInfo.setEmployeeType(null);
        return newInfo;
    }

    public static boolean hasSamePositionActive(Context ctx, EmpPosOrgRelationInfo newInfo) throws BOSException, EASBizException {
        Date startDateTime;
        String adminOrgId;
        String positionId;
        String personId = newInfo.getPerson().getId().toString();
        EmpPosOrgRelationInfo dbInfo = SHREmpPosOrgRelationDomainUtil.getNotInActiveEmpPosOrgRelaByPositionAndDate(ctx, personId, positionId = newInfo.getPosition().getId().toString(), adminOrgId = newInfo.getAdminOrg().getId().toString(), startDateTime = newInfo.getStartDateTime());
        return dbInfo != null;
    }

    public static void addNewPositionMember(Context ctx, EmpPosOrgRelationInfo info) throws EASBizException, BOSException {
        if (info.getPosition() == null) {
            return;
        }
        PositionMemberInfo pmInfo = new PositionMemberInfo();
        pmInfo.setPerson(info.getPerson());
        pmInfo.setPosition(info.getPosition());
        pmInfo.setIsPrimary(EmpPosOrgUtil.isPrimaryPosition(info.getAssignType()));
        pmInfo.setBeginDate(info.getEFFDT());
        pmInfo.setHrOrgUnit(info.getHrOrgUnit());
        pmInfo.put("IS_FROM_SHR_OPTAction", (Object)true);
        PositionMemberFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)pmInfo);
    }

    public static void deletePositionMember(Context ctx, EmpPosOrgRelationInfo info) throws EASBizException, BOSException {
        if (info.getPosition() == null) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)info.getPerson().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("position.id", (Object)info.getPosition().getId().toString()));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        SorterItemCollection sorters = new SorterItemCollection();
        sorters.add(new SorterItemInfo("createTime"));
        view.setSorter(sorters);
        PositionMemberCollection pmColl = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(view);
        if (pmColl == null || pmColl.size() == 0) {
            return;
        }
        String needPMid = null;
        int countPrimary = 0;
        if (pmColl.size() == 1) {
            needPMid = pmColl.get(0).getId().toString();
        } else {
            for (int i = 0; i < pmColl.size(); ++i) {
                if (!DateTimeUtils.truncateDate((Date)pmColl.get(i).getBeginDate()).equals(info.getEFFDT())) continue;
                boolean isPrimary = pmColl.get(i).isIsPrimary();
                if (isPrimary) {
                    ++countPrimary;
                    continue;
                }
                needPMid = pmColl.get(i).getId().toString();
            }
            if (pmColl.size() == countPrimary || countPrimary == 0) {
                needPMid = pmColl.get(0).getId().toString();
            }
        }
        if (!StringUtils.isEmpty((String)needPMid)) {
            try {
                PositionMemberFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(needPMid));
            }
            catch (EASBizException e) {
                logger.error("SHREmpPosOrgRelationDomainUtil.deletePositionMember needPMid: " + needPMid);
                throw e;
            }
            catch (BOSException e) {
                logger.error("SHREmpPosOrgRelationDomainUtil.deletePositionMember needPMid: " + needPMid);
                throw e;
            }
        }
    }

    public static void deletePositionMemberBySql(Context ctx, EmpPosOrgRelationInfo info) throws EASBizException, BOSException {
        if (info.getPosition() == null) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)info.getPerson().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("position.id", (Object)info.getPosition().getId().toString()));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        SorterItemCollection sortCollection = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        sortInfo.setSortType(SortType.ASCEND);
        sortCollection.add(sortInfo);
        view.setSorter(sortCollection);
        PositionMemberCollection pmColl = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(view);
        if (pmColl == null || pmColl.size() == 0) {
            return;
        }
        String needPMid = null;
        if (pmColl.size() == 1) {
            needPMid = pmColl.get(0).getId().toString();
        } else {
            for (int i = 0; i < pmColl.size(); ++i) {
                if (!DateTimeUtils.truncateDate((Date)pmColl.get(i).getBeginDate()).equals(info.getEFFDT())) continue;
                needPMid = pmColl.get(i).getId().toString();
                if (!pmColl.get(i).isIsPrimary()) break;
            }
        }
        if (!StringUtils.isEmpty((String)needPMid)) {
            String sql = "delete from T_ORG_PositionMember where fid='" + needPMid + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    public static void deletePositionMember(Context ctx, EmpPosOrgRelationChangeInfo changeInfo) throws EASBizException, BOSException {
        EmpPositionInfo empPositionInfo = changeInfo.getPositionInfo();
        String personId = empPositionInfo.getPersonInfo().getId().toString();
        String poitionId = empPositionInfo.getPositionInfo().getId().toString();
        String adminId = empPositionInfo.getAdminInfo().getId().toString();
        HRBizData bizData = changeInfo.getHrBizData();
        Date startDateTime = bizData.getPreEndDateTime();
        EmpPosOrgRelationInfo existInfo = SHREmpPosOrgRelationDomainUtil.getNotInActiveEmpPosOrgRelaByPositionAndDate(ctx, personId, poitionId, adminId, startDateTime);
        Boolean deleteBySql = SHREmpPosOrgRelationDomainUtil.IsDeletePositionMemberBySql(ctx, bizData);
        if (existInfo != null && deleteBySql.booleanValue()) {
            SHREmpPosOrgRelationDomainUtil.deletePositionMemberBySql(ctx, existInfo);
        } else if (existInfo != null && !deleteBySql.booleanValue()) {
            SHREmpPosOrgRelationDomainUtil.deletePositionMember(ctx, existInfo);
        }
    }

    public static Boolean IsDeletePositionMemberBySql(Context ctx, HRBizData bizData) {
        HRBizDefineInfo action = bizData.getHrbizDefine();
        Boolean deleteBySql = false;
        if (HRBizDefineTypeEnum.RESIGN.equals((Object)action.getBizDefineType()) || HRBizDefineTypeEnum.RETIRE.equals((Object)action.getBizDefineType()) || HRBizDefineTypeEnum.REINVITEFIRE.equals((Object)action.getBizDefineType())) {
            deleteBySql = true;
        }
        return deleteBySql;
    }

    public static EmpPosOrgRelationInfo getNotInActiveEmpPosOrgRelaByPositionAndDate(Context ctx, String personId, String positionId, String adminId, Date startDateTime) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)adminId));
        filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionId));
        filter.getFilterItems().add(new FilterItemInfo("isinner", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("positionstatus", (Object)new Integer(0), CompareType.GREATER));
        FilterInfo filterDateTime = HistoryVersionUtil.getPointDateTimeFilterInfo(startDateTime);
        filter.mergeFilter(filterDateTime, "and");
        view.setFilter(filter);
        EmpPosOrgRelationQueryHelper queryHelper = new EmpPosOrgRelationQueryHelper();
        view.setSelector(queryHelper.getSelector());
        EmpPosOrgRelationCollection empposorgRelationColl = EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationCollection(view);
        if (empposorgRelationColl.size() <= 1 && empposorgRelationColl.size() > 0) {
            return empposorgRelationColl.get(0);
        }
        return null;
    }

    public static IObjectPK updatePersonPosition(Context ctx, EmpPosOrgRelationChangeInfo changeInfo, EmpPosOrgRelationInfo info) throws EASBizException, BOSException {
        IObjectPK hisPk = null;
        hisPk = PersonPositionOptFacadeFactory.getLocalInstance((Context)ctx).personChangeToUpdateWithHis(changeInfo, info);
        return hisPk;
    }

    public static void primaryPositionAddToAddEmpPostExp(Context ctx, EmpPosOrgRelationChangeInfo changeInfo, EmpPosOrgRelationInfo newInfo) throws EASBizException, BOSException {
        EmpPostExperienceHisHelper.primaryPositionAddToAddEmpPostExp(ctx, changeInfo, newInfo);
    }

    private static boolean isTrue(int count) {
        boolean isTrue = false;
        if (count == 1) {
            isTrue = true;
        }
        return isTrue;
    }

    public static void insertMidHisToUpdatePersonPosition(Context ctx, EmpPosOrgRelationChangeInfo changeInfo, EmpPosOrgRelationInfo newInfo) throws EASBizException, BOSException {
        PersonInfo personInfo = newInfo.getPerson();
        PersonPositionInfo ppInfo = SHREmpOptPersonPositionUtil.getPersonPositionInfoByPersonId((Context)ctx, (String)personInfo.getId().toString());
        AdminOrgUnitInfo adminCompanyOld = ppInfo.getCompany();
        AdminOrgUnitInfo adminCompanyNew = newInfo.getCompany();
        if (adminCompanyNew == null && newInfo.getAdminOrg() != null) {
            adminCompanyNew = HRUtilExtend.getCompany(ctx, newInfo.getAdminOrg());
        }
        if (!DateTimeUtils.dayBefore((Date)ppInfo.getEFFDT(), (Date)newInfo.getEFFDT()) && !HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)adminCompanyOld, (CoreBaseInfo)adminCompanyNew)) {
            throw new EmpAffairBizBillException(EmpAffairBizBillException.CANNOT_CHANGE_DIF_COMPANY);
        }
        SHREmpPosOrgRelationDomainUtil.updatePersonPosition(ctx, changeInfo, newInfo);
    }

    public static void insertMidHisToUpdateEmpPostExperienceHis(Context ctx, EmpPosOrgRelationChangeInfo changeInfo, EmpPosOrgRelationInfo newInfo) throws EASBizException, BOSException {
        EmpPosOrgRelationInfo copyInfo = (EmpPosOrgRelationInfo)newInfo.clone();
        copyInfo.setEndDateTime(HistoryVersionUtil.getMaxEndDate());
        copyInfo.setLEFFDT(HRUtil.getMaxEndDate());
        SHREmpPosOrgRelationDomainUtil.primaryPositionAddToAddEmpPostExp(ctx, changeInfo, copyInfo);
    }

    public static EmpPosOrgRelationCollection getAllPartTimePosition(Context ctx, String personID) throws BOSException, EASBizException {
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        Date appointDate = DateTimeUtils.truncateDate((Date)new Date());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
        filter.getFilterItems().add(new FilterItemInfo("assignType", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.EFFDT, (Object)appointDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.LEFFDT, (Object)appointDate, CompareType.GREATER_EQUALS));
        view.setFilter(filter);
        view.setSelector(helper.getSelector());
        EmpPosOrgRelationCollection empposorgRelationColl = EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationCollection(view);
        return empposorgRelationColl;
    }
}

