/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.EmpCmpSchmFacadeException;
import com.kingdee.eas.hr.compensation.EmpCompenseException;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CmpBuildDynSqlHandler {
    Context ctx = null;
    private String tableName = null;
    private String aliasName = null;
    private List cmpItemList;

    public CmpBuildDynSqlHandler(Context ctx, String tableName) {
        this.ctx = ctx;
        this.setTableName(tableName);
    }

    public String getItemSelectSQL(EntityViewInfo entityViewInfoPerson, HashMap paramMap) throws BOSException, EASBizException {
        if (entityViewInfoPerson == null) {
            entityViewInfoPerson = new EntityViewInfo();
        }
        SqlSelect select = this.getDynItemSQL(entityViewInfoPerson, paramMap);
        ArrayList orderedSelectors = this.buildSelectItemList(select);
        select.selectList = null;
        select.selectList = orderedSelectors;
        select.distinct = 1;
        StringBuffer sb = new StringBuffer();
        try {
            DrSQLFormater formater = new DrSQLFormater(sb);
            formater.formatSelect(select);
        }
        catch (FormaterException e2) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        return sb.toString();
    }

    public SqlSelect getDynItemSQL(EntityViewInfo entityViewInfo, HashMap paramMap) throws BOSException, EmpCmpSchmFacadeException {
        SqlSelectBase sb;
        String sql = HRSchemeUtils.getCmpDynamicTableSql(this.ctx, this.tableName, this.aliasName, entityViewInfo, null);
        int index = sql.indexOf(" ORDER BY ");
        if (index > -1) {
            sql = sql.substring(0, index);
        }
        SqlSelect select = null;
        try {
            SelectParser parser = new SelectParser(sql);
            sb = parser.select();
        }
        catch (ParserException e) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.PARSE_SQL_EXEC, e);
        }
        if (sb == null || !(sb instanceof SqlSelect)) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.GET_FIXEDSQL_EXEC);
        }
        select = (SqlSelect)sb;
        return select;
    }

    public ArrayList buildSelectItemList(SqlSelect select) throws EmpCompenseException {
        List selectors = select.selectList;
        ArrayList<SqlSelectItem> orderedSelectors = new ArrayList<SqlSelectItem>();
        String itemNumber = null;
        SqlExprParser parser = null;
        int size = this.cmpItemList.size();
        for (int i = 0; i < size; ++i) {
            SqlSelectItem item = null;
            itemNumber = ((CmpItemInfo)this.cmpItemList.get(i)).getNumber();
            int jsize = selectors.size();
            for (int j = 0; j < jsize; ++j) {
                if (!((SqlSelectItem)selectors.get((int)j)).alias.replaceAll("\"", "").trim().equals(itemNumber.replaceAll("\"", "").trim())) continue;
                item = (SqlSelectItem)selectors.get(j);
                break;
            }
            if (item == null) {
                try {
                    item = new SqlSelectItem();
                    parser = itemNumber.equalsIgnoreCase("FOTHERTOTAL") ? new SqlExprParser(this.getTotalExpr(this.cmpItemList)) : new SqlExprParser(this.aliasName + "." + itemNumber);
                    item.expr = parser.expr();
                    item.alias = itemNumber;
                    orderedSelectors.add(item);
                    continue;
                }
                catch (ParserException e1) {
                    throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
                }
            }
            orderedSelectors.add(item);
        }
        try {
            SqlSelectItem item = null;
            itemNumber = "FPERSONID";
            item = new SqlSelectItem();
            parser = new SqlExprParser("PERSON.FID");
            item.expr = parser.expr();
            item.alias = itemNumber;
            orderedSelectors.add(item);
        }
        catch (ParserException e1) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        return orderedSelectors;
    }

    private String getTotalExpr(List lstColumn) {
        StringBuffer sb = new StringBuffer("");
        CmpItemInfo infoColumn = null;
        String number = null;
        int dataType = 0;
        int size = lstColumn.size();
        for (int i = 0; i < size; ++i) {
            infoColumn = (CmpItemInfo)lstColumn.get(i);
            number = infoColumn.getNumber();
            dataType = infoColumn.getDataType().getValue();
            if (number.equalsIgnoreCase("FOTHERTOTAL") || dataType != 60) continue;
            sb.append(this.aliasName);
            sb.append(".");
            sb.append(number);
            sb.append("+");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public List getCmpItemList() {
        return this.cmpItemList;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
        if (StringUtils.isEmpty((String)this.aliasName)) {
            this.setAliasName(tableName);
        }
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public void setCmpItemList(List cmpItemList) {
        this.cmpItemList = cmpItemList;
    }
}

