/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.compensation.CmpItemCatalogCollection;
import com.kingdee.eas.hr.compensation.CmpItemCatalogFactory;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpReportFilterF7Info;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CmpSchemePersonCollection;
import com.kingdee.eas.hr.compensation.CmpSchemePersonFactory;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.ICmpSchemePerson;
import com.kingdee.eas.hr.compensation.ITaxScheme;
import com.kingdee.eas.hr.compensation.TaxSchemeCollection;
import com.kingdee.eas.hr.compensation.TaxSchemeFactory;
import com.kingdee.eas.hr.compensation.TaxSchemeInfo;
import com.kingdee.eas.hr.compensation.app.AbstractCmpCommonFacadeControllerBean;
import com.kingdee.eas.hr.compensation.app.AppCmpReportUtil;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRCommonQueryUtils;
import com.kingdee.eas.hr.compensation.util.HRReportUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CmpCommonFacadeControllerBean
extends AbstractCmpCommonFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.CmpCommonFacadeControllerBean");

    @Override
    protected IObjectCollection _getCmpPeriodColl(Context ctx, Date startCmpPeriodDate, Date endCmpPeriodDate) throws BOSException, EASBizException {
        CmpPeriodCollection coll = null;
        if (startCmpPeriodDate != null && endCmpPeriodDate != null) {
            ICmpPeriod iCmpPeriod = CmpPeriodFactory.getLocalInstance(ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("beginDate", (Object)startCmpPeriodDate, CompareType.GREATER_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("endDate", (Object)endCmpPeriodDate, CompareType.LESS_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
            SorterItemInfo sortInfoPerson = new SorterItemInfo("beginDate");
            sortInfoPerson.setSortType(SortType.ASCEND);
            view.getSorter().add(sortInfoPerson);
            filterInfo.setMaskString("#0 and #1 and #2");
            view.setFilter(filterInfo);
            coll = iCmpPeriod.getCmpPeriodCollection(view);
        }
        return coll;
    }

    private boolean isColumnExists(Context ctx, String tblName, String colName) throws Exception {
        boolean rtn = false;
        String sql = "select 1 from KSQL_USERCOLUMNS where KSQL_COL_NAME =? and KSQL_COL_TABNAME=?";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{colName, tblName});
        if (rows.size() > 0) {
            rtn = true;
        }
        return rtn;
    }

    @Override
    protected HashMap _getCmpItemValue(Context ctx, String cmpSchemeID, String personID, String cmpItemNumber, List cmpPeriodList) throws BOSException, EASBizException {
        String fhortablename = this.getHisTable(ctx, cmpSchemeID);
        StringBuffer selectSql = null;
        IRowSet rows = null;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (fhortablename != null) {
            boolean isExistsCol = false;
            try {
                isExistsCol = this.isColumnExists(ctx, fhortablename, cmpItemNumber);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
            if (isExistsCol) {
                selectSql = new StringBuffer("select fperiod, sum(isnull(");
                selectSql.append(cmpItemNumber);
                selectSql.append(",0)) ").append(cmpItemNumber).append(" from ");
                selectSql.append(fhortablename);
                selectSql.append(" where fPersonID = '");
                selectSql.append(personID);
                selectSql.append("' and fperiod in ");
                selectSql.append(CompUtils.getStrFromList(cmpPeriodList));
                selectSql.append(" group by fperiod ");
                try {
                    rows = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
                    while (rows.next()) {
                        map.put(rows.getString("fperiod"), rows.getBigDecimal(cmpItemNumber));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
        return map;
    }

    private String getHorTable(Context ctx, String cmpSchemeID) throws BOSException {
        String fhortablename = null;
        String selectSql = "select fhortablename from t_hr_cmpScheme where fid = ?";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{cmpSchemeID});
        try {
            while (rows.next()) {
                fhortablename = rows.getString("fhortablename");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        return fhortablename;
    }

    private String getHisTable(Context ctx, String cmpSchemeID) throws BOSException {
        String fhistablename = null;
        String selectSql = "select fhistablename from t_hr_cmpScheme where fid = ?";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{cmpSchemeID});
        try {
            while (rows.next()) {
                fhistablename = rows.getString("fhistablename");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        return fhistablename;
    }

    private List getHorTableList(Context ctx, List cmpSchemeList) throws BOSException {
        ArrayList<String> tableList = new ArrayList<String>();
        String selectSql = "select fhortablename from t_hr_cmpScheme where fid in " + CompUtils.getStrFromList(cmpSchemeList);
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)selectSql);
        try {
            while (rows.next()) {
                tableList.add(rows.getString("fhortablename"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        return tableList;
    }

    private List getHisTableList(Context ctx, List cmpSchemeList) throws BOSException {
        ArrayList<String> tableList = new ArrayList<String>();
        if (cmpSchemeList.size() > 0) {
            String selectSql = "select fhistablename from t_hr_cmpScheme where fid in " + CompUtils.getStrFromList(cmpSchemeList);
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            try {
                while (rows.next()) {
                    tableList.add(rows.getString("fhistablename"));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
        }
        return tableList;
    }

    @Override
    protected List _getCmpItemValueInCmpColl(Context ctx, Set personSet, List cmpPeriodList) throws BOSException, EASBizException {
        ArrayList<IRowSet> rowList = new ArrayList<IRowSet>();
        if (personSet.size() > 0) {
            List cmpSchemeList = this.getCmpSchemeList(ctx, personSet);
            List tableList = this.getHisTableList(ctx, cmpSchemeList);
            StringBuffer selectSql = null;
            IRowSet rows = null;
            IRowSet rowsCheck = null;
            int size = tableList.size();
            for (int i = 0; i < size; ++i) {
                String sql;
                if (tableList.get(i) == null || (rowsCheck = DbUtil.executeQuery((Context)ctx, (String)(sql = "select KSQL_COL_NAME,KSQL_COL_TABNAME from KSQL_USERCOLUMNS where (KSQL_COL_NAME ='FSAL027' or KSQL_COL_NAME ='FSAL007') and KSQL_COL_TABNAME='" + tableList.get(i) + "'"))).size() != 2) continue;
                selectSql = new StringBuffer("select fpersonid, fperiod,ftime,FSAL027, FSAL007");
                selectSql.append(" from ");
                selectSql.append(tableList.get(i));
                selectSql.append(" where fPersonID in ");
                selectSql.append(CompUtils.getStrFromSet(personSet));
                selectSql.append(" and fperiod in ");
                selectSql.append(CompUtils.getStrFromList(cmpPeriodList));
                rows = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
                rowList.add(rows);
            }
        }
        return rowList;
    }

    private List getCmpSchemeList(Context ctx, Set personSet) throws BOSException {
        String oql = "select cmpScheme.* where person.id in " + CompUtils.getStrFromSet(personSet);
        ICmpSchemePerson iCmpSchemePerson = CmpSchemePersonFactory.getLocalInstance(ctx);
        CmpSchemePersonCollection cmpSchemePerColl = null;
        CmpSchemeInfo info = null;
        ArrayList<String> cmpSchemeList = new ArrayList<String>();
        cmpSchemePerColl = iCmpSchemePerson.getCmpSchemePersonCollection(oql);
        int size = cmpSchemePerColl.size();
        for (int i = 0; i < size; ++i) {
            info = cmpSchemePerColl.get(i).getCmpScheme();
            cmpSchemeList.add(info.getId().toString());
        }
        return cmpSchemeList;
    }

    @Override
    protected HashMap _getTaxMap(Context ctx, List listId) throws BOSException, EASBizException {
        HashMap<String, TaxSchemeInfo> map = new HashMap<String, TaxSchemeInfo>();
        if (listId.size() > 0) {
            String oql = "select * where id in " + CompUtils.getStrFromList(listId);
            ITaxScheme iTaxScheme = TaxSchemeFactory.getLocalInstance(ctx);
            TaxSchemeCollection coll = null;
            TaxSchemeInfo info = null;
            coll = iTaxScheme.getTaxSchemeCollection(oql);
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                info = coll.get(i);
                map.put(info.getId().toString(), info);
            }
        }
        return map;
    }

    @Override
    protected String[] _getHisDepAndPosFromHisPeriod(Context ctx, String strSchemeId, String strPeriodID, String strPersonID) throws BOSException, EASBizException {
        String[] strNames = new String[2];
        CmpSchemeInfo schemeInfo = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeInfo((IObjectPK)new ObjectUuidPK(strSchemeId));
        String hosTableName = schemeInfo.getHorTableName();
        String hisTableName = schemeInfo.getHisTableName();
        String language = ctx.getLocale().getLanguage();
        String sql = " select orgAdmin.Fname_" + language + " as orgName,position.fname_" + language + " as positionName from  (select FAdminOrgUnitId,FPositionID from " + hosTableName;
        sql = hisTableName != null ? sql + " union  select FAdminOrgUnitId,FPositionID from " + hisTableName + " where fpersonid = '" + strPersonID + "' and FPeriod = '" + strPeriodID + "') orgPosID " : sql + ") orgPosID ";
        sql = sql + " left join t_org_admin orgAdmin on orgAdmin.Fid = orgPosID.FAdminOrgUnitId  left join t_org_position position on position.fid = orgPosID.FPositionID ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            rs.beforeFirst();
            while (rs.next()) {
                strNames[0] = rs.getString("orgName");
                strNames[1] = rs.getString("positionName");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return strNames;
    }

    @Override
    protected AdminOrgUnitCollection _getSubAdminOrgCollection(Context ctx, Map paramsMap) throws BOSException {
        AdminOrgUnitInfo unitInfo = (AdminOrgUnitInfo)paramsMap.get("AdminOrgUnitInfo");
        int selfLevel = unitInfo.getLevel();
        String language = ctx.getLocale().getLanguage();
        Integer toLevel = (Integer)paramsMap.get("ToLevel");
        String longNumber = unitInfo.getLongNumber();
        boolean isShowSealUp = true;
        if (paramsMap.get("isShowSealUp") != null && !((Boolean)paramsMap.get("isShowSealUp")).booleanValue()) {
            isShowSealUp = false;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT \"ADMIN\".fid, \"ADMIN\".FName_" + language + ",\"ADMIN\".fLevel,\"ADMIN\".fLongNumber,\"ADMIN\".fDisplayName_" + language);
        sql.append(" FROM T_ORG_Admin  \"ADMIN\"");
        sql.append(" INNER JOIN T_PM_OrgRange  \"ADMINORGRANGE\"");
        sql.append(" ON \"ADMIN\".FID = \"ADMINORGRANGE\".FOrgID");
        sql.append(" INNER JOIN T_PM_User  \"ADMINUSER\"");
        sql.append(" ON \"ADMINORGRANGE\".FUserID = \"ADMINUSER\".FID ");
        sql.append(" WHERE \"ADMIN\".flongnumber like '");
        sql.append(longNumber);
        sql.append("!%' and \"ADMINORGRANGE\".FType = 20 and \"ADMINUSER\".FID = '");
        sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        sql.append("'");
        sql.append(" and \"ADMIN\".flevel > ");
        sql.append(selfLevel);
        if (toLevel != null) {
            sql.append(" and \"ADMIN\".flevel <= ");
            sql.append("" + (selfLevel + toLevel));
        }
        if (!isShowSealUp) {
            sql.append(" and \"ADMIN\".FIsSealUp = 1");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        AdminOrgUnitCollection colDept = new AdminOrgUnitCollection();
        colDept.add(unitInfo);
        AdminOrgUnitInfo tmpUnitInfo = null;
        try {
            while (rowSet.next()) {
                tmpUnitInfo = new AdminOrgUnitInfo();
                tmpUnitInfo.setId(BOSUuid.read((String)rowSet.getString(1)));
                tmpUnitInfo.setName(rowSet.getString(2));
                tmpUnitInfo.setLevel(rowSet.getInt(3));
                tmpUnitInfo.setLongNumber(rowSet.getString(4));
                tmpUnitInfo.setDisplayName(rowSet.getString(5));
                colDept.add(tmpUnitInfo);
            }
        }
        catch (UuidException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return colDept;
    }

    @Override
    protected void _releaseTempTable(Context ctx, List tableNameList) throws BOSException {
        String tableName = null;
        if (tableNameList != null && tableNameList.size() > 0) {
            int size = tableNameList.size();
            for (int i = 0; i < size; ++i) {
                tableName = (String)tableNameList.get(i);
                if (StringUtils.isEmpty((String)tableName)) continue;
                HRReportUtils.releaseTmpTable(ctx, tableName);
            }
        }
    }

    @Override
    protected Map _getHaveDataInPeriods(Context ctx, List schemeIDList, CmpPeriodCollection periodColl) throws BOSException, EASBizException {
        if (periodColl == null || periodColl.size() <= 0) {
            return new HashMap();
        }
        String[] periodNums = new String[periodColl.size()];
        for (int i = 0; i < periodColl.size(); ++i) {
            periodNums[i] = periodColl.get(i).getNumber();
        }
        return AppCmpReportUtil.getHaveDataInPeriods(ctx, schemeIDList, periodNums);
    }

    @Override
    protected CmpReportFilterF7Info _getF7InfoFromFilterUI(Context ctx, Map paramMap) throws BOSException, EASBizException {
        CmpItemCollection cmpItemColl;
        FilterInfo adminRangeFilter;
        FilterInfo fi;
        Object value = null;
        EntityViewInfo evi = null;
        CmpReportFilterF7Info paramInfo = new CmpReportFilterF7Info();
        LinkedHashSet<String> idSet = null;
        if (paramMap.containsKey("cmpreport_admin_mul") && (value = (Object)paramMap.get("cmpreport_admin_mul")) != null) {
            IAdminOrgUnit adminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            if (value instanceof String[]) {
                idSet = new LinkedHashSet<String>(Arrays.asList((String[])value));
                evi = new EntityViewInfo();
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                evi.setFilter(fi);
                AdminOrgUnitCollection col = adminOrgUnit.getAdminOrgUnitCollection(evi);
                paramInfo.setAdminColl(col);
            }
        }
        if (paramMap.containsKey("cmpreport_admin_single") && (value = (Object)paramMap.get("cmpreport_admin_single")) != null) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)value)));
            AdminOrgUnitInfo adminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)pk);
            paramInfo.setAdminInfo(adminInfo);
            paramInfo.setLevel(HRCommonQueryUtils.getAdminOrgLevelCount(ctx, adminInfo));
        }
        CmpSchemeCollection cmpColl = null;
        if (paramMap.containsKey("cmpreport_scheme_mul") && (value = (Object)paramMap.get("cmpreport_scheme_mul")) != null && value instanceof String[]) {
            idSet = new LinkedHashSet<String>(Arrays.asList((String[])value));
            evi = new EntityViewInfo();
            fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            adminRangeFilter = HRSchemeUtils.getAdminRangeFilter(ctx, "");
            if (adminRangeFilter != null) {
                try {
                    fi.mergeFilter(adminRangeFilter, "and");
                }
                catch (BOSException bOSException) {
                    // empty catch block
                }
            }
            evi.setFilter(fi);
            cmpColl = CmpSchemeFactory.getLocalInstance(ctx).getSchemeCollNoDataPermission(evi);
            paramInfo.setCmpSchemeColl(cmpColl);
        }
        if (paramMap.containsKey("cmpreport_scheme_single") && (value = (Object)paramMap.get("cmpreport_scheme_single")) != null) {
            evi = new EntityViewInfo();
            fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", value, CompareType.EQUALS));
            adminRangeFilter = HRSchemeUtils.getAdminRangeFilter(ctx, "");
            if (adminRangeFilter != null) {
                try {
                    fi.mergeFilter(adminRangeFilter, "and");
                }
                catch (BOSException bOSException) {
                    // empty catch block
                }
            }
            evi.setFilter(fi);
            cmpColl = CmpSchemeFactory.getLocalInstance(ctx).getSchemeCollNoDataPermission(evi);
            if (cmpColl != null && cmpColl.size() > 0) {
                paramInfo.setCmpSchemeInfo(cmpColl.get(0));
            }
        }
        CmpPeriodInfo cmpBeginPeriond = null;
        if (paramMap.containsKey("cmpreport_period_start") && (value = (Object)paramMap.get("cmpreport_period_start")) != null) {
            ObjectUuidPK pkTemp = new ObjectUuidPK(BOSUuid.read((String)value.toString()));
            cmpBeginPeriond = CmpPeriodFactory.getLocalInstance(ctx).getCmpPeriodInfo((IObjectPK)pkTemp);
            paramInfo.setPeriodInfo(cmpBeginPeriond);
        }
        CmpPeriodInfo cmpEndPeriond = null;
        if (paramMap.containsKey("cmpreport_period_end") && (value = paramMap.get("cmpreport_period_end")) != null) {
            ObjectUuidPK pkTemp = new ObjectUuidPK(BOSUuid.read((String)value.toString()));
            cmpEndPeriond = CmpPeriodFactory.getLocalInstance(ctx).getCmpPeriodInfo((IObjectPK)pkTemp);
            paramInfo.setEndPeriodInfo(cmpEndPeriond);
        }
        if (paramMap.containsKey("cmpreport_item_public") && (value = paramMap.get("cmpreport_item_public")) != null && value instanceof String[]) {
            idSet = new LinkedHashSet<String>(Arrays.asList((String[])value));
            cmpItemColl = (CmpItemCollection)CmpItemFactory.getLocalInstance(ctx).getForNotDataAuthority(idSet);
            paramInfo.setPubCmpItemColl(cmpItemColl);
        }
        if (paramMap.containsKey("cmpreport_item_private") && (value = paramMap.get("cmpreport_item_private")) != null && value instanceof String[]) {
            idSet = new LinkedHashSet<String>(Arrays.asList((String[])value));
            cmpItemColl = (CmpItemCollection)CmpItemFactory.getLocalInstance(ctx).getForNotDataAuthority(idSet);
            paramInfo.setPrivateCmpItemColl(cmpItemColl);
        }
        if (cmpBeginPeriond != null && cmpEndPeriond != null) {
            List cmpPeriodList = HRUtils.getCmpPeriodList(ctx, cmpBeginPeriond, cmpEndPeriond, false);
            CmpPeriodCollection colCmpPeriod = new CmpPeriodCollection();
            for (int i = 0; i < cmpPeriodList.size(); ++i) {
                colCmpPeriod.add((CmpPeriodInfo)cmpPeriodList.get(i));
            }
            paramInfo.setPeriodColl(colCmpPeriod);
        }
        try {
            this.setF7CmpItemInfoForScheme(ctx, paramInfo, cmpColl, paramMap);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return paramInfo;
    }

    private void setF7CmpItemInfoForScheme(Context ctx, CmpReportFilterF7Info f7Info, CmpSchemeCollection cmpColl, Map paramMap) throws BOSException, SQLException, EASBizException {
        if (cmpColl == null || cmpColl.size() <= 0) {
            return;
        }
        boolean dataTypeFilter = false;
        if (paramMap.containsKey("cmpreport_dataTypeFilter")) {
            dataTypeFilter = (Boolean)paramMap.get("cmpreport_dataTypeFilter");
        }
        boolean perItemFilter = false;
        if (paramMap.containsKey("cmpreport_perItemFilter")) {
            perItemFilter = (Boolean)paramMap.get("cmpreport_perItemFilter");
        }
        int displayFSAL000 = 0;
        if (paramMap.containsKey("cmpreport_display_FSAL000")) {
            displayFSAL000 = (Integer)paramMap.get("cmpreport_display_FSAL000");
        }
        ArrayList<String> schemeIDs = new ArrayList<String>();
        for (int i = 0; i < cmpColl.size(); ++i) {
            schemeIDs.add(cmpColl.get(i).getId().toString());
        }
        CmpItemCollection personItemColl = HRCommonQueryUtils.getPersonItems(ctx);
        f7Info.setPersonItemColl(personItemColl);
        ICmpSchemeItem iCmpSchemeItemIts = CmpSchemeItemFactory.getLocalInstance(ctx);
        List cmpItemList = iCmpSchemeItemIts.getAllItemsByScheme(schemeIDs, HRCommonQueryUtils.getEntityViewInfo(schemeIDs, dataTypeFilter, displayFSAL000));
        f7Info.setCmpItemList(cmpItemList);
        HashSet deletedItemSet = iCmpSchemeItemIts.getDeletedCmpItem(schemeIDs);
        f7Info.setDeletedItemSet(deletedItemSet);
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString()));
        if (perItemFilter) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"FPER", CompareType.NOTEQUALS));
            filterInfo.setMaskString(" #0 and #1");
        }
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("longnumber"));
        evi.setSorter(sort);
        evi.setFilter(filterInfo);
        CmpItemCatalogCollection colCmpItemCatalog = CmpItemCatalogFactory.getLocalInstance(ctx).getCmpItemCatalogCollection(evi);
        f7Info.setColCmpItemCatalog(colCmpItemCatalog);
        if (schemeIDs.size() > 0 && f7Info.getPeriodColl() != null) {
            f7Info.setHasDataSchemeMap(this._getHaveDataInPeriods(ctx, schemeIDs, f7Info.getPeriodColl()));
        }
    }

    @Override
    protected String _getHROrgUnitIDByUserPermssion(Context ctx) throws BOSException, EASBizException {
        List orgList = null;
        String hrOrgUnitID = null;
        try {
            orgList = HRSchemeUtils.getHRAndAdminRangeList(ctx);
            hrOrgUnitID = HRUtils.getParentOrgId(ctx, orgList, 1);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return hrOrgUnitID;
    }

    @Override
    protected Map _getOtherPersonItemAndCmpSalaryMap(Context ctx, Map paramsMap) throws BOSException, EASBizException {
        List personItemList = (List)paramsMap.get("PersonItemList");
        Map resultMap = null;
        try {
            resultMap = this.getEnumAndBooleanPersonItemMap(ctx, personItemList);
            resultMap.put("CmpSalaryMap", CompUtils.getCmpSalaryMap(ctx));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return resultMap;
    }

    private Map getEnumAndBooleanPersonItemMap(Context ctx, List personItemList) throws BOSException, SQLException {
        HashMap<String, BizEnumInfo> enumPersonItemMap = new HashMap<String, BizEnumInfo>();
        HashSet<String> booleanPersonItemSet = new HashSet<String>();
        String strQueryPK = "com.kingdee.eas.hr.compensation.app.PersonInfoQuery";
        MetaDataPK queryPK = new MetaDataPK(strQueryPK);
        QueryInfo queryInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getQuery((IMetaDataPK)queryPK);
        EntityViewInfo evi = HRCmpItemUtils.getCmpItemDynQueryFilter(ctx, HRUtils.getSchemeQueryType(strQueryPK));
        QueryInfo newQueryInfo = (QueryInfo)queryInfo.clone();
        newQueryInfo.updateQuery(evi);
        SelectorItemCollection selectorColl = evi.getSelector();
        CmpItemInfo itemInfo = null;
        if (personItemList != null) {
            for (int i = 0; i < personItemList.size(); ++i) {
                BizEnumInfo enumInfo;
                itemInfo = (CmpItemInfo)personItemList.get(i);
                String propertyName = HRUtils.getPropertyNameFromSelector(itemInfo.getNumber(), selectorColl);
                QueryFieldInfo queryFieldInfo = QueryUtil.getQueryFieldByName((QueryInfo)newQueryInfo, (String)propertyName);
                if (queryFieldInfo == null) {
                    queryFieldInfo = QueryUtil.getQueryFieldByName((QueryInfo)newQueryInfo, (String)itemInfo.getNumber());
                }
                if ((enumInfo = HRUtil.getEnum((QueryFieldInfo)queryFieldInfo)) != null) {
                    enumPersonItemMap.put(itemInfo.getNumber(), enumInfo);
                    continue;
                }
                if (!HRUtil.isBoolean((QueryFieldInfo)queryFieldInfo)) continue;
                booleanPersonItemSet.add(itemInfo.getNumber());
            }
        }
        HashMap<String, Cloneable> resultMap = new HashMap<String, Cloneable>();
        resultMap.put("EnumPersonItemMap", enumPersonItemMap);
        resultMap.put("BooleanPersonItemSet", booleanPersonItemSet);
        return resultMap;
    }
}

