/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeException;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.app.AbstractCmpForRepFacadeControllerBean;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.emp.HREmpRptFormulaFacadeFactory;
import com.kingdee.eas.hr.emp.IHREmpRptFormulaFacade;
import com.kingdee.eas.hr.rec.util.DateUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpForRepFacadeControllerBean
extends AbstractCmpForRepFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.CmpForRepFacadeControllerBean");

    @Override
    protected BigDecimal _getCmpItemValue(Context ctx, HashMap paramMap) throws BOSException, EASBizException {
        String orgUnitNumber = paramMap.get("hrOrgUnit").toString();
        String cmpSchemeNumber = paramMap.get("hrCmpScheme").toString();
        String cmpItemOfSchemeNumber = paramMap.get("hrCmpSchemeItem").toString();
        String empFilterString = paramMap.get("hrEmpFilter").toString();
        if (StringUtils.isEmpty((String)orgUnitNumber)) {
            orgUnitNumber = HRSchemeUtils.getServerHROrgUnitInfo(ctx).getNumber();
        }
        String schemeOQL = "SELECT id,name,number,horTableName,hisTableName,cmpPeriod.id,cmpPeriod.hrOrgUnit.id WHERE number='" + cmpSchemeNumber + "' AND hrOrgUnit.number='" + orgUnitNumber + "'";
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        CmpSchemeCollection cmpSchemeCol = iCmpScheme.getCmpSchemeCollection(schemeOQL);
        if (cmpSchemeCol.size() <= 0) {
            return new BigDecimal("0");
        }
        CmpSchemeInfo cmpSchemeInfo = cmpSchemeCol.get(0);
        String cmpPeriodNumber = null;
        CmpPeriodInfo cmpPeriodInfo = null;
        if (paramMap.get("hrCmpPeriod") != null) {
            Date nowDate;
            SimpleDateFormat sf;
            String strNowDate;
            cmpPeriodNumber = paramMap.get("hrCmpPeriod").toString();
            if (cmpPeriodNumber.equals("C@F_01")) {
                return this.getPersonNumberOfCmpScheme(orgUnitNumber, ctx);
            }
            if ((cmpPeriodNumber == null || cmpPeriodNumber.trim().length() == 0) && (cmpPeriodNumber = this.getCmpPeriodNumber(ctx, strNowDate = (sf = new SimpleDateFormat("yyyy-MM-dd")).format(nowDate = Calendar.getInstance().getTime()), orgUnitNumber, cmpSchemeNumber)) == null) {
                return new BigDecimal("0");
            }
            String periodOQL = "SELECT id,hrOrgUnit.id WHERE number='" + cmpPeriodNumber + "' AND hrOrgUnit.number='" + orgUnitNumber + "'";
            ICmpPeriod iCmpPeriod = CmpPeriodFactory.getLocalInstance(ctx);
            if (!iCmpPeriod.exists(periodOQL)) {
                return new BigDecimal("0");
            }
            cmpPeriodInfo = iCmpPeriod.getCmpPeriodInfo(periodOQL);
        } else {
            String relativeHrCmpPeriod = paramMap.get("relativeHrCmpPeriod").toString();
            cmpPeriodInfo = HRUtils.getCmpPeriodInfoByConstantServer(ctx, cmpSchemeInfo.getCmpPeriod(), Integer.valueOf(relativeHrCmpPeriod));
        }
        if (cmpPeriodInfo == null) {
            return new BigDecimal("0");
        }
        StringBuffer sqlBuffer = this.getBasicSql(cmpSchemeInfo, cmpItemOfSchemeNumber);
        IHREmpRptFormulaFacade iHREmpRptFormulaFac = HREmpRptFormulaFacadeFactory.getLocalInstance((Context)ctx);
        sqlBuffer.append(iHREmpRptFormulaFac.getJoinSql(empFilterString, new HashMap()));
        sqlBuffer.append(" WHERE ");
        sqlBuffer.append(" T.FPERIOD='" + cmpPeriodInfo.getId().toString() + "'");
        if (!empFilterString.trim().equals("")) {
            sqlBuffer.append(" AND " + empFilterString);
        }
        BigDecimal summerNumber = HRSchemeUtils.BD_ZERO;
        String sql = sqlBuffer.toString();
        sql = StringUtils.replace((String)sql, (String)"PERSONPOSITION.FPersonDep", (String)"T.FAdminOrgUnitID");
        sql = StringUtils.replace((String)sql, (String)"PERSONPOSITION.Fprimarypositionid", (String)"T.FPositionID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            rs.beforeFirst();
            while (rs.next()) {
                if (rs.getBigDecimal("SUMNUMBER") == null) continue;
                summerNumber = rs.getBigDecimal("SUMNUMBER");
            }
        }
        catch (SQLException e) {
            throw new BOSException("calculate error!");
        }
        return summerNumber;
    }

    private BigDecimal getPersonNumberOfCmpScheme(String paramString, Context ctx) throws BOSException, EASBizException {
        IRowSet rs;
        BigDecimal personNumber = HRSchemeUtils.BD_ZERO;
        HashMap paramMap = HRUtils.parseValue(paramString);
        String cmpSchemeNumber = paramMap.get("CmpSchemeNumber").toString();
        String cmpPeriodNumber = paramMap.get("CmpPeriodNumber").toString();
        Object isOnPerson = paramMap.get("hasPosition");
        HROrgUnitInfo hrOrgUnitInfo = HRSchemeUtils.getServerHROrgUnitInfo(ctx);
        String schemeOQL = "SELECT * WHERE number='" + cmpSchemeNumber + "' AND hrOrgUnit.id='" + hrOrgUnitInfo.getId().toString() + "'";
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        if (!iCmpScheme.exists(schemeOQL)) {
            return new BigDecimal("0");
        }
        CmpSchemeInfo cmpSchemeInfo = iCmpScheme.getCmpSchemeInfo(schemeOQL);
        StringBuffer sqlString = new StringBuffer();
        sqlString.append(" SELECT COUNT(T.fpersonid) AS PERSONNUMBER FROM ( ");
        sqlString.append(" SELECT fpersonid FROM " + cmpSchemeInfo.getHorTableName());
        sqlString.append(" UNION ALL ");
        sqlString.append(" SELECT fpersonid FROM\u3000" + cmpSchemeInfo.getHisTableName() + ") T  ");
        sqlString.append(" LEFT JOIN t_hr_personposition ON T.Fpersonid = t_hr_personposition.fpersonid ");
        sqlString.append(" LEFT JOIN t_org_position ON t_hr_personposition.fprimarypositionid = t_org_position.fid ");
        sqlString.append(" LEFT JOIN t_hr_cmpperiod ON t_hr_cmpperiod.fid = T.Fperiod ");
        sqlString.append(" WHERE t_hr_cmpperiod.fnumber='" + cmpPeriodNumber + "' AND ");
        sqlString.append(" t_hr_cmpperiod.fhrorgunitid='" + hrOrgUnitInfo.getId().toString() + "' ");
        if (isOnPerson != null) {
            if (isOnPerson.toString().equals("true")) {
                sqlString.append(" AND  t_org_position.fid is not null ");
            } else {
                sqlString.append(" AND  t_org_position.fid is null ");
            }
        }
        if ((rs = DbUtil.executeQuery((Context)ctx, (String)sqlString.toString())).size() > 0) {
            try {
                while (rs.next()) {
                    if (rs.getBigDecimal("PERSONNUMBER") == null) continue;
                    personNumber = rs.getBigDecimal("PERSONNUMBER");
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage());
            }
        }
        return personNumber;
    }

    private StringBuffer getBasicSql(CmpSchemeInfo cmpSchemeInfo, String CmpSchemeItem2) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT  sum(isnull(T." + CmpSchemeItem2 + ",0)) AS SUMNUMBER FROM");
        sqlBuffer.append("(");
        sqlBuffer.append("  SELECT FPERIOD,FAdminOrgUnitID,FpositionID,FPERSONID, " + CmpSchemeItem2 + " FROM " + cmpSchemeInfo.getHorTableName());
        if (cmpSchemeInfo.getHisTableName() != null) {
            sqlBuffer.append("  UNION ALL ");
            sqlBuffer.append("  SELECT FPERIOD,FAdminOrgUnitID,FpositionID,FPERSONID, " + CmpSchemeItem2 + " FROM " + cmpSchemeInfo.getHisTableName());
        }
        sqlBuffer.append(" ) T  INNER JOIN T_BD_PERSON PERSON ON T.Fpersonid = PERSON.Fid ");
        return sqlBuffer;
    }

    private String getCmpPeriodNumber(Context ctx, String nowDate, String hrOrgUnit, String hrCmpScheme) throws EASBizException, BOSException {
        String cmpPeriodNumber = null;
        if (hrOrgUnit == null || hrOrgUnit.trim().equals("")) {
            HROrgUnitInfo hrOrgUnitInfo = null;
            hrOrgUnitInfo = HRSchemeUtils.getServerHROrgUnitInfo(ctx);
            hrOrgUnit = hrOrgUnitInfo.getNumber();
        }
        String kSqlStr = "SELECT *,cmpPeriod.*,hrOrgUnit.* WHERE number='" + hrCmpScheme + "' and hrOrgUnit.number='" + hrOrgUnit + "'";
        ICmpScheme iCS = CmpSchemeFactory.getLocalInstance(ctx);
        if (!iCS.exists(kSqlStr)) {
            return null;
        }
        CmpSchemeInfo cmpSchemeInfo = iCS.getCmpSchemeInfo(kSqlStr);
        CmpPeriodInfo cmpPeriodInfoTemp = cmpSchemeInfo.getCmpPeriod();
        if (nowDate != null) {
            kSqlStr = "SELECT *,hrOrgUnit.* WHERE beginDate<='" + nowDate + "' AND endDate>='" + nowDate + "' AND endDate<'" + cmpPeriodInfoTemp.getEndDate().toString() + "' AND hrOrgUnit.number='" + hrOrgUnit + "'";
            CmpPeriodCollection cmpPeriodColl = CmpPeriodFactory.getLocalInstance(ctx).getCmpPeriodCollection(kSqlStr);
            if (cmpPeriodColl.size() > 0) {
                CmpPeriodInfo cmpPeriodInfo = cmpPeriodColl.get(0);
                cmpPeriodNumber = cmpPeriodInfo.getNumber();
            } else {
                cmpPeriodNumber = cmpPeriodInfoTemp.getNumber();
            }
        } else {
            cmpPeriodNumber = cmpPeriodInfoTemp.getNumber();
        }
        return cmpPeriodNumber;
    }

    @Override
    protected BigDecimal _getSalPointDataFormula(Context ctx, Map paramMap) throws BOSException, EASBizException {
        String orgUnitNumber = null;
        if (paramMap.get("hrOrgUnitNumber") != null) {
            orgUnitNumber = paramMap.get("hrOrgUnitNumber").toString();
        }
        String cmpItemNumber = paramMap.get("hrCmpItemNumber").toString();
        String salPointName = paramMap.get("hrSalPointAllName").toString();
        if (StringUtils.isEmpty((String)salPointName)) {
            return new BigDecimal("0.00");
        }
        String orgUnitID = null;
        if (!StringUtils.isEmpty((String)orgUnitNumber)) {
            String oql = "select id,name where number = '" + orgUnitNumber + "'";
            HROrgUnitCollection hrCol = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitCollection(oql);
            if (hrCol.size() > 0) {
                orgUnitID = hrCol.get(0).getId().toString();
            }
        } else {
            orgUnitID = HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString();
        }
        SalariatSchemeInfo info = HRSchemeUtils.getCurrentHRSalSchm(ctx, orgUnitID);
        if (info == null) {
            throw new FixedCmpSchemeException(FixedCmpSchemeException.NOT_ENABLE_SALARIATSCHEME);
        }
        String[] names = salPointName.split("-");
        String parentName = names[0].trim();
        String subName = names[1].trim();
        String language = ctx.getLocale().getLanguage();
        StringBuffer sb = new StringBuffer();
        sb.append(" select sub.fid from t_hr_salariattree sub inner join t_hr_salariattree parent ");
        sb.append(" on sub.fparentid = parent.fid  ");
        sb.append(" where  parent.fname_").append(language).append("= ? and sub.fname_").append(language).append(" = ? and sub.fschemeid =?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{parentName, subName, info.getId().toString()});
        String salPointID = null;
        try {
            while (rs.next()) {
                salPointID = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        if (StringUtils.isEmpty(salPointID)) {
            return new BigDecimal("0.00");
        }
        String dataTableName = info.getPointTableName();
        if (StringUtils.isEmpty((String)dataTableName)) {
            return new BigDecimal("0.00");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select top 1 ").append(cmpItemNumber).append(" from ").append(dataTableName).append(" where FPointID =?");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{salPointID});
        BigDecimal pointData = new BigDecimal("0.00");
        try {
            while (result.next()) {
                if (result.getBigDecimal(cmpItemNumber) == null) continue;
                pointData = result.getBigDecimal(cmpItemNumber);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return pointData;
    }

    @Override
    protected BigDecimal _getCmpItemSumValue(Context ctx, HashMap paramMap) throws BOSException, EASBizException {
        String orgUnitNumber = paramMap.get("hrOrgUnit").toString();
        String cmpSchemeName = paramMap.get("hrCmpScheme").toString();
        String cmpItemOfSchemeNumber = paramMap.get("hrCmpSchemeItem").toString();
        String empFilterString = paramMap.get("hrEmpFilter").toString();
        if (StringUtils.isEmpty((String)orgUnitNumber)) {
            orgUnitNumber = HRSchemeUtils.getServerHROrgUnitInfo(ctx).getNumber();
        }
        String schemeOQL = "SELECT *,cmpPeriod.* WHERE number='" + cmpSchemeName + "' AND hrOrgUnit.number='" + orgUnitNumber + "'";
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        CmpSchemeCollection cmpSchemeCol = iCmpScheme.getCmpSchemeCollection(schemeOQL);
        if (cmpSchemeCol.size() <= 0) {
            return new BigDecimal("0");
        }
        CmpSchemeInfo cmpSchemeInfo = cmpSchemeCol.get(0);
        StringBuffer sqlBuffer = this.getBasicSql(cmpSchemeInfo, cmpItemOfSchemeNumber);
        IHREmpRptFormulaFacade iHREmpRptFormulaFac = HREmpRptFormulaFacadeFactory.getLocalInstance((Context)ctx);
        String beginYear = paramMap.get("beginYear").toString();
        String beginPeriod = paramMap.get("beginPeriod").toString();
        String endYear = paramMap.get("endYear").toString();
        String ednPeriod = paramMap.get("endPeriod").toString();
        ArrayList cmpPeriodList = this.getSumCmpPeriod(ctx, cmpSchemeInfo, Integer.valueOf(beginYear), Integer.valueOf(beginPeriod), Integer.valueOf(endYear), Integer.valueOf(ednPeriod));
        if (cmpPeriodList == null) {
            return new BigDecimal("0");
        }
        sqlBuffer.append(iHREmpRptFormulaFac.getJoinSql(empFilterString, new HashMap()));
        sqlBuffer.append(" WHERE T.FPERIOD in (");
        int listSize = cmpPeriodList.size();
        for (int i = 0; i < listSize - 1; ++i) {
            sqlBuffer.append("'").append(cmpPeriodList.get(i)).append("',");
        }
        sqlBuffer.append("'").append(cmpPeriodList.get(listSize - 1)).append("')");
        if (!empFilterString.trim().equals("")) {
            sqlBuffer.append(" AND " + empFilterString);
        }
        BigDecimal summerNumber = HRSchemeUtils.BD_ZERO;
        String sql = sqlBuffer.toString();
        sql = StringUtils.replace((String)sql, (String)"PERSONPOSITION.FPersonDep", (String)"T.FAdminOrgUnitID");
        sql = StringUtils.replace((String)sql, (String)"PERSONPOSITION.Fprimarypositionid", (String)"T.FPositionID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            rs.beforeFirst();
            while (rs.next()) {
                if (rs.getBigDecimal("SUMNUMBER") == null) continue;
                summerNumber = rs.getBigDecimal("SUMNUMBER");
            }
        }
        catch (SQLException e) {
            throw new BOSException("calculate error!");
        }
        return summerNumber;
    }

    private ArrayList getSumCmpPeriod(Context ctx, CmpSchemeInfo cmpSchemeInfo, int beginYear, int beginPeriod, int endYear, int endPeriod) throws BOSException {
        ArrayList<BOSUuid> sumPeriodList = new ArrayList<BOSUuid>();
        CmpPeriodInfo currCmpPeriod = cmpSchemeInfo.getCmpPeriod();
        if (beginYear == 0 && beginPeriod == 0 && endYear == 0 && endPeriod == 0) {
            sumPeriodList.add(currCmpPeriod.getId());
            return sumPeriodList;
        }
        ICmpPeriod iCmpPeriod = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String hrOrgUnitID = null;
        iCmpPeriod = CmpPeriodFactory.getLocalInstance(ctx);
        hrOrgUnitID = cmpSchemeInfo.getHrOrgUnit().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgUnitID));
        filter.mergeFilter(this.getYearQueryFilter(beginYear, endYear, cmpSchemeInfo), "and");
        FilterInfo periodFilter = this.getPeriodQueryFilter(ctx, beginPeriod, endPeriod, cmpSchemeInfo);
        if (periodFilter == null) {
            return null;
        }
        filter.mergeFilter(periodFilter, "and");
        entityViewInfo.setFilter(filter);
        SorterItemInfo sortInfo = new SorterItemInfo("begindate");
        sortInfo.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sortInfo);
        CmpPeriodCollection cmpPeriodColl = iCmpPeriod.getCmpPeriodCollection(entityViewInfo);
        if (cmpPeriodColl == null || cmpPeriodColl.size() <= 0) {
            return null;
        }
        int size = cmpPeriodColl.size();
        for (int i = 0; i < size; ++i) {
            sumPeriodList.add(cmpPeriodColl.get(i).getId());
        }
        return sumPeriodList;
    }

    private FilterInfo getYearQueryFilter(int beginYear, int endYear, CmpSchemeInfo cmpSchemeInfo) {
        FilterInfo filter = new FilterInfo();
        Date periodDate = cmpSchemeInfo.getCmpPeriod().getBeginDate();
        Date beginDate = DateUtil.getDate((int)(DateUtil.getYear((Date)periodDate) + beginYear), (int)1, (int)1);
        Date endDate = DateUtil.getDate((int)(DateUtil.getYear((Date)periodDate) + endYear), (int)12, (int)31);
        filter.getFilterItems().add(new FilterItemInfo("begindate", (Object)beginDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("begindate", (Object)endDate, CompareType.LESS_EQUALS));
        return filter;
    }

    private FilterInfo getPeriodQueryFilter(Context ctx, int beginPeriod, int endPeriod, CmpSchemeInfo cmpSchemeInfo) {
        FilterInfo filter = new FilterInfo();
        CmpPeriodInfo cmpPeriodBeginInfo = null;
        CmpPeriodInfo cmpPeriodEndInfo = null;
        if (endPeriod > 0) {
            endPeriod = 0;
        }
        String hrOrgUnitID = null;
        if (cmpSchemeInfo.getCmpPeriod().getHrOrgUnit() != null) {
            hrOrgUnitID = cmpSchemeInfo.getCmpPeriod().getHrOrgUnit().getId().toString();
        }
        try {
            cmpPeriodBeginInfo = HRUtils.getCmpPeriodInfoByConstantServer(ctx, cmpSchemeInfo.getCmpPeriod(), beginPeriod);
            cmpPeriodEndInfo = HRUtils.getCmpPeriodInfoByConstantServer(ctx, cmpSchemeInfo.getCmpPeriod(), endPeriod);
            if (cmpPeriodBeginInfo == null) {
                cmpPeriodBeginInfo = this.beginCmpPeriodInfo(ctx, hrOrgUnitID);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        if (cmpPeriodBeginInfo == null || cmpPeriodEndInfo == null) {
            return null;
        }
        filter.getFilterItems().add(new FilterItemInfo("begindate", (Object)cmpPeriodBeginInfo.getBeginDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("begindate", (Object)cmpPeriodEndInfo.getEndDate(), CompareType.LESS_EQUALS));
        return filter;
    }

    private CmpPeriodInfo beginCmpPeriodInfo(Context ctx, String hrOrgUnitID) throws BOSException {
        ICmpPeriod iCmpPeriod = CmpPeriodFactory.getLocalInstance(ctx);
        if (hrOrgUnitID == null) {
            hrOrgUnitID = HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString();
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgUnitID));
        entityViewInfo.setFilter(filter);
        SorterItemInfo sortInfo = new SorterItemInfo("begindate");
        sortInfo.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sortInfo);
        CmpPeriodCollection cmpPeriodColl = iCmpPeriod.getCmpPeriodCollection(entityViewInfo);
        if (cmpPeriodColl != null && cmpPeriodColl.size() > 0) {
            return cmpPeriodColl.get(0);
        }
        return null;
    }
}

